; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
;SignTool=byparam $qC:\Program Files\Microsoft SDKs\Windows\v7.1\Bin\signtool.exe$q sign /f $qc:\librework\client\windeploy\Comodo.pfx$q /t http://timestamp.comodoca.com/authenticode /p librework14 $f
;SignedUninstaller=yes
ArchitecturesInstallIn64BitMode=x64
ArchitecturesAllowed=x64
AppId={{38AF146E-9C2D-424A-9F8F-FC77E0066EC4}
AppName=Librework Client
AppVersion=2.5
;AppVerName=LibreWork Client 1.2
AppPublisher=LibreWork
AppPublisherURL=http://www.librework.com/
AppSupportURL=http://www.librework.com/
AppUpdatesURL=http://www.librework.com/
DefaultDirName={pf}\LibreWork Client
DisableDirPage=yes
DefaultGroupName=Librework Client
DisableProgramGroupPage=yes
;LicenseFile=wFreeRDP-LICENSE
OutputBaseFilename=librework-client-setup
SetupIconFile=librework.ico
Compression=lzma
SolidCompression=yes

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"
Name: "spanish"; MessagesFile: "compiler:Languages\Spanish.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

[Files]
Source: "librework-client.exe"; DestDir: "{app}"; Flags: ignoreversion; AfterInstall: ModifyRegistry
Source: "es_ES.qm"; DestDir: "{app}"; Flags: ignoreversion
Source: "librework.png"; DestDir: "{app}"; Flags: ignoreversion
Source: "librework.ico"; DestDir: "{app}"; Flags: ignoreversion
;Source: "libeay32.dll"; DestDir: "{app}"; Flags: ignoreversion
;Source: "libssl32.dll"; DestDir: "{app}"; Flags: ignoreversion
;Source: "ssleay32.dll"; DestDir: "{app}"; Flags: ignoreversion
;Source: "icudt52.dll"; DestDir: "{app}"; Flags: ignoreversion
;Source: "icuin52.dll"; DestDir: "{app}"; Flags: ignoreversion
;Source: "icuuc52.dll"; DestDir: "{app}"; Flags: ignoreversion
;Source: "libfreerdp-client.dll"; DestDir: "{app}"; Flags: ignoreversion
;Source: "libfreerdp.dll"; DestDir: "{app}"; Flags: ignoreversion
;Source: "libwfreerdp-client.dll"; DestDir: "{app}"; Flags: ignoreversion
;Source: "libwinpr.dll"; DestDir: "{app}"; Flags: ignoreversion
;Source: "wfreerdp.exe"; DestDir: "{app}"; Flags: ignoreversion
;Source: "winpr.dll"; DestDir: "{app}"; Flags: ignoreversion
;Source: "winpr-hash.exe"; DestDir: "{app}"; Flags: ignoreversion
;Source: "winpr-makecert.exe"; DestDir: "{app}"; Flags: ignoreversion
;Source: "freerdp.dll"; DestDir: "{app}"; Flags: ignoreversion
;Source: "freerdp-client.dll"; DestDir: "{app}"; Flags: ignoreversion
;Source: "wfreerdp-client.dll"; DestDir: "{app}"; Flags: ignoreversion
;Source: "rdtk.dll"; DestDir: "{app}"; Flags: ignoreversion
;Source: "msvcp100.dll"; DestDir: "{app}"; Flags: ignoreversion
;Source: "msvcr100.dll"; DestDir: "{app}"; Flags: ignoreversion
;Source: "msvcr100d.dll"; DestDir: "{app}"; Flags: ignoreversion
;Source: "msvcp120.dll"; DestDir: "{app}"; Flags: ignoreversion
;Source: "msvcr120.dll"; DestDir: "{app}"; Flags: ignoreversion
;Source: "vccorlib120.dll"; DestDir: "{app}"; Flags: ignoreversion
Source: "msvcp140.dll"; DestDir: "{app}"; Flags: ignoreversion
Source: "concrt140.dll"; DestDir: "{app}"; Flags: ignoreversion
Source: "vccorlib140.dll"; DestDir: "{app}"; Flags: ignoreversion
Source: "vcruntime140.dll"; DestDir: "{app}"; Flags: ignoreversion
Source: "platforms\qwindows.dll"; DestDir: "{app}\platforms\"; Flags: ignoreversion
Source: "Qt5Core.dll"; DestDir: "{app}"; Flags: ignoreversion
Source: "Qt5Gui.dll"; DestDir: "{app}"; Flags: ignoreversion
Source: "Qt5Widgets.dll"; DestDir: "{app}"; Flags: ignoreversion
;Source: "Qt5Network.dll"; DestDir: "{app}"; Flags: ignoreversion
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Icons]
Name: "{group}\LibreWork Client"; Filename: "{app}\librework-client.exe"
Name: "{group}\{cm:UninstallProgram,LibreWork Client}"; Filename: "{uninstallexe}"
Name: "{commondesktop}\LibreWork Client"; Filename: "{app}\librework-client.exe"; Tasks: desktopicon


[Run]
Filename: "{app}\librework-client.exe"; Description: "{cm:LaunchProgram,LibreWork Client}"; Flags: nowait postinstall skipifsilent

[Code]
var
  restartNeeded: Boolean;

function NeedRestart() : Boolean;
begin
  Result := restartNeeded;
end;

procedure ModifyRegistry;
var
  Version: TWindowsVersion;
  SecurityProviders: String;
  SecurityPackages: String;
begin
  GetWindowsVersionEx(Version);
  restartNeeded := False;
  // Only modify registry on Windows XP/2003
  if Version.Major = 5 then
  begin
    if RegQueryStringValue(HKEY_LOCAL_MACHINE, 'SYSTEM\CurrentControlSet\Control\SecurityProviders', 'SecurityProviders', SecurityProviders) then
    begin
      // Successfully read the value
      if Pos('credssp.dll', SecurityProviders) = 0 Then
      begin
        restartNeeded := True;
        if Length( SecurityProviders ) > 0 Then
        begin
          SecurityProviders := SecurityProviders + ',';
        end;
        SecurityProviders := SecurityProviders + 'credssp.dll';
        RegWriteStringValue(HKEY_LOCAL_MACHINE, 'SYSTEM\CurrentControlSet\Control\SecurityProviders', 'SecurityProviders', SecurityProviders);
      end;
    end;
    if RegQueryMultiStringValue(HKEY_LOCAL_MACHINE, 'SYSTEM\CurrentControlSet\Control\Lsa', 'Security Packages', SecurityPackages) then
    begin
      // Successfully read the value
      if Pos('tspkg', SecurityPackages) = 0 Then                                                 
      begin
        restartNeeded := True;
        SecurityPackages := SecurityPackages + 'tspkg'#0;
        RegWriteMultiStringValue(HKEY_LOCAL_MACHINE, 'SYSTEM\CurrentControlSet\Control\Lsa', 'Security Packages', SecurityPackages)
      end;
    end;
  end;
end;

