set VERSION=%1
set VERSION_TYPE=%2
set ARCHID=%3

set VSVERSION=14
set QTVERSION=5.9.7

set VSDIR=%programfiles(x86)%\Microsoft Visual Studio %VSVERSION%.0\VC
set VSBINDIR=%VSDIR%\Bin
set SDKBINDIR=%programfiles%\Microsoft SDKs\Windows\v7.1\Bin

if %VSVERSION% equ 14 set VSYEAR=2015
if %VSVERSION% equ 12 set VSYEAR=2013

if "%ARCHID%" equ "x86" set ARCH=32
if "%ARCHID%" equ "x64" set ARCH=64

if %ARCH% equ 32 set QTBINDIR=c:\Qt\%QTVERSION%\msvc%VSYEAR%\bin
if %ARCH% equ 64 set QTBINDIR=c:\Qt\%QTVERSION%\msvc%VSYEAR%_64\bin

if %ARCH% equ 32 set ARCHNAME=x86
if %ARCH% equ 64 set ARCHNAME=amd64

set PATH=%PATH%;%SDKBINDIR%;%VSBINDIR%;%QTBINDIR%

cd ..

call "%VSDIR%\vcvarsall.bat" %ARCHNAME%

call "%VSBINDIR%\nmake" distclean

call rmdir /q /s Release
call rmdir /q /s Debug

call "%QTBINDIR%\qmake"
call "%QTBINDIR%\lupdate" client.pro
call "%QTBINDIR%\lrelease" client.pro
call "%VSBINDIR%\nmake" Release
call "%QTBINDIR%\windeployqt" Release

del Release\*.obj
del Release\*.cpp
del Release\*.qm

copy es_ES.qm Release\
copy librework.png Release\
copy windeploy\librework.ico Release\
copy windeploy\setupScript.iss Release\
copy "%VSDIR%\redist\%ARCHID%\Microsoft.VC%VSVERSION%0.CRT\*.dll" Release\
REM copy windeploy\wfreerdp.exe Release\
REM copy windeploy\wFreeRDP-LICENSE Release\
REM copy windeploy\*.dll Release\

cd Release
call ..\windeploy\InnoSetup\ISCC.exe /q setupScript.iss
cd ..

copy Release\Output\librework-client-setup.exe LibreWork-Client-Setup-%ARCHID%-v%VERSION%.exe

cd windeploy

pause