#!/bin/bash

usage()
{
	echo "$0 [ -p <PID> ]"
	echo "$0 [ -n <window name> ]"
	exit $1
}

raise()
{
	WINIDS=$1

	if [ -n "${WINIDS}" ]
	then
		for i in ${WINIDS}
		do
			wmctrl -i -a $i
		done
	fi
}

OPTION=$1

if [ "${OPTION}" == "-p" ]
then
	PID=$2
	if [ -z "${PID}" ] || [ -n "$3" ]
	then
		usage
	fi

	WINIDS=`wmctrl -p -l | awk '{ print $1" "$3 }' | grep -w "${PID}" | awk '{print $1}'`

	if [ -z "${WINIDS}" ]
	then
		COMMAND=`ps -f ${PID} | grep -w -v "CMD" | awk '{ print $9 }'`
		${COMMAND} &
	else
		raise ${WINIDS}
	fi

	exit 0
fi

if [ "${OPTION}" == "-n" ]
then
	PROGRAM=$2
	if [ -z "${PROGRAM}" ] || [ -n "$3" ]
	then
		usage
	fi

	WINIDS=`wmctrl -l | grep -w "${PROGRAM}" | awk '{print $1}'`

	raise ${WINIDS}

	exit 0
fi

usage
