#include "loginscreen.h"
#include "clientsettings.h"
#include "clientsession.h"

#ifdef Q_OS_WIN
#include <windows.h>
#include <fcntl.h>
#include <io.h>
#else
#include <termios.h>
#include <unistd.h>
#endif

#include <iostream>

#include <QApplication>
#include <QTranslator>
#include <QLibraryInfo>
#include <QFile>
#include <QStyle>
#include <QStyleFactory>
#include <QObject>

void setStdinEcho(bool enable = true)
{
#ifdef Q_OS_WIN
	HANDLE hStdin = GetStdHandle(STD_INPUT_HANDLE);
	DWORD mode;
	GetConsoleMode(hStdin, &mode);

	if( ! enable )
	{
		mode &= ~ENABLE_ECHO_INPUT;
	} else {
		mode |= ENABLE_ECHO_INPUT;
	}

	SetConsoleMode(hStdin, mode );
#else
	struct termios tty;
	tcgetattr(STDIN_FILENO, &tty);
	if( ! enable )
	{
		tty.c_lflag &= ~ECHO;
	} else {
		tty.c_lflag |= ECHO;
	}
	(void) tcsetattr(STDIN_FILENO, TCSANOW, &tty);
#endif
}

int main(int argc, char *argv[])
{
	QApplication app(argc, argv);

	QTranslator qtTranslator;
	qtTranslator.load("qt_" + QLocale::system().name(),
	QLibraryInfo::location(QLibraryInfo::TranslationsPath));
	app.installTranslator(&qtTranslator);

	QApplication::setStyle(QStyleFactory::create("WindowsVista"));

	QTranslator myappTranslator;

#ifdef Q_OS_MAC
	QString translatorPath = QString::fromLatin1("%1/../Resources/Translations/").arg(QCoreApplication::applicationDirPath());
	if (QFile::exists(translatorPath + QLocale::system().name() + ".qm"))
	{
		myappTranslator.load(QLocale::system().name(), translatorPath);
	}
#else
	if (QFile::exists(QLocale::system().name() + ".qm"))
	{
		myappTranslator.load(QLocale::system().name());
	} else {
		myappTranslator.load(QLocale::system().name(),
		"/usr/share/apps/librework-client/" );
	}
#endif

	app.installTranslator(&myappTranslator);

	QStringList appArguments = QCoreApplication::arguments();

	bool noDesktop = false;
	bool readFromStdin = false;

	int pos = appArguments.indexOf( "--nodesktop" ); // Launch client without a desktop
	if ( pos != -1 )
	{
		noDesktop = true;
		appArguments.removeAt( pos );
	}

	pos = appArguments.indexOf( "--stdin" ); // Read user and password from stdin
	if ( pos != -1 )
	{
		readFromStdin = true;
		appArguments.removeAt( pos );
	}

	if ( appArguments.count() > 1 )
	{
		qDebug("Usage: %s [ --nodesktop ] [ --stdin ]", argv[0]);
		return 0;
	}

	if ( readFromStdin )
	{
		QString username;
		QString password;
		QString serverConfig;

#ifdef Q_OS_WIN32
		_setmode(_fileno(stdin), _O_BINARY);
#endif
		qDebug("Waiting username,password,serverconfig from stdin...");
		setStdinEcho( false );

		QStringList stdinData;
		for ( int i = 0; i < 3; i++ )
		{
			QString string;
			bool exitLoop = false;
			while ( ! exitLoop )
			{
				char arr[1];
				std::cin.read(arr,sizeof(arr));
				if ( arr[0] == '\n' )
				{
					exitLoop = true;
				} else {
					string += arr[0];
				}
			}
			stdinData.append( string );
		}
		qDebug("stdinData count: %d", stdinData.count());
		if ( stdinData.count() == 3 )
		{
			username = stdinData[0];
			password = stdinData[1];
			serverConfig = stdinData[2];
		}

		setStdinEcho( true );

		ClientSettings * settings = new ClientSettings();
		ClientSession * session = new ClientSession( settings );
		session->launchProcess( username, password, serverConfig );
		QObject::connect( session, SIGNAL( finished() ), qApp, SLOT( quit() ) );
		int ret = app.exec();
		delete session;
		delete settings;
		return ret;
	} else {
		LoginScreen w(noDesktop);
		w.show();
		return app.exec();
	}
}
