#ifndef DISKREDIRECTION_H
#define DISKREDIRECTION_H

#include <QDialog>
#include <QFileDialog>
#include <QStringList>

#ifdef Q_OS_WIN
#include "Windows.h"
#endif

namespace Ui {
class DiskRedirection;
}

class DiskRedirection : public QDialog
{
    Q_OBJECT

public:
    explicit DiskRedirection(QStringList redirectedDisks, QWidget *parent = 0);
    ~DiskRedirection();
    QStringList redirectedDisks();

private slots:
    void on_appendButton_clicked();
    void on_removeButton_clicked();


private:
#ifdef Q_OS_WIN
	QIcon getIcon(LPCWSTR drive);
#endif
    Ui::DiskRedirection *ui;
};

#endif // DISKREDIRECTION_H
