#include "diskredirection.h"
#include "ui_diskredirection.h"

DiskRedirection::DiskRedirection(QStringList redirectedDisks, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::DiskRedirection)
{
    ui->setupUi(this);
	ui->buttonBox->button(QDialogButtonBox::Ok)->setText(tr("OK"));
	ui->buttonBox->button(QDialogButtonBox::Cancel)->setText(tr("Cancel"));
#if defined(Q_OS_LINUX) || defined(Q_OS_FREEBSD)
    ui->driveComboBox->setHidden( true );
#endif
#ifdef Q_OS_WIN
    DWORD dwSize = MAX_PATH;
    LPWSTR szLogicalDrives = new WCHAR[MAX_PATH]; // = {0};
    DWORD dwResult = GetLogicalDriveStrings(dwSize, szLogicalDrives);

    if (dwResult > 0 && dwResult <= MAX_PATH)
    {
        LPWSTR szSingleDrive = szLogicalDrives;
        while(*szSingleDrive)
        {
			QString drive = QString::fromWCharArray( szSingleDrive );
			QIcon icon = getIcon( szSingleDrive );
			ui->driveComboBox->addItem(icon, drive );
            szSingleDrive += 4;
        }
    }
    delete szLogicalDrives;
#endif
    for (int i = 0; i < redirectedDisks.count(); i++)
    {
#ifdef Q_OS_WIN
		QIcon icon = getIcon( (LPCWSTR)redirectedDisks[i].utf16() );
#endif
#if defined(Q_OS_LINUX) || defined(Q_OS_FREEBSD)
        QIcon icon(":/folder.png");
#endif
#ifdef Q_OS_MAC
        QIcon icon(":/folder.png");
#endif
        ui->listWidget->addItem( new QListWidgetItem( icon, redirectedDisks[i] ) );
    }
}

#ifdef Q_OS_WIN
QIcon DiskRedirection::getIcon(LPCWSTR drive)
{
	uint dType = GetDriveType(drive);
	QIcon icon;
	switch (dType)
	{
	case DRIVE_CDROM:
		icon = QIcon(":/cdrom.png");
		break;
	case DRIVE_REMOVABLE:
		icon = QIcon(":/usb.png");
		break;
	default:
		icon = QIcon(":/drive.png");
	}
	return icon;
}
#endif

DiskRedirection::~DiskRedirection()
{
    delete ui;
}

QStringList DiskRedirection::redirectedDisks()
{
    QStringList list;
    for (int i = 0; i < ui->listWidget->count(); i++)
    {
        list += ui->listWidget->item(i)->text();
    }

    return list;
}

void DiskRedirection::on_appendButton_clicked()
{
#ifdef Q_OS_WIN
    QString path = ui->driveComboBox->currentText();
	QIcon icon = ui->driveComboBox->itemIcon(ui->driveComboBox->currentIndex());
#endif
#if defined(Q_OS_LINUX) || defined(Q_OS_FREEBSD)
    QString path = QFileDialog::getExistingDirectory(this, tr("Select folder") );
    QIcon icon(":/folder.png");
#endif
#ifdef Q_OS_MAC
    QString path = QFileDialog::getExistingDirectory(this, tr("Select folder") );
    QIcon icon(":/folder.png");
#endif
    if (! path.isEmpty() && ui->listWidget->findItems( path, Qt::MatchCaseSensitive ).count() == 0)
    {
        ui->listWidget->addItem( new QListWidgetItem( icon, path ) );
    }
}

void DiskRedirection::on_removeButton_clicked()
{
    for (int i = 0; i < ui->listWidget->selectedItems().count(); i++)
    {
        delete ui->listWidget->selectedItems().at(i);
    }
}
