#include "container.h"

Container::Container(QWidget * parent) : QWidget( parent )
{
	_closing = false;
}

void Container::closeEvent(QCloseEvent *event)
{
	if ( ! _closing )
	{
		qDebug("Close requested!");
		emit closeRequested();
	} else {
		QWidget::closeEvent( event );
	}
}

void Container::closeContainer()
{
	qDebug("Closing");
	_closing = true;
	hide();
}
