#ifndef CONFIGURESERVERS_H
#define CONFIGURESERVERS_H

#include <QDialog>
#include <QModelIndex>
#include <QListWidgetItem>
#include <QMessageBox>

#include "clientsettings.h"

namespace Ui {
class ConfigureServers;
}

class ConfigureServers : public QDialog
{
    Q_OBJECT

public:
    explicit ConfigureServers(QWidget * parent, ClientSettings * settings);
    ~ConfigureServers();

public slots:
    void serversChanged();

private slots:
    void on_addButton_clicked();
    void on_buttonBox_accepted();
    void on_deleteButton_clicked();
    void accept();

    void on_serverList_itemDoubleClicked(QListWidgetItem *item);

private:
    Ui::ConfigureServers *ui;

    ClientSettings * settings;
};

#endif // CONFIGURESERVERS_H
