#include "configureservers.h"
#include "ui_configureservers.h"

#include "editserver.h"

ConfigureServers::ConfigureServers(QWidget *parent, ClientSettings * settings) :
    QDialog(parent),
    ui(new Ui::ConfigureServers)
{
    this->settings = settings;
    ui->setupUi(this);
	ui->buttonBox->button(QDialogButtonBox::Ok)->setText(tr("OK"));
	ui->buttonBox->button(QDialogButtonBox::Cancel)->setText(tr("Cancel"));
    serversChanged();
}

ConfigureServers::~ConfigureServers()
{
    delete ui;
}

void ConfigureServers::serversChanged()
{
    ui->serverList->clear();
    QStringList serverList = settings->defaultServersList() + settings->serverList();
    for (int i = 0; i < serverList.count(); i++)
    {
        QListWidgetItem * item = new QListWidgetItem(settings->getIcon(serverList[i]), serverList[i]);
        ui->serverList->addItem( item );
    }
}

void ConfigureServers::on_addButton_clicked()
{
	EditServer * editServer = new EditServer(0, settings);
    connect(editServer, SIGNAL(accepted()), this, SLOT(serversChanged()));
    editServer->show();
}

void ConfigureServers::on_buttonBox_accepted()
{
    QStringList serverStringList;
    for (int i=0; i < ui->serverList->count(); i++)
    {
         serverStringList.append(ui->serverList->item(i)->text());
    }
    settings->sync();
    QDialog::accept();
}

void ConfigureServers::on_deleteButton_clicked()
{
    if ( ui->serverList->currentItem() != 0 )
    {
        QString name = ui->serverList->currentItem()->text();
        if ( QMessageBox::question( this, tr("Delete connection information"), tr("You are going to remove connection configuration for host '%1'. Are you sure you want to do that?").arg(name), QMessageBox::Yes, QMessageBox::No) == QMessageBox::Yes )
        {
            settings->removeServer( name );
            serversChanged();
        }
    }
}
void ConfigureServers::accept()
{
    settings->sync();
}

void ConfigureServers::on_serverList_itemDoubleClicked(QListWidgetItem *item)
{
    EditServer * editServer = new EditServer(this, settings, item->text());
    connect(editServer, SIGNAL(accepted()), this, SLOT(serversChanged()));
    editServer->show();
}
