#ifndef COMMAND_H
#define COMMAND_H

#include <QObject>
#include <QDebug>
#include <QApplication>
#include <QByteArray>
#include <QString>
#include <QStringList>
#include <QProcess>
#include <QFile>
#include <QFileInfo>
#include <QMessageBox>
#include <QTemporaryFile>
#include <QTextStream>
#include <QDir>

#ifdef Q_OS_MAC
#include <libproc.h>
#endif

#include "clientsettings.h"
#include "toolbar.h"

#ifdef Q_OS_WIN
#define USE_MSTSC 1 // 1: Use mstsc.exe 0: Use wfreerdp.exe
#include "Windows.h"
#include "wincrypt.h"
#include "dpapi.h"
#endif

class Command : public QObject
{
	Q_OBJECT

	public:
		Command(QString username, QString password, QString host, int port, ClientSettings *settings, QString connName, QWidget * containerWidget, bool fullWidth = false);

		QString getCommand();
		QStringList getArguments();
		static void clearMstsc(QString hostName, QString tempFile);

	private:
		bool newFreerdpCommand();
		QStringList oldFreerdpArguments(QString username, QString password, QString host, int port, ClientSettings * settings, QString connName, QWidget * containerWidget);
		QStringList newFreerdpArguments(QString username, QString password, QString host, int port, ClientSettings * settings, QString connName, QWidget * containerWidget);
		QStringList mstscArguments(QString username, QString password, QString host, int port, ClientSettings * settings, QString connName );
		QString rdpCommand();
		static QString cryptPassword(QString password);

		QString command;
		QStringList arguments;
		bool fullWidth;
};

#endif // COMMAND_H
