#ifndef CLIENTSETTINGS_H
#define CLIENTSETTINGS_H

#include <QString>
#include <QStringList>
#include <QSize>
#include <QList>
#include <QVariant>
#include <QSettings>
#include <QIcon>
#include <QDebug>

#include "clientconstants.h"

#define APP_PREFIX QString("Application::")

#define OK_NAME 0
#define EXISTING_NAME 1
#define BAD_NAME 2

#if VERSION_TYPE == 0 // free
#define FREE_VERSION 1
#define DEFAULT_SERVER FREE_SERVER
#endif

#if VERSION_TYPE == 1 // premium
#define FREE_VERSION 1
#define DEFAULT_SERVER PREMIUM_SERVER
#endif

#if VERSION_TYPE == 2 // business
#define FREE_VERSION 0
#define DEFAULT_SERVER ""
#endif

class ClientSettings
{
public:
	ClientSettings();
	~ClientSettings();

	int addServer(QString name);
	bool removeServer(QString name);
	QStringList serverList();
	QStringList userServerList();
	QStringList defaultServersList();

	void rename(QString oldName, QString newName);
	void sync();

	QStringList serverTypes();
	QStringList screenSizes();
	QStringList colorDepths();
	QStringList appNames();
	QStringList rfxModes();

	QString getLastLogin();
	QString getLastServer();
	QString getLogin(QString name);
	QIcon getIcon(QString name);
	QString getServer(QString name);
	QString getType(QString name);
	bool canCheckAuth(QString name);
	QString getDomain(QString name);
	long getPort(QString name);
	QString getScreenSize(QString name);
	QString getOrientation(QString name);
	int getColorDepth(QString name);
	QString getDriveRedirect(QString name);
	QString getDriveRedirectFolder(QString name);
	QStringList getDriveRedirectFolders(QString name);
	QStringList getExcludedApps(QString name);
	QString getUserWhiteList(QString name);
	QString getUserBlackList(QString name);
	bool getSmartCardRedirect(QString name);
	bool getHomeRedirect(QString name);
	bool getRemovableRedirect(QString name);
	bool getPrintersRedirect(QString name);
	bool getSoundRedirect(QString name);
	bool getMicrophoneRedirect(QString name);
	bool getWallpaper(QString name);
	bool getEffects(QString name);
	QString getRfxMode(QString name);
	bool getMultimonSupport(QString name);
	bool getPortKnocker(QString name);
	QStringList getExtraArgs(QString name);

	QString getAppExec(QString appName);
	QString getAppExecArgs(QString appName);
	QStringList getAppExecEnv(QString appName);
	QString getAppIcon(QString appName);
	QString getAppWindowName(QString appName);
	bool isAppEnabled(QString appName);

	void setLastLogin(QString lastLogin);
	void setLastServer(QString lastServer);
	void setLogin(QString name, QString login);
	void setServer(QString name, QString server);
	void setType(QString name, QString connType);
	void setDomain(QString name, QString domain);
	void setPort(QString name, long port);
	void setScreenSize(QString name, QString screenSize);
	void setOrientation(QString name, QString orientation);
	void setColorDepth(QString name, int colorDepth);
	void setDriveRedirect(QString name, QString redirectDrive);
	void setDriveRedirectFolder(QString name, QString folder);
	void setDriveRedirectFolders(QString name, QStringList folders);
	void setExcludedApps(QString name, QStringList apps);
	void setUserWhiteList(QString name, QString userWhiteList);
	void setUserBlackList(QString name, QString userBlackList);
	void setSmartCardRedirect(QString name, bool redirectSmartCard);
	void setHomeRedirect(QString name, bool redirectHome);
	void setRemovableRedirect(QString name, bool redirectRemovable);
	void setPrintersRedirect(QString name, bool redirectPrinters);
	void setSoundRedirect(QString name, bool redirectSound);
	void setMicrophoneRedirect(QString name, bool redirectMicrophone);
	void setWallpaper(QString name, bool enableWallpaper);
	void setEffects(QString name, bool enableEffects);
	void setRfxMode(QString name, QString rfxMode);
	void setMultimonSupport(QString name, bool enableMultimon);
	void setExtraArgs(QString name, QStringList args);

private:
	void fixClientSettings();
	QVariant getValue(QString name, QString key, QVariant defaultValue = QVariant());

	QSettings * userSettings;
	QSettings * systemSettings;
};

#endif // CLIENTSETTINGS_H
