#ifndef CLIENTSESSION_H
#define CLIENTSESSION_H

#include <QWidget>
#include <QWindow>
#include <QProcess>
#include <QDialog>
#include <QApplication>
#include <QGuiApplication>
#include <QSettings>
#include <QDateTime>
#include <QThread>
#include <QMutex>
#include <QShowEvent>

#include "clientsettings.h"
#include "command.h"
#include "toolbar.h"
#include "container.h"
#include "clientappbutton.h"

#define RDP_TIMEOUT 20 // seconds
#define PROCESS_TIMEOUT 5000 // miliseconds

class ClientSession : public QObject
{
    Q_OBJECT

public:
	explicit ClientSession(ClientSettings * settings = 0, QWidget *parent = 0, bool hideContainer = false);
	~ClientSession();

	static bool authenticateRemoteUser(QString username, QString password, QString serverConfig);
	void launchProcess(QString username, QString password, QString server, int connPort = 0);
	void launchRemovableManagerProcess();

public slots:
	void showContainer();
	void refreshConnection();
	void finish();
	void launchProcess();

private slots:
	void finished(int);

private:
	void mountSmbShares(QString username, QString password);
	void smbMount(QString credentialsFile, QString smbPath, QString targetPath);
	void smbUmountAll();
	QString credentialsFile();

signals:
	void started();
	void finished();
	void containerCreated();

private:
	QProcess * process;
	QProcess * removableManagerProcess;
	ClientSettings * settings;
	bool deleteSettingsOnDestroy;
	bool errorShown;
	QWidget * parent;
	Container * container;
	QWidget * containerWidget;
	ToolBar * bar;
	QDateTime processStart;
	QString username;
	QString password;
	QString server;
	QString serverAddress;
	int serverPort;
	int connPort;
	bool hideContainer;
	QMutex mutex;
	QString hostname;
	QString tempFile;
};

#endif // CLIENTSESSION_H
