#ifndef CLIENTAPPBUTTON_H
#define CLIENTAPPBUTTON_H

#include <QPushButton>
#include <QString>
#include <QProcess>
#include <QProcessEnvironment>
#include <QFile>
#include <QDir>
#include <QDebug>

#include "clientconstants.h"
#include "clientsettings.h"

class ClientAppButton : public QPushButton
{
Q_OBJECT

public:
	ClientAppButton(ClientSettings * settings, QString name, QWidget *parent = 0, QProcess * process = 0);

	static bool isInstalled(ClientSettings * settings, QString appName, QString name);

public slots:
	void buttonClicked();

private:
	void setExec(QString exec);

	QString name;
	QString exec;
	QProcess * process;
	ClientSettings * settings;
};

#endif // APPBUTTON_H
