#include "clientappbutton.h"

ClientAppButton::ClientAppButton(ClientSettings * settings, QString name, QWidget * parent, QProcess * process) : QPushButton( "", parent )
{
	this->name = name;
	this->settings = settings;
	this->process = process;

	setIcon(QIcon(settings->getAppIcon(name)));

	connect( this, SIGNAL(clicked()), this, SLOT(buttonClicked()));
}

bool ClientAppButton::isInstalled(ClientSettings * settings, QString appName, QString name)
{
	return QFile::exists(settings->getAppExec(appName)) && QFile::exists(settings->getAppIcon(appName)) && settings->isAppEnabled(appName) && ! settings->getExcludedApps(name).contains(appName);
}

void ClientAppButton::buttonClicked()
{
	bool running = false;
	if (process != 0)
	{
		if ( process->state() == QProcess::Running )
		{
			running = true;
		} else {
			delete process;
		}
	}

	if ( ! running )
	{
		process = new QProcess(this);
		QProcessEnvironment env = QProcessEnvironment::systemEnvironment();
		QStringList appExecEnv = settings->getAppExecEnv(name);
		for ( int i = 0; i < appExecEnv.count(); i++ )
		{
			if ( appExecEnv[i].contains('=') )
			{
				QString envName = appExecEnv[i].section( '=', 0, 0 );
				QString envValue = appExecEnv[i].section( '=', 1 );
				env.insert( envName, envValue );
			}
		}
		process->setProcessEnvironment(QProcessEnvironment::systemEnvironment());
		process->setWorkingDirectory( QDir::homePath() );
		QString command = settings->getAppExec(name);
		QStringList arguments;
		QString argumentsString = settings->getAppExecArgs(name).simplified();
		if ( ! argumentsString.isEmpty() )
		{
			arguments = argumentsString.split(" ");
		}
		process->start( command, arguments );
	} else {
		QProcess raise(this);
		QString command = CLIENT_DATA_DIR "/raisewindow.sh";
		QStringList arguments;
		arguments += "-p";
		arguments += QString::number((long long)process->processId());
		raise.start( command, arguments );
		raise.waitForFinished();
		qDebug() << raise.readAll();
	}
}
