/*
 * Copyright 2022 Asahi Lina
 * SPDX-License-Identifier: MIT
 */

#include <gtest/gtest.h>
#include "layout.h"

/*
 * Test uncompressed texture sizes. All test cases in this file are extracted from
 * texture structure dumps in Metal.
 */
struct sizetest {
   enum pipe_format format;
   uint32_t width, height, depth;
   uint8_t levels;
   uint32_t size;
};

/* Sort: `sort -t"," -k1,1 -k2,5n | uniq` */
static struct sizetest sizetests[] = {
   { PIPE_FORMAT_R8_UNORM, 1, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_R8_UNORM, 1, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_R8_UNORM, 1, 2, 1, 2, 0x100 },
   { PIPE_FORMAT_R8_UNORM, 1, 2, 2, 2, 0x200 },
   { PIPE_FORMAT_R8_UNORM, 1, 4, 1, 3, 0x180 },
   { PIPE_FORMAT_R8_UNORM, 1, 4, 2, 3, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 1, 8, 1, 4, 0x200 },
   { PIPE_FORMAT_R8_UNORM, 1, 8, 2, 4, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 1, 15, 1, 4, 0x200 },
   { PIPE_FORMAT_R8_UNORM, 1, 15, 2, 4, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 1, 16, 1, 5, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 1, 16, 2, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 1, 17, 1, 5, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 1, 17, 2, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 1, 31, 1, 5, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 1, 31, 2, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 1, 32, 1, 6, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 1, 32, 2, 6, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 1, 33, 1, 6, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 1, 33, 2, 6, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 1, 63, 1, 6, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 1, 63, 2, 6, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 1, 64, 1, 7, 0x380 },
   { PIPE_FORMAT_R8_UNORM, 1, 64, 2, 7, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 1, 65, 1, 7, 0x380 },
   { PIPE_FORMAT_R8_UNORM, 1, 65, 2, 7, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 1, 127, 1, 7, 0x380 },
   { PIPE_FORMAT_R8_UNORM, 1, 127, 2, 7, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 1, 128, 1, 8, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 1, 128, 2, 8, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 1, 129, 1, 8, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 1, 129, 2, 8, 0x900 },
   { PIPE_FORMAT_R8_UNORM, 1, 255, 1, 8, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 1, 255, 2, 8, 0x900 },
   { PIPE_FORMAT_R8_UNORM, 1, 256, 1, 9, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 1, 256, 2, 9, 0xa00 },
   { PIPE_FORMAT_R8_UNORM, 1, 257, 1, 9, 0x680 },
   { PIPE_FORMAT_R8_UNORM, 1, 257, 2, 9, 0xd00 },
   { PIPE_FORMAT_R8_UNORM, 1, 511, 1, 9, 0x680 },
   { PIPE_FORMAT_R8_UNORM, 1, 511, 2, 9, 0xd00 },
   { PIPE_FORMAT_R8_UNORM, 1, 512, 1, 10, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 1, 512, 2, 10, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 1, 513, 1, 10, 0xa80 },
   { PIPE_FORMAT_R8_UNORM, 1, 513, 2, 10, 0x1500 },
   { PIPE_FORMAT_R8_UNORM, 1, 1023, 1, 10, 0xa80 },
   { PIPE_FORMAT_R8_UNORM, 1, 1023, 2, 10, 0x1500 },
   { PIPE_FORMAT_R8_UNORM, 1, 1024, 1, 11, 0xb00 },
   { PIPE_FORMAT_R8_UNORM, 1, 1024, 2, 11, 0x1600 },
   { PIPE_FORMAT_R8_UNORM, 1, 1025, 1, 11, 0x1280 },
   { PIPE_FORMAT_R8_UNORM, 1, 1025, 2, 11, 0x2500 },
   { PIPE_FORMAT_R8_UNORM, 1, 2047, 1, 11, 0x1280 },
   { PIPE_FORMAT_R8_UNORM, 1, 2047, 2, 11, 0x2500 },
   { PIPE_FORMAT_R8_UNORM, 1, 2048, 1, 12, 0x1300 },
   { PIPE_FORMAT_R8_UNORM, 1, 2048, 2, 12, 0x2600 },
   { PIPE_FORMAT_R8_UNORM, 1, 2049, 1, 12, 0x2280 },
   { PIPE_FORMAT_R8_UNORM, 1, 2049, 2, 12, 0x4500 },
   { PIPE_FORMAT_R8_UNORM, 1, 4095, 1, 12, 0x2280 },
   { PIPE_FORMAT_R8_UNORM, 1, 4095, 2, 12, 0x4500 },
   { PIPE_FORMAT_R8_UNORM, 1, 4096, 1, 13, 0x2300 },
   { PIPE_FORMAT_R8_UNORM, 1, 4096, 2, 13, 0x4600 },
   { PIPE_FORMAT_R8_UNORM, 1, 4097, 1, 13, 0x4280 },
   { PIPE_FORMAT_R8_UNORM, 1, 4097, 2, 13, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 2, 1, 1, 2, 0x100 },
   { PIPE_FORMAT_R8_UNORM, 2, 1, 2, 2, 0x200 },
   { PIPE_FORMAT_R8_UNORM, 2, 2, 1, 2, 0x100 },
   { PIPE_FORMAT_R8_UNORM, 2, 2, 2, 2, 0x200 },
   { PIPE_FORMAT_R8_UNORM, 2, 4, 1, 3, 0x180 },
   { PIPE_FORMAT_R8_UNORM, 2, 4, 2, 3, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 2, 8, 1, 4, 0x200 },
   { PIPE_FORMAT_R8_UNORM, 2, 8, 2, 4, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 2, 15, 1, 4, 0x200 },
   { PIPE_FORMAT_R8_UNORM, 2, 15, 2, 4, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 2, 16, 1, 5, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 2, 16, 2, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 2, 17, 1, 5, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 2, 17, 2, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 2, 31, 1, 5, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 2, 31, 2, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 2, 32, 1, 6, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 2, 32, 2, 6, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 2, 33, 1, 6, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 2, 33, 2, 6, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 2, 63, 1, 6, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 2, 63, 2, 6, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 2, 64, 1, 7, 0x380 },
   { PIPE_FORMAT_R8_UNORM, 2, 64, 2, 7, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 2, 65, 1, 7, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 2, 65, 2, 7, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 2, 127, 1, 7, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 2, 127, 2, 7, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 2, 128, 1, 8, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 2, 128, 2, 8, 0x900 },
   { PIPE_FORMAT_R8_UNORM, 2, 129, 1, 8, 0x580 },
   { PIPE_FORMAT_R8_UNORM, 2, 129, 2, 8, 0xb00 },
   { PIPE_FORMAT_R8_UNORM, 2, 255, 1, 8, 0x580 },
   { PIPE_FORMAT_R8_UNORM, 2, 255, 2, 8, 0xb00 },
   { PIPE_FORMAT_R8_UNORM, 2, 256, 1, 9, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 2, 256, 2, 9, 0xc00 },
   { PIPE_FORMAT_R8_UNORM, 2, 257, 1, 9, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 2, 257, 2, 9, 0x1100 },
   { PIPE_FORMAT_R8_UNORM, 2, 511, 1, 9, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 2, 511, 2, 9, 0x1100 },
   { PIPE_FORMAT_R8_UNORM, 2, 512, 1, 10, 0x900 },
   { PIPE_FORMAT_R8_UNORM, 2, 512, 2, 10, 0x1200 },
   { PIPE_FORMAT_R8_UNORM, 2, 513, 1, 10, 0xe80 },
   { PIPE_FORMAT_R8_UNORM, 2, 513, 2, 10, 0x1d00 },
   { PIPE_FORMAT_R8_UNORM, 2, 1023, 1, 10, 0xe80 },
   { PIPE_FORMAT_R8_UNORM, 2, 1023, 2, 10, 0x1d00 },
   { PIPE_FORMAT_R8_UNORM, 2, 1024, 1, 11, 0xf00 },
   { PIPE_FORMAT_R8_UNORM, 2, 1024, 2, 11, 0x1e00 },
   { PIPE_FORMAT_R8_UNORM, 2, 1025, 1, 11, 0x1a80 },
   { PIPE_FORMAT_R8_UNORM, 2, 1025, 2, 11, 0x3500 },
   { PIPE_FORMAT_R8_UNORM, 2, 2047, 1, 11, 0x1a80 },
   { PIPE_FORMAT_R8_UNORM, 2, 2047, 2, 11, 0x3500 },
   { PIPE_FORMAT_R8_UNORM, 2, 2048, 1, 12, 0x1b00 },
   { PIPE_FORMAT_R8_UNORM, 2, 2048, 2, 12, 0x3600 },
   { PIPE_FORMAT_R8_UNORM, 2, 2049, 1, 12, 0x3280 },
   { PIPE_FORMAT_R8_UNORM, 2, 2049, 2, 12, 0x6500 },
   { PIPE_FORMAT_R8_UNORM, 2, 4095, 1, 12, 0x3280 },
   { PIPE_FORMAT_R8_UNORM, 2, 4095, 2, 12, 0x6500 },
   { PIPE_FORMAT_R8_UNORM, 2, 4096, 1, 13, 0x3300 },
   { PIPE_FORMAT_R8_UNORM, 2, 4096, 2, 13, 0x6600 },
   { PIPE_FORMAT_R8_UNORM, 2, 4097, 1, 13, 0x6280 },
   { PIPE_FORMAT_R8_UNORM, 2, 4097, 2, 13, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 4, 1, 1, 3, 0x180 },
   { PIPE_FORMAT_R8_UNORM, 4, 1, 2, 3, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 4, 2, 1, 3, 0x180 },
   { PIPE_FORMAT_R8_UNORM, 4, 2, 2, 3, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 4, 4, 1, 3, 0x180 },
   { PIPE_FORMAT_R8_UNORM, 4, 4, 2, 3, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 4, 8, 1, 4, 0x200 },
   { PIPE_FORMAT_R8_UNORM, 4, 8, 2, 4, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 4, 15, 1, 4, 0x200 },
   { PIPE_FORMAT_R8_UNORM, 4, 15, 2, 4, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 4, 16, 1, 5, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 4, 16, 2, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 4, 17, 1, 5, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 4, 17, 2, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 4, 31, 1, 5, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 4, 31, 2, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 4, 32, 1, 6, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 4, 32, 2, 6, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 4, 33, 1, 6, 0x380 },
   { PIPE_FORMAT_R8_UNORM, 4, 33, 2, 6, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 4, 63, 1, 6, 0x380 },
   { PIPE_FORMAT_R8_UNORM, 4, 63, 2, 6, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 4, 64, 1, 7, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 4, 64, 2, 7, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 4, 65, 1, 7, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 4, 65, 2, 7, 0xa00 },
   { PIPE_FORMAT_R8_UNORM, 4, 127, 1, 7, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 4, 127, 2, 7, 0xa00 },
   { PIPE_FORMAT_R8_UNORM, 4, 128, 1, 8, 0x580 },
   { PIPE_FORMAT_R8_UNORM, 4, 128, 2, 8, 0xb00 },
   { PIPE_FORMAT_R8_UNORM, 4, 129, 1, 8, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 4, 129, 2, 8, 0x1000 },
   { PIPE_FORMAT_R8_UNORM, 4, 255, 1, 8, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 4, 255, 2, 8, 0x1000 },
   { PIPE_FORMAT_R8_UNORM, 4, 256, 1, 9, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 4, 256, 2, 9, 0x1100 },
   { PIPE_FORMAT_R8_UNORM, 4, 257, 1, 9, 0xd80 },
   { PIPE_FORMAT_R8_UNORM, 4, 257, 2, 9, 0x1b00 },
   { PIPE_FORMAT_R8_UNORM, 4, 511, 1, 9, 0xd80 },
   { PIPE_FORMAT_R8_UNORM, 4, 511, 2, 9, 0x1b00 },
   { PIPE_FORMAT_R8_UNORM, 4, 512, 1, 10, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 4, 512, 2, 10, 0x1c00 },
   { PIPE_FORMAT_R8_UNORM, 4, 513, 1, 10, 0x1880 },
   { PIPE_FORMAT_R8_UNORM, 4, 513, 2, 10, 0x3100 },
   { PIPE_FORMAT_R8_UNORM, 4, 1023, 1, 10, 0x1880 },
   { PIPE_FORMAT_R8_UNORM, 4, 1023, 2, 10, 0x3100 },
   { PIPE_FORMAT_R8_UNORM, 4, 1024, 1, 11, 0x1900 },
   { PIPE_FORMAT_R8_UNORM, 4, 1024, 2, 11, 0x3200 },
   { PIPE_FORMAT_R8_UNORM, 4, 1025, 1, 11, 0x2e80 },
   { PIPE_FORMAT_R8_UNORM, 4, 1025, 2, 11, 0x5d00 },
   { PIPE_FORMAT_R8_UNORM, 4, 2047, 1, 11, 0x2e80 },
   { PIPE_FORMAT_R8_UNORM, 4, 2047, 2, 11, 0x5d00 },
   { PIPE_FORMAT_R8_UNORM, 4, 2048, 1, 12, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 4, 2048, 2, 12, 0x5e00 },
   { PIPE_FORMAT_R8_UNORM, 4, 2049, 1, 12, 0x5a80 },
   { PIPE_FORMAT_R8_UNORM, 4, 2049, 2, 12, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 4, 4095, 1, 12, 0x5a80 },
   { PIPE_FORMAT_R8_UNORM, 4, 4095, 2, 12, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 4, 4096, 1, 13, 0x5b00 },
   { PIPE_FORMAT_R8_UNORM, 4, 4096, 2, 13, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 4, 4097, 1, 13, 0xb280 },
   { PIPE_FORMAT_R8_UNORM, 4, 4097, 2, 13, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 8, 1, 1, 4, 0x200 },
   { PIPE_FORMAT_R8_UNORM, 8, 1, 2, 4, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 8, 2, 1, 4, 0x200 },
   { PIPE_FORMAT_R8_UNORM, 8, 2, 2, 4, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 8, 4, 1, 4, 0x200 },
   { PIPE_FORMAT_R8_UNORM, 8, 4, 2, 4, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 8, 8, 1, 4, 0x200 },
   { PIPE_FORMAT_R8_UNORM, 8, 8, 2, 4, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 8, 15, 1, 4, 0x200 },
   { PIPE_FORMAT_R8_UNORM, 8, 15, 2, 4, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 8, 16, 1, 5, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 8, 16, 2, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 8, 17, 1, 5, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 8, 17, 2, 5, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 8, 31, 1, 5, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 8, 31, 2, 5, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 8, 32, 1, 6, 0x380 },
   { PIPE_FORMAT_R8_UNORM, 8, 32, 2, 6, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 8, 33, 1, 6, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 8, 33, 2, 6, 0x900 },
   { PIPE_FORMAT_R8_UNORM, 8, 63, 1, 6, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 8, 63, 2, 6, 0x900 },
   { PIPE_FORMAT_R8_UNORM, 8, 64, 1, 7, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 8, 64, 2, 7, 0xa00 },
   { PIPE_FORMAT_R8_UNORM, 8, 65, 1, 7, 0x780 },
   { PIPE_FORMAT_R8_UNORM, 8, 65, 2, 7, 0xf00 },
   { PIPE_FORMAT_R8_UNORM, 8, 127, 1, 7, 0x780 },
   { PIPE_FORMAT_R8_UNORM, 8, 127, 2, 7, 0xf00 },
   { PIPE_FORMAT_R8_UNORM, 8, 128, 1, 8, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 8, 128, 2, 8, 0x1000 },
   { PIPE_FORMAT_R8_UNORM, 8, 129, 1, 8, 0xd00 },
   { PIPE_FORMAT_R8_UNORM, 8, 129, 2, 8, 0x1a00 },
   { PIPE_FORMAT_R8_UNORM, 8, 255, 1, 8, 0xd00 },
   { PIPE_FORMAT_R8_UNORM, 8, 255, 2, 8, 0x1a00 },
   { PIPE_FORMAT_R8_UNORM, 8, 256, 1, 9, 0xd80 },
   { PIPE_FORMAT_R8_UNORM, 8, 256, 2, 9, 0x1b00 },
   { PIPE_FORMAT_R8_UNORM, 8, 257, 1, 9, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 8, 257, 2, 9, 0x3000 },
   { PIPE_FORMAT_R8_UNORM, 8, 511, 1, 9, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 8, 511, 2, 9, 0x3000 },
   { PIPE_FORMAT_R8_UNORM, 8, 512, 1, 10, 0x1880 },
   { PIPE_FORMAT_R8_UNORM, 8, 512, 2, 10, 0x3100 },
   { PIPE_FORMAT_R8_UNORM, 8, 513, 1, 10, 0x2d80 },
   { PIPE_FORMAT_R8_UNORM, 8, 513, 2, 10, 0x5b00 },
   { PIPE_FORMAT_R8_UNORM, 8, 1023, 1, 10, 0x2d80 },
   { PIPE_FORMAT_R8_UNORM, 8, 1023, 2, 10, 0x5b00 },
   { PIPE_FORMAT_R8_UNORM, 8, 1024, 1, 11, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 8, 1024, 2, 11, 0x5c00 },
   { PIPE_FORMAT_R8_UNORM, 8, 1025, 1, 11, 0x5880 },
   { PIPE_FORMAT_R8_UNORM, 8, 1025, 2, 11, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 8, 2047, 1, 11, 0x5880 },
   { PIPE_FORMAT_R8_UNORM, 8, 2047, 2, 11, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 8, 2048, 1, 12, 0x5900 },
   { PIPE_FORMAT_R8_UNORM, 8, 2048, 2, 12, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 8, 2049, 1, 12, 0xae80 },
   { PIPE_FORMAT_R8_UNORM, 8, 2049, 2, 12, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 8, 4095, 1, 12, 0xae80 },
   { PIPE_FORMAT_R8_UNORM, 8, 4095, 2, 12, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 8, 4096, 1, 13, 0xaf00 },
   { PIPE_FORMAT_R8_UNORM, 8, 4096, 2, 13, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 8, 4097, 1, 13, 0x15a80 },
   { PIPE_FORMAT_R8_UNORM, 8, 4097, 2, 13, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 15, 1, 1, 4, 0x200 },
   { PIPE_FORMAT_R8_UNORM, 15, 1, 2, 4, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 15, 2, 1, 4, 0x200 },
   { PIPE_FORMAT_R8_UNORM, 15, 2, 2, 4, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 15, 4, 1, 4, 0x200 },
   { PIPE_FORMAT_R8_UNORM, 15, 4, 2, 4, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 15, 8, 1, 4, 0x200 },
   { PIPE_FORMAT_R8_UNORM, 15, 8, 2, 4, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 15, 15, 1, 4, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 15, 15, 2, 4, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 15, 16, 1, 5, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 15, 16, 2, 5, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 15, 17, 1, 5, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 15, 17, 2, 5, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 15, 31, 1, 5, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 15, 31, 2, 5, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 15, 32, 1, 6, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 15, 32, 2, 6, 0x900 },
   { PIPE_FORMAT_R8_UNORM, 15, 33, 1, 6, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 15, 33, 2, 6, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 15, 63, 1, 6, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 15, 63, 2, 6, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 15, 64, 1, 7, 0x780 },
   { PIPE_FORMAT_R8_UNORM, 15, 64, 2, 7, 0xf00 },
   { PIPE_FORMAT_R8_UNORM, 15, 65, 1, 7, 0xc80 },
   { PIPE_FORMAT_R8_UNORM, 15, 65, 2, 7, 0x1900 },
   { PIPE_FORMAT_R8_UNORM, 15, 127, 1, 7, 0xc80 },
   { PIPE_FORMAT_R8_UNORM, 15, 127, 2, 7, 0x1900 },
   { PIPE_FORMAT_R8_UNORM, 15, 128, 1, 8, 0xd00 },
   { PIPE_FORMAT_R8_UNORM, 15, 128, 2, 8, 0x1a00 },
   { PIPE_FORMAT_R8_UNORM, 15, 129, 1, 8, 0x1780 },
   { PIPE_FORMAT_R8_UNORM, 15, 129, 2, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 15, 255, 1, 8, 0x1780 },
   { PIPE_FORMAT_R8_UNORM, 15, 255, 2, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 15, 256, 1, 9, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 15, 256, 2, 9, 0x3000 },
   { PIPE_FORMAT_R8_UNORM, 15, 257, 1, 9, 0x2d00 },
   { PIPE_FORMAT_R8_UNORM, 15, 257, 2, 9, 0x5a00 },
   { PIPE_FORMAT_R8_UNORM, 15, 511, 1, 9, 0x2d00 },
   { PIPE_FORMAT_R8_UNORM, 15, 511, 2, 9, 0x5a00 },
   { PIPE_FORMAT_R8_UNORM, 15, 512, 1, 10, 0x2d80 },
   { PIPE_FORMAT_R8_UNORM, 15, 512, 2, 10, 0x5b00 },
   { PIPE_FORMAT_R8_UNORM, 15, 513, 1, 10, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 15, 513, 2, 10, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 15, 1023, 1, 10, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 15, 1023, 2, 10, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 15, 1024, 1, 11, 0x5880 },
   { PIPE_FORMAT_R8_UNORM, 15, 1024, 2, 11, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 15, 1025, 1, 11, 0xad80 },
   { PIPE_FORMAT_R8_UNORM, 15, 1025, 2, 11, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 15, 2047, 1, 11, 0xad80 },
   { PIPE_FORMAT_R8_UNORM, 15, 2047, 2, 11, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 15, 2048, 1, 12, 0xae00 },
   { PIPE_FORMAT_R8_UNORM, 15, 2048, 2, 12, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 15, 2049, 1, 12, 0x15880 },
   { PIPE_FORMAT_R8_UNORM, 15, 2049, 2, 12, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 15, 4095, 1, 12, 0x15880 },
   { PIPE_FORMAT_R8_UNORM, 15, 4095, 2, 12, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 15, 4096, 1, 13, 0x15900 },
   { PIPE_FORMAT_R8_UNORM, 15, 4096, 2, 13, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 15, 4097, 1, 13, 0x2ae80 },
   { PIPE_FORMAT_R8_UNORM, 15, 4097, 2, 13, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 16, 1, 1, 5, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 16, 1, 2, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 16, 2, 1, 5, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 16, 2, 2, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 16, 4, 1, 5, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 16, 4, 2, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 16, 8, 1, 5, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 16, 8, 2, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 16, 15, 1, 5, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 16, 15, 2, 5, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 16, 16, 1, 5, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 16, 16, 2, 5, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 16, 17, 1, 5, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 16, 17, 2, 5, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 16, 31, 1, 5, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 16, 31, 2, 5, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 16, 32, 1, 6, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 16, 32, 2, 6, 0x900 },
   { PIPE_FORMAT_R8_UNORM, 16, 33, 1, 6, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 16, 33, 2, 6, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 16, 63, 1, 6, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 16, 63, 2, 6, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 16, 64, 1, 7, 0x780 },
   { PIPE_FORMAT_R8_UNORM, 16, 64, 2, 7, 0xf00 },
   { PIPE_FORMAT_R8_UNORM, 16, 65, 1, 7, 0xc80 },
   { PIPE_FORMAT_R8_UNORM, 16, 65, 2, 7, 0x1900 },
   { PIPE_FORMAT_R8_UNORM, 16, 127, 1, 7, 0xc80 },
   { PIPE_FORMAT_R8_UNORM, 16, 127, 2, 7, 0x1900 },
   { PIPE_FORMAT_R8_UNORM, 16, 128, 1, 8, 0xd00 },
   { PIPE_FORMAT_R8_UNORM, 16, 128, 2, 8, 0x1a00 },
   { PIPE_FORMAT_R8_UNORM, 16, 129, 1, 8, 0x1780 },
   { PIPE_FORMAT_R8_UNORM, 16, 129, 2, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 16, 255, 1, 8, 0x1780 },
   { PIPE_FORMAT_R8_UNORM, 16, 255, 2, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 16, 256, 1, 9, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 16, 256, 2, 9, 0x3000 },
   { PIPE_FORMAT_R8_UNORM, 16, 257, 1, 9, 0x2d00 },
   { PIPE_FORMAT_R8_UNORM, 16, 257, 2, 9, 0x5a00 },
   { PIPE_FORMAT_R8_UNORM, 16, 511, 1, 9, 0x2d00 },
   { PIPE_FORMAT_R8_UNORM, 16, 511, 2, 9, 0x5a00 },
   { PIPE_FORMAT_R8_UNORM, 16, 512, 1, 10, 0x2d80 },
   { PIPE_FORMAT_R8_UNORM, 16, 512, 2, 10, 0x5b00 },
   { PIPE_FORMAT_R8_UNORM, 16, 513, 1, 10, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 16, 513, 2, 10, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 16, 1023, 1, 10, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 16, 1023, 2, 10, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 16, 1024, 1, 11, 0x5880 },
   { PIPE_FORMAT_R8_UNORM, 16, 1024, 2, 11, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 16, 1025, 1, 11, 0xad80 },
   { PIPE_FORMAT_R8_UNORM, 16, 1025, 2, 11, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 16, 2047, 1, 11, 0xad80 },
   { PIPE_FORMAT_R8_UNORM, 16, 2047, 2, 11, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 16, 2048, 1, 12, 0xae00 },
   { PIPE_FORMAT_R8_UNORM, 16, 2048, 2, 12, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 16, 2049, 1, 12, 0x15880 },
   { PIPE_FORMAT_R8_UNORM, 16, 2049, 2, 12, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 16, 4095, 1, 12, 0x15880 },
   { PIPE_FORMAT_R8_UNORM, 16, 4095, 2, 12, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 16, 4096, 1, 13, 0x15900 },
   { PIPE_FORMAT_R8_UNORM, 16, 4096, 2, 13, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 16, 4097, 1, 13, 0x2ae80 },
   { PIPE_FORMAT_R8_UNORM, 16, 4097, 2, 13, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 17, 1, 1, 5, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 17, 1, 2, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 17, 2, 1, 5, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 17, 2, 2, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 17, 4, 1, 5, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 17, 4, 2, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 17, 8, 1, 5, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 17, 8, 2, 5, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 17, 15, 1, 5, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 17, 15, 2, 5, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 17, 16, 1, 5, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 17, 16, 2, 5, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 17, 17, 1, 5, 0x680 },
   { PIPE_FORMAT_R8_UNORM, 17, 17, 2, 5, 0xd00 },
   { PIPE_FORMAT_R8_UNORM, 17, 31, 1, 5, 0x680 },
   { PIPE_FORMAT_R8_UNORM, 17, 31, 2, 5, 0xd00 },
   { PIPE_FORMAT_R8_UNORM, 17, 32, 1, 6, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 17, 32, 2, 6, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 17, 33, 1, 6, 0xc00 },
   { PIPE_FORMAT_R8_UNORM, 17, 33, 2, 6, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 17, 63, 1, 6, 0xc00 },
   { PIPE_FORMAT_R8_UNORM, 17, 63, 2, 6, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 17, 64, 1, 7, 0xc80 },
   { PIPE_FORMAT_R8_UNORM, 17, 64, 2, 7, 0x1900 },
   { PIPE_FORMAT_R8_UNORM, 17, 65, 1, 7, 0x1700 },
   { PIPE_FORMAT_R8_UNORM, 17, 65, 2, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 17, 127, 1, 7, 0x1700 },
   { PIPE_FORMAT_R8_UNORM, 17, 127, 2, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 17, 128, 1, 8, 0x1780 },
   { PIPE_FORMAT_R8_UNORM, 17, 128, 2, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 17, 129, 1, 8, 0x2c80 },
   { PIPE_FORMAT_R8_UNORM, 17, 129, 2, 8, 0x5900 },
   { PIPE_FORMAT_R8_UNORM, 17, 255, 1, 8, 0x2c80 },
   { PIPE_FORMAT_R8_UNORM, 17, 255, 2, 8, 0x5900 },
   { PIPE_FORMAT_R8_UNORM, 17, 256, 1, 9, 0x2d00 },
   { PIPE_FORMAT_R8_UNORM, 17, 256, 2, 9, 0x5a00 },
   { PIPE_FORMAT_R8_UNORM, 17, 257, 1, 9, 0x5780 },
   { PIPE_FORMAT_R8_UNORM, 17, 257, 2, 9, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 17, 511, 1, 9, 0x5780 },
   { PIPE_FORMAT_R8_UNORM, 17, 511, 2, 9, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 17, 512, 1, 10, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 17, 512, 2, 10, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 17, 513, 1, 10, 0xad00 },
   { PIPE_FORMAT_R8_UNORM, 17, 513, 2, 10, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 17, 1023, 1, 10, 0xad00 },
   { PIPE_FORMAT_R8_UNORM, 17, 1023, 2, 10, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 17, 1024, 1, 11, 0xad80 },
   { PIPE_FORMAT_R8_UNORM, 17, 1024, 2, 11, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 17, 1025, 1, 11, 0x15800 },
   { PIPE_FORMAT_R8_UNORM, 17, 1025, 2, 11, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 17, 2047, 1, 11, 0x15800 },
   { PIPE_FORMAT_R8_UNORM, 17, 2047, 2, 11, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 17, 2048, 1, 12, 0x15880 },
   { PIPE_FORMAT_R8_UNORM, 17, 2048, 2, 12, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 17, 2049, 1, 12, 0x2ad80 },
   { PIPE_FORMAT_R8_UNORM, 17, 2049, 2, 12, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 17, 4095, 1, 12, 0x2ad80 },
   { PIPE_FORMAT_R8_UNORM, 17, 4095, 2, 12, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 17, 4096, 1, 13, 0x2ae00 },
   { PIPE_FORMAT_R8_UNORM, 17, 4096, 2, 13, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 17, 4097, 1, 13, 0x55880 },
   { PIPE_FORMAT_R8_UNORM, 17, 4097, 2, 13, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 31, 1, 1, 5, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 31, 1, 2, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 31, 2, 1, 5, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 31, 2, 2, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 31, 4, 1, 5, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 31, 4, 2, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 31, 8, 1, 5, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 31, 8, 2, 5, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 31, 15, 1, 5, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 31, 15, 2, 5, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 31, 16, 1, 5, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 31, 16, 2, 5, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 31, 17, 1, 5, 0x680 },
   { PIPE_FORMAT_R8_UNORM, 31, 17, 2, 5, 0xd00 },
   { PIPE_FORMAT_R8_UNORM, 31, 31, 1, 5, 0x680 },
   { PIPE_FORMAT_R8_UNORM, 31, 31, 2, 5, 0xd00 },
   { PIPE_FORMAT_R8_UNORM, 31, 32, 1, 6, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 31, 32, 2, 6, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 31, 33, 1, 6, 0xc00 },
   { PIPE_FORMAT_R8_UNORM, 31, 33, 2, 6, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 31, 63, 1, 6, 0xc00 },
   { PIPE_FORMAT_R8_UNORM, 31, 63, 2, 6, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 31, 64, 1, 7, 0xc80 },
   { PIPE_FORMAT_R8_UNORM, 31, 64, 2, 7, 0x1900 },
   { PIPE_FORMAT_R8_UNORM, 31, 65, 1, 7, 0x1700 },
   { PIPE_FORMAT_R8_UNORM, 31, 65, 2, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 31, 127, 1, 7, 0x1700 },
   { PIPE_FORMAT_R8_UNORM, 31, 127, 2, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 31, 128, 1, 8, 0x1780 },
   { PIPE_FORMAT_R8_UNORM, 31, 128, 2, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 31, 129, 1, 8, 0x2c80 },
   { PIPE_FORMAT_R8_UNORM, 31, 129, 2, 8, 0x5900 },
   { PIPE_FORMAT_R8_UNORM, 31, 255, 1, 8, 0x2c80 },
   { PIPE_FORMAT_R8_UNORM, 31, 255, 2, 8, 0x5900 },
   { PIPE_FORMAT_R8_UNORM, 31, 256, 1, 9, 0x2d00 },
   { PIPE_FORMAT_R8_UNORM, 31, 256, 2, 9, 0x5a00 },
   { PIPE_FORMAT_R8_UNORM, 31, 257, 1, 9, 0x5780 },
   { PIPE_FORMAT_R8_UNORM, 31, 257, 2, 9, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 31, 511, 1, 9, 0x5780 },
   { PIPE_FORMAT_R8_UNORM, 31, 511, 2, 9, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 31, 512, 1, 10, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 31, 512, 2, 10, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 31, 513, 1, 10, 0xad00 },
   { PIPE_FORMAT_R8_UNORM, 31, 513, 2, 10, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 31, 1023, 1, 10, 0xad00 },
   { PIPE_FORMAT_R8_UNORM, 31, 1023, 2, 10, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 31, 1024, 1, 11, 0xad80 },
   { PIPE_FORMAT_R8_UNORM, 31, 1024, 2, 11, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 31, 1025, 1, 11, 0x15800 },
   { PIPE_FORMAT_R8_UNORM, 31, 1025, 2, 11, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 31, 2047, 1, 11, 0x15800 },
   { PIPE_FORMAT_R8_UNORM, 31, 2047, 2, 11, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 31, 2048, 1, 12, 0x15880 },
   { PIPE_FORMAT_R8_UNORM, 31, 2048, 2, 12, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 31, 2049, 1, 12, 0x2ad80 },
   { PIPE_FORMAT_R8_UNORM, 31, 2049, 2, 12, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 31, 4095, 1, 12, 0x2ad80 },
   { PIPE_FORMAT_R8_UNORM, 31, 4095, 2, 12, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 31, 4096, 1, 13, 0x2ae00 },
   { PIPE_FORMAT_R8_UNORM, 31, 4096, 2, 13, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 31, 4097, 1, 13, 0x55880 },
   { PIPE_FORMAT_R8_UNORM, 31, 4097, 2, 13, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 32, 1, 1, 6, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 32, 1, 2, 6, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 32, 2, 1, 6, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 32, 2, 2, 6, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 32, 4, 1, 6, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 32, 4, 2, 6, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 32, 8, 1, 6, 0x380 },
   { PIPE_FORMAT_R8_UNORM, 32, 8, 2, 6, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 32, 15, 1, 6, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 32, 15, 2, 6, 0x900 },
   { PIPE_FORMAT_R8_UNORM, 32, 16, 1, 6, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 32, 16, 2, 6, 0x900 },
   { PIPE_FORMAT_R8_UNORM, 32, 17, 1, 6, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 32, 17, 2, 6, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 32, 31, 1, 6, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 32, 31, 2, 6, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 32, 32, 1, 6, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 32, 32, 2, 6, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 32, 33, 1, 6, 0xc00 },
   { PIPE_FORMAT_R8_UNORM, 32, 33, 2, 6, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 32, 63, 1, 6, 0xc00 },
   { PIPE_FORMAT_R8_UNORM, 32, 63, 2, 6, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 32, 64, 1, 7, 0xc80 },
   { PIPE_FORMAT_R8_UNORM, 32, 64, 2, 7, 0x1900 },
   { PIPE_FORMAT_R8_UNORM, 32, 65, 1, 7, 0x1700 },
   { PIPE_FORMAT_R8_UNORM, 32, 65, 2, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 32, 127, 1, 7, 0x1700 },
   { PIPE_FORMAT_R8_UNORM, 32, 127, 2, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 32, 128, 1, 8, 0x1780 },
   { PIPE_FORMAT_R8_UNORM, 32, 128, 2, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 32, 129, 1, 8, 0x2c80 },
   { PIPE_FORMAT_R8_UNORM, 32, 129, 2, 8, 0x5900 },
   { PIPE_FORMAT_R8_UNORM, 32, 255, 1, 8, 0x2c80 },
   { PIPE_FORMAT_R8_UNORM, 32, 255, 2, 8, 0x5900 },
   { PIPE_FORMAT_R8_UNORM, 32, 256, 1, 9, 0x2d00 },
   { PIPE_FORMAT_R8_UNORM, 32, 256, 2, 9, 0x5a00 },
   { PIPE_FORMAT_R8_UNORM, 32, 257, 1, 9, 0x5780 },
   { PIPE_FORMAT_R8_UNORM, 32, 257, 2, 9, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 32, 511, 1, 9, 0x5780 },
   { PIPE_FORMAT_R8_UNORM, 32, 511, 2, 9, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 32, 512, 1, 10, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 32, 512, 2, 10, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 32, 513, 1, 10, 0xad00 },
   { PIPE_FORMAT_R8_UNORM, 32, 513, 2, 10, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 32, 1023, 1, 10, 0xad00 },
   { PIPE_FORMAT_R8_UNORM, 32, 1023, 2, 10, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 32, 1024, 1, 11, 0xad80 },
   { PIPE_FORMAT_R8_UNORM, 32, 1024, 2, 11, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 32, 1025, 1, 11, 0x15800 },
   { PIPE_FORMAT_R8_UNORM, 32, 1025, 2, 11, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 32, 2047, 1, 11, 0x15800 },
   { PIPE_FORMAT_R8_UNORM, 32, 2047, 2, 11, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 32, 2048, 1, 12, 0x15880 },
   { PIPE_FORMAT_R8_UNORM, 32, 2048, 2, 12, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 32, 2049, 1, 12, 0x2ad80 },
   { PIPE_FORMAT_R8_UNORM, 32, 2049, 2, 12, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 32, 4095, 1, 12, 0x2ad80 },
   { PIPE_FORMAT_R8_UNORM, 32, 4095, 2, 12, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 32, 4096, 1, 13, 0x2ae00 },
   { PIPE_FORMAT_R8_UNORM, 32, 4096, 2, 13, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 32, 4097, 1, 13, 0x55880 },
   { PIPE_FORMAT_R8_UNORM, 32, 4097, 2, 13, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 33, 1, 1, 6, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 33, 1, 2, 6, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 33, 2, 1, 6, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 33, 2, 2, 6, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 33, 4, 1, 6, 0x380 },
   { PIPE_FORMAT_R8_UNORM, 33, 4, 2, 6, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 33, 8, 1, 6, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 33, 8, 2, 6, 0x900 },
   { PIPE_FORMAT_R8_UNORM, 33, 15, 1, 6, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 33, 15, 2, 6, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 33, 16, 1, 6, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 33, 16, 2, 6, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 33, 17, 1, 6, 0xc00 },
   { PIPE_FORMAT_R8_UNORM, 33, 17, 2, 6, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 33, 31, 1, 6, 0xc00 },
   { PIPE_FORMAT_R8_UNORM, 33, 31, 2, 6, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 33, 32, 1, 6, 0xc00 },
   { PIPE_FORMAT_R8_UNORM, 33, 32, 2, 6, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 33, 33, 1, 6, 0x1680 },
   { PIPE_FORMAT_R8_UNORM, 33, 33, 2, 6, 0x2d00 },
   { PIPE_FORMAT_R8_UNORM, 33, 63, 1, 6, 0x1680 },
   { PIPE_FORMAT_R8_UNORM, 33, 63, 2, 6, 0x2d00 },
   { PIPE_FORMAT_R8_UNORM, 33, 64, 1, 7, 0x1700 },
   { PIPE_FORMAT_R8_UNORM, 33, 64, 2, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 33, 65, 1, 7, 0x2c00 },
   { PIPE_FORMAT_R8_UNORM, 33, 65, 2, 7, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 33, 127, 1, 7, 0x2c00 },
   { PIPE_FORMAT_R8_UNORM, 33, 127, 2, 7, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 33, 128, 1, 8, 0x2c80 },
   { PIPE_FORMAT_R8_UNORM, 33, 128, 2, 8, 0x5900 },
   { PIPE_FORMAT_R8_UNORM, 33, 129, 1, 8, 0x5700 },
   { PIPE_FORMAT_R8_UNORM, 33, 129, 2, 8, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 33, 255, 1, 8, 0x5700 },
   { PIPE_FORMAT_R8_UNORM, 33, 255, 2, 8, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 33, 256, 1, 9, 0x5780 },
   { PIPE_FORMAT_R8_UNORM, 33, 256, 2, 9, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 33, 257, 1, 9, 0xac80 },
   { PIPE_FORMAT_R8_UNORM, 33, 257, 2, 9, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 33, 511, 1, 9, 0xac80 },
   { PIPE_FORMAT_R8_UNORM, 33, 511, 2, 9, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 33, 512, 1, 10, 0xad00 },
   { PIPE_FORMAT_R8_UNORM, 33, 512, 2, 10, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 33, 513, 1, 10, 0x15780 },
   { PIPE_FORMAT_R8_UNORM, 33, 513, 2, 10, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 33, 1023, 1, 10, 0x15780 },
   { PIPE_FORMAT_R8_UNORM, 33, 1023, 2, 10, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 33, 1024, 1, 11, 0x15800 },
   { PIPE_FORMAT_R8_UNORM, 33, 1024, 2, 11, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 33, 1025, 1, 11, 0x2ad00 },
   { PIPE_FORMAT_R8_UNORM, 33, 1025, 2, 11, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 33, 2047, 1, 11, 0x2ad00 },
   { PIPE_FORMAT_R8_UNORM, 33, 2047, 2, 11, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 33, 2048, 1, 12, 0x2ad80 },
   { PIPE_FORMAT_R8_UNORM, 33, 2048, 2, 12, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 33, 2049, 1, 12, 0x55800 },
   { PIPE_FORMAT_R8_UNORM, 33, 2049, 2, 12, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 33, 4095, 1, 12, 0x55800 },
   { PIPE_FORMAT_R8_UNORM, 33, 4095, 2, 12, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 33, 4096, 1, 13, 0x55880 },
   { PIPE_FORMAT_R8_UNORM, 33, 4096, 2, 13, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 33, 4097, 1, 13, 0xaad80 },
   { PIPE_FORMAT_R8_UNORM, 33, 4097, 2, 13, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 63, 1, 1, 6, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 63, 1, 2, 6, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 63, 2, 1, 6, 0x300 },
   { PIPE_FORMAT_R8_UNORM, 63, 2, 2, 6, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 63, 4, 1, 6, 0x380 },
   { PIPE_FORMAT_R8_UNORM, 63, 4, 2, 6, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 63, 8, 1, 6, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 63, 8, 2, 6, 0x900 },
   { PIPE_FORMAT_R8_UNORM, 63, 15, 1, 6, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 63, 15, 2, 6, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 63, 16, 1, 6, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 63, 16, 2, 6, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 63, 17, 1, 6, 0xc00 },
   { PIPE_FORMAT_R8_UNORM, 63, 17, 2, 6, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 63, 31, 1, 6, 0xc00 },
   { PIPE_FORMAT_R8_UNORM, 63, 31, 2, 6, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 63, 32, 1, 6, 0xc00 },
   { PIPE_FORMAT_R8_UNORM, 63, 32, 2, 6, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 63, 33, 1, 6, 0x1680 },
   { PIPE_FORMAT_R8_UNORM, 63, 33, 2, 6, 0x2d00 },
   { PIPE_FORMAT_R8_UNORM, 63, 63, 1, 6, 0x1680 },
   { PIPE_FORMAT_R8_UNORM, 63, 63, 2, 6, 0x2d00 },
   { PIPE_FORMAT_R8_UNORM, 63, 64, 1, 7, 0x1700 },
   { PIPE_FORMAT_R8_UNORM, 63, 64, 2, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 63, 65, 1, 7, 0x2c00 },
   { PIPE_FORMAT_R8_UNORM, 63, 65, 2, 7, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 63, 127, 1, 7, 0x2c00 },
   { PIPE_FORMAT_R8_UNORM, 63, 127, 2, 7, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 63, 128, 1, 8, 0x2c80 },
   { PIPE_FORMAT_R8_UNORM, 63, 128, 2, 8, 0x5900 },
   { PIPE_FORMAT_R8_UNORM, 63, 129, 1, 8, 0x5700 },
   { PIPE_FORMAT_R8_UNORM, 63, 129, 2, 8, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 63, 255, 1, 8, 0x5700 },
   { PIPE_FORMAT_R8_UNORM, 63, 255, 2, 8, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 63, 256, 1, 9, 0x5780 },
   { PIPE_FORMAT_R8_UNORM, 63, 256, 2, 9, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 63, 257, 1, 9, 0xac80 },
   { PIPE_FORMAT_R8_UNORM, 63, 257, 2, 9, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 63, 511, 1, 9, 0xac80 },
   { PIPE_FORMAT_R8_UNORM, 63, 511, 2, 9, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 63, 512, 1, 10, 0xad00 },
   { PIPE_FORMAT_R8_UNORM, 63, 512, 2, 10, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 63, 513, 1, 10, 0x15780 },
   { PIPE_FORMAT_R8_UNORM, 63, 513, 2, 10, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 63, 1023, 1, 10, 0x15780 },
   { PIPE_FORMAT_R8_UNORM, 63, 1023, 2, 10, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 63, 1024, 1, 11, 0x15800 },
   { PIPE_FORMAT_R8_UNORM, 63, 1024, 2, 11, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 63, 1025, 1, 11, 0x2ad00 },
   { PIPE_FORMAT_R8_UNORM, 63, 1025, 2, 11, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 63, 2047, 1, 11, 0x2ad00 },
   { PIPE_FORMAT_R8_UNORM, 63, 2047, 2, 11, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 63, 2048, 1, 12, 0x2ad80 },
   { PIPE_FORMAT_R8_UNORM, 63, 2048, 2, 12, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 63, 2049, 1, 12, 0x55800 },
   { PIPE_FORMAT_R8_UNORM, 63, 2049, 2, 12, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 63, 4095, 1, 12, 0x55800 },
   { PIPE_FORMAT_R8_UNORM, 63, 4095, 2, 12, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 63, 4096, 1, 13, 0x55880 },
   { PIPE_FORMAT_R8_UNORM, 63, 4096, 2, 13, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 63, 4097, 1, 13, 0xaad80 },
   { PIPE_FORMAT_R8_UNORM, 63, 4097, 2, 13, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 64, 1, 1, 7, 0x380 },
   { PIPE_FORMAT_R8_UNORM, 64, 1, 2, 7, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 64, 2, 1, 7, 0x380 },
   { PIPE_FORMAT_R8_UNORM, 64, 2, 2, 7, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 64, 4, 1, 7, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 64, 4, 2, 7, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 64, 8, 1, 7, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 64, 8, 2, 7, 0xa00 },
   { PIPE_FORMAT_R8_UNORM, 64, 15, 1, 7, 0x780 },
   { PIPE_FORMAT_R8_UNORM, 64, 15, 2, 7, 0xf00 },
   { PIPE_FORMAT_R8_UNORM, 64, 16, 1, 7, 0x780 },
   { PIPE_FORMAT_R8_UNORM, 64, 16, 2, 7, 0xf00 },
   { PIPE_FORMAT_R8_UNORM, 64, 17, 1, 7, 0xc80 },
   { PIPE_FORMAT_R8_UNORM, 64, 17, 2, 7, 0x1900 },
   { PIPE_FORMAT_R8_UNORM, 64, 31, 1, 7, 0xc80 },
   { PIPE_FORMAT_R8_UNORM, 64, 31, 2, 7, 0x1900 },
   { PIPE_FORMAT_R8_UNORM, 64, 32, 1, 7, 0xc80 },
   { PIPE_FORMAT_R8_UNORM, 64, 32, 2, 7, 0x1900 },
   { PIPE_FORMAT_R8_UNORM, 64, 33, 1, 7, 0x1700 },
   { PIPE_FORMAT_R8_UNORM, 64, 33, 2, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 64, 63, 1, 7, 0x1700 },
   { PIPE_FORMAT_R8_UNORM, 64, 63, 2, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 64, 64, 1, 7, 0x1700 },
   { PIPE_FORMAT_R8_UNORM, 64, 64, 2, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 64, 65, 1, 7, 0x2c00 },
   { PIPE_FORMAT_R8_UNORM, 64, 65, 2, 7, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 64, 127, 1, 7, 0x2c00 },
   { PIPE_FORMAT_R8_UNORM, 64, 127, 2, 7, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 64, 128, 1, 8, 0x2c80 },
   { PIPE_FORMAT_R8_UNORM, 64, 128, 2, 8, 0x5900 },
   { PIPE_FORMAT_R8_UNORM, 64, 129, 1, 8, 0x5700 },
   { PIPE_FORMAT_R8_UNORM, 64, 129, 2, 8, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 64, 255, 1, 8, 0x5700 },
   { PIPE_FORMAT_R8_UNORM, 64, 255, 2, 8, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 64, 256, 1, 9, 0x5780 },
   { PIPE_FORMAT_R8_UNORM, 64, 256, 2, 9, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 64, 257, 1, 9, 0xac80 },
   { PIPE_FORMAT_R8_UNORM, 64, 257, 2, 9, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 64, 511, 1, 9, 0xac80 },
   { PIPE_FORMAT_R8_UNORM, 64, 511, 2, 9, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 64, 512, 1, 10, 0xad00 },
   { PIPE_FORMAT_R8_UNORM, 64, 512, 2, 10, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 64, 513, 1, 10, 0x15780 },
   { PIPE_FORMAT_R8_UNORM, 64, 513, 2, 10, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 64, 1023, 1, 10, 0x15780 },
   { PIPE_FORMAT_R8_UNORM, 64, 1023, 2, 10, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 64, 1024, 1, 11, 0x15800 },
   { PIPE_FORMAT_R8_UNORM, 64, 1024, 2, 11, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 64, 1025, 1, 11, 0x2ad00 },
   { PIPE_FORMAT_R8_UNORM, 64, 1025, 2, 11, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 64, 2047, 1, 11, 0x2ad00 },
   { PIPE_FORMAT_R8_UNORM, 64, 2047, 2, 11, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 64, 2048, 1, 12, 0x2ad80 },
   { PIPE_FORMAT_R8_UNORM, 64, 2048, 2, 12, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 64, 2049, 1, 12, 0x55800 },
   { PIPE_FORMAT_R8_UNORM, 64, 2049, 2, 12, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 64, 4095, 1, 12, 0x55800 },
   { PIPE_FORMAT_R8_UNORM, 64, 4095, 2, 12, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 64, 4096, 1, 13, 0x55880 },
   { PIPE_FORMAT_R8_UNORM, 64, 4096, 2, 13, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 64, 4097, 1, 13, 0xaad80 },
   { PIPE_FORMAT_R8_UNORM, 64, 4097, 2, 13, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 65, 1, 1, 7, 0x380 },
   { PIPE_FORMAT_R8_UNORM, 65, 1, 2, 7, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 65, 2, 1, 7, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 65, 2, 2, 7, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 65, 4, 1, 7, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 65, 4, 2, 7, 0xa00 },
   { PIPE_FORMAT_R8_UNORM, 65, 8, 1, 7, 0x780 },
   { PIPE_FORMAT_R8_UNORM, 65, 8, 2, 7, 0xf00 },
   { PIPE_FORMAT_R8_UNORM, 65, 15, 1, 7, 0xc80 },
   { PIPE_FORMAT_R8_UNORM, 65, 15, 2, 7, 0x1900 },
   { PIPE_FORMAT_R8_UNORM, 65, 16, 1, 7, 0xc80 },
   { PIPE_FORMAT_R8_UNORM, 65, 16, 2, 7, 0x1900 },
   { PIPE_FORMAT_R8_UNORM, 65, 17, 1, 7, 0x1700 },
   { PIPE_FORMAT_R8_UNORM, 65, 17, 2, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 65, 31, 1, 7, 0x1700 },
   { PIPE_FORMAT_R8_UNORM, 65, 31, 2, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 65, 32, 1, 7, 0x1700 },
   { PIPE_FORMAT_R8_UNORM, 65, 32, 2, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 65, 33, 1, 7, 0x2c00 },
   { PIPE_FORMAT_R8_UNORM, 65, 33, 2, 7, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 65, 63, 1, 7, 0x2c00 },
   { PIPE_FORMAT_R8_UNORM, 65, 63, 2, 7, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 65, 64, 1, 7, 0x2c00 },
   { PIPE_FORMAT_R8_UNORM, 65, 64, 2, 7, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 65, 65, 1, 7, 0x5680 },
   { PIPE_FORMAT_R8_UNORM, 65, 65, 2, 7, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 65, 127, 1, 7, 0x5680 },
   { PIPE_FORMAT_R8_UNORM, 65, 127, 2, 7, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 65, 128, 1, 8, 0x5700 },
   { PIPE_FORMAT_R8_UNORM, 65, 128, 2, 8, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 65, 129, 1, 8, 0xac00 },
   { PIPE_FORMAT_R8_UNORM, 65, 129, 2, 8, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 65, 255, 1, 8, 0xac00 },
   { PIPE_FORMAT_R8_UNORM, 65, 255, 2, 8, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 65, 256, 1, 9, 0xac80 },
   { PIPE_FORMAT_R8_UNORM, 65, 256, 2, 9, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 65, 257, 1, 9, 0x15700 },
   { PIPE_FORMAT_R8_UNORM, 65, 257, 2, 9, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 65, 511, 1, 9, 0x15700 },
   { PIPE_FORMAT_R8_UNORM, 65, 511, 2, 9, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 65, 512, 1, 10, 0x15780 },
   { PIPE_FORMAT_R8_UNORM, 65, 512, 2, 10, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 65, 513, 1, 10, 0x2ac80 },
   { PIPE_FORMAT_R8_UNORM, 65, 513, 2, 10, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 65, 1023, 1, 10, 0x2ac80 },
   { PIPE_FORMAT_R8_UNORM, 65, 1023, 2, 10, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 65, 1024, 1, 11, 0x2ad00 },
   { PIPE_FORMAT_R8_UNORM, 65, 1024, 2, 11, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 65, 1025, 1, 11, 0x55780 },
   { PIPE_FORMAT_R8_UNORM, 65, 1025, 2, 11, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 65, 2047, 1, 11, 0x55780 },
   { PIPE_FORMAT_R8_UNORM, 65, 2047, 2, 11, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 65, 2048, 1, 12, 0x55800 },
   { PIPE_FORMAT_R8_UNORM, 65, 2048, 2, 12, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 65, 2049, 1, 12, 0xaad00 },
   { PIPE_FORMAT_R8_UNORM, 65, 2049, 2, 12, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 65, 4095, 1, 12, 0xaad00 },
   { PIPE_FORMAT_R8_UNORM, 65, 4095, 2, 12, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 65, 4096, 1, 13, 0xaad80 },
   { PIPE_FORMAT_R8_UNORM, 65, 4096, 2, 13, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 65, 4097, 1, 13, 0x155800 },
   { PIPE_FORMAT_R8_UNORM, 65, 4097, 2, 13, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 127, 1, 1, 7, 0x380 },
   { PIPE_FORMAT_R8_UNORM, 127, 1, 2, 7, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 127, 2, 1, 7, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 127, 2, 2, 7, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 127, 4, 1, 7, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 127, 4, 2, 7, 0xa00 },
   { PIPE_FORMAT_R8_UNORM, 127, 8, 1, 7, 0x780 },
   { PIPE_FORMAT_R8_UNORM, 127, 8, 2, 7, 0xf00 },
   { PIPE_FORMAT_R8_UNORM, 127, 15, 1, 7, 0xc80 },
   { PIPE_FORMAT_R8_UNORM, 127, 15, 2, 7, 0x1900 },
   { PIPE_FORMAT_R8_UNORM, 127, 16, 1, 7, 0xc80 },
   { PIPE_FORMAT_R8_UNORM, 127, 16, 2, 7, 0x1900 },
   { PIPE_FORMAT_R8_UNORM, 127, 17, 1, 7, 0x1700 },
   { PIPE_FORMAT_R8_UNORM, 127, 17, 2, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 127, 31, 1, 7, 0x1700 },
   { PIPE_FORMAT_R8_UNORM, 127, 31, 2, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 127, 32, 1, 7, 0x1700 },
   { PIPE_FORMAT_R8_UNORM, 127, 32, 2, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 127, 33, 1, 7, 0x2c00 },
   { PIPE_FORMAT_R8_UNORM, 127, 33, 2, 7, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 127, 63, 1, 7, 0x2c00 },
   { PIPE_FORMAT_R8_UNORM, 127, 63, 2, 7, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 127, 64, 1, 7, 0x2c00 },
   { PIPE_FORMAT_R8_UNORM, 127, 64, 2, 7, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 127, 65, 1, 7, 0x5680 },
   { PIPE_FORMAT_R8_UNORM, 127, 65, 2, 7, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 127, 127, 1, 7, 0x5680 },
   { PIPE_FORMAT_R8_UNORM, 127, 127, 2, 7, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 127, 128, 1, 8, 0x5700 },
   { PIPE_FORMAT_R8_UNORM, 127, 128, 2, 8, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 127, 129, 1, 8, 0xac00 },
   { PIPE_FORMAT_R8_UNORM, 127, 129, 2, 8, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 127, 255, 1, 8, 0xac00 },
   { PIPE_FORMAT_R8_UNORM, 127, 255, 2, 8, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 127, 256, 1, 9, 0xac80 },
   { PIPE_FORMAT_R8_UNORM, 127, 256, 2, 9, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 127, 257, 1, 9, 0x15700 },
   { PIPE_FORMAT_R8_UNORM, 127, 257, 2, 9, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 127, 511, 1, 9, 0x15700 },
   { PIPE_FORMAT_R8_UNORM, 127, 511, 2, 9, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 127, 512, 1, 10, 0x15780 },
   { PIPE_FORMAT_R8_UNORM, 127, 512, 2, 10, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 127, 513, 1, 10, 0x2ac80 },
   { PIPE_FORMAT_R8_UNORM, 127, 513, 2, 10, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 127, 1023, 1, 10, 0x2ac80 },
   { PIPE_FORMAT_R8_UNORM, 127, 1023, 2, 10, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 127, 1024, 1, 11, 0x2ad00 },
   { PIPE_FORMAT_R8_UNORM, 127, 1024, 2, 11, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 127, 1025, 1, 11, 0x55780 },
   { PIPE_FORMAT_R8_UNORM, 127, 1025, 2, 11, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 127, 2047, 1, 11, 0x55780 },
   { PIPE_FORMAT_R8_UNORM, 127, 2047, 2, 11, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 127, 2048, 1, 12, 0x55800 },
   { PIPE_FORMAT_R8_UNORM, 127, 2048, 2, 12, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 127, 2049, 1, 12, 0xaad00 },
   { PIPE_FORMAT_R8_UNORM, 127, 2049, 2, 12, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 127, 4095, 1, 12, 0xaad00 },
   { PIPE_FORMAT_R8_UNORM, 127, 4095, 2, 12, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 127, 4096, 1, 13, 0xaad80 },
   { PIPE_FORMAT_R8_UNORM, 127, 4096, 2, 13, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 127, 4097, 1, 13, 0x155800 },
   { PIPE_FORMAT_R8_UNORM, 127, 4097, 2, 13, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 128, 1, 1, 8, 0x400 },
   { PIPE_FORMAT_R8_UNORM, 128, 1, 2, 8, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 128, 2, 1, 8, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 128, 2, 2, 8, 0x900 },
   { PIPE_FORMAT_R8_UNORM, 128, 4, 1, 8, 0x580 },
   { PIPE_FORMAT_R8_UNORM, 128, 4, 2, 8, 0xb00 },
   { PIPE_FORMAT_R8_UNORM, 128, 8, 1, 8, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 128, 8, 2, 8, 0x1000 },
   { PIPE_FORMAT_R8_UNORM, 128, 15, 1, 8, 0xd00 },
   { PIPE_FORMAT_R8_UNORM, 128, 15, 2, 8, 0x1a00 },
   { PIPE_FORMAT_R8_UNORM, 128, 16, 1, 8, 0xd00 },
   { PIPE_FORMAT_R8_UNORM, 128, 16, 2, 8, 0x1a00 },
   { PIPE_FORMAT_R8_UNORM, 128, 17, 1, 8, 0x1780 },
   { PIPE_FORMAT_R8_UNORM, 128, 17, 2, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 128, 31, 1, 8, 0x1780 },
   { PIPE_FORMAT_R8_UNORM, 128, 31, 2, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 128, 32, 1, 8, 0x1780 },
   { PIPE_FORMAT_R8_UNORM, 128, 32, 2, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 128, 33, 1, 8, 0x2c80 },
   { PIPE_FORMAT_R8_UNORM, 128, 33, 2, 8, 0x5900 },
   { PIPE_FORMAT_R8_UNORM, 128, 63, 1, 8, 0x2c80 },
   { PIPE_FORMAT_R8_UNORM, 128, 63, 2, 8, 0x5900 },
   { PIPE_FORMAT_R8_UNORM, 128, 64, 1, 8, 0x2c80 },
   { PIPE_FORMAT_R8_UNORM, 128, 64, 2, 8, 0x5900 },
   { PIPE_FORMAT_R8_UNORM, 128, 65, 1, 8, 0x5700 },
   { PIPE_FORMAT_R8_UNORM, 128, 65, 2, 8, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 128, 127, 1, 8, 0x5700 },
   { PIPE_FORMAT_R8_UNORM, 128, 127, 2, 8, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 128, 128, 1, 8, 0x5700 },
   { PIPE_FORMAT_R8_UNORM, 128, 128, 2, 8, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 128, 129, 1, 8, 0x9700 },
   { PIPE_FORMAT_R8_UNORM, 128, 129, 2, 8, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 128, 255, 1, 8, 0xac00 },
   { PIPE_FORMAT_R8_UNORM, 128, 255, 2, 8, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 128, 256, 1, 9, 0xac80 },
   { PIPE_FORMAT_R8_UNORM, 128, 256, 2, 9, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 128, 257, 1, 9, 0xec80 },
   { PIPE_FORMAT_R8_UNORM, 128, 257, 2, 9, 0x20000 },
   { PIPE_FORMAT_R8_UNORM, 128, 511, 1, 9, 0x15700 },
   { PIPE_FORMAT_R8_UNORM, 128, 511, 2, 9, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 128, 512, 1, 10, 0x15780 },
   { PIPE_FORMAT_R8_UNORM, 128, 512, 2, 10, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 128, 513, 1, 10, 0x19780 },
   { PIPE_FORMAT_R8_UNORM, 128, 513, 2, 10, 0x38000 },
   { PIPE_FORMAT_R8_UNORM, 128, 1023, 1, 10, 0x2ac80 },
   { PIPE_FORMAT_R8_UNORM, 128, 1023, 2, 10, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 128, 1024, 1, 11, 0x2ad00 },
   { PIPE_FORMAT_R8_UNORM, 128, 1024, 2, 11, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 128, 1025, 1, 11, 0x2ed00 },
   { PIPE_FORMAT_R8_UNORM, 128, 1025, 2, 11, 0x60000 },
   { PIPE_FORMAT_R8_UNORM, 128, 2047, 1, 11, 0x55780 },
   { PIPE_FORMAT_R8_UNORM, 128, 2047, 2, 11, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 128, 2048, 1, 12, 0x55800 },
   { PIPE_FORMAT_R8_UNORM, 128, 2048, 2, 12, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 128, 2049, 1, 12, 0x59800 },
   { PIPE_FORMAT_R8_UNORM, 128, 2049, 2, 12, 0xb8000 },
   { PIPE_FORMAT_R8_UNORM, 128, 4095, 1, 12, 0xaad00 },
   { PIPE_FORMAT_R8_UNORM, 128, 4095, 2, 12, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 128, 4096, 1, 13, 0xaad80 },
   { PIPE_FORMAT_R8_UNORM, 128, 4096, 2, 13, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 128, 4097, 1, 13, 0xaed80 },
   { PIPE_FORMAT_R8_UNORM, 128, 4097, 2, 13, 0x160000 },
   { PIPE_FORMAT_R8_UNORM, 129, 1, 1, 8, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 129, 1, 2, 8, 0x900 },
   { PIPE_FORMAT_R8_UNORM, 129, 2, 1, 8, 0x580 },
   { PIPE_FORMAT_R8_UNORM, 129, 2, 2, 8, 0xb00 },
   { PIPE_FORMAT_R8_UNORM, 129, 4, 1, 8, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 129, 4, 2, 8, 0x1000 },
   { PIPE_FORMAT_R8_UNORM, 129, 8, 1, 8, 0xd00 },
   { PIPE_FORMAT_R8_UNORM, 129, 8, 2, 8, 0x1a00 },
   { PIPE_FORMAT_R8_UNORM, 129, 15, 1, 8, 0x1780 },
   { PIPE_FORMAT_R8_UNORM, 129, 15, 2, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 129, 16, 1, 8, 0x1780 },
   { PIPE_FORMAT_R8_UNORM, 129, 16, 2, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 129, 17, 1, 8, 0x2c80 },
   { PIPE_FORMAT_R8_UNORM, 129, 17, 2, 8, 0x5900 },
   { PIPE_FORMAT_R8_UNORM, 129, 31, 1, 8, 0x2c80 },
   { PIPE_FORMAT_R8_UNORM, 129, 31, 2, 8, 0x5900 },
   { PIPE_FORMAT_R8_UNORM, 129, 32, 1, 8, 0x2c80 },
   { PIPE_FORMAT_R8_UNORM, 129, 32, 2, 8, 0x5900 },
   { PIPE_FORMAT_R8_UNORM, 129, 33, 1, 8, 0x5700 },
   { PIPE_FORMAT_R8_UNORM, 129, 33, 2, 8, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 129, 63, 1, 8, 0x5700 },
   { PIPE_FORMAT_R8_UNORM, 129, 63, 2, 8, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 129, 64, 1, 8, 0x5700 },
   { PIPE_FORMAT_R8_UNORM, 129, 64, 2, 8, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 129, 65, 1, 8, 0xac00 },
   { PIPE_FORMAT_R8_UNORM, 129, 65, 2, 8, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 129, 127, 1, 8, 0xac00 },
   { PIPE_FORMAT_R8_UNORM, 129, 127, 2, 8, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 129, 128, 1, 8, 0x9700 },
   { PIPE_FORMAT_R8_UNORM, 129, 128, 2, 8, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 129, 129, 1, 8, 0x11700 },
   { PIPE_FORMAT_R8_UNORM, 129, 129, 2, 8, 0x28000 },
   { PIPE_FORMAT_R8_UNORM, 129, 255, 1, 8, 0x12c00 },
   { PIPE_FORMAT_R8_UNORM, 129, 255, 2, 8, 0x28000 },
   { PIPE_FORMAT_R8_UNORM, 129, 256, 1, 9, 0x12c80 },
   { PIPE_FORMAT_R8_UNORM, 129, 256, 2, 9, 0x28000 },
   { PIPE_FORMAT_R8_UNORM, 129, 257, 1, 9, 0x1ac80 },
   { PIPE_FORMAT_R8_UNORM, 129, 257, 2, 9, 0x38000 },
   { PIPE_FORMAT_R8_UNORM, 129, 511, 1, 9, 0x25700 },
   { PIPE_FORMAT_R8_UNORM, 129, 511, 2, 9, 0x50000 },
   { PIPE_FORMAT_R8_UNORM, 129, 512, 1, 10, 0x25780 },
   { PIPE_FORMAT_R8_UNORM, 129, 512, 2, 10, 0x50000 },
   { PIPE_FORMAT_R8_UNORM, 129, 513, 1, 10, 0x2d780 },
   { PIPE_FORMAT_R8_UNORM, 129, 513, 2, 10, 0x60000 },
   { PIPE_FORMAT_R8_UNORM, 129, 1023, 1, 10, 0x4ac80 },
   { PIPE_FORMAT_R8_UNORM, 129, 1023, 2, 10, 0x98000 },
   { PIPE_FORMAT_R8_UNORM, 129, 1024, 1, 11, 0x4ad00 },
   { PIPE_FORMAT_R8_UNORM, 129, 1024, 2, 11, 0x98000 },
   { PIPE_FORMAT_R8_UNORM, 129, 1025, 1, 11, 0x52d00 },
   { PIPE_FORMAT_R8_UNORM, 129, 1025, 2, 11, 0xa8000 },
   { PIPE_FORMAT_R8_UNORM, 129, 2047, 1, 11, 0x95780 },
   { PIPE_FORMAT_R8_UNORM, 129, 2047, 2, 11, 0x130000 },
   { PIPE_FORMAT_R8_UNORM, 129, 2048, 1, 12, 0x95800 },
   { PIPE_FORMAT_R8_UNORM, 129, 2048, 2, 12, 0x130000 },
   { PIPE_FORMAT_R8_UNORM, 129, 2049, 1, 12, 0x9d800 },
   { PIPE_FORMAT_R8_UNORM, 129, 2049, 2, 12, 0x140000 },
   { PIPE_FORMAT_R8_UNORM, 129, 4095, 1, 12, 0x12ad00 },
   { PIPE_FORMAT_R8_UNORM, 129, 4095, 2, 12, 0x258000 },
   { PIPE_FORMAT_R8_UNORM, 129, 4096, 1, 13, 0x12ad80 },
   { PIPE_FORMAT_R8_UNORM, 129, 4096, 2, 13, 0x258000 },
   { PIPE_FORMAT_R8_UNORM, 129, 4097, 1, 13, 0x132d80 },
   { PIPE_FORMAT_R8_UNORM, 129, 4097, 2, 13, 0x268000 },
   { PIPE_FORMAT_R8_UNORM, 255, 1, 1, 8, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 255, 1, 2, 8, 0x900 },
   { PIPE_FORMAT_R8_UNORM, 255, 2, 1, 8, 0x580 },
   { PIPE_FORMAT_R8_UNORM, 255, 2, 2, 8, 0xb00 },
   { PIPE_FORMAT_R8_UNORM, 255, 4, 1, 8, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 255, 4, 2, 8, 0x1000 },
   { PIPE_FORMAT_R8_UNORM, 255, 8, 1, 8, 0xd00 },
   { PIPE_FORMAT_R8_UNORM, 255, 8, 2, 8, 0x1a00 },
   { PIPE_FORMAT_R8_UNORM, 255, 15, 1, 8, 0x1780 },
   { PIPE_FORMAT_R8_UNORM, 255, 15, 2, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 255, 16, 1, 8, 0x1780 },
   { PIPE_FORMAT_R8_UNORM, 255, 16, 2, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 255, 17, 1, 8, 0x2c80 },
   { PIPE_FORMAT_R8_UNORM, 255, 17, 2, 8, 0x5900 },
   { PIPE_FORMAT_R8_UNORM, 255, 31, 1, 8, 0x2c80 },
   { PIPE_FORMAT_R8_UNORM, 255, 31, 2, 8, 0x5900 },
   { PIPE_FORMAT_R8_UNORM, 255, 32, 1, 8, 0x2c80 },
   { PIPE_FORMAT_R8_UNORM, 255, 32, 2, 8, 0x5900 },
   { PIPE_FORMAT_R8_UNORM, 255, 33, 1, 8, 0x5700 },
   { PIPE_FORMAT_R8_UNORM, 255, 33, 2, 8, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 255, 63, 1, 8, 0x5700 },
   { PIPE_FORMAT_R8_UNORM, 255, 63, 2, 8, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 255, 64, 1, 8, 0x5700 },
   { PIPE_FORMAT_R8_UNORM, 255, 64, 2, 8, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 255, 65, 1, 8, 0xac00 },
   { PIPE_FORMAT_R8_UNORM, 255, 65, 2, 8, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 255, 127, 1, 8, 0xac00 },
   { PIPE_FORMAT_R8_UNORM, 255, 127, 2, 8, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 255, 128, 1, 8, 0xac00 },
   { PIPE_FORMAT_R8_UNORM, 255, 128, 2, 8, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 255, 129, 1, 8, 0x12c00 },
   { PIPE_FORMAT_R8_UNORM, 255, 129, 2, 8, 0x28000 },
   { PIPE_FORMAT_R8_UNORM, 255, 255, 1, 8, 0x15680 },
   { PIPE_FORMAT_R8_UNORM, 255, 255, 2, 8, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 255, 256, 1, 9, 0x15700 },
   { PIPE_FORMAT_R8_UNORM, 255, 256, 2, 9, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 255, 257, 1, 9, 0x1d700 },
   { PIPE_FORMAT_R8_UNORM, 255, 257, 2, 9, 0x40000 },
   { PIPE_FORMAT_R8_UNORM, 255, 511, 1, 9, 0x2ac00 },
   { PIPE_FORMAT_R8_UNORM, 255, 511, 2, 9, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 255, 512, 1, 10, 0x2ac80 },
   { PIPE_FORMAT_R8_UNORM, 255, 512, 2, 10, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 255, 513, 1, 10, 0x32c80 },
   { PIPE_FORMAT_R8_UNORM, 255, 513, 2, 10, 0x68000 },
   { PIPE_FORMAT_R8_UNORM, 255, 1023, 1, 10, 0x55700 },
   { PIPE_FORMAT_R8_UNORM, 255, 1023, 2, 10, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 255, 1024, 1, 11, 0x55780 },
   { PIPE_FORMAT_R8_UNORM, 255, 1024, 2, 11, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 255, 1025, 1, 11, 0x5d780 },
   { PIPE_FORMAT_R8_UNORM, 255, 1025, 2, 11, 0xc0000 },
   { PIPE_FORMAT_R8_UNORM, 255, 2047, 1, 11, 0xaac80 },
   { PIPE_FORMAT_R8_UNORM, 255, 2047, 2, 11, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 255, 2048, 1, 12, 0xaad00 },
   { PIPE_FORMAT_R8_UNORM, 255, 2048, 2, 12, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 255, 2049, 1, 12, 0xb2d00 },
   { PIPE_FORMAT_R8_UNORM, 255, 2049, 2, 12, 0x168000 },
   { PIPE_FORMAT_R8_UNORM, 255, 4095, 1, 12, 0x155780 },
   { PIPE_FORMAT_R8_UNORM, 255, 4095, 2, 12, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 255, 4096, 1, 13, 0x155800 },
   { PIPE_FORMAT_R8_UNORM, 255, 4096, 2, 13, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 255, 4097, 1, 13, 0x15d800 },
   { PIPE_FORMAT_R8_UNORM, 255, 4097, 2, 13, 0x2c0000 },
   { PIPE_FORMAT_R8_UNORM, 256, 1, 1, 9, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 256, 1, 2, 9, 0xa00 },
   { PIPE_FORMAT_R8_UNORM, 256, 2, 1, 9, 0x600 },
   { PIPE_FORMAT_R8_UNORM, 256, 2, 2, 9, 0xc00 },
   { PIPE_FORMAT_R8_UNORM, 256, 4, 1, 9, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 256, 4, 2, 9, 0x1100 },
   { PIPE_FORMAT_R8_UNORM, 256, 8, 1, 9, 0xd80 },
   { PIPE_FORMAT_R8_UNORM, 256, 8, 2, 9, 0x1b00 },
   { PIPE_FORMAT_R8_UNORM, 256, 15, 1, 9, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 256, 15, 2, 9, 0x3000 },
   { PIPE_FORMAT_R8_UNORM, 256, 16, 1, 9, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 256, 16, 2, 9, 0x3000 },
   { PIPE_FORMAT_R8_UNORM, 256, 17, 1, 9, 0x2d00 },
   { PIPE_FORMAT_R8_UNORM, 256, 17, 2, 9, 0x5a00 },
   { PIPE_FORMAT_R8_UNORM, 256, 31, 1, 9, 0x2d00 },
   { PIPE_FORMAT_R8_UNORM, 256, 31, 2, 9, 0x5a00 },
   { PIPE_FORMAT_R8_UNORM, 256, 32, 1, 9, 0x2d00 },
   { PIPE_FORMAT_R8_UNORM, 256, 32, 2, 9, 0x5a00 },
   { PIPE_FORMAT_R8_UNORM, 256, 33, 1, 9, 0x5780 },
   { PIPE_FORMAT_R8_UNORM, 256, 33, 2, 9, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 256, 63, 1, 9, 0x5780 },
   { PIPE_FORMAT_R8_UNORM, 256, 63, 2, 9, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 256, 64, 1, 9, 0x5780 },
   { PIPE_FORMAT_R8_UNORM, 256, 64, 2, 9, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 256, 65, 1, 9, 0xac80 },
   { PIPE_FORMAT_R8_UNORM, 256, 65, 2, 9, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 256, 127, 1, 9, 0xac80 },
   { PIPE_FORMAT_R8_UNORM, 256, 127, 2, 9, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 256, 128, 1, 9, 0xac80 },
   { PIPE_FORMAT_R8_UNORM, 256, 128, 2, 9, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 256, 129, 1, 9, 0x12c80 },
   { PIPE_FORMAT_R8_UNORM, 256, 129, 2, 9, 0x28000 },
   { PIPE_FORMAT_R8_UNORM, 256, 255, 1, 9, 0x15700 },
   { PIPE_FORMAT_R8_UNORM, 256, 255, 2, 9, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 256, 256, 1, 9, 0x15700 },
   { PIPE_FORMAT_R8_UNORM, 256, 256, 2, 9, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 256, 257, 1, 9, 0x21700 },
   { PIPE_FORMAT_R8_UNORM, 256, 257, 2, 9, 0x48000 },
   { PIPE_FORMAT_R8_UNORM, 256, 511, 1, 9, 0x2ac00 },
   { PIPE_FORMAT_R8_UNORM, 256, 511, 2, 9, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 256, 512, 1, 10, 0x2ac80 },
   { PIPE_FORMAT_R8_UNORM, 256, 512, 2, 10, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 256, 513, 1, 10, 0x36c80 },
   { PIPE_FORMAT_R8_UNORM, 256, 513, 2, 10, 0x70000 },
   { PIPE_FORMAT_R8_UNORM, 256, 1023, 1, 10, 0x55700 },
   { PIPE_FORMAT_R8_UNORM, 256, 1023, 2, 10, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 256, 1024, 1, 11, 0x55780 },
   { PIPE_FORMAT_R8_UNORM, 256, 1024, 2, 11, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 256, 1025, 1, 11, 0x61780 },
   { PIPE_FORMAT_R8_UNORM, 256, 1025, 2, 11, 0xc8000 },
   { PIPE_FORMAT_R8_UNORM, 256, 2047, 1, 11, 0xaac80 },
   { PIPE_FORMAT_R8_UNORM, 256, 2047, 2, 11, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 256, 2048, 1, 12, 0xaad00 },
   { PIPE_FORMAT_R8_UNORM, 256, 2048, 2, 12, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 256, 2049, 1, 12, 0xb6d00 },
   { PIPE_FORMAT_R8_UNORM, 256, 2049, 2, 12, 0x170000 },
   { PIPE_FORMAT_R8_UNORM, 256, 4095, 1, 12, 0x155780 },
   { PIPE_FORMAT_R8_UNORM, 256, 4095, 2, 12, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 256, 4096, 1, 13, 0x155800 },
   { PIPE_FORMAT_R8_UNORM, 256, 4096, 2, 13, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 256, 4097, 1, 13, 0x161800 },
   { PIPE_FORMAT_R8_UNORM, 256, 4097, 2, 13, 0x2c8000 },
   { PIPE_FORMAT_R8_UNORM, 257, 1, 1, 9, 0x680 },
   { PIPE_FORMAT_R8_UNORM, 257, 1, 2, 9, 0xd00 },
   { PIPE_FORMAT_R8_UNORM, 257, 2, 1, 9, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 257, 2, 2, 9, 0x1100 },
   { PIPE_FORMAT_R8_UNORM, 257, 4, 1, 9, 0xd80 },
   { PIPE_FORMAT_R8_UNORM, 257, 4, 2, 9, 0x1b00 },
   { PIPE_FORMAT_R8_UNORM, 257, 8, 1, 9, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 257, 8, 2, 9, 0x3000 },
   { PIPE_FORMAT_R8_UNORM, 257, 15, 1, 9, 0x2d00 },
   { PIPE_FORMAT_R8_UNORM, 257, 15, 2, 9, 0x5a00 },
   { PIPE_FORMAT_R8_UNORM, 257, 16, 1, 9, 0x2d00 },
   { PIPE_FORMAT_R8_UNORM, 257, 16, 2, 9, 0x5a00 },
   { PIPE_FORMAT_R8_UNORM, 257, 17, 1, 9, 0x5780 },
   { PIPE_FORMAT_R8_UNORM, 257, 17, 2, 9, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 257, 31, 1, 9, 0x5780 },
   { PIPE_FORMAT_R8_UNORM, 257, 31, 2, 9, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 257, 32, 1, 9, 0x5780 },
   { PIPE_FORMAT_R8_UNORM, 257, 32, 2, 9, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 257, 33, 1, 9, 0xac80 },
   { PIPE_FORMAT_R8_UNORM, 257, 33, 2, 9, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 257, 63, 1, 9, 0xac80 },
   { PIPE_FORMAT_R8_UNORM, 257, 63, 2, 9, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 257, 64, 1, 9, 0xac80 },
   { PIPE_FORMAT_R8_UNORM, 257, 64, 2, 9, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 257, 65, 1, 9, 0x15700 },
   { PIPE_FORMAT_R8_UNORM, 257, 65, 2, 9, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 257, 127, 1, 9, 0x15700 },
   { PIPE_FORMAT_R8_UNORM, 257, 127, 2, 9, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 257, 128, 1, 9, 0xec80 },
   { PIPE_FORMAT_R8_UNORM, 257, 128, 2, 9, 0x20000 },
   { PIPE_FORMAT_R8_UNORM, 257, 129, 1, 9, 0x1ac80 },
   { PIPE_FORMAT_R8_UNORM, 257, 129, 2, 9, 0x38000 },
   { PIPE_FORMAT_R8_UNORM, 257, 255, 1, 9, 0x1d700 },
   { PIPE_FORMAT_R8_UNORM, 257, 255, 2, 9, 0x40000 },
   { PIPE_FORMAT_R8_UNORM, 257, 256, 1, 9, 0x21700 },
   { PIPE_FORMAT_R8_UNORM, 257, 256, 2, 9, 0x48000 },
   { PIPE_FORMAT_R8_UNORM, 257, 257, 1, 9, 0x39700 },
   { PIPE_FORMAT_R8_UNORM, 257, 257, 2, 9, 0x78000 },
   { PIPE_FORMAT_R8_UNORM, 257, 511, 1, 9, 0x46c00 },
   { PIPE_FORMAT_R8_UNORM, 257, 511, 2, 9, 0x90000 },
   { PIPE_FORMAT_R8_UNORM, 257, 512, 1, 10, 0x46c80 },
   { PIPE_FORMAT_R8_UNORM, 257, 512, 2, 10, 0x90000 },
   { PIPE_FORMAT_R8_UNORM, 257, 513, 1, 10, 0x5ac80 },
   { PIPE_FORMAT_R8_UNORM, 257, 513, 2, 10, 0xb8000 },
   { PIPE_FORMAT_R8_UNORM, 257, 1023, 1, 10, 0x8d700 },
   { PIPE_FORMAT_R8_UNORM, 257, 1023, 2, 10, 0x120000 },
   { PIPE_FORMAT_R8_UNORM, 257, 1024, 1, 11, 0x8d780 },
   { PIPE_FORMAT_R8_UNORM, 257, 1024, 2, 11, 0x120000 },
   { PIPE_FORMAT_R8_UNORM, 257, 1025, 1, 11, 0xa1780 },
   { PIPE_FORMAT_R8_UNORM, 257, 1025, 2, 11, 0x148000 },
   { PIPE_FORMAT_R8_UNORM, 257, 2047, 1, 11, 0x11ac80 },
   { PIPE_FORMAT_R8_UNORM, 257, 2047, 2, 11, 0x238000 },
   { PIPE_FORMAT_R8_UNORM, 257, 2048, 1, 12, 0x11ad00 },
   { PIPE_FORMAT_R8_UNORM, 257, 2048, 2, 12, 0x238000 },
   { PIPE_FORMAT_R8_UNORM, 257, 2049, 1, 12, 0x12ed00 },
   { PIPE_FORMAT_R8_UNORM, 257, 2049, 2, 12, 0x260000 },
   { PIPE_FORMAT_R8_UNORM, 257, 4095, 1, 12, 0x235780 },
   { PIPE_FORMAT_R8_UNORM, 257, 4095, 2, 12, 0x470000 },
   { PIPE_FORMAT_R8_UNORM, 257, 4096, 1, 13, 0x235800 },
   { PIPE_FORMAT_R8_UNORM, 257, 4096, 2, 13, 0x470000 },
   { PIPE_FORMAT_R8_UNORM, 257, 4097, 1, 13, 0x249800 },
   { PIPE_FORMAT_R8_UNORM, 257, 4097, 2, 13, 0x498000 },
   { PIPE_FORMAT_R8_UNORM, 511, 1, 1, 9, 0x680 },
   { PIPE_FORMAT_R8_UNORM, 511, 1, 2, 9, 0xd00 },
   { PIPE_FORMAT_R8_UNORM, 511, 2, 1, 9, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 511, 2, 2, 9, 0x1100 },
   { PIPE_FORMAT_R8_UNORM, 511, 4, 1, 9, 0xd80 },
   { PIPE_FORMAT_R8_UNORM, 511, 4, 2, 9, 0x1b00 },
   { PIPE_FORMAT_R8_UNORM, 511, 8, 1, 9, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 511, 8, 2, 9, 0x3000 },
   { PIPE_FORMAT_R8_UNORM, 511, 15, 1, 9, 0x2d00 },
   { PIPE_FORMAT_R8_UNORM, 511, 15, 2, 9, 0x5a00 },
   { PIPE_FORMAT_R8_UNORM, 511, 16, 1, 9, 0x2d00 },
   { PIPE_FORMAT_R8_UNORM, 511, 16, 2, 9, 0x5a00 },
   { PIPE_FORMAT_R8_UNORM, 511, 17, 1, 9, 0x5780 },
   { PIPE_FORMAT_R8_UNORM, 511, 17, 2, 9, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 511, 31, 1, 9, 0x5780 },
   { PIPE_FORMAT_R8_UNORM, 511, 31, 2, 9, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 511, 32, 1, 9, 0x5780 },
   { PIPE_FORMAT_R8_UNORM, 511, 32, 2, 9, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 511, 33, 1, 9, 0xac80 },
   { PIPE_FORMAT_R8_UNORM, 511, 33, 2, 9, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 511, 63, 1, 9, 0xac80 },
   { PIPE_FORMAT_R8_UNORM, 511, 63, 2, 9, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 511, 64, 1, 9, 0xac80 },
   { PIPE_FORMAT_R8_UNORM, 511, 64, 2, 9, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 511, 65, 1, 9, 0x15700 },
   { PIPE_FORMAT_R8_UNORM, 511, 65, 2, 9, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 511, 127, 1, 9, 0x15700 },
   { PIPE_FORMAT_R8_UNORM, 511, 127, 2, 9, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 511, 128, 1, 9, 0x15700 },
   { PIPE_FORMAT_R8_UNORM, 511, 128, 2, 9, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 511, 129, 1, 9, 0x25700 },
   { PIPE_FORMAT_R8_UNORM, 511, 129, 2, 9, 0x50000 },
   { PIPE_FORMAT_R8_UNORM, 511, 255, 1, 9, 0x2ac00 },
   { PIPE_FORMAT_R8_UNORM, 511, 255, 2, 9, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 511, 256, 1, 9, 0x2ac00 },
   { PIPE_FORMAT_R8_UNORM, 511, 256, 2, 9, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 511, 257, 1, 9, 0x46c00 },
   { PIPE_FORMAT_R8_UNORM, 511, 257, 2, 9, 0x90000 },
   { PIPE_FORMAT_R8_UNORM, 511, 511, 1, 9, 0x55680 },
   { PIPE_FORMAT_R8_UNORM, 511, 511, 2, 9, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 511, 512, 1, 10, 0x55700 },
   { PIPE_FORMAT_R8_UNORM, 511, 512, 2, 10, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 511, 513, 1, 10, 0x71700 },
   { PIPE_FORMAT_R8_UNORM, 511, 513, 2, 10, 0xe8000 },
   { PIPE_FORMAT_R8_UNORM, 511, 1023, 1, 10, 0xaac00 },
   { PIPE_FORMAT_R8_UNORM, 511, 1023, 2, 10, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 511, 1024, 1, 11, 0xaac80 },
   { PIPE_FORMAT_R8_UNORM, 511, 1024, 2, 11, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 511, 1025, 1, 11, 0xc6c80 },
   { PIPE_FORMAT_R8_UNORM, 511, 1025, 2, 11, 0x190000 },
   { PIPE_FORMAT_R8_UNORM, 511, 2047, 1, 11, 0x155700 },
   { PIPE_FORMAT_R8_UNORM, 511, 2047, 2, 11, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 511, 2048, 1, 12, 0x155780 },
   { PIPE_FORMAT_R8_UNORM, 511, 2048, 2, 12, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 511, 2049, 1, 12, 0x171780 },
   { PIPE_FORMAT_R8_UNORM, 511, 2049, 2, 12, 0x2e8000 },
   { PIPE_FORMAT_R8_UNORM, 511, 4095, 1, 12, 0x2aac80 },
   { PIPE_FORMAT_R8_UNORM, 511, 4095, 2, 12, 0x558000 },
   { PIPE_FORMAT_R8_UNORM, 511, 4096, 1, 13, 0x2aad00 },
   { PIPE_FORMAT_R8_UNORM, 511, 4096, 2, 13, 0x558000 },
   { PIPE_FORMAT_R8_UNORM, 511, 4097, 1, 13, 0x2c6d00 },
   { PIPE_FORMAT_R8_UNORM, 511, 4097, 2, 13, 0x590000 },
   { PIPE_FORMAT_R8_UNORM, 512, 1, 1, 10, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 512, 1, 2, 10, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 512, 2, 1, 10, 0x900 },
   { PIPE_FORMAT_R8_UNORM, 512, 2, 2, 10, 0x1200 },
   { PIPE_FORMAT_R8_UNORM, 512, 4, 1, 10, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 512, 4, 2, 10, 0x1c00 },
   { PIPE_FORMAT_R8_UNORM, 512, 8, 1, 10, 0x1880 },
   { PIPE_FORMAT_R8_UNORM, 512, 8, 2, 10, 0x3100 },
   { PIPE_FORMAT_R8_UNORM, 512, 15, 1, 10, 0x2d80 },
   { PIPE_FORMAT_R8_UNORM, 512, 15, 2, 10, 0x5b00 },
   { PIPE_FORMAT_R8_UNORM, 512, 16, 1, 10, 0x2d80 },
   { PIPE_FORMAT_R8_UNORM, 512, 16, 2, 10, 0x5b00 },
   { PIPE_FORMAT_R8_UNORM, 512, 17, 1, 10, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 512, 17, 2, 10, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 512, 31, 1, 10, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 512, 31, 2, 10, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 512, 32, 1, 10, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 512, 32, 2, 10, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 512, 33, 1, 10, 0xad00 },
   { PIPE_FORMAT_R8_UNORM, 512, 33, 2, 10, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 512, 63, 1, 10, 0xad00 },
   { PIPE_FORMAT_R8_UNORM, 512, 63, 2, 10, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 512, 64, 1, 10, 0xad00 },
   { PIPE_FORMAT_R8_UNORM, 512, 64, 2, 10, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 512, 65, 1, 10, 0x15780 },
   { PIPE_FORMAT_R8_UNORM, 512, 65, 2, 10, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 512, 127, 1, 10, 0x15780 },
   { PIPE_FORMAT_R8_UNORM, 512, 127, 2, 10, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 512, 128, 1, 10, 0x15780 },
   { PIPE_FORMAT_R8_UNORM, 512, 128, 2, 10, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 512, 129, 1, 10, 0x25780 },
   { PIPE_FORMAT_R8_UNORM, 512, 129, 2, 10, 0x50000 },
   { PIPE_FORMAT_R8_UNORM, 512, 255, 1, 10, 0x2ac80 },
   { PIPE_FORMAT_R8_UNORM, 512, 255, 2, 10, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 512, 256, 1, 10, 0x2ac80 },
   { PIPE_FORMAT_R8_UNORM, 512, 256, 2, 10, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 512, 257, 1, 10, 0x46c80 },
   { PIPE_FORMAT_R8_UNORM, 512, 257, 2, 10, 0x90000 },
   { PIPE_FORMAT_R8_UNORM, 512, 511, 1, 10, 0x55700 },
   { PIPE_FORMAT_R8_UNORM, 512, 511, 2, 10, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 512, 512, 1, 10, 0x55700 },
   { PIPE_FORMAT_R8_UNORM, 512, 512, 2, 10, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 512, 513, 1, 10, 0x75700 },
   { PIPE_FORMAT_R8_UNORM, 512, 513, 2, 10, 0xf0000 },
   { PIPE_FORMAT_R8_UNORM, 512, 1023, 1, 10, 0xaac00 },
   { PIPE_FORMAT_R8_UNORM, 512, 1023, 2, 10, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 512, 1024, 1, 11, 0xaac80 },
   { PIPE_FORMAT_R8_UNORM, 512, 1024, 2, 11, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 512, 1025, 1, 11, 0xcac80 },
   { PIPE_FORMAT_R8_UNORM, 512, 1025, 2, 11, 0x198000 },
   { PIPE_FORMAT_R8_UNORM, 512, 2047, 1, 11, 0x155700 },
   { PIPE_FORMAT_R8_UNORM, 512, 2047, 2, 11, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 512, 2048, 1, 12, 0x155780 },
   { PIPE_FORMAT_R8_UNORM, 512, 2048, 2, 12, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 512, 2049, 1, 12, 0x175780 },
   { PIPE_FORMAT_R8_UNORM, 512, 2049, 2, 12, 0x2f0000 },
   { PIPE_FORMAT_R8_UNORM, 512, 4095, 1, 12, 0x2aac80 },
   { PIPE_FORMAT_R8_UNORM, 512, 4095, 2, 12, 0x558000 },
   { PIPE_FORMAT_R8_UNORM, 512, 4096, 1, 13, 0x2aad00 },
   { PIPE_FORMAT_R8_UNORM, 512, 4096, 2, 13, 0x558000 },
   { PIPE_FORMAT_R8_UNORM, 512, 4097, 1, 13, 0x2cad00 },
   { PIPE_FORMAT_R8_UNORM, 512, 4097, 2, 13, 0x598000 },
   { PIPE_FORMAT_R8_UNORM, 513, 1, 1, 10, 0xa80 },
   { PIPE_FORMAT_R8_UNORM, 513, 1, 2, 10, 0x1500 },
   { PIPE_FORMAT_R8_UNORM, 513, 2, 1, 10, 0xe80 },
   { PIPE_FORMAT_R8_UNORM, 513, 2, 2, 10, 0x1d00 },
   { PIPE_FORMAT_R8_UNORM, 513, 4, 1, 10, 0x1880 },
   { PIPE_FORMAT_R8_UNORM, 513, 4, 2, 10, 0x3100 },
   { PIPE_FORMAT_R8_UNORM, 513, 8, 1, 10, 0x2d80 },
   { PIPE_FORMAT_R8_UNORM, 513, 8, 2, 10, 0x5b00 },
   { PIPE_FORMAT_R8_UNORM, 513, 15, 1, 10, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 513, 15, 2, 10, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 513, 16, 1, 10, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 513, 16, 2, 10, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 513, 17, 1, 10, 0xad00 },
   { PIPE_FORMAT_R8_UNORM, 513, 17, 2, 10, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 513, 31, 1, 10, 0xad00 },
   { PIPE_FORMAT_R8_UNORM, 513, 31, 2, 10, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 513, 32, 1, 10, 0xad00 },
   { PIPE_FORMAT_R8_UNORM, 513, 32, 2, 10, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 513, 33, 1, 10, 0x15780 },
   { PIPE_FORMAT_R8_UNORM, 513, 33, 2, 10, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 513, 63, 1, 10, 0x15780 },
   { PIPE_FORMAT_R8_UNORM, 513, 63, 2, 10, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 513, 64, 1, 10, 0x15780 },
   { PIPE_FORMAT_R8_UNORM, 513, 64, 2, 10, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 513, 65, 1, 10, 0x2ac80 },
   { PIPE_FORMAT_R8_UNORM, 513, 65, 2, 10, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 513, 127, 1, 10, 0x2ac80 },
   { PIPE_FORMAT_R8_UNORM, 513, 127, 2, 10, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 513, 128, 1, 10, 0x19780 },
   { PIPE_FORMAT_R8_UNORM, 513, 128, 2, 10, 0x38000 },
   { PIPE_FORMAT_R8_UNORM, 513, 129, 1, 10, 0x2d780 },
   { PIPE_FORMAT_R8_UNORM, 513, 129, 2, 10, 0x60000 },
   { PIPE_FORMAT_R8_UNORM, 513, 255, 1, 10, 0x32c80 },
   { PIPE_FORMAT_R8_UNORM, 513, 255, 2, 10, 0x68000 },
   { PIPE_FORMAT_R8_UNORM, 513, 256, 1, 10, 0x36c80 },
   { PIPE_FORMAT_R8_UNORM, 513, 256, 2, 10, 0x70000 },
   { PIPE_FORMAT_R8_UNORM, 513, 257, 1, 10, 0x5ac80 },
   { PIPE_FORMAT_R8_UNORM, 513, 257, 2, 10, 0xb8000 },
   { PIPE_FORMAT_R8_UNORM, 513, 511, 1, 10, 0x71700 },
   { PIPE_FORMAT_R8_UNORM, 513, 511, 2, 10, 0xe8000 },
   { PIPE_FORMAT_R8_UNORM, 513, 512, 1, 10, 0x75700 },
   { PIPE_FORMAT_R8_UNORM, 513, 512, 2, 10, 0xf0000 },
   { PIPE_FORMAT_R8_UNORM, 513, 513, 1, 10, 0xa1700 },
   { PIPE_FORMAT_R8_UNORM, 513, 513, 2, 10, 0x148000 },
   { PIPE_FORMAT_R8_UNORM, 513, 1023, 1, 10, 0xeac00 },
   { PIPE_FORMAT_R8_UNORM, 513, 1023, 2, 10, 0x1d8000 },
   { PIPE_FORMAT_R8_UNORM, 513, 1024, 1, 11, 0xeac80 },
   { PIPE_FORMAT_R8_UNORM, 513, 1024, 2, 11, 0x1d8000 },
   { PIPE_FORMAT_R8_UNORM, 513, 1025, 1, 11, 0x116c80 },
   { PIPE_FORMAT_R8_UNORM, 513, 1025, 2, 11, 0x230000 },
   { PIPE_FORMAT_R8_UNORM, 513, 2047, 1, 11, 0x1d9700 },
   { PIPE_FORMAT_R8_UNORM, 513, 2047, 2, 11, 0x3b8000 },
   { PIPE_FORMAT_R8_UNORM, 513, 2048, 1, 12, 0x1d9780 },
   { PIPE_FORMAT_R8_UNORM, 513, 2048, 2, 12, 0x3b8000 },
   { PIPE_FORMAT_R8_UNORM, 513, 2049, 1, 12, 0x205780 },
   { PIPE_FORMAT_R8_UNORM, 513, 2049, 2, 12, 0x410000 },
   { PIPE_FORMAT_R8_UNORM, 513, 4095, 1, 12, 0x3b2c80 },
   { PIPE_FORMAT_R8_UNORM, 513, 4095, 2, 12, 0x768000 },
   { PIPE_FORMAT_R8_UNORM, 513, 4096, 1, 13, 0x3b2d00 },
   { PIPE_FORMAT_R8_UNORM, 513, 4096, 2, 13, 0x768000 },
   { PIPE_FORMAT_R8_UNORM, 513, 4097, 1, 13, 0x3ded00 },
   { PIPE_FORMAT_R8_UNORM, 513, 4097, 2, 13, 0x7c0000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 1, 1, 10, 0xa80 },
   { PIPE_FORMAT_R8_UNORM, 1023, 1, 2, 10, 0x1500 },
   { PIPE_FORMAT_R8_UNORM, 1023, 2, 1, 10, 0xe80 },
   { PIPE_FORMAT_R8_UNORM, 1023, 2, 2, 10, 0x1d00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 4, 1, 10, 0x1880 },
   { PIPE_FORMAT_R8_UNORM, 1023, 4, 2, 10, 0x3100 },
   { PIPE_FORMAT_R8_UNORM, 1023, 8, 1, 10, 0x2d80 },
   { PIPE_FORMAT_R8_UNORM, 1023, 8, 2, 10, 0x5b00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 15, 1, 10, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 1023, 15, 2, 10, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 16, 1, 10, 0x5800 },
   { PIPE_FORMAT_R8_UNORM, 1023, 16, 2, 10, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 17, 1, 10, 0xad00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 17, 2, 10, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 31, 1, 10, 0xad00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 31, 2, 10, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 32, 1, 10, 0xad00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 32, 2, 10, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 33, 1, 10, 0x15780 },
   { PIPE_FORMAT_R8_UNORM, 1023, 33, 2, 10, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 63, 1, 10, 0x15780 },
   { PIPE_FORMAT_R8_UNORM, 1023, 63, 2, 10, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 64, 1, 10, 0x15780 },
   { PIPE_FORMAT_R8_UNORM, 1023, 64, 2, 10, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 65, 1, 10, 0x2ac80 },
   { PIPE_FORMAT_R8_UNORM, 1023, 65, 2, 10, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 127, 1, 10, 0x2ac80 },
   { PIPE_FORMAT_R8_UNORM, 1023, 127, 2, 10, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 128, 1, 10, 0x2ac80 },
   { PIPE_FORMAT_R8_UNORM, 1023, 128, 2, 10, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 129, 1, 10, 0x4ac80 },
   { PIPE_FORMAT_R8_UNORM, 1023, 129, 2, 10, 0x98000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 255, 1, 10, 0x55700 },
   { PIPE_FORMAT_R8_UNORM, 1023, 255, 2, 10, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 256, 1, 10, 0x55700 },
   { PIPE_FORMAT_R8_UNORM, 1023, 256, 2, 10, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 257, 1, 10, 0x8d700 },
   { PIPE_FORMAT_R8_UNORM, 1023, 257, 2, 10, 0x120000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 511, 1, 10, 0xaac00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 511, 2, 10, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 512, 1, 10, 0xaac00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 512, 2, 10, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 513, 1, 10, 0xeac00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 513, 2, 10, 0x1d8000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 1023, 1, 10, 0x155680 },
   { PIPE_FORMAT_R8_UNORM, 1023, 1023, 2, 10, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 1024, 1, 11, 0x155700 },
   { PIPE_FORMAT_R8_UNORM, 1023, 1024, 2, 11, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 1025, 1, 11, 0x195700 },
   { PIPE_FORMAT_R8_UNORM, 1023, 1025, 2, 11, 0x330000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 2047, 1, 11, 0x2aac00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 2047, 2, 11, 0x558000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 2048, 1, 12, 0x2aac80 },
   { PIPE_FORMAT_R8_UNORM, 1023, 2048, 2, 12, 0x558000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 2049, 1, 12, 0x2eac80 },
   { PIPE_FORMAT_R8_UNORM, 1023, 2049, 2, 12, 0x5d8000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 4095, 1, 12, 0x555700 },
   { PIPE_FORMAT_R8_UNORM, 1023, 4095, 2, 12, 0xab0000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 4096, 1, 13, 0x555780 },
   { PIPE_FORMAT_R8_UNORM, 1023, 4096, 2, 13, 0xab0000 },
   { PIPE_FORMAT_R8_UNORM, 1023, 4097, 1, 13, 0x595780 },
   { PIPE_FORMAT_R8_UNORM, 1023, 4097, 2, 13, 0xb30000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 1, 1, 11, 0xb00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 1, 2, 11, 0x1600 },
   { PIPE_FORMAT_R8_UNORM, 1024, 2, 1, 11, 0xf00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 2, 2, 11, 0x1e00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 4, 1, 11, 0x1900 },
   { PIPE_FORMAT_R8_UNORM, 1024, 4, 2, 11, 0x3200 },
   { PIPE_FORMAT_R8_UNORM, 1024, 8, 1, 11, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 8, 2, 11, 0x5c00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 15, 1, 11, 0x5880 },
   { PIPE_FORMAT_R8_UNORM, 1024, 15, 2, 11, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 16, 1, 11, 0x5880 },
   { PIPE_FORMAT_R8_UNORM, 1024, 16, 2, 11, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 17, 1, 11, 0xad80 },
   { PIPE_FORMAT_R8_UNORM, 1024, 17, 2, 11, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 31, 1, 11, 0xad80 },
   { PIPE_FORMAT_R8_UNORM, 1024, 31, 2, 11, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 32, 1, 11, 0xad80 },
   { PIPE_FORMAT_R8_UNORM, 1024, 32, 2, 11, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 33, 1, 11, 0x15800 },
   { PIPE_FORMAT_R8_UNORM, 1024, 33, 2, 11, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 63, 1, 11, 0x15800 },
   { PIPE_FORMAT_R8_UNORM, 1024, 63, 2, 11, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 64, 1, 11, 0x15800 },
   { PIPE_FORMAT_R8_UNORM, 1024, 64, 2, 11, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 65, 1, 11, 0x2ad00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 65, 2, 11, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 127, 1, 11, 0x2ad00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 127, 2, 11, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 128, 1, 11, 0x2ad00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 128, 2, 11, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 129, 1, 11, 0x4ad00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 129, 2, 11, 0x98000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 255, 1, 11, 0x55780 },
   { PIPE_FORMAT_R8_UNORM, 1024, 255, 2, 11, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 256, 1, 11, 0x55780 },
   { PIPE_FORMAT_R8_UNORM, 1024, 256, 2, 11, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 257, 1, 11, 0x8d780 },
   { PIPE_FORMAT_R8_UNORM, 1024, 257, 2, 11, 0x120000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 511, 1, 11, 0xaac80 },
   { PIPE_FORMAT_R8_UNORM, 1024, 511, 2, 11, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 512, 1, 11, 0xaac80 },
   { PIPE_FORMAT_R8_UNORM, 1024, 512, 2, 11, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 513, 1, 11, 0xeac80 },
   { PIPE_FORMAT_R8_UNORM, 1024, 513, 2, 11, 0x1d8000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 1023, 1, 11, 0x155700 },
   { PIPE_FORMAT_R8_UNORM, 1024, 1023, 2, 11, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 1024, 1, 11, 0x155700 },
   { PIPE_FORMAT_R8_UNORM, 1024, 1024, 2, 11, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 1025, 1, 11, 0x199700 },
   { PIPE_FORMAT_R8_UNORM, 1024, 1025, 2, 11, 0x338000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 2047, 1, 11, 0x2aac00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 2047, 2, 11, 0x558000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 2048, 1, 12, 0x2aac80 },
   { PIPE_FORMAT_R8_UNORM, 1024, 2048, 2, 12, 0x558000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 2049, 1, 12, 0x2eec80 },
   { PIPE_FORMAT_R8_UNORM, 1024, 2049, 2, 12, 0x5e0000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 4095, 1, 12, 0x555700 },
   { PIPE_FORMAT_R8_UNORM, 1024, 4095, 2, 12, 0xab0000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 4096, 1, 13, 0x555780 },
   { PIPE_FORMAT_R8_UNORM, 1024, 4096, 2, 13, 0xab0000 },
   { PIPE_FORMAT_R8_UNORM, 1024, 4097, 1, 13, 0x599780 },
   { PIPE_FORMAT_R8_UNORM, 1024, 4097, 2, 13, 0xb38000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 1, 1, 11, 0x1280 },
   { PIPE_FORMAT_R8_UNORM, 1025, 1, 2, 11, 0x2500 },
   { PIPE_FORMAT_R8_UNORM, 1025, 2, 1, 11, 0x1a80 },
   { PIPE_FORMAT_R8_UNORM, 1025, 2, 2, 11, 0x3500 },
   { PIPE_FORMAT_R8_UNORM, 1025, 4, 1, 11, 0x2e80 },
   { PIPE_FORMAT_R8_UNORM, 1025, 4, 2, 11, 0x5d00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 8, 1, 11, 0x5880 },
   { PIPE_FORMAT_R8_UNORM, 1025, 8, 2, 11, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 15, 1, 11, 0xad80 },
   { PIPE_FORMAT_R8_UNORM, 1025, 15, 2, 11, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 16, 1, 11, 0xad80 },
   { PIPE_FORMAT_R8_UNORM, 1025, 16, 2, 11, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 17, 1, 11, 0x15800 },
   { PIPE_FORMAT_R8_UNORM, 1025, 17, 2, 11, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 31, 1, 11, 0x15800 },
   { PIPE_FORMAT_R8_UNORM, 1025, 31, 2, 11, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 32, 1, 11, 0x15800 },
   { PIPE_FORMAT_R8_UNORM, 1025, 32, 2, 11, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 33, 1, 11, 0x2ad00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 33, 2, 11, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 63, 1, 11, 0x2ad00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 63, 2, 11, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 64, 1, 11, 0x2ad00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 64, 2, 11, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 65, 1, 11, 0x55780 },
   { PIPE_FORMAT_R8_UNORM, 1025, 65, 2, 11, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 127, 1, 11, 0x55780 },
   { PIPE_FORMAT_R8_UNORM, 1025, 127, 2, 11, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 128, 1, 11, 0x2ed00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 128, 2, 11, 0x60000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 129, 1, 11, 0x52d00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 129, 2, 11, 0xa8000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 255, 1, 11, 0x5d780 },
   { PIPE_FORMAT_R8_UNORM, 1025, 255, 2, 11, 0xc0000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 256, 1, 11, 0x61780 },
   { PIPE_FORMAT_R8_UNORM, 1025, 256, 2, 11, 0xc8000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 257, 1, 11, 0xa1780 },
   { PIPE_FORMAT_R8_UNORM, 1025, 257, 2, 11, 0x148000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 511, 1, 11, 0xc6c80 },
   { PIPE_FORMAT_R8_UNORM, 1025, 511, 2, 11, 0x190000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 512, 1, 11, 0xcac80 },
   { PIPE_FORMAT_R8_UNORM, 1025, 512, 2, 11, 0x198000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 513, 1, 11, 0x116c80 },
   { PIPE_FORMAT_R8_UNORM, 1025, 513, 2, 11, 0x230000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 1023, 1, 11, 0x195700 },
   { PIPE_FORMAT_R8_UNORM, 1025, 1023, 2, 11, 0x330000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 1024, 1, 11, 0x199700 },
   { PIPE_FORMAT_R8_UNORM, 1025, 1024, 2, 11, 0x338000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 1025, 1, 11, 0x1f1700 },
   { PIPE_FORMAT_R8_UNORM, 1025, 1025, 2, 11, 0x3e8000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 2047, 1, 11, 0x336c00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 2047, 2, 11, 0x670000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 2048, 1, 12, 0x336c80 },
   { PIPE_FORMAT_R8_UNORM, 1025, 2048, 2, 12, 0x670000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 2049, 1, 12, 0x38ac80 },
   { PIPE_FORMAT_R8_UNORM, 1025, 2049, 2, 12, 0x718000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 4095, 1, 12, 0x66d700 },
   { PIPE_FORMAT_R8_UNORM, 1025, 4095, 2, 12, 0xce0000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 4096, 1, 13, 0x66d780 },
   { PIPE_FORMAT_R8_UNORM, 1025, 4096, 2, 13, 0xce0000 },
   { PIPE_FORMAT_R8_UNORM, 1025, 4097, 1, 13, 0x6c1780 },
   { PIPE_FORMAT_R8_UNORM, 1025, 4097, 2, 13, 0xd88000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 1, 1, 11, 0x1280 },
   { PIPE_FORMAT_R8_UNORM, 2047, 1, 2, 11, 0x2500 },
   { PIPE_FORMAT_R8_UNORM, 2047, 2, 1, 11, 0x1a80 },
   { PIPE_FORMAT_R8_UNORM, 2047, 2, 2, 11, 0x3500 },
   { PIPE_FORMAT_R8_UNORM, 2047, 4, 1, 11, 0x2e80 },
   { PIPE_FORMAT_R8_UNORM, 2047, 4, 2, 11, 0x5d00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 8, 1, 11, 0x5880 },
   { PIPE_FORMAT_R8_UNORM, 2047, 8, 2, 11, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 15, 1, 11, 0xad80 },
   { PIPE_FORMAT_R8_UNORM, 2047, 15, 2, 11, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 16, 1, 11, 0xad80 },
   { PIPE_FORMAT_R8_UNORM, 2047, 16, 2, 11, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 17, 1, 11, 0x15800 },
   { PIPE_FORMAT_R8_UNORM, 2047, 17, 2, 11, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 31, 1, 11, 0x15800 },
   { PIPE_FORMAT_R8_UNORM, 2047, 31, 2, 11, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 32, 1, 11, 0x15800 },
   { PIPE_FORMAT_R8_UNORM, 2047, 32, 2, 11, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 33, 1, 11, 0x2ad00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 33, 2, 11, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 63, 1, 11, 0x2ad00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 63, 2, 11, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 64, 1, 11, 0x2ad00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 64, 2, 11, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 65, 1, 11, 0x55780 },
   { PIPE_FORMAT_R8_UNORM, 2047, 65, 2, 11, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 127, 1, 11, 0x55780 },
   { PIPE_FORMAT_R8_UNORM, 2047, 127, 2, 11, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 128, 1, 11, 0x55780 },
   { PIPE_FORMAT_R8_UNORM, 2047, 128, 2, 11, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 129, 1, 11, 0x95780 },
   { PIPE_FORMAT_R8_UNORM, 2047, 129, 2, 11, 0x130000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 255, 1, 11, 0xaac80 },
   { PIPE_FORMAT_R8_UNORM, 2047, 255, 2, 11, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 256, 1, 11, 0xaac80 },
   { PIPE_FORMAT_R8_UNORM, 2047, 256, 2, 11, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 257, 1, 11, 0x11ac80 },
   { PIPE_FORMAT_R8_UNORM, 2047, 257, 2, 11, 0x238000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 511, 1, 11, 0x155700 },
   { PIPE_FORMAT_R8_UNORM, 2047, 511, 2, 11, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 512, 1, 11, 0x155700 },
   { PIPE_FORMAT_R8_UNORM, 2047, 512, 2, 11, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 513, 1, 11, 0x1d9700 },
   { PIPE_FORMAT_R8_UNORM, 2047, 513, 2, 11, 0x3b8000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 1023, 1, 11, 0x2aac00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 1023, 2, 11, 0x558000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 1024, 1, 11, 0x2aac00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 1024, 2, 11, 0x558000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 1025, 1, 11, 0x336c00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 1025, 2, 11, 0x670000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 2047, 1, 11, 0x555680 },
   { PIPE_FORMAT_R8_UNORM, 2047, 2047, 2, 11, 0xab0000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 2048, 1, 12, 0x555700 },
   { PIPE_FORMAT_R8_UNORM, 2047, 2048, 2, 12, 0xab0000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 2049, 1, 12, 0x5e1700 },
   { PIPE_FORMAT_R8_UNORM, 2047, 2049, 2, 12, 0xbc8000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 4095, 1, 12, 0xaaac00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 4095, 2, 12, 0x1558000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 4096, 1, 13, 0xaaac80 },
   { PIPE_FORMAT_R8_UNORM, 2047, 4096, 2, 13, 0x1558000 },
   { PIPE_FORMAT_R8_UNORM, 2047, 4097, 1, 13, 0xb36c80 },
   { PIPE_FORMAT_R8_UNORM, 2047, 4097, 2, 13, 0x1670000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 1, 1, 12, 0x1300 },
   { PIPE_FORMAT_R8_UNORM, 2048, 1, 2, 12, 0x2600 },
   { PIPE_FORMAT_R8_UNORM, 2048, 2, 1, 12, 0x1b00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 2, 2, 12, 0x3600 },
   { PIPE_FORMAT_R8_UNORM, 2048, 4, 1, 12, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 4, 2, 12, 0x5e00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 8, 1, 12, 0x5900 },
   { PIPE_FORMAT_R8_UNORM, 2048, 8, 2, 12, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 15, 1, 12, 0xae00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 15, 2, 12, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 16, 1, 12, 0xae00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 16, 2, 12, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 17, 1, 12, 0x15880 },
   { PIPE_FORMAT_R8_UNORM, 2048, 17, 2, 12, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 31, 1, 12, 0x15880 },
   { PIPE_FORMAT_R8_UNORM, 2048, 31, 2, 12, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 32, 1, 12, 0x15880 },
   { PIPE_FORMAT_R8_UNORM, 2048, 32, 2, 12, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 33, 1, 12, 0x2ad80 },
   { PIPE_FORMAT_R8_UNORM, 2048, 33, 2, 12, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 63, 1, 12, 0x2ad80 },
   { PIPE_FORMAT_R8_UNORM, 2048, 63, 2, 12, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 64, 1, 12, 0x2ad80 },
   { PIPE_FORMAT_R8_UNORM, 2048, 64, 2, 12, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 65, 1, 12, 0x55800 },
   { PIPE_FORMAT_R8_UNORM, 2048, 65, 2, 12, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 127, 1, 12, 0x55800 },
   { PIPE_FORMAT_R8_UNORM, 2048, 127, 2, 12, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 128, 1, 12, 0x55800 },
   { PIPE_FORMAT_R8_UNORM, 2048, 128, 2, 12, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 129, 1, 12, 0x95800 },
   { PIPE_FORMAT_R8_UNORM, 2048, 129, 2, 12, 0x130000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 255, 1, 12, 0xaad00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 255, 2, 12, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 256, 1, 12, 0xaad00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 256, 2, 12, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 257, 1, 12, 0x11ad00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 257, 2, 12, 0x238000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 511, 1, 12, 0x155780 },
   { PIPE_FORMAT_R8_UNORM, 2048, 511, 2, 12, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 512, 1, 12, 0x155780 },
   { PIPE_FORMAT_R8_UNORM, 2048, 512, 2, 12, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 513, 1, 12, 0x1d9780 },
   { PIPE_FORMAT_R8_UNORM, 2048, 513, 2, 12, 0x3b8000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 1023, 1, 12, 0x2aac80 },
   { PIPE_FORMAT_R8_UNORM, 2048, 1023, 2, 12, 0x558000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 1024, 1, 12, 0x2aac80 },
   { PIPE_FORMAT_R8_UNORM, 2048, 1024, 2, 12, 0x558000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 1025, 1, 12, 0x336c80 },
   { PIPE_FORMAT_R8_UNORM, 2048, 1025, 2, 12, 0x670000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 2047, 1, 12, 0x555700 },
   { PIPE_FORMAT_R8_UNORM, 2048, 2047, 2, 12, 0xab0000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 2048, 1, 12, 0x555700 },
   { PIPE_FORMAT_R8_UNORM, 2048, 2048, 2, 12, 0xab0000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 2049, 1, 12, 0x5e5700 },
   { PIPE_FORMAT_R8_UNORM, 2048, 2049, 2, 12, 0xbd0000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 4095, 1, 12, 0xaaac00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 4095, 2, 12, 0x1558000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 4096, 1, 13, 0xaaac80 },
   { PIPE_FORMAT_R8_UNORM, 2048, 4096, 2, 13, 0x1558000 },
   { PIPE_FORMAT_R8_UNORM, 2048, 4097, 1, 13, 0xb3ac80 },
   { PIPE_FORMAT_R8_UNORM, 2048, 4097, 2, 13, 0x1678000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 1, 1, 12, 0x2280 },
   { PIPE_FORMAT_R8_UNORM, 2049, 1, 2, 12, 0x4500 },
   { PIPE_FORMAT_R8_UNORM, 2049, 2, 1, 12, 0x3280 },
   { PIPE_FORMAT_R8_UNORM, 2049, 2, 2, 12, 0x6500 },
   { PIPE_FORMAT_R8_UNORM, 2049, 4, 1, 12, 0x5a80 },
   { PIPE_FORMAT_R8_UNORM, 2049, 4, 2, 12, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 8, 1, 12, 0xae80 },
   { PIPE_FORMAT_R8_UNORM, 2049, 8, 2, 12, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 15, 1, 12, 0x15880 },
   { PIPE_FORMAT_R8_UNORM, 2049, 15, 2, 12, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 16, 1, 12, 0x15880 },
   { PIPE_FORMAT_R8_UNORM, 2049, 16, 2, 12, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 17, 1, 12, 0x2ad80 },
   { PIPE_FORMAT_R8_UNORM, 2049, 17, 2, 12, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 31, 1, 12, 0x2ad80 },
   { PIPE_FORMAT_R8_UNORM, 2049, 31, 2, 12, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 32, 1, 12, 0x2ad80 },
   { PIPE_FORMAT_R8_UNORM, 2049, 32, 2, 12, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 33, 1, 12, 0x55800 },
   { PIPE_FORMAT_R8_UNORM, 2049, 33, 2, 12, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 63, 1, 12, 0x55800 },
   { PIPE_FORMAT_R8_UNORM, 2049, 63, 2, 12, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 64, 1, 12, 0x55800 },
   { PIPE_FORMAT_R8_UNORM, 2049, 64, 2, 12, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 65, 1, 12, 0xaad00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 65, 2, 12, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 127, 1, 12, 0xaad00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 127, 2, 12, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 128, 1, 12, 0x59800 },
   { PIPE_FORMAT_R8_UNORM, 2049, 128, 2, 12, 0xb8000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 129, 1, 12, 0x9d800 },
   { PIPE_FORMAT_R8_UNORM, 2049, 129, 2, 12, 0x140000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 255, 1, 12, 0xb2d00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 255, 2, 12, 0x168000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 256, 1, 12, 0xb6d00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 256, 2, 12, 0x170000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 257, 1, 12, 0x12ed00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 257, 2, 12, 0x260000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 511, 1, 12, 0x171780 },
   { PIPE_FORMAT_R8_UNORM, 2049, 511, 2, 12, 0x2e8000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 512, 1, 12, 0x175780 },
   { PIPE_FORMAT_R8_UNORM, 2049, 512, 2, 12, 0x2f0000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 513, 1, 12, 0x205780 },
   { PIPE_FORMAT_R8_UNORM, 2049, 513, 2, 12, 0x410000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 1023, 1, 12, 0x2eac80 },
   { PIPE_FORMAT_R8_UNORM, 2049, 1023, 2, 12, 0x5d8000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 1024, 1, 12, 0x2eec80 },
   { PIPE_FORMAT_R8_UNORM, 2049, 1024, 2, 12, 0x5e0000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 1025, 1, 12, 0x38ac80 },
   { PIPE_FORMAT_R8_UNORM, 2049, 1025, 2, 12, 0x718000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 2047, 1, 12, 0x5e1700 },
   { PIPE_FORMAT_R8_UNORM, 2049, 2047, 2, 12, 0xbc8000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 2048, 1, 12, 0x5e5700 },
   { PIPE_FORMAT_R8_UNORM, 2049, 2048, 2, 12, 0xbd0000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 2049, 1, 12, 0x689700 },
   { PIPE_FORMAT_R8_UNORM, 2049, 2049, 2, 12, 0xd18000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 4095, 1, 12, 0xbcac00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 4095, 2, 12, 0x1798000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 4096, 1, 13, 0xbcac80 },
   { PIPE_FORMAT_R8_UNORM, 2049, 4096, 2, 13, 0x1798000 },
   { PIPE_FORMAT_R8_UNORM, 2049, 4097, 1, 13, 0xc6ec80 },
   { PIPE_FORMAT_R8_UNORM, 2049, 4097, 2, 13, 0x18e0000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 1, 1, 12, 0x2280 },
   { PIPE_FORMAT_R8_UNORM, 4095, 1, 2, 12, 0x4500 },
   { PIPE_FORMAT_R8_UNORM, 4095, 2, 1, 12, 0x3280 },
   { PIPE_FORMAT_R8_UNORM, 4095, 2, 2, 12, 0x6500 },
   { PIPE_FORMAT_R8_UNORM, 4095, 4, 1, 12, 0x5a80 },
   { PIPE_FORMAT_R8_UNORM, 4095, 4, 2, 12, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 8, 1, 12, 0xae80 },
   { PIPE_FORMAT_R8_UNORM, 4095, 8, 2, 12, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 15, 1, 12, 0x15880 },
   { PIPE_FORMAT_R8_UNORM, 4095, 15, 2, 12, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 16, 1, 12, 0x15880 },
   { PIPE_FORMAT_R8_UNORM, 4095, 16, 2, 12, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 17, 1, 12, 0x2ad80 },
   { PIPE_FORMAT_R8_UNORM, 4095, 17, 2, 12, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 31, 1, 12, 0x2ad80 },
   { PIPE_FORMAT_R8_UNORM, 4095, 31, 2, 12, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 32, 1, 12, 0x2ad80 },
   { PIPE_FORMAT_R8_UNORM, 4095, 32, 2, 12, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 33, 1, 12, 0x55800 },
   { PIPE_FORMAT_R8_UNORM, 4095, 33, 2, 12, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 63, 1, 12, 0x55800 },
   { PIPE_FORMAT_R8_UNORM, 4095, 63, 2, 12, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 64, 1, 12, 0x55800 },
   { PIPE_FORMAT_R8_UNORM, 4095, 64, 2, 12, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 65, 1, 12, 0xaad00 },
   { PIPE_FORMAT_R8_UNORM, 4095, 65, 2, 12, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 127, 1, 12, 0xaad00 },
   { PIPE_FORMAT_R8_UNORM, 4095, 127, 2, 12, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 128, 1, 12, 0xaad00 },
   { PIPE_FORMAT_R8_UNORM, 4095, 128, 2, 12, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 129, 1, 12, 0x12ad00 },
   { PIPE_FORMAT_R8_UNORM, 4095, 129, 2, 12, 0x258000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 255, 1, 12, 0x155780 },
   { PIPE_FORMAT_R8_UNORM, 4095, 255, 2, 12, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 256, 1, 12, 0x155780 },
   { PIPE_FORMAT_R8_UNORM, 4095, 256, 2, 12, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 257, 1, 12, 0x235780 },
   { PIPE_FORMAT_R8_UNORM, 4095, 257, 2, 12, 0x470000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 511, 1, 12, 0x2aac80 },
   { PIPE_FORMAT_R8_UNORM, 4095, 511, 2, 12, 0x558000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 512, 1, 12, 0x2aac80 },
   { PIPE_FORMAT_R8_UNORM, 4095, 512, 2, 12, 0x558000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 513, 1, 12, 0x3b2c80 },
   { PIPE_FORMAT_R8_UNORM, 4095, 513, 2, 12, 0x768000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 1023, 1, 12, 0x555700 },
   { PIPE_FORMAT_R8_UNORM, 4095, 1023, 2, 12, 0xab0000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 1024, 1, 12, 0x555700 },
   { PIPE_FORMAT_R8_UNORM, 4095, 1024, 2, 12, 0xab0000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 1025, 1, 12, 0x66d700 },
   { PIPE_FORMAT_R8_UNORM, 4095, 1025, 2, 12, 0xce0000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 2047, 1, 12, 0xaaac00 },
   { PIPE_FORMAT_R8_UNORM, 4095, 2047, 2, 12, 0x1558000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 2048, 1, 12, 0xaaac00 },
   { PIPE_FORMAT_R8_UNORM, 4095, 2048, 2, 12, 0x1558000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 2049, 1, 12, 0xbcac00 },
   { PIPE_FORMAT_R8_UNORM, 4095, 2049, 2, 12, 0x1798000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 4095, 1, 12, 0x1555680 },
   { PIPE_FORMAT_R8_UNORM, 4095, 4095, 2, 12, 0x2ab0000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 4096, 1, 13, 0x1555700 },
   { PIPE_FORMAT_R8_UNORM, 4095, 4096, 2, 13, 0x2ab0000 },
   { PIPE_FORMAT_R8_UNORM, 4095, 4097, 1, 13, 0x1675700 },
   { PIPE_FORMAT_R8_UNORM, 4095, 4097, 2, 13, 0x2cf0000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 1, 1, 13, 0x2300 },
   { PIPE_FORMAT_R8_UNORM, 4096, 1, 2, 13, 0x4600 },
   { PIPE_FORMAT_R8_UNORM, 4096, 2, 1, 13, 0x3300 },
   { PIPE_FORMAT_R8_UNORM, 4096, 2, 2, 13, 0x6600 },
   { PIPE_FORMAT_R8_UNORM, 4096, 4, 1, 13, 0x5b00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 4, 2, 13, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 8, 1, 13, 0xaf00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 8, 2, 13, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 15, 1, 13, 0x15900 },
   { PIPE_FORMAT_R8_UNORM, 4096, 15, 2, 13, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 16, 1, 13, 0x15900 },
   { PIPE_FORMAT_R8_UNORM, 4096, 16, 2, 13, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 17, 1, 13, 0x2ae00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 17, 2, 13, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 31, 1, 13, 0x2ae00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 31, 2, 13, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 32, 1, 13, 0x2ae00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 32, 2, 13, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 33, 1, 13, 0x55880 },
   { PIPE_FORMAT_R8_UNORM, 4096, 33, 2, 13, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 63, 1, 13, 0x55880 },
   { PIPE_FORMAT_R8_UNORM, 4096, 63, 2, 13, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 64, 1, 13, 0x55880 },
   { PIPE_FORMAT_R8_UNORM, 4096, 64, 2, 13, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 65, 1, 13, 0xaad80 },
   { PIPE_FORMAT_R8_UNORM, 4096, 65, 2, 13, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 127, 1, 13, 0xaad80 },
   { PIPE_FORMAT_R8_UNORM, 4096, 127, 2, 13, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 128, 1, 13, 0xaad80 },
   { PIPE_FORMAT_R8_UNORM, 4096, 128, 2, 13, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 129, 1, 13, 0x12ad80 },
   { PIPE_FORMAT_R8_UNORM, 4096, 129, 2, 13, 0x258000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 255, 1, 13, 0x155800 },
   { PIPE_FORMAT_R8_UNORM, 4096, 255, 2, 13, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 256, 1, 13, 0x155800 },
   { PIPE_FORMAT_R8_UNORM, 4096, 256, 2, 13, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 257, 1, 13, 0x235800 },
   { PIPE_FORMAT_R8_UNORM, 4096, 257, 2, 13, 0x470000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 511, 1, 13, 0x2aad00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 511, 2, 13, 0x558000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 512, 1, 13, 0x2aad00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 512, 2, 13, 0x558000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 513, 1, 13, 0x3b2d00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 513, 2, 13, 0x768000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 1023, 1, 13, 0x555780 },
   { PIPE_FORMAT_R8_UNORM, 4096, 1023, 2, 13, 0xab0000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 1024, 1, 13, 0x555780 },
   { PIPE_FORMAT_R8_UNORM, 4096, 1024, 2, 13, 0xab0000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 1025, 1, 13, 0x66d780 },
   { PIPE_FORMAT_R8_UNORM, 4096, 1025, 2, 13, 0xce0000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 2047, 1, 13, 0xaaac80 },
   { PIPE_FORMAT_R8_UNORM, 4096, 2047, 2, 13, 0x1558000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 2048, 1, 13, 0xaaac80 },
   { PIPE_FORMAT_R8_UNORM, 4096, 2048, 2, 13, 0x1558000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 2049, 1, 13, 0xbcac80 },
   { PIPE_FORMAT_R8_UNORM, 4096, 2049, 2, 13, 0x1798000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 4095, 1, 13, 0x1555700 },
   { PIPE_FORMAT_R8_UNORM, 4096, 4095, 2, 13, 0x2ab0000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 4096, 1, 13, 0x1555700 },
   { PIPE_FORMAT_R8_UNORM, 4096, 4096, 2, 13, 0x2ab0000 },
   { PIPE_FORMAT_R8_UNORM, 4096, 4097, 1, 13, 0x1679700 },
   { PIPE_FORMAT_R8_UNORM, 4096, 4097, 2, 13, 0x2cf8000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 1, 1, 13, 0x4280 },
   { PIPE_FORMAT_R8_UNORM, 4097, 1, 2, 13, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 2, 1, 13, 0x6280 },
   { PIPE_FORMAT_R8_UNORM, 4097, 2, 2, 13, 0x10000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 4, 1, 13, 0xb280 },
   { PIPE_FORMAT_R8_UNORM, 4097, 4, 2, 13, 0x18000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 8, 1, 13, 0x15a80 },
   { PIPE_FORMAT_R8_UNORM, 4097, 8, 2, 13, 0x30000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 15, 1, 13, 0x2ae80 },
   { PIPE_FORMAT_R8_UNORM, 4097, 15, 2, 13, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 16, 1, 13, 0x2ae80 },
   { PIPE_FORMAT_R8_UNORM, 4097, 16, 2, 13, 0x58000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 17, 1, 13, 0x55880 },
   { PIPE_FORMAT_R8_UNORM, 4097, 17, 2, 13, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 31, 1, 13, 0x55880 },
   { PIPE_FORMAT_R8_UNORM, 4097, 31, 2, 13, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 32, 1, 13, 0x55880 },
   { PIPE_FORMAT_R8_UNORM, 4097, 32, 2, 13, 0xb0000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 33, 1, 13, 0xaad80 },
   { PIPE_FORMAT_R8_UNORM, 4097, 33, 2, 13, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 63, 1, 13, 0xaad80 },
   { PIPE_FORMAT_R8_UNORM, 4097, 63, 2, 13, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 64, 1, 13, 0xaad80 },
   { PIPE_FORMAT_R8_UNORM, 4097, 64, 2, 13, 0x158000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 65, 1, 13, 0x155800 },
   { PIPE_FORMAT_R8_UNORM, 4097, 65, 2, 13, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 127, 1, 13, 0x155800 },
   { PIPE_FORMAT_R8_UNORM, 4097, 127, 2, 13, 0x2b0000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 128, 1, 13, 0xaed80 },
   { PIPE_FORMAT_R8_UNORM, 4097, 128, 2, 13, 0x160000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 129, 1, 13, 0x132d80 },
   { PIPE_FORMAT_R8_UNORM, 4097, 129, 2, 13, 0x268000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 255, 1, 13, 0x15d800 },
   { PIPE_FORMAT_R8_UNORM, 4097, 255, 2, 13, 0x2c0000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 256, 1, 13, 0x161800 },
   { PIPE_FORMAT_R8_UNORM, 4097, 256, 2, 13, 0x2c8000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 257, 1, 13, 0x249800 },
   { PIPE_FORMAT_R8_UNORM, 4097, 257, 2, 13, 0x498000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 511, 1, 13, 0x2c6d00 },
   { PIPE_FORMAT_R8_UNORM, 4097, 511, 2, 13, 0x590000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 512, 1, 13, 0x2cad00 },
   { PIPE_FORMAT_R8_UNORM, 4097, 512, 2, 13, 0x598000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 513, 1, 13, 0x3ded00 },
   { PIPE_FORMAT_R8_UNORM, 4097, 513, 2, 13, 0x7c0000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 1023, 1, 13, 0x595780 },
   { PIPE_FORMAT_R8_UNORM, 4097, 1023, 2, 13, 0xb30000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 1024, 1, 13, 0x599780 },
   { PIPE_FORMAT_R8_UNORM, 4097, 1024, 2, 13, 0xb38000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 1025, 1, 13, 0x6c1780 },
   { PIPE_FORMAT_R8_UNORM, 4097, 1025, 2, 13, 0xd88000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 2047, 1, 13, 0xb36c80 },
   { PIPE_FORMAT_R8_UNORM, 4097, 2047, 2, 13, 0x1670000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 2048, 1, 13, 0xb3ac80 },
   { PIPE_FORMAT_R8_UNORM, 4097, 2048, 2, 13, 0x1678000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 2049, 1, 13, 0xc6ec80 },
   { PIPE_FORMAT_R8_UNORM, 4097, 2049, 2, 13, 0x18e0000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 4095, 1, 13, 0x1675700 },
   { PIPE_FORMAT_R8_UNORM, 4097, 4095, 2, 13, 0x2cf0000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 4096, 1, 13, 0x1679700 },
   { PIPE_FORMAT_R8_UNORM, 4097, 4096, 2, 13, 0x2cf8000 },
   { PIPE_FORMAT_R8_UNORM, 4097, 4097, 1, 13, 0x17b9700 },
   { PIPE_FORMAT_R8_UNORM, 4097, 4097, 2, 13, 0x2f78000 },
   { PIPE_FORMAT_S8_UINT, 1, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 1, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 1, 2, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 1, 2, 1, 2, 0x100 },
   { PIPE_FORMAT_S8_UINT, 1, 2, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 1, 2, 2, 2, 0x200 },
   { PIPE_FORMAT_S8_UINT, 1, 4, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 1, 4, 1, 3, 0x180 },
   { PIPE_FORMAT_S8_UINT, 1, 4, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 1, 4, 2, 3, 0x300 },
   { PIPE_FORMAT_S8_UINT, 1, 8, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 1, 8, 1, 4, 0x200 },
   { PIPE_FORMAT_S8_UINT, 1, 8, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 1, 8, 2, 4, 0x400 },
   { PIPE_FORMAT_S8_UINT, 1, 15, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 1, 15, 1, 4, 0x200 },
   { PIPE_FORMAT_S8_UINT, 1, 15, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 1, 15, 2, 4, 0x400 },
   { PIPE_FORMAT_S8_UINT, 1, 16, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 1, 16, 1, 5, 0x280 },
   { PIPE_FORMAT_S8_UINT, 1, 16, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 1, 16, 2, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 1, 17, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 1, 17, 1, 5, 0x280 },
   { PIPE_FORMAT_S8_UINT, 1, 17, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 1, 17, 2, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 1, 31, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 1, 31, 1, 5, 0x280 },
   { PIPE_FORMAT_S8_UINT, 1, 31, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 1, 31, 2, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 1, 32, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 1, 32, 1, 6, 0x300 },
   { PIPE_FORMAT_S8_UINT, 1, 32, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 1, 32, 2, 6, 0x600 },
   { PIPE_FORMAT_S8_UINT, 1, 33, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 1, 33, 1, 6, 0x300 },
   { PIPE_FORMAT_S8_UINT, 1, 33, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 1, 33, 2, 6, 0x600 },
   { PIPE_FORMAT_S8_UINT, 1, 63, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 1, 63, 1, 6, 0x300 },
   { PIPE_FORMAT_S8_UINT, 1, 63, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 1, 63, 2, 6, 0x600 },
   { PIPE_FORMAT_S8_UINT, 1, 64, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 1, 64, 1, 7, 0x380 },
   { PIPE_FORMAT_S8_UINT, 1, 64, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 1, 64, 2, 7, 0x700 },
   { PIPE_FORMAT_S8_UINT, 1, 65, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 1, 65, 1, 7, 0x380 },
   { PIPE_FORMAT_S8_UINT, 1, 65, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 1, 65, 2, 7, 0x700 },
   { PIPE_FORMAT_S8_UINT, 1, 127, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 1, 127, 1, 7, 0x380 },
   { PIPE_FORMAT_S8_UINT, 1, 127, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 1, 127, 2, 7, 0x700 },
   { PIPE_FORMAT_S8_UINT, 1, 128, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 1, 128, 1, 8, 0x400 },
   { PIPE_FORMAT_S8_UINT, 1, 128, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 1, 128, 2, 8, 0x800 },
   { PIPE_FORMAT_S8_UINT, 1, 129, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 1, 129, 1, 8, 0x480 },
   { PIPE_FORMAT_S8_UINT, 1, 129, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 1, 129, 2, 8, 0x900 },
   { PIPE_FORMAT_S8_UINT, 1, 255, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 1, 255, 1, 8, 0x480 },
   { PIPE_FORMAT_S8_UINT, 1, 255, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 1, 255, 2, 8, 0x900 },
   { PIPE_FORMAT_S8_UINT, 1, 256, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 1, 256, 1, 9, 0x500 },
   { PIPE_FORMAT_S8_UINT, 1, 256, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 1, 256, 2, 9, 0xa00 },
   { PIPE_FORMAT_S8_UINT, 1, 257, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 1, 257, 1, 9, 0x680 },
   { PIPE_FORMAT_S8_UINT, 1, 257, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 1, 257, 2, 9, 0xd00 },
   { PIPE_FORMAT_S8_UINT, 1, 511, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 1, 511, 1, 9, 0x680 },
   { PIPE_FORMAT_S8_UINT, 1, 511, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 1, 511, 2, 9, 0xd00 },
   { PIPE_FORMAT_S8_UINT, 1, 512, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 1, 512, 1, 10, 0x700 },
   { PIPE_FORMAT_S8_UINT, 1, 512, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 1, 512, 2, 10, 0xe00 },
   { PIPE_FORMAT_S8_UINT, 1, 513, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 1, 513, 1, 10, 0xa80 },
   { PIPE_FORMAT_S8_UINT, 1, 513, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 1, 513, 2, 10, 0x1500 },
   { PIPE_FORMAT_S8_UINT, 1, 1023, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 1, 1023, 1, 10, 0xa80 },
   { PIPE_FORMAT_S8_UINT, 1, 1023, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 1, 1023, 2, 10, 0x1500 },
   { PIPE_FORMAT_S8_UINT, 1, 1024, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 1, 1024, 1, 11, 0xb00 },
   { PIPE_FORMAT_S8_UINT, 1, 1024, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 1, 1024, 2, 11, 0x1600 },
   { PIPE_FORMAT_S8_UINT, 1, 1025, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 1, 1025, 1, 11, 0x1280 },
   { PIPE_FORMAT_S8_UINT, 1, 1025, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 1, 1025, 2, 11, 0x2500 },
   { PIPE_FORMAT_S8_UINT, 1, 2047, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 1, 2047, 1, 11, 0x1280 },
   { PIPE_FORMAT_S8_UINT, 1, 2047, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 1, 2047, 2, 11, 0x2500 },
   { PIPE_FORMAT_S8_UINT, 1, 2048, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 1, 2048, 1, 12, 0x1300 },
   { PIPE_FORMAT_S8_UINT, 1, 2048, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 1, 2048, 2, 12, 0x2600 },
   { PIPE_FORMAT_S8_UINT, 1, 2049, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 1, 2049, 1, 12, 0x2280 },
   { PIPE_FORMAT_S8_UINT, 1, 2049, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 1, 2049, 2, 12, 0x4500 },
   { PIPE_FORMAT_S8_UINT, 1, 4095, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 1, 4095, 1, 12, 0x2280 },
   { PIPE_FORMAT_S8_UINT, 1, 4095, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 1, 4095, 2, 12, 0x4500 },
   { PIPE_FORMAT_S8_UINT, 1, 4096, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 1, 4096, 1, 13, 0x2300 },
   { PIPE_FORMAT_S8_UINT, 1, 4096, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 1, 4096, 2, 13, 0x4600 },
   { PIPE_FORMAT_S8_UINT, 1, 4097, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 1, 4097, 1, 13, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 1, 4097, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 1, 4097, 2, 13, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 2, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 2, 1, 1, 2, 0x100 },
   { PIPE_FORMAT_S8_UINT, 2, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 2, 1, 2, 2, 0x200 },
   { PIPE_FORMAT_S8_UINT, 2, 2, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 2, 2, 1, 2, 0x100 },
   { PIPE_FORMAT_S8_UINT, 2, 2, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 2, 2, 2, 2, 0x200 },
   { PIPE_FORMAT_S8_UINT, 2, 4, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 2, 4, 1, 3, 0x180 },
   { PIPE_FORMAT_S8_UINT, 2, 4, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 2, 4, 2, 3, 0x300 },
   { PIPE_FORMAT_S8_UINT, 2, 8, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 2, 8, 1, 4, 0x200 },
   { PIPE_FORMAT_S8_UINT, 2, 8, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 2, 8, 2, 4, 0x400 },
   { PIPE_FORMAT_S8_UINT, 2, 15, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 2, 15, 1, 4, 0x200 },
   { PIPE_FORMAT_S8_UINT, 2, 15, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 2, 15, 2, 4, 0x400 },
   { PIPE_FORMAT_S8_UINT, 2, 16, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 2, 16, 1, 5, 0x280 },
   { PIPE_FORMAT_S8_UINT, 2, 16, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 2, 16, 2, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 2, 17, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 2, 17, 1, 5, 0x280 },
   { PIPE_FORMAT_S8_UINT, 2, 17, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 2, 17, 2, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 2, 31, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 2, 31, 1, 5, 0x280 },
   { PIPE_FORMAT_S8_UINT, 2, 31, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 2, 31, 2, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 2, 32, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 2, 32, 1, 6, 0x300 },
   { PIPE_FORMAT_S8_UINT, 2, 32, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 2, 32, 2, 6, 0x600 },
   { PIPE_FORMAT_S8_UINT, 2, 33, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 2, 33, 1, 6, 0x300 },
   { PIPE_FORMAT_S8_UINT, 2, 33, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 2, 33, 2, 6, 0x600 },
   { PIPE_FORMAT_S8_UINT, 2, 63, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 2, 63, 1, 6, 0x300 },
   { PIPE_FORMAT_S8_UINT, 2, 63, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 2, 63, 2, 6, 0x600 },
   { PIPE_FORMAT_S8_UINT, 2, 64, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 2, 64, 1, 7, 0x380 },
   { PIPE_FORMAT_S8_UINT, 2, 64, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 2, 64, 2, 7, 0x700 },
   { PIPE_FORMAT_S8_UINT, 2, 65, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 2, 65, 1, 7, 0x400 },
   { PIPE_FORMAT_S8_UINT, 2, 65, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 2, 65, 2, 7, 0x800 },
   { PIPE_FORMAT_S8_UINT, 2, 127, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 2, 127, 1, 7, 0x400 },
   { PIPE_FORMAT_S8_UINT, 2, 127, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 2, 127, 2, 7, 0x800 },
   { PIPE_FORMAT_S8_UINT, 2, 128, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 2, 128, 1, 8, 0x480 },
   { PIPE_FORMAT_S8_UINT, 2, 128, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 2, 128, 2, 8, 0x900 },
   { PIPE_FORMAT_S8_UINT, 2, 129, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 2, 129, 1, 8, 0x580 },
   { PIPE_FORMAT_S8_UINT, 2, 129, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 2, 129, 2, 8, 0xb00 },
   { PIPE_FORMAT_S8_UINT, 2, 255, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 2, 255, 1, 8, 0x580 },
   { PIPE_FORMAT_S8_UINT, 2, 255, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 2, 255, 2, 8, 0xb00 },
   { PIPE_FORMAT_S8_UINT, 2, 256, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 2, 256, 1, 9, 0x600 },
   { PIPE_FORMAT_S8_UINT, 2, 256, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 2, 256, 2, 9, 0xc00 },
   { PIPE_FORMAT_S8_UINT, 2, 257, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 2, 257, 1, 9, 0x880 },
   { PIPE_FORMAT_S8_UINT, 2, 257, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 2, 257, 2, 9, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 2, 511, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 2, 511, 1, 9, 0x880 },
   { PIPE_FORMAT_S8_UINT, 2, 511, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 2, 511, 2, 9, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 2, 512, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 2, 512, 1, 10, 0x900 },
   { PIPE_FORMAT_S8_UINT, 2, 512, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 2, 512, 2, 10, 0x1200 },
   { PIPE_FORMAT_S8_UINT, 2, 513, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 2, 513, 1, 10, 0xe80 },
   { PIPE_FORMAT_S8_UINT, 2, 513, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 2, 513, 2, 10, 0x1d00 },
   { PIPE_FORMAT_S8_UINT, 2, 1023, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 2, 1023, 1, 10, 0xe80 },
   { PIPE_FORMAT_S8_UINT, 2, 1023, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 2, 1023, 2, 10, 0x1d00 },
   { PIPE_FORMAT_S8_UINT, 2, 1024, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 2, 1024, 1, 11, 0xf00 },
   { PIPE_FORMAT_S8_UINT, 2, 1024, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 2, 1024, 2, 11, 0x1e00 },
   { PIPE_FORMAT_S8_UINT, 2, 1025, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 2, 1025, 1, 11, 0x1a80 },
   { PIPE_FORMAT_S8_UINT, 2, 1025, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 2, 1025, 2, 11, 0x3500 },
   { PIPE_FORMAT_S8_UINT, 2, 2047, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 2, 2047, 1, 11, 0x1a80 },
   { PIPE_FORMAT_S8_UINT, 2, 2047, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 2, 2047, 2, 11, 0x3500 },
   { PIPE_FORMAT_S8_UINT, 2, 2048, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 2, 2048, 1, 12, 0x1b00 },
   { PIPE_FORMAT_S8_UINT, 2, 2048, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 2, 2048, 2, 12, 0x3600 },
   { PIPE_FORMAT_S8_UINT, 2, 2049, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 2, 2049, 1, 12, 0x3280 },
   { PIPE_FORMAT_S8_UINT, 2, 2049, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 2, 2049, 2, 12, 0x6500 },
   { PIPE_FORMAT_S8_UINT, 2, 4095, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 2, 4095, 1, 12, 0x3280 },
   { PIPE_FORMAT_S8_UINT, 2, 4095, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 2, 4095, 2, 12, 0x6500 },
   { PIPE_FORMAT_S8_UINT, 2, 4096, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 2, 4096, 1, 13, 0x3300 },
   { PIPE_FORMAT_S8_UINT, 2, 4096, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 2, 4096, 2, 13, 0x6600 },
   { PIPE_FORMAT_S8_UINT, 2, 4097, 1, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 2, 4097, 1, 13, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 2, 4097, 2, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 2, 4097, 2, 13, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 4, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 4, 1, 1, 3, 0x180 },
   { PIPE_FORMAT_S8_UINT, 4, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 4, 1, 2, 3, 0x300 },
   { PIPE_FORMAT_S8_UINT, 4, 2, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 4, 2, 1, 3, 0x180 },
   { PIPE_FORMAT_S8_UINT, 4, 2, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 4, 2, 2, 3, 0x300 },
   { PIPE_FORMAT_S8_UINT, 4, 4, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 4, 4, 1, 3, 0x180 },
   { PIPE_FORMAT_S8_UINT, 4, 4, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 4, 4, 2, 3, 0x300 },
   { PIPE_FORMAT_S8_UINT, 4, 8, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 4, 8, 1, 4, 0x200 },
   { PIPE_FORMAT_S8_UINT, 4, 8, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 4, 8, 2, 4, 0x400 },
   { PIPE_FORMAT_S8_UINT, 4, 15, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 4, 15, 1, 4, 0x200 },
   { PIPE_FORMAT_S8_UINT, 4, 15, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 4, 15, 2, 4, 0x400 },
   { PIPE_FORMAT_S8_UINT, 4, 16, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 4, 16, 1, 5, 0x280 },
   { PIPE_FORMAT_S8_UINT, 4, 16, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 4, 16, 2, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 4, 17, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 4, 17, 1, 5, 0x280 },
   { PIPE_FORMAT_S8_UINT, 4, 17, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 4, 17, 2, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 4, 31, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 4, 31, 1, 5, 0x280 },
   { PIPE_FORMAT_S8_UINT, 4, 31, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 4, 31, 2, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 4, 32, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 4, 32, 1, 6, 0x300 },
   { PIPE_FORMAT_S8_UINT, 4, 32, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 4, 32, 2, 6, 0x600 },
   { PIPE_FORMAT_S8_UINT, 4, 33, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 4, 33, 1, 6, 0x380 },
   { PIPE_FORMAT_S8_UINT, 4, 33, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 4, 33, 2, 6, 0x700 },
   { PIPE_FORMAT_S8_UINT, 4, 63, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 4, 63, 1, 6, 0x380 },
   { PIPE_FORMAT_S8_UINT, 4, 63, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 4, 63, 2, 6, 0x700 },
   { PIPE_FORMAT_S8_UINT, 4, 64, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 4, 64, 1, 7, 0x400 },
   { PIPE_FORMAT_S8_UINT, 4, 64, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 4, 64, 2, 7, 0x800 },
   { PIPE_FORMAT_S8_UINT, 4, 65, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 4, 65, 1, 7, 0x500 },
   { PIPE_FORMAT_S8_UINT, 4, 65, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 4, 65, 2, 7, 0xa00 },
   { PIPE_FORMAT_S8_UINT, 4, 127, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 4, 127, 1, 7, 0x500 },
   { PIPE_FORMAT_S8_UINT, 4, 127, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 4, 127, 2, 7, 0xa00 },
   { PIPE_FORMAT_S8_UINT, 4, 128, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 4, 128, 1, 8, 0x580 },
   { PIPE_FORMAT_S8_UINT, 4, 128, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 4, 128, 2, 8, 0xb00 },
   { PIPE_FORMAT_S8_UINT, 4, 129, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 4, 129, 1, 8, 0x800 },
   { PIPE_FORMAT_S8_UINT, 4, 129, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 4, 129, 2, 8, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 4, 255, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 4, 255, 1, 8, 0x800 },
   { PIPE_FORMAT_S8_UINT, 4, 255, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 4, 255, 2, 8, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 4, 256, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 4, 256, 1, 9, 0x880 },
   { PIPE_FORMAT_S8_UINT, 4, 256, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 4, 256, 2, 9, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 4, 257, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 4, 257, 1, 9, 0xd80 },
   { PIPE_FORMAT_S8_UINT, 4, 257, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 4, 257, 2, 9, 0x1b00 },
   { PIPE_FORMAT_S8_UINT, 4, 511, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 4, 511, 1, 9, 0xd80 },
   { PIPE_FORMAT_S8_UINT, 4, 511, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 4, 511, 2, 9, 0x1b00 },
   { PIPE_FORMAT_S8_UINT, 4, 512, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 4, 512, 1, 10, 0xe00 },
   { PIPE_FORMAT_S8_UINT, 4, 512, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 4, 512, 2, 10, 0x1c00 },
   { PIPE_FORMAT_S8_UINT, 4, 513, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 4, 513, 1, 10, 0x1880 },
   { PIPE_FORMAT_S8_UINT, 4, 513, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 4, 513, 2, 10, 0x3100 },
   { PIPE_FORMAT_S8_UINT, 4, 1023, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 4, 1023, 1, 10, 0x1880 },
   { PIPE_FORMAT_S8_UINT, 4, 1023, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 4, 1023, 2, 10, 0x3100 },
   { PIPE_FORMAT_S8_UINT, 4, 1024, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 4, 1024, 1, 11, 0x1900 },
   { PIPE_FORMAT_S8_UINT, 4, 1024, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 4, 1024, 2, 11, 0x3200 },
   { PIPE_FORMAT_S8_UINT, 4, 1025, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 4, 1025, 1, 11, 0x2e80 },
   { PIPE_FORMAT_S8_UINT, 4, 1025, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 4, 1025, 2, 11, 0x5d00 },
   { PIPE_FORMAT_S8_UINT, 4, 2047, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 4, 2047, 1, 11, 0x2e80 },
   { PIPE_FORMAT_S8_UINT, 4, 2047, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 4, 2047, 2, 11, 0x5d00 },
   { PIPE_FORMAT_S8_UINT, 4, 2048, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 4, 2048, 1, 12, 0x2f00 },
   { PIPE_FORMAT_S8_UINT, 4, 2048, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 4, 2048, 2, 12, 0x5e00 },
   { PIPE_FORMAT_S8_UINT, 4, 2049, 1, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 4, 2049, 1, 12, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 4, 2049, 2, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 4, 2049, 2, 12, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 4, 4095, 1, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 4, 4095, 1, 12, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 4, 4095, 2, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 4, 4095, 2, 12, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 4, 4096, 1, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 4, 4096, 1, 13, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 4, 4096, 2, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 4, 4096, 2, 13, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 4, 4097, 1, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 4, 4097, 1, 13, 0xc000 },
   { PIPE_FORMAT_S8_UINT, 4, 4097, 2, 1, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 4, 4097, 2, 13, 0x18000 },
   { PIPE_FORMAT_S8_UINT, 8, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 8, 1, 1, 4, 0x200 },
   { PIPE_FORMAT_S8_UINT, 8, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 8, 1, 2, 4, 0x400 },
   { PIPE_FORMAT_S8_UINT, 8, 2, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 8, 2, 1, 4, 0x200 },
   { PIPE_FORMAT_S8_UINT, 8, 2, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 8, 2, 2, 4, 0x400 },
   { PIPE_FORMAT_S8_UINT, 8, 4, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 8, 4, 1, 4, 0x200 },
   { PIPE_FORMAT_S8_UINT, 8, 4, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 8, 4, 2, 4, 0x400 },
   { PIPE_FORMAT_S8_UINT, 8, 8, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 8, 8, 1, 4, 0x200 },
   { PIPE_FORMAT_S8_UINT, 8, 8, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 8, 8, 2, 4, 0x400 },
   { PIPE_FORMAT_S8_UINT, 8, 15, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 8, 15, 1, 4, 0x200 },
   { PIPE_FORMAT_S8_UINT, 8, 15, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 8, 15, 2, 4, 0x400 },
   { PIPE_FORMAT_S8_UINT, 8, 16, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 8, 16, 1, 5, 0x280 },
   { PIPE_FORMAT_S8_UINT, 8, 16, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 8, 16, 2, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 8, 17, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 8, 17, 1, 5, 0x300 },
   { PIPE_FORMAT_S8_UINT, 8, 17, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 8, 17, 2, 5, 0x600 },
   { PIPE_FORMAT_S8_UINT, 8, 31, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 8, 31, 1, 5, 0x300 },
   { PIPE_FORMAT_S8_UINT, 8, 31, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 8, 31, 2, 5, 0x600 },
   { PIPE_FORMAT_S8_UINT, 8, 32, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 8, 32, 1, 6, 0x380 },
   { PIPE_FORMAT_S8_UINT, 8, 32, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 8, 32, 2, 6, 0x700 },
   { PIPE_FORMAT_S8_UINT, 8, 33, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 8, 33, 1, 6, 0x480 },
   { PIPE_FORMAT_S8_UINT, 8, 33, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 8, 33, 2, 6, 0x900 },
   { PIPE_FORMAT_S8_UINT, 8, 63, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 8, 63, 1, 6, 0x480 },
   { PIPE_FORMAT_S8_UINT, 8, 63, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 8, 63, 2, 6, 0x900 },
   { PIPE_FORMAT_S8_UINT, 8, 64, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 8, 64, 1, 7, 0x500 },
   { PIPE_FORMAT_S8_UINT, 8, 64, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 8, 64, 2, 7, 0xa00 },
   { PIPE_FORMAT_S8_UINT, 8, 65, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 8, 65, 1, 7, 0x780 },
   { PIPE_FORMAT_S8_UINT, 8, 65, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 8, 65, 2, 7, 0xf00 },
   { PIPE_FORMAT_S8_UINT, 8, 127, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 8, 127, 1, 7, 0x780 },
   { PIPE_FORMAT_S8_UINT, 8, 127, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 8, 127, 2, 7, 0xf00 },
   { PIPE_FORMAT_S8_UINT, 8, 128, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 8, 128, 1, 8, 0x800 },
   { PIPE_FORMAT_S8_UINT, 8, 128, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 8, 128, 2, 8, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 8, 129, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 8, 129, 1, 8, 0xd00 },
   { PIPE_FORMAT_S8_UINT, 8, 129, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 8, 129, 2, 8, 0x1a00 },
   { PIPE_FORMAT_S8_UINT, 8, 255, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 8, 255, 1, 8, 0xd00 },
   { PIPE_FORMAT_S8_UINT, 8, 255, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 8, 255, 2, 8, 0x1a00 },
   { PIPE_FORMAT_S8_UINT, 8, 256, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 8, 256, 1, 9, 0xd80 },
   { PIPE_FORMAT_S8_UINT, 8, 256, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 8, 256, 2, 9, 0x1b00 },
   { PIPE_FORMAT_S8_UINT, 8, 257, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 8, 257, 1, 9, 0x1800 },
   { PIPE_FORMAT_S8_UINT, 8, 257, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 8, 257, 2, 9, 0x3000 },
   { PIPE_FORMAT_S8_UINT, 8, 511, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 8, 511, 1, 9, 0x1800 },
   { PIPE_FORMAT_S8_UINT, 8, 511, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 8, 511, 2, 9, 0x3000 },
   { PIPE_FORMAT_S8_UINT, 8, 512, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 8, 512, 1, 10, 0x1880 },
   { PIPE_FORMAT_S8_UINT, 8, 512, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 8, 512, 2, 10, 0x3100 },
   { PIPE_FORMAT_S8_UINT, 8, 513, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 8, 513, 1, 10, 0x2d80 },
   { PIPE_FORMAT_S8_UINT, 8, 513, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 8, 513, 2, 10, 0x5b00 },
   { PIPE_FORMAT_S8_UINT, 8, 1023, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 8, 1023, 1, 10, 0x2d80 },
   { PIPE_FORMAT_S8_UINT, 8, 1023, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 8, 1023, 2, 10, 0x5b00 },
   { PIPE_FORMAT_S8_UINT, 8, 1024, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 8, 1024, 1, 11, 0x2e00 },
   { PIPE_FORMAT_S8_UINT, 8, 1024, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 8, 1024, 2, 11, 0x5c00 },
   { PIPE_FORMAT_S8_UINT, 8, 1025, 1, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 8, 1025, 1, 11, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 8, 1025, 2, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 8, 1025, 2, 11, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 8, 2047, 1, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 8, 2047, 1, 11, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 8, 2047, 2, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 8, 2047, 2, 11, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 8, 2048, 1, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 8, 2048, 1, 12, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 8, 2048, 2, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 8, 2048, 2, 12, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 8, 2049, 1, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 8, 2049, 1, 12, 0xc000 },
   { PIPE_FORMAT_S8_UINT, 8, 2049, 2, 1, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 8, 2049, 2, 12, 0x18000 },
   { PIPE_FORMAT_S8_UINT, 8, 4095, 1, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 8, 4095, 1, 12, 0xc000 },
   { PIPE_FORMAT_S8_UINT, 8, 4095, 2, 1, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 8, 4095, 2, 12, 0x18000 },
   { PIPE_FORMAT_S8_UINT, 8, 4096, 1, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 8, 4096, 1, 13, 0xc000 },
   { PIPE_FORMAT_S8_UINT, 8, 4096, 2, 1, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 8, 4096, 2, 13, 0x18000 },
   { PIPE_FORMAT_S8_UINT, 8, 4097, 1, 1, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 8, 4097, 1, 13, 0x18000 },
   { PIPE_FORMAT_S8_UINT, 8, 4097, 2, 1, 0x20000 },
   { PIPE_FORMAT_S8_UINT, 8, 4097, 2, 13, 0x30000 },
   { PIPE_FORMAT_S8_UINT, 15, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 15, 1, 1, 4, 0x200 },
   { PIPE_FORMAT_S8_UINT, 15, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 15, 1, 2, 4, 0x400 },
   { PIPE_FORMAT_S8_UINT, 15, 2, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 15, 2, 1, 4, 0x200 },
   { PIPE_FORMAT_S8_UINT, 15, 2, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 15, 2, 2, 4, 0x400 },
   { PIPE_FORMAT_S8_UINT, 15, 4, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 15, 4, 1, 4, 0x200 },
   { PIPE_FORMAT_S8_UINT, 15, 4, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 15, 4, 2, 4, 0x400 },
   { PIPE_FORMAT_S8_UINT, 15, 8, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 15, 8, 1, 4, 0x200 },
   { PIPE_FORMAT_S8_UINT, 15, 8, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 15, 8, 2, 4, 0x400 },
   { PIPE_FORMAT_S8_UINT, 15, 15, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 15, 15, 1, 4, 0x280 },
   { PIPE_FORMAT_S8_UINT, 15, 15, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 15, 15, 2, 4, 0x500 },
   { PIPE_FORMAT_S8_UINT, 15, 16, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 15, 16, 1, 5, 0x300 },
   { PIPE_FORMAT_S8_UINT, 15, 16, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 15, 16, 2, 5, 0x600 },
   { PIPE_FORMAT_S8_UINT, 15, 17, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 15, 17, 1, 5, 0x400 },
   { PIPE_FORMAT_S8_UINT, 15, 17, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 15, 17, 2, 5, 0x800 },
   { PIPE_FORMAT_S8_UINT, 15, 31, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 15, 31, 1, 5, 0x400 },
   { PIPE_FORMAT_S8_UINT, 15, 31, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 15, 31, 2, 5, 0x800 },
   { PIPE_FORMAT_S8_UINT, 15, 32, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 15, 32, 1, 6, 0x480 },
   { PIPE_FORMAT_S8_UINT, 15, 32, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 15, 32, 2, 6, 0x900 },
   { PIPE_FORMAT_S8_UINT, 15, 33, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 15, 33, 1, 6, 0x700 },
   { PIPE_FORMAT_S8_UINT, 15, 33, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 15, 33, 2, 6, 0xe00 },
   { PIPE_FORMAT_S8_UINT, 15, 63, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 15, 63, 1, 6, 0x700 },
   { PIPE_FORMAT_S8_UINT, 15, 63, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 15, 63, 2, 6, 0xe00 },
   { PIPE_FORMAT_S8_UINT, 15, 64, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 15, 64, 1, 7, 0x780 },
   { PIPE_FORMAT_S8_UINT, 15, 64, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 15, 64, 2, 7, 0xf00 },
   { PIPE_FORMAT_S8_UINT, 15, 65, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 15, 65, 1, 7, 0xc80 },
   { PIPE_FORMAT_S8_UINT, 15, 65, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 15, 65, 2, 7, 0x1900 },
   { PIPE_FORMAT_S8_UINT, 15, 127, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 15, 127, 1, 7, 0xc80 },
   { PIPE_FORMAT_S8_UINT, 15, 127, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 15, 127, 2, 7, 0x1900 },
   { PIPE_FORMAT_S8_UINT, 15, 128, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 15, 128, 1, 8, 0xd00 },
   { PIPE_FORMAT_S8_UINT, 15, 128, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 15, 128, 2, 8, 0x1a00 },
   { PIPE_FORMAT_S8_UINT, 15, 129, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 15, 129, 1, 8, 0x1780 },
   { PIPE_FORMAT_S8_UINT, 15, 129, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 15, 129, 2, 8, 0x2f00 },
   { PIPE_FORMAT_S8_UINT, 15, 255, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 15, 255, 1, 8, 0x1780 },
   { PIPE_FORMAT_S8_UINT, 15, 255, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 15, 255, 2, 8, 0x2f00 },
   { PIPE_FORMAT_S8_UINT, 15, 256, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 15, 256, 1, 9, 0x1800 },
   { PIPE_FORMAT_S8_UINT, 15, 256, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 15, 256, 2, 9, 0x3000 },
   { PIPE_FORMAT_S8_UINT, 15, 257, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 15, 257, 1, 9, 0x2d00 },
   { PIPE_FORMAT_S8_UINT, 15, 257, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 15, 257, 2, 9, 0x5a00 },
   { PIPE_FORMAT_S8_UINT, 15, 511, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 15, 511, 1, 9, 0x2d00 },
   { PIPE_FORMAT_S8_UINT, 15, 511, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 15, 511, 2, 9, 0x5a00 },
   { PIPE_FORMAT_S8_UINT, 15, 512, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 15, 512, 1, 10, 0x2d80 },
   { PIPE_FORMAT_S8_UINT, 15, 512, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 15, 512, 2, 10, 0x5b00 },
   { PIPE_FORMAT_S8_UINT, 15, 513, 1, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 15, 513, 1, 10, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 15, 513, 2, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 15, 513, 2, 10, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 15, 1023, 1, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 15, 1023, 1, 10, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 15, 1023, 2, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 15, 1023, 2, 10, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 15, 1024, 1, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 15, 1024, 1, 11, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 15, 1024, 2, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 15, 1024, 2, 11, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 15, 1025, 1, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 15, 1025, 1, 11, 0xc000 },
   { PIPE_FORMAT_S8_UINT, 15, 1025, 2, 1, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 15, 1025, 2, 11, 0x18000 },
   { PIPE_FORMAT_S8_UINT, 15, 2047, 1, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 15, 2047, 1, 11, 0xc000 },
   { PIPE_FORMAT_S8_UINT, 15, 2047, 2, 1, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 15, 2047, 2, 11, 0x18000 },
   { PIPE_FORMAT_S8_UINT, 15, 2048, 1, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 15, 2048, 1, 12, 0xc000 },
   { PIPE_FORMAT_S8_UINT, 15, 2048, 2, 1, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 15, 2048, 2, 12, 0x18000 },
   { PIPE_FORMAT_S8_UINT, 15, 2049, 1, 1, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 15, 2049, 1, 12, 0x18000 },
   { PIPE_FORMAT_S8_UINT, 15, 2049, 2, 1, 0x20000 },
   { PIPE_FORMAT_S8_UINT, 15, 2049, 2, 12, 0x30000 },
   { PIPE_FORMAT_S8_UINT, 15, 4095, 1, 1, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 15, 4095, 1, 12, 0x18000 },
   { PIPE_FORMAT_S8_UINT, 15, 4095, 2, 1, 0x20000 },
   { PIPE_FORMAT_S8_UINT, 15, 4095, 2, 12, 0x30000 },
   { PIPE_FORMAT_S8_UINT, 15, 4096, 1, 1, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 15, 4096, 1, 13, 0x18000 },
   { PIPE_FORMAT_S8_UINT, 15, 4096, 2, 1, 0x20000 },
   { PIPE_FORMAT_S8_UINT, 15, 4096, 2, 13, 0x30000 },
   { PIPE_FORMAT_S8_UINT, 15, 4097, 1, 1, 0x20000 },
   { PIPE_FORMAT_S8_UINT, 15, 4097, 1, 13, 0x2c000 },
   { PIPE_FORMAT_S8_UINT, 15, 4097, 2, 1, 0x40000 },
   { PIPE_FORMAT_S8_UINT, 15, 4097, 2, 13, 0x58000 },
   { PIPE_FORMAT_S8_UINT, 16, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 16, 1, 1, 5, 0x280 },
   { PIPE_FORMAT_S8_UINT, 16, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 16, 1, 2, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 16, 2, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 16, 2, 1, 5, 0x280 },
   { PIPE_FORMAT_S8_UINT, 16, 2, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 16, 2, 2, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 16, 4, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 16, 4, 1, 5, 0x280 },
   { PIPE_FORMAT_S8_UINT, 16, 4, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 16, 4, 2, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 16, 8, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 16, 8, 1, 5, 0x280 },
   { PIPE_FORMAT_S8_UINT, 16, 8, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 16, 8, 2, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 16, 15, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 16, 15, 1, 5, 0x300 },
   { PIPE_FORMAT_S8_UINT, 16, 15, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 16, 15, 2, 5, 0x600 },
   { PIPE_FORMAT_S8_UINT, 17, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 17, 1, 1, 5, 0x280 },
   { PIPE_FORMAT_S8_UINT, 17, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 17, 1, 2, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 17, 2, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 17, 2, 1, 5, 0x280 },
   { PIPE_FORMAT_S8_UINT, 17, 2, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 17, 2, 2, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 17, 4, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 17, 4, 1, 5, 0x280 },
   { PIPE_FORMAT_S8_UINT, 17, 4, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 17, 4, 2, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 17, 8, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 17, 8, 1, 5, 0x300 },
   { PIPE_FORMAT_S8_UINT, 17, 8, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 17, 8, 2, 5, 0x600 },
   { PIPE_FORMAT_S8_UINT, 17, 15, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 17, 15, 1, 5, 0x400 },
   { PIPE_FORMAT_S8_UINT, 17, 15, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 17, 15, 2, 5, 0x800 },
   { PIPE_FORMAT_S8_UINT, 31, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 31, 1, 1, 5, 0x280 },
   { PIPE_FORMAT_S8_UINT, 31, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 31, 1, 2, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 31, 2, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 31, 2, 1, 5, 0x280 },
   { PIPE_FORMAT_S8_UINT, 31, 2, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 31, 2, 2, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 31, 4, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 31, 4, 1, 5, 0x280 },
   { PIPE_FORMAT_S8_UINT, 31, 4, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 31, 4, 2, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 31, 8, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 31, 8, 1, 5, 0x300 },
   { PIPE_FORMAT_S8_UINT, 31, 8, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 31, 8, 2, 5, 0x600 },
   { PIPE_FORMAT_S8_UINT, 31, 15, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 31, 15, 1, 5, 0x400 },
   { PIPE_FORMAT_S8_UINT, 31, 15, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 31, 15, 2, 5, 0x800 },
   { PIPE_FORMAT_S8_UINT, 32, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 32, 1, 1, 6, 0x300 },
   { PIPE_FORMAT_S8_UINT, 32, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 32, 1, 2, 6, 0x600 },
   { PIPE_FORMAT_S8_UINT, 32, 2, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 32, 2, 1, 6, 0x300 },
   { PIPE_FORMAT_S8_UINT, 32, 2, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 32, 2, 2, 6, 0x600 },
   { PIPE_FORMAT_S8_UINT, 32, 4, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 32, 4, 1, 6, 0x300 },
   { PIPE_FORMAT_S8_UINT, 32, 4, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 32, 4, 2, 6, 0x600 },
   { PIPE_FORMAT_S8_UINT, 32, 8, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 32, 8, 1, 6, 0x380 },
   { PIPE_FORMAT_S8_UINT, 32, 8, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 32, 8, 2, 6, 0x700 },
   { PIPE_FORMAT_S8_UINT, 32, 15, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 32, 15, 1, 6, 0x480 },
   { PIPE_FORMAT_S8_UINT, 32, 15, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 32, 15, 2, 6, 0x900 },
   { PIPE_FORMAT_S8_UINT, 33, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 33, 1, 1, 6, 0x300 },
   { PIPE_FORMAT_S8_UINT, 33, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 33, 1, 2, 6, 0x600 },
   { PIPE_FORMAT_S8_UINT, 33, 2, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 33, 2, 1, 6, 0x300 },
   { PIPE_FORMAT_S8_UINT, 33, 2, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 33, 2, 2, 6, 0x600 },
   { PIPE_FORMAT_S8_UINT, 33, 4, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 33, 4, 1, 6, 0x380 },
   { PIPE_FORMAT_S8_UINT, 33, 4, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 33, 4, 2, 6, 0x700 },
   { PIPE_FORMAT_S8_UINT, 33, 8, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 33, 8, 1, 6, 0x480 },
   { PIPE_FORMAT_S8_UINT, 33, 8, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 33, 8, 2, 6, 0x900 },
   { PIPE_FORMAT_S8_UINT, 33, 15, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 33, 15, 1, 6, 0x700 },
   { PIPE_FORMAT_S8_UINT, 33, 15, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 33, 15, 2, 6, 0xe00 },
   { PIPE_FORMAT_S8_UINT, 63, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 63, 1, 1, 6, 0x300 },
   { PIPE_FORMAT_S8_UINT, 63, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 63, 1, 2, 6, 0x600 },
   { PIPE_FORMAT_S8_UINT, 63, 2, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 63, 2, 1, 6, 0x300 },
   { PIPE_FORMAT_S8_UINT, 63, 2, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 63, 2, 2, 6, 0x600 },
   { PIPE_FORMAT_S8_UINT, 63, 4, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 63, 4, 1, 6, 0x380 },
   { PIPE_FORMAT_S8_UINT, 63, 4, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 63, 4, 2, 6, 0x700 },
   { PIPE_FORMAT_S8_UINT, 63, 8, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 63, 8, 1, 6, 0x480 },
   { PIPE_FORMAT_S8_UINT, 63, 8, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 63, 8, 2, 6, 0x900 },
   { PIPE_FORMAT_S8_UINT, 63, 15, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 63, 15, 1, 6, 0x700 },
   { PIPE_FORMAT_S8_UINT, 63, 15, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 63, 15, 2, 6, 0xe00 },
   { PIPE_FORMAT_S8_UINT, 64, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 64, 1, 1, 7, 0x380 },
   { PIPE_FORMAT_S8_UINT, 64, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 64, 1, 2, 7, 0x700 },
   { PIPE_FORMAT_S8_UINT, 64, 2, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 64, 2, 1, 7, 0x380 },
   { PIPE_FORMAT_S8_UINT, 64, 2, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 64, 2, 2, 7, 0x700 },
   { PIPE_FORMAT_S8_UINT, 64, 4, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 64, 4, 1, 7, 0x400 },
   { PIPE_FORMAT_S8_UINT, 64, 4, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 64, 4, 2, 7, 0x800 },
   { PIPE_FORMAT_S8_UINT, 64, 8, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 64, 8, 1, 7, 0x500 },
   { PIPE_FORMAT_S8_UINT, 64, 8, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 64, 8, 2, 7, 0xa00 },
   { PIPE_FORMAT_S8_UINT, 64, 15, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 64, 15, 1, 7, 0x780 },
   { PIPE_FORMAT_S8_UINT, 64, 15, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 64, 15, 2, 7, 0xf00 },
   { PIPE_FORMAT_S8_UINT, 65, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 65, 1, 1, 7, 0x380 },
   { PIPE_FORMAT_S8_UINT, 65, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 65, 1, 2, 7, 0x700 },
   { PIPE_FORMAT_S8_UINT, 65, 2, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 65, 2, 1, 7, 0x400 },
   { PIPE_FORMAT_S8_UINT, 65, 2, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 65, 2, 2, 7, 0x800 },
   { PIPE_FORMAT_S8_UINT, 65, 4, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 65, 4, 1, 7, 0x500 },
   { PIPE_FORMAT_S8_UINT, 65, 4, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 65, 4, 2, 7, 0xa00 },
   { PIPE_FORMAT_S8_UINT, 65, 8, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 65, 8, 1, 7, 0x780 },
   { PIPE_FORMAT_S8_UINT, 65, 8, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 65, 8, 2, 7, 0xf00 },
   { PIPE_FORMAT_S8_UINT, 65, 15, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 65, 15, 1, 7, 0xc80 },
   { PIPE_FORMAT_S8_UINT, 65, 15, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 65, 15, 2, 7, 0x1900 },
   { PIPE_FORMAT_S8_UINT, 127, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 127, 1, 1, 7, 0x380 },
   { PIPE_FORMAT_S8_UINT, 127, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 127, 1, 2, 7, 0x700 },
   { PIPE_FORMAT_S8_UINT, 127, 2, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 127, 2, 1, 7, 0x400 },
   { PIPE_FORMAT_S8_UINT, 127, 2, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 127, 2, 2, 7, 0x800 },
   { PIPE_FORMAT_S8_UINT, 127, 4, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 127, 4, 1, 7, 0x500 },
   { PIPE_FORMAT_S8_UINT, 127, 4, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 127, 4, 2, 7, 0xa00 },
   { PIPE_FORMAT_S8_UINT, 127, 8, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 127, 8, 1, 7, 0x780 },
   { PIPE_FORMAT_S8_UINT, 127, 8, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 127, 8, 2, 7, 0xf00 },
   { PIPE_FORMAT_S8_UINT, 127, 15, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 127, 15, 1, 7, 0xc80 },
   { PIPE_FORMAT_S8_UINT, 127, 15, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 127, 15, 2, 7, 0x1900 },
   { PIPE_FORMAT_S8_UINT, 128, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_S8_UINT, 128, 1, 1, 8, 0x400 },
   { PIPE_FORMAT_S8_UINT, 128, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 128, 1, 2, 8, 0x800 },
   { PIPE_FORMAT_S8_UINT, 128, 2, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 128, 2, 1, 8, 0x480 },
   { PIPE_FORMAT_S8_UINT, 128, 2, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 128, 2, 2, 8, 0x900 },
   { PIPE_FORMAT_S8_UINT, 128, 4, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 128, 4, 1, 8, 0x580 },
   { PIPE_FORMAT_S8_UINT, 128, 4, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 128, 4, 2, 8, 0xb00 },
   { PIPE_FORMAT_S8_UINT, 128, 8, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 128, 8, 1, 8, 0x800 },
   { PIPE_FORMAT_S8_UINT, 128, 8, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 128, 8, 2, 8, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 128, 15, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 128, 15, 1, 8, 0xd00 },
   { PIPE_FORMAT_S8_UINT, 128, 15, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 128, 15, 2, 8, 0x1a00 },
   { PIPE_FORMAT_S8_UINT, 129, 1, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 129, 1, 1, 8, 0x480 },
   { PIPE_FORMAT_S8_UINT, 129, 1, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 129, 1, 2, 8, 0x900 },
   { PIPE_FORMAT_S8_UINT, 129, 2, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 129, 2, 1, 8, 0x580 },
   { PIPE_FORMAT_S8_UINT, 129, 2, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 129, 2, 2, 8, 0xb00 },
   { PIPE_FORMAT_S8_UINT, 129, 4, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 129, 4, 1, 8, 0x800 },
   { PIPE_FORMAT_S8_UINT, 129, 4, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 129, 4, 2, 8, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 129, 8, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 129, 8, 1, 8, 0xd00 },
   { PIPE_FORMAT_S8_UINT, 129, 8, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 129, 8, 2, 8, 0x1a00 },
   { PIPE_FORMAT_S8_UINT, 129, 15, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 129, 15, 1, 8, 0x1780 },
   { PIPE_FORMAT_S8_UINT, 129, 15, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 129, 15, 2, 8, 0x2f00 },
   { PIPE_FORMAT_S8_UINT, 255, 1, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 255, 1, 1, 8, 0x480 },
   { PIPE_FORMAT_S8_UINT, 255, 1, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 255, 1, 2, 8, 0x900 },
   { PIPE_FORMAT_S8_UINT, 255, 2, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 255, 2, 1, 8, 0x580 },
   { PIPE_FORMAT_S8_UINT, 255, 2, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 255, 2, 2, 8, 0xb00 },
   { PIPE_FORMAT_S8_UINT, 255, 4, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 255, 4, 1, 8, 0x800 },
   { PIPE_FORMAT_S8_UINT, 255, 4, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 255, 4, 2, 8, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 255, 8, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 255, 8, 1, 8, 0xd00 },
   { PIPE_FORMAT_S8_UINT, 255, 8, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 255, 8, 2, 8, 0x1a00 },
   { PIPE_FORMAT_S8_UINT, 255, 15, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 255, 15, 1, 8, 0x1780 },
   { PIPE_FORMAT_S8_UINT, 255, 15, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 255, 15, 2, 8, 0x2f00 },
   { PIPE_FORMAT_S8_UINT, 256, 1, 1, 1, 0x100 },
   { PIPE_FORMAT_S8_UINT, 256, 1, 1, 9, 0x500 },
   { PIPE_FORMAT_S8_UINT, 256, 1, 2, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 256, 1, 2, 9, 0xa00 },
   { PIPE_FORMAT_S8_UINT, 256, 2, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 256, 2, 1, 9, 0x600 },
   { PIPE_FORMAT_S8_UINT, 256, 2, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 256, 2, 2, 9, 0xc00 },
   { PIPE_FORMAT_S8_UINT, 256, 4, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 256, 4, 1, 9, 0x880 },
   { PIPE_FORMAT_S8_UINT, 256, 4, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 256, 4, 2, 9, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 256, 8, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 256, 8, 1, 9, 0xd80 },
   { PIPE_FORMAT_S8_UINT, 256, 8, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 256, 8, 2, 9, 0x1b00 },
   { PIPE_FORMAT_S8_UINT, 256, 15, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 256, 15, 1, 9, 0x1800 },
   { PIPE_FORMAT_S8_UINT, 256, 15, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 256, 15, 2, 9, 0x3000 },
   { PIPE_FORMAT_S8_UINT, 257, 1, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 257, 1, 1, 9, 0x680 },
   { PIPE_FORMAT_S8_UINT, 257, 1, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 257, 1, 2, 9, 0xd00 },
   { PIPE_FORMAT_S8_UINT, 257, 2, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 257, 2, 1, 9, 0x880 },
   { PIPE_FORMAT_S8_UINT, 257, 2, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 257, 2, 2, 9, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 257, 4, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 257, 4, 1, 9, 0xd80 },
   { PIPE_FORMAT_S8_UINT, 257, 4, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 257, 4, 2, 9, 0x1b00 },
   { PIPE_FORMAT_S8_UINT, 257, 8, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 257, 8, 1, 9, 0x1800 },
   { PIPE_FORMAT_S8_UINT, 257, 8, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 257, 8, 2, 9, 0x3000 },
   { PIPE_FORMAT_S8_UINT, 257, 15, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 257, 15, 1, 9, 0x2d00 },
   { PIPE_FORMAT_S8_UINT, 257, 15, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 257, 15, 2, 9, 0x5a00 },
   { PIPE_FORMAT_S8_UINT, 511, 1, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 511, 1, 1, 9, 0x680 },
   { PIPE_FORMAT_S8_UINT, 511, 1, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 511, 1, 2, 9, 0xd00 },
   { PIPE_FORMAT_S8_UINT, 511, 2, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 511, 2, 1, 9, 0x880 },
   { PIPE_FORMAT_S8_UINT, 511, 2, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 511, 2, 2, 9, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 511, 4, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 511, 4, 1, 9, 0xd80 },
   { PIPE_FORMAT_S8_UINT, 511, 4, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 511, 4, 2, 9, 0x1b00 },
   { PIPE_FORMAT_S8_UINT, 511, 8, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 511, 8, 1, 9, 0x1800 },
   { PIPE_FORMAT_S8_UINT, 511, 8, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 511, 8, 2, 9, 0x3000 },
   { PIPE_FORMAT_S8_UINT, 511, 15, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 511, 15, 1, 9, 0x2d00 },
   { PIPE_FORMAT_S8_UINT, 511, 15, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 511, 15, 2, 9, 0x5a00 },
   { PIPE_FORMAT_S8_UINT, 512, 1, 1, 1, 0x200 },
   { PIPE_FORMAT_S8_UINT, 512, 1, 1, 10, 0x700 },
   { PIPE_FORMAT_S8_UINT, 512, 1, 2, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 512, 1, 2, 10, 0xe00 },
   { PIPE_FORMAT_S8_UINT, 512, 2, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 512, 2, 1, 10, 0x900 },
   { PIPE_FORMAT_S8_UINT, 512, 2, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 512, 2, 2, 10, 0x1200 },
   { PIPE_FORMAT_S8_UINT, 512, 4, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 512, 4, 1, 10, 0xe00 },
   { PIPE_FORMAT_S8_UINT, 512, 4, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 512, 4, 2, 10, 0x1c00 },
   { PIPE_FORMAT_S8_UINT, 512, 8, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 512, 8, 1, 10, 0x1880 },
   { PIPE_FORMAT_S8_UINT, 512, 8, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 512, 8, 2, 10, 0x3100 },
   { PIPE_FORMAT_S8_UINT, 512, 15, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 512, 15, 1, 10, 0x2d80 },
   { PIPE_FORMAT_S8_UINT, 512, 15, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 512, 15, 2, 10, 0x5b00 },
   { PIPE_FORMAT_S8_UINT, 513, 1, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 513, 1, 1, 10, 0xa80 },
   { PIPE_FORMAT_S8_UINT, 513, 1, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 513, 1, 2, 10, 0x1500 },
   { PIPE_FORMAT_S8_UINT, 513, 2, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 513, 2, 1, 10, 0xe80 },
   { PIPE_FORMAT_S8_UINT, 513, 2, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 513, 2, 2, 10, 0x1d00 },
   { PIPE_FORMAT_S8_UINT, 513, 4, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 513, 4, 1, 10, 0x1880 },
   { PIPE_FORMAT_S8_UINT, 513, 4, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 513, 4, 2, 10, 0x3100 },
   { PIPE_FORMAT_S8_UINT, 513, 8, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 513, 8, 1, 10, 0x2d80 },
   { PIPE_FORMAT_S8_UINT, 513, 8, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 513, 8, 2, 10, 0x5b00 },
   { PIPE_FORMAT_S8_UINT, 513, 15, 1, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 513, 15, 1, 10, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 513, 15, 2, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 513, 15, 2, 10, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 1023, 1, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 1023, 1, 1, 10, 0xa80 },
   { PIPE_FORMAT_S8_UINT, 1023, 1, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 1023, 1, 2, 10, 0x1500 },
   { PIPE_FORMAT_S8_UINT, 1023, 2, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 1023, 2, 1, 10, 0xe80 },
   { PIPE_FORMAT_S8_UINT, 1023, 2, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 1023, 2, 2, 10, 0x1d00 },
   { PIPE_FORMAT_S8_UINT, 1023, 4, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 1023, 4, 1, 10, 0x1880 },
   { PIPE_FORMAT_S8_UINT, 1023, 4, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 1023, 4, 2, 10, 0x3100 },
   { PIPE_FORMAT_S8_UINT, 1023, 8, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 1023, 8, 1, 10, 0x2d80 },
   { PIPE_FORMAT_S8_UINT, 1023, 8, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 1023, 8, 2, 10, 0x5b00 },
   { PIPE_FORMAT_S8_UINT, 1023, 15, 1, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 1023, 15, 1, 10, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 1023, 15, 2, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 1023, 15, 2, 10, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 1024, 1, 1, 1, 0x400 },
   { PIPE_FORMAT_S8_UINT, 1024, 1, 1, 11, 0xb00 },
   { PIPE_FORMAT_S8_UINT, 1024, 1, 2, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 1024, 1, 2, 11, 0x1600 },
   { PIPE_FORMAT_S8_UINT, 1024, 2, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 1024, 2, 1, 11, 0xf00 },
   { PIPE_FORMAT_S8_UINT, 1024, 2, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 1024, 2, 2, 11, 0x1e00 },
   { PIPE_FORMAT_S8_UINT, 1024, 4, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 1024, 4, 1, 11, 0x1900 },
   { PIPE_FORMAT_S8_UINT, 1024, 4, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 1024, 4, 2, 11, 0x3200 },
   { PIPE_FORMAT_S8_UINT, 1024, 8, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 1024, 8, 1, 11, 0x2e00 },
   { PIPE_FORMAT_S8_UINT, 1024, 8, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 1024, 8, 2, 11, 0x5c00 },
   { PIPE_FORMAT_S8_UINT, 1024, 15, 1, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 1024, 15, 1, 11, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 1024, 15, 2, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 1024, 15, 2, 11, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 1025, 1, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 1025, 1, 1, 11, 0x1280 },
   { PIPE_FORMAT_S8_UINT, 1025, 1, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 1025, 1, 2, 11, 0x2500 },
   { PIPE_FORMAT_S8_UINT, 1025, 2, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 1025, 2, 1, 11, 0x1a80 },
   { PIPE_FORMAT_S8_UINT, 1025, 2, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 1025, 2, 2, 11, 0x3500 },
   { PIPE_FORMAT_S8_UINT, 1025, 4, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 1025, 4, 1, 11, 0x2e80 },
   { PIPE_FORMAT_S8_UINT, 1025, 4, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 1025, 4, 2, 11, 0x5d00 },
   { PIPE_FORMAT_S8_UINT, 1025, 8, 1, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 1025, 8, 1, 11, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 1025, 8, 2, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 1025, 8, 2, 11, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 1025, 15, 1, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 1025, 15, 1, 11, 0xc000 },
   { PIPE_FORMAT_S8_UINT, 1025, 15, 2, 1, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 1025, 15, 2, 11, 0x18000 },
   { PIPE_FORMAT_S8_UINT, 2047, 1, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 2047, 1, 1, 11, 0x1280 },
   { PIPE_FORMAT_S8_UINT, 2047, 1, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 2047, 1, 2, 11, 0x2500 },
   { PIPE_FORMAT_S8_UINT, 2047, 2, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 2047, 2, 1, 11, 0x1a80 },
   { PIPE_FORMAT_S8_UINT, 2047, 2, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 2047, 2, 2, 11, 0x3500 },
   { PIPE_FORMAT_S8_UINT, 2047, 4, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 2047, 4, 1, 11, 0x2e80 },
   { PIPE_FORMAT_S8_UINT, 2047, 4, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 2047, 4, 2, 11, 0x5d00 },
   { PIPE_FORMAT_S8_UINT, 2047, 8, 1, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 2047, 8, 1, 11, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 2047, 8, 2, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 2047, 8, 2, 11, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 2047, 15, 1, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 2047, 15, 1, 11, 0xc000 },
   { PIPE_FORMAT_S8_UINT, 2047, 15, 2, 1, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 2047, 15, 2, 11, 0x18000 },
   { PIPE_FORMAT_S8_UINT, 2048, 1, 1, 1, 0x800 },
   { PIPE_FORMAT_S8_UINT, 2048, 1, 1, 12, 0x1300 },
   { PIPE_FORMAT_S8_UINT, 2048, 1, 2, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 2048, 1, 2, 12, 0x2600 },
   { PIPE_FORMAT_S8_UINT, 2048, 2, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 2048, 2, 1, 12, 0x1b00 },
   { PIPE_FORMAT_S8_UINT, 2048, 2, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 2048, 2, 2, 12, 0x3600 },
   { PIPE_FORMAT_S8_UINT, 2048, 4, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 2048, 4, 1, 12, 0x2f00 },
   { PIPE_FORMAT_S8_UINT, 2048, 4, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 2048, 4, 2, 12, 0x5e00 },
   { PIPE_FORMAT_S8_UINT, 2048, 8, 1, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 2048, 8, 1, 12, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 2048, 8, 2, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 2048, 8, 2, 12, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 2048, 15, 1, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 2048, 15, 1, 12, 0xc000 },
   { PIPE_FORMAT_S8_UINT, 2048, 15, 2, 1, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 2048, 15, 2, 12, 0x18000 },
   { PIPE_FORMAT_S8_UINT, 2049, 1, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 2049, 1, 1, 12, 0x2280 },
   { PIPE_FORMAT_S8_UINT, 2049, 1, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 2049, 1, 2, 12, 0x4500 },
   { PIPE_FORMAT_S8_UINT, 2049, 2, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 2049, 2, 1, 12, 0x3280 },
   { PIPE_FORMAT_S8_UINT, 2049, 2, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 2049, 2, 2, 12, 0x6500 },
   { PIPE_FORMAT_S8_UINT, 2049, 4, 1, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 2049, 4, 1, 12, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 2049, 4, 2, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 2049, 4, 2, 12, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 2049, 8, 1, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 2049, 8, 1, 12, 0xc000 },
   { PIPE_FORMAT_S8_UINT, 2049, 8, 2, 1, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 2049, 8, 2, 12, 0x18000 },
   { PIPE_FORMAT_S8_UINT, 2049, 15, 1, 1, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 2049, 15, 1, 12, 0x18000 },
   { PIPE_FORMAT_S8_UINT, 2049, 15, 2, 1, 0x20000 },
   { PIPE_FORMAT_S8_UINT, 2049, 15, 2, 12, 0x30000 },
   { PIPE_FORMAT_S8_UINT, 4095, 1, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 4095, 1, 1, 12, 0x2280 },
   { PIPE_FORMAT_S8_UINT, 4095, 1, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 4095, 1, 2, 12, 0x4500 },
   { PIPE_FORMAT_S8_UINT, 4095, 2, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 4095, 2, 1, 12, 0x3280 },
   { PIPE_FORMAT_S8_UINT, 4095, 2, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 4095, 2, 2, 12, 0x6500 },
   { PIPE_FORMAT_S8_UINT, 4095, 4, 1, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 4095, 4, 1, 12, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 4095, 4, 2, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 4095, 4, 2, 12, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 4095, 8, 1, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 4095, 8, 1, 12, 0xc000 },
   { PIPE_FORMAT_S8_UINT, 4095, 8, 2, 1, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 4095, 8, 2, 12, 0x18000 },
   { PIPE_FORMAT_S8_UINT, 4095, 15, 1, 1, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 4095, 15, 1, 12, 0x18000 },
   { PIPE_FORMAT_S8_UINT, 4095, 15, 2, 1, 0x20000 },
   { PIPE_FORMAT_S8_UINT, 4095, 15, 2, 12, 0x30000 },
   { PIPE_FORMAT_S8_UINT, 4096, 1, 1, 1, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 4096, 1, 1, 13, 0x2300 },
   { PIPE_FORMAT_S8_UINT, 4096, 1, 2, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 4096, 1, 2, 13, 0x4600 },
   { PIPE_FORMAT_S8_UINT, 4096, 2, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 4096, 2, 1, 13, 0x3300 },
   { PIPE_FORMAT_S8_UINT, 4096, 2, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 4096, 2, 2, 13, 0x6600 },
   { PIPE_FORMAT_S8_UINT, 4096, 4, 1, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 4096, 4, 1, 13, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 4096, 4, 2, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 4096, 4, 2, 13, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 4096, 8, 1, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 4096, 8, 1, 13, 0xc000 },
   { PIPE_FORMAT_S8_UINT, 4096, 8, 2, 1, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 4096, 8, 2, 13, 0x18000 },
   { PIPE_FORMAT_S8_UINT, 4096, 15, 1, 1, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 4096, 15, 1, 13, 0x18000 },
   { PIPE_FORMAT_S8_UINT, 4096, 15, 2, 1, 0x20000 },
   { PIPE_FORMAT_S8_UINT, 4096, 15, 2, 13, 0x30000 },
   { PIPE_FORMAT_S8_UINT, 4097, 1, 1, 1, 0x2000 },
   { PIPE_FORMAT_S8_UINT, 4097, 1, 1, 13, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 4097, 1, 2, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 4097, 1, 2, 13, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 4097, 2, 1, 1, 0x4000 },
   { PIPE_FORMAT_S8_UINT, 4097, 2, 1, 13, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 4097, 2, 2, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 4097, 2, 2, 13, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 4097, 4, 1, 1, 0x8000 },
   { PIPE_FORMAT_S8_UINT, 4097, 4, 1, 13, 0xc000 },
   { PIPE_FORMAT_S8_UINT, 4097, 4, 2, 1, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 4097, 4, 2, 13, 0x18000 },
   { PIPE_FORMAT_S8_UINT, 4097, 8, 1, 1, 0x10000 },
   { PIPE_FORMAT_S8_UINT, 4097, 8, 1, 13, 0x18000 },
   { PIPE_FORMAT_S8_UINT, 4097, 8, 2, 1, 0x20000 },
   { PIPE_FORMAT_S8_UINT, 4097, 8, 2, 13, 0x30000 },
   { PIPE_FORMAT_S8_UINT, 4097, 15, 1, 1, 0x20000 },
   { PIPE_FORMAT_S8_UINT, 4097, 15, 1, 13, 0x2c000 },
   { PIPE_FORMAT_S8_UINT, 4097, 15, 2, 1, 0x40000 },
   { PIPE_FORMAT_S8_UINT, 4097, 15, 2, 13, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 2, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 2, 1, 2, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 2, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 2, 2, 2, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 3, 1, 2, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 3, 2, 2, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 4, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 4, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 4, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 4, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 5, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 5, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 7, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 7, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 8, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 8, 1, 4, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 8, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 8, 2, 4, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 9, 1, 4, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 9, 2, 4, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 15, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 15, 1, 4, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 15, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 15, 2, 4, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 16, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 16, 1, 5, 0x280 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 16, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 16, 2, 5, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 17, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 17, 1, 5, 0x280 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 17, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 17, 2, 5, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 31, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 31, 1, 5, 0x280 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 31, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 31, 2, 5, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 32, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 32, 1, 6, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 32, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 32, 2, 6, 0x600 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 33, 1, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 33, 1, 6, 0x380 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 33, 2, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 33, 2, 6, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 63, 1, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 63, 1, 6, 0x380 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 63, 2, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 63, 2, 6, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 64, 1, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 64, 1, 7, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 64, 2, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 64, 2, 7, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 65, 1, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 65, 1, 7, 0x580 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 65, 2, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 65, 2, 7, 0xb00 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 127, 1, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 127, 1, 7, 0x580 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 127, 2, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 127, 2, 7, 0xb00 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 128, 1, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 128, 1, 8, 0x600 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 128, 2, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 128, 2, 8, 0xc00 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 129, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 129, 1, 8, 0x980 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 129, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 129, 2, 8, 0x1300 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 255, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 255, 1, 8, 0x980 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 255, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 255, 2, 8, 0x1300 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 256, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 256, 1, 9, 0xa00 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 256, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 256, 2, 9, 0x1400 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 257, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 257, 1, 9, 0x1180 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 257, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 257, 2, 9, 0x2300 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 511, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 511, 1, 9, 0x1180 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 511, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 511, 2, 9, 0x2300 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 512, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 512, 1, 10, 0x1200 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 512, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 512, 2, 10, 0x2400 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 513, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 513, 1, 10, 0x2180 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 513, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 513, 2, 10, 0x4300 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 1023, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 1023, 1, 10, 0x2180 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 1023, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 1023, 2, 10, 0x4300 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 1024, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 1024, 1, 11, 0x2200 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 1024, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 1024, 2, 11, 0x4400 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 1025, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 1025, 1, 11, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 1025, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 1025, 2, 11, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 2047, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 2047, 1, 11, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 2047, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 2047, 2, 11, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 2048, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 2048, 1, 12, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 2048, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 2048, 2, 12, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 2049, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 2049, 1, 12, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 2049, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 2049, 2, 12, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 4095, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 4095, 1, 12, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 4095, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 4095, 2, 12, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 4096, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 4096, 1, 13, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 4096, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 4096, 2, 13, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 4097, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 4097, 1, 13, 0x14000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 4097, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 1, 4097, 2, 13, 0x28000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 1, 1, 2, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 1, 2, 2, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 2, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 2, 1, 2, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 2, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 2, 2, 2, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 3, 1, 2, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 3, 2, 2, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 4, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 4, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 4, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 4, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 5, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 5, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 7, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 7, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 8, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 8, 1, 4, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 8, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 8, 2, 4, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 9, 1, 4, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 9, 2, 4, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 15, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 15, 1, 4, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 15, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 15, 2, 4, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 16, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 16, 1, 5, 0x280 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 16, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 16, 2, 5, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 17, 1, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 17, 1, 5, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 17, 2, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 17, 2, 5, 0x600 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 31, 1, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 31, 1, 5, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 31, 2, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 31, 2, 5, 0x600 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 32, 1, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 32, 1, 6, 0x380 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 32, 2, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 32, 2, 6, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 33, 1, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 33, 1, 6, 0x480 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 33, 2, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 33, 2, 6, 0x900 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 63, 1, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 63, 1, 6, 0x480 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 63, 2, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 63, 2, 6, 0x900 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 64, 1, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 64, 1, 7, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 64, 2, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 64, 2, 7, 0xa00 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 65, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 65, 1, 7, 0x780 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 65, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 65, 2, 7, 0xf00 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 127, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 127, 1, 7, 0x780 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 127, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 127, 2, 7, 0xf00 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 128, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 128, 1, 8, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 128, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 128, 2, 8, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 129, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 129, 1, 8, 0xd80 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 129, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 129, 2, 8, 0x1b00 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 255, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 255, 1, 8, 0xd80 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 255, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 255, 2, 8, 0x1b00 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 256, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 256, 1, 9, 0xe00 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 256, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 256, 2, 9, 0x1c00 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 257, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 257, 1, 9, 0x1980 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 257, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 257, 2, 9, 0x3300 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 511, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 511, 1, 9, 0x1980 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 511, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 511, 2, 9, 0x3300 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 512, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 512, 1, 10, 0x1a00 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 512, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 512, 2, 10, 0x3400 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 513, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 513, 1, 10, 0x3180 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 513, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 513, 2, 10, 0x6300 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 1023, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 1023, 1, 10, 0x3180 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 1023, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 1023, 2, 10, 0x6300 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 1024, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 1024, 1, 11, 0x3200 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 1024, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 1024, 2, 11, 0x6400 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 1025, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 1025, 1, 11, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 1025, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 1025, 2, 11, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 2047, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 2047, 1, 11, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 2047, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 2047, 2, 11, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 2048, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 2048, 1, 12, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 2048, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 2048, 2, 12, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 2049, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 2049, 1, 12, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 2049, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 2049, 2, 12, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 4095, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 4095, 1, 12, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 4095, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 4095, 2, 12, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 4096, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 4096, 1, 13, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 4096, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 4096, 2, 13, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 4097, 1, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 4097, 1, 13, 0x1c000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 4097, 2, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 2, 4097, 2, 13, 0x38000 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 1, 1, 2, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 1, 2, 2, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 2, 1, 2, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 2, 2, 2, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 3, 1, 2, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 3, 2, 2, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 4, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 4, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 5, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 5, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 7, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 7, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 8, 1, 4, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 8, 2, 4, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 9, 1, 4, 0x280 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 9, 2, 4, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 15, 1, 4, 0x280 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 15, 2, 4, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 16, 1, 5, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 16, 2, 5, 0x600 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 17, 1, 5, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 17, 2, 5, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 31, 1, 5, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 31, 2, 5, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 32, 1, 6, 0x480 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 32, 2, 6, 0x900 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 33, 1, 6, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 33, 2, 6, 0xe00 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 63, 1, 6, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 63, 2, 6, 0xe00 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 64, 1, 7, 0x780 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 64, 2, 7, 0xf00 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 65, 1, 7, 0xc80 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 65, 2, 7, 0x1900 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 127, 1, 7, 0xc80 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 127, 2, 7, 0x1900 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 128, 1, 8, 0xd00 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 128, 2, 8, 0x1a00 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 129, 1, 8, 0x1780 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 129, 2, 8, 0x2f00 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 255, 1, 8, 0x1780 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 255, 2, 8, 0x2f00 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 256, 1, 9, 0x1800 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 256, 2, 9, 0x3000 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 257, 1, 9, 0x2d80 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 257, 2, 9, 0x5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 511, 1, 9, 0x2d80 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 511, 2, 9, 0x5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 512, 1, 10, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 512, 2, 10, 0x5c00 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 513, 1, 10, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 513, 2, 10, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 1023, 1, 10, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 1023, 2, 10, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 1024, 1, 11, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 1024, 2, 11, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 1025, 1, 11, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 1025, 2, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 2047, 1, 11, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 2047, 2, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 2048, 1, 12, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 2048, 2, 12, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 2049, 1, 12, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 2049, 2, 12, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 4095, 1, 12, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 4095, 2, 12, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 4096, 1, 13, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 4096, 2, 13, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 4097, 1, 13, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 3, 4097, 2, 13, 0x60000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 1, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 1, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 2, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 2, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 2, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 2, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 3, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 3, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 4, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 4, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 4, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 4, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 5, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 5, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 7, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 7, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 8, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 8, 1, 4, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 8, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 8, 2, 4, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 9, 1, 4, 0x280 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 9, 2, 4, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 15, 1, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 15, 1, 4, 0x280 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 15, 2, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 15, 2, 4, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 16, 1, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 16, 1, 5, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 16, 2, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 16, 2, 5, 0x600 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 17, 1, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 17, 1, 5, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 17, 2, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 17, 2, 5, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 31, 1, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 31, 1, 5, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 31, 2, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 31, 2, 5, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 32, 1, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 32, 1, 6, 0x480 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 32, 2, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 32, 2, 6, 0x900 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 33, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 33, 1, 6, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 33, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 33, 2, 6, 0xe00 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 63, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 63, 1, 6, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 63, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 63, 2, 6, 0xe00 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 64, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 64, 1, 7, 0x780 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 64, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 64, 2, 7, 0xf00 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 65, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 65, 1, 7, 0xc80 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 65, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 65, 2, 7, 0x1900 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 127, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 127, 1, 7, 0xc80 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 127, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 127, 2, 7, 0x1900 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 128, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 128, 1, 8, 0xd00 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 128, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 128, 2, 8, 0x1a00 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 129, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 129, 1, 8, 0x1780 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 129, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 129, 2, 8, 0x2f00 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 255, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 255, 1, 8, 0x1780 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 255, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 255, 2, 8, 0x2f00 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 256, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 256, 1, 9, 0x1800 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 256, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 256, 2, 9, 0x3000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 257, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 257, 1, 9, 0x2d80 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 257, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 257, 2, 9, 0x5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 511, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 511, 1, 9, 0x2d80 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 511, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 511, 2, 9, 0x5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 512, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 512, 1, 10, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 512, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 512, 2, 10, 0x5c00 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 513, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 513, 1, 10, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 513, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 513, 2, 10, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 1023, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 1023, 1, 10, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 1023, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 1023, 2, 10, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 1024, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 1024, 1, 11, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 1024, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 1024, 2, 11, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 1025, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 1025, 1, 11, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 1025, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 1025, 2, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 2047, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 2047, 1, 11, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 2047, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 2047, 2, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 2048, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 2048, 1, 12, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 2048, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 2048, 2, 12, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 2049, 1, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 2049, 1, 12, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 2049, 2, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 2049, 2, 12, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 4095, 1, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 4095, 1, 12, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 4095, 2, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 4095, 2, 12, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 4096, 1, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 4096, 1, 13, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 4096, 2, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 4096, 2, 13, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 4097, 1, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 4097, 1, 13, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 4097, 2, 1, 0x40000 },
   { PIPE_FORMAT_Z32_FLOAT, 4, 4097, 2, 13, 0x60000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 1, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 1, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 2, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 2, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 3, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 3, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 4, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 4, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 5, 1, 3, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 5, 2, 3, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 7, 1, 3, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 7, 2, 3, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 8, 1, 4, 0x280 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 8, 2, 4, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 9, 1, 4, 0x380 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 9, 2, 4, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 15, 1, 4, 0x380 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 15, 2, 4, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 16, 1, 5, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 16, 2, 5, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 17, 1, 5, 0x680 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 17, 2, 5, 0xd00 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 31, 1, 5, 0x680 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 31, 2, 5, 0xd00 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 32, 1, 6, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 32, 2, 6, 0xe00 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 33, 1, 6, 0xc00 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 33, 2, 6, 0x1800 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 63, 1, 6, 0xc00 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 63, 2, 6, 0x1800 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 64, 1, 7, 0xc80 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 64, 2, 7, 0x1900 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 65, 1, 7, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 65, 2, 7, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 127, 1, 7, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 127, 2, 7, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 128, 1, 8, 0x1780 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 128, 2, 8, 0x2f00 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 129, 1, 8, 0x2c80 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 129, 2, 8, 0x5900 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 255, 1, 8, 0x2c80 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 255, 2, 8, 0x5900 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 256, 1, 9, 0x2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 256, 2, 9, 0x5a00 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 257, 1, 9, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 257, 2, 9, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 511, 1, 9, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 511, 2, 9, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 512, 1, 10, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 512, 2, 10, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 513, 1, 10, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 513, 2, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 1023, 1, 10, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 1023, 2, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 1024, 1, 11, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 1024, 2, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 1025, 1, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 1025, 2, 11, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 2047, 1, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 2047, 2, 11, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 2048, 1, 12, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 2048, 2, 12, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 2049, 1, 12, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 2049, 2, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 4095, 1, 12, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 4095, 2, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 4096, 1, 13, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 4096, 2, 13, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 4097, 1, 13, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 5, 4097, 2, 13, 0xb0000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 1, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 1, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 2, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 2, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 3, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 3, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 4, 1, 3, 0x180 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 4, 2, 3, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 5, 1, 3, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 5, 2, 3, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 7, 1, 3, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 7, 2, 3, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 8, 1, 4, 0x280 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 8, 2, 4, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 9, 1, 4, 0x380 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 9, 2, 4, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 15, 1, 4, 0x380 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 15, 2, 4, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 16, 1, 5, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 16, 2, 5, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 17, 1, 5, 0x680 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 17, 2, 5, 0xd00 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 31, 1, 5, 0x680 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 31, 2, 5, 0xd00 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 32, 1, 6, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 32, 2, 6, 0xe00 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 33, 1, 6, 0xc00 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 33, 2, 6, 0x1800 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 63, 1, 6, 0xc00 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 63, 2, 6, 0x1800 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 64, 1, 7, 0xc80 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 64, 2, 7, 0x1900 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 65, 1, 7, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 65, 2, 7, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 127, 1, 7, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 127, 2, 7, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 128, 1, 8, 0x1780 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 128, 2, 8, 0x2f00 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 129, 1, 8, 0x2c80 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 129, 2, 8, 0x5900 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 255, 1, 8, 0x2c80 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 255, 2, 8, 0x5900 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 256, 1, 9, 0x2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 256, 2, 9, 0x5a00 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 257, 1, 9, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 257, 2, 9, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 511, 1, 9, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 511, 2, 9, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 512, 1, 10, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 512, 2, 10, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 513, 1, 10, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 513, 2, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 1023, 1, 10, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 1023, 2, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 1024, 1, 11, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 1024, 2, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 1025, 1, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 1025, 2, 11, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 2047, 1, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 2047, 2, 11, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 2048, 1, 12, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 2048, 2, 12, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 2049, 1, 12, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 2049, 2, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 4095, 1, 12, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 4095, 2, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 4096, 1, 13, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 4096, 2, 13, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 4097, 1, 13, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 7, 4097, 2, 13, 0xb0000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 1, 1, 4, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 1, 2, 4, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 2, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 2, 1, 4, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 2, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 2, 2, 4, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 3, 1, 4, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 3, 2, 4, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 4, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 4, 1, 4, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 4, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 4, 2, 4, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 5, 1, 4, 0x280 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 5, 2, 4, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 7, 1, 4, 0x280 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 7, 2, 4, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 8, 1, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 8, 1, 4, 0x280 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 8, 2, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 8, 2, 4, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 9, 1, 4, 0x380 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 9, 2, 4, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 15, 1, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 15, 1, 4, 0x380 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 15, 2, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 15, 2, 4, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 16, 1, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 16, 1, 5, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 16, 2, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 16, 2, 5, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 17, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 17, 1, 5, 0x680 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 17, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 17, 2, 5, 0xd00 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 31, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 31, 1, 5, 0x680 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 31, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 31, 2, 5, 0xd00 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 32, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 32, 1, 6, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 32, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 32, 2, 6, 0xe00 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 33, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 33, 1, 6, 0xc00 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 33, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 33, 2, 6, 0x1800 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 63, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 63, 1, 6, 0xc00 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 63, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 63, 2, 6, 0x1800 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 64, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 64, 1, 7, 0xc80 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 64, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 64, 2, 7, 0x1900 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 65, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 65, 1, 7, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 65, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 65, 2, 7, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 127, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 127, 1, 7, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 127, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 127, 2, 7, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 128, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 128, 1, 8, 0x1780 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 128, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 128, 2, 8, 0x2f00 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 129, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 129, 1, 8, 0x2c80 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 129, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 129, 2, 8, 0x5900 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 255, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 255, 1, 8, 0x2c80 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 255, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 255, 2, 8, 0x5900 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 256, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 256, 1, 9, 0x2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 256, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 256, 2, 9, 0x5a00 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 257, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 257, 1, 9, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 257, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 257, 2, 9, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 511, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 511, 1, 9, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 511, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 511, 2, 9, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 512, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 512, 1, 10, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 512, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 512, 2, 10, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 513, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 513, 1, 10, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 513, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 513, 2, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 1023, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 1023, 1, 10, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 1023, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 1023, 2, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 1024, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 1024, 1, 11, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 1024, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 1024, 2, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 1025, 1, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 1025, 1, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 1025, 2, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 1025, 2, 11, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 2047, 1, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 2047, 1, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 2047, 2, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 2047, 2, 11, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 2048, 1, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 2048, 1, 12, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 2048, 2, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 2048, 2, 12, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 2049, 1, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 2049, 1, 12, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 2049, 2, 1, 0x40000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 2049, 2, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 4095, 1, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 4095, 1, 12, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 4095, 2, 1, 0x40000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 4095, 2, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 4096, 1, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 4096, 1, 13, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 4096, 2, 1, 0x40000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 4096, 2, 13, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 4097, 1, 1, 0x40000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 4097, 1, 13, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 4097, 2, 1, 0x80000 },
   { PIPE_FORMAT_Z32_FLOAT, 8, 4097, 2, 13, 0xb0000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 1, 1, 4, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 1, 2, 4, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 2, 1, 4, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 2, 2, 4, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 3, 1, 4, 0x280 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 3, 2, 4, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 4, 1, 4, 0x280 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 4, 2, 4, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 5, 1, 4, 0x380 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 5, 2, 4, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 7, 1, 4, 0x380 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 7, 2, 4, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 8, 1, 4, 0x380 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 8, 2, 4, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 9, 1, 4, 0x600 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 9, 2, 4, 0xc00 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 15, 1, 4, 0x600 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 15, 2, 4, 0xc00 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 16, 1, 5, 0x680 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 16, 2, 5, 0xd00 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 17, 1, 5, 0xb80 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 17, 2, 5, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 31, 1, 5, 0xb80 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 31, 2, 5, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 32, 1, 6, 0xc00 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 32, 2, 6, 0x1800 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 33, 1, 6, 0x1680 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 33, 2, 6, 0x2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 63, 1, 6, 0x1680 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 63, 2, 6, 0x2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 64, 1, 7, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 64, 2, 7, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 65, 1, 7, 0x2c00 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 65, 2, 7, 0x5800 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 127, 1, 7, 0x2c00 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 127, 2, 7, 0x5800 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 128, 1, 8, 0x2c80 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 128, 2, 8, 0x5900 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 129, 1, 8, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 129, 2, 8, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 255, 1, 8, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 255, 2, 8, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 256, 1, 9, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 256, 2, 9, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 257, 1, 9, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 257, 2, 9, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 511, 1, 9, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 511, 2, 9, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 512, 1, 10, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 512, 2, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 513, 1, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 513, 2, 10, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 1023, 1, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 1023, 2, 10, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 1024, 1, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 1024, 2, 11, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 1025, 1, 11, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 1025, 2, 11, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 2047, 1, 11, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 2047, 2, 11, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 2048, 1, 12, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 2048, 2, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 2049, 1, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 2049, 2, 12, 0xb0000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 4095, 1, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 4095, 2, 12, 0xb0000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 4096, 1, 13, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 4096, 2, 13, 0xb0000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 4097, 1, 13, 0xac000 },
   { PIPE_FORMAT_Z32_FLOAT, 9, 4097, 2, 13, 0x158000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 1, 1, 4, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 1, 2, 4, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 2, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 2, 1, 4, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 2, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 2, 2, 4, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 3, 1, 4, 0x280 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 3, 2, 4, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 4, 1, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 4, 1, 4, 0x280 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 4, 2, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 4, 2, 4, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 5, 1, 4, 0x380 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 5, 2, 4, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 7, 1, 4, 0x380 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 7, 2, 4, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 8, 1, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 8, 1, 4, 0x380 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 8, 2, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 8, 2, 4, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 9, 1, 4, 0x600 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 9, 2, 4, 0xc00 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 15, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 15, 1, 4, 0x600 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 15, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 15, 2, 4, 0xc00 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 16, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 16, 1, 5, 0x680 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 16, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 16, 2, 5, 0xd00 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 17, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 17, 1, 5, 0xb80 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 17, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 17, 2, 5, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 31, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 31, 1, 5, 0xb80 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 31, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 31, 2, 5, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 32, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 32, 1, 6, 0xc00 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 32, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 32, 2, 6, 0x1800 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 33, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 33, 1, 6, 0x1680 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 33, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 33, 2, 6, 0x2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 63, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 63, 1, 6, 0x1680 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 63, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 63, 2, 6, 0x2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 64, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 64, 1, 7, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 64, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 64, 2, 7, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 65, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 65, 1, 7, 0x2c00 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 65, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 65, 2, 7, 0x5800 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 127, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 127, 1, 7, 0x2c00 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 127, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 127, 2, 7, 0x5800 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 128, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 128, 1, 8, 0x2c80 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 128, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 128, 2, 8, 0x5900 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 129, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 129, 1, 8, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 129, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 129, 2, 8, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 255, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 255, 1, 8, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 255, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 255, 2, 8, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 256, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 256, 1, 9, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 256, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 256, 2, 9, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 257, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 257, 1, 9, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 257, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 257, 2, 9, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 511, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 511, 1, 9, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 511, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 511, 2, 9, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 512, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 512, 1, 10, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 512, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 512, 2, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 513, 1, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 513, 1, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 513, 2, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 513, 2, 10, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 1023, 1, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 1023, 1, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 1023, 2, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 1023, 2, 10, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 1024, 1, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 1024, 1, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 1024, 2, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 1024, 2, 11, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 1025, 1, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 1025, 1, 11, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 1025, 2, 1, 0x40000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 1025, 2, 11, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 2047, 1, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 2047, 1, 11, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 2047, 2, 1, 0x40000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 2047, 2, 11, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 2048, 1, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 2048, 1, 12, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 2048, 2, 1, 0x40000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 2048, 2, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 2049, 1, 1, 0x40000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 2049, 1, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 2049, 2, 1, 0x80000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 2049, 2, 12, 0xb0000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 4095, 1, 1, 0x40000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 4095, 1, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 4095, 2, 1, 0x80000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 4095, 2, 12, 0xb0000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 4096, 1, 1, 0x40000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 4096, 1, 13, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 4096, 2, 1, 0x80000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 4096, 2, 13, 0xb0000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 4097, 1, 1, 0x80000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 4097, 1, 13, 0xac000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 4097, 2, 1, 0x100000 },
   { PIPE_FORMAT_Z32_FLOAT, 15, 4097, 2, 13, 0x158000 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 1, 1, 5, 0x280 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 1, 2, 5, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 2, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 2, 1, 5, 0x280 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 2, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 2, 2, 5, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 3, 1, 5, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 3, 2, 5, 0x600 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 4, 1, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 4, 1, 5, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 4, 2, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 4, 2, 5, 0x600 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 5, 1, 5, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 5, 2, 5, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 7, 1, 5, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 7, 2, 5, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 8, 1, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 8, 1, 5, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 8, 2, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 8, 2, 5, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 9, 1, 5, 0x680 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 9, 2, 5, 0xd00 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 15, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 15, 1, 5, 0x680 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 15, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 15, 2, 5, 0xd00 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 1, 1, 5, 0x280 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 1, 2, 5, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 2, 1, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 2, 1, 5, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 2, 2, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 2, 2, 5, 0x600 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 3, 1, 5, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 3, 2, 5, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 4, 1, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 4, 1, 5, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 4, 2, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 4, 2, 5, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 5, 1, 5, 0x680 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 5, 2, 5, 0xd00 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 7, 1, 5, 0x680 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 7, 2, 5, 0xd00 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 8, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 8, 1, 5, 0x680 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 8, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 8, 2, 5, 0xd00 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 9, 1, 5, 0xb80 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 9, 2, 5, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 15, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 15, 1, 5, 0xb80 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 15, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 15, 2, 5, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 1, 1, 5, 0x280 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 1, 2, 5, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 2, 1, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 2, 1, 5, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 2, 2, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 2, 2, 5, 0x600 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 3, 1, 5, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 3, 2, 5, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 4, 1, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 4, 1, 5, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 4, 2, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 4, 2, 5, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 5, 1, 5, 0x680 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 5, 2, 5, 0xd00 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 7, 1, 5, 0x680 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 7, 2, 5, 0xd00 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 8, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 8, 1, 5, 0x680 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 8, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 8, 2, 5, 0xd00 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 9, 1, 5, 0xb80 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 9, 2, 5, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 15, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 15, 1, 5, 0xb80 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 15, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 15, 2, 5, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 1, 1, 1, 0x80 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 1, 1, 6, 0x300 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 1, 2, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 1, 2, 6, 0x600 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 2, 1, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 2, 1, 6, 0x380 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 2, 2, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 2, 2, 6, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 3, 1, 6, 0x480 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 3, 2, 6, 0x900 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 4, 1, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 4, 1, 6, 0x480 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 4, 2, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 4, 2, 6, 0x900 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 5, 1, 6, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 5, 2, 6, 0xe00 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 7, 1, 6, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 7, 2, 6, 0xe00 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 8, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 8, 1, 6, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 8, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 8, 2, 6, 0xe00 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 9, 1, 6, 0xc00 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 9, 2, 6, 0x1800 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 15, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 15, 1, 6, 0xc00 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 15, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 15, 2, 6, 0x1800 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 1, 1, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 1, 1, 6, 0x380 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 1, 2, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 1, 2, 6, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 2, 1, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 2, 1, 6, 0x480 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 2, 2, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 2, 2, 6, 0x900 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 3, 1, 6, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 3, 2, 6, 0xe00 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 4, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 4, 1, 6, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 4, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 4, 2, 6, 0xe00 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 5, 1, 6, 0xc00 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 5, 2, 6, 0x1800 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 7, 1, 6, 0xc00 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 7, 2, 6, 0x1800 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 8, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 8, 1, 6, 0xc00 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 8, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 8, 2, 6, 0x1800 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 9, 1, 6, 0x1680 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 9, 2, 6, 0x2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 15, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 15, 1, 6, 0x1680 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 15, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 15, 2, 6, 0x2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 1, 1, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 1, 1, 6, 0x380 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 1, 2, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 1, 2, 6, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 2, 1, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 2, 1, 6, 0x480 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 2, 2, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 2, 2, 6, 0x900 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 3, 1, 6, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 3, 2, 6, 0xe00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 4, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 4, 1, 6, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 4, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 4, 2, 6, 0xe00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 5, 1, 6, 0xc00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 5, 2, 6, 0x1800 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 7, 1, 6, 0xc00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 7, 2, 6, 0x1800 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 8, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 8, 1, 6, 0xc00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 8, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 8, 2, 6, 0x1800 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 9, 1, 6, 0x1680 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 9, 2, 6, 0x2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 15, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 15, 1, 6, 0x1680 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 15, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 15, 2, 6, 0x2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 1, 1, 1, 0x100 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 1, 1, 7, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 1, 2, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 1, 2, 7, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 2, 1, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 2, 1, 7, 0x500 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 2, 2, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 2, 2, 7, 0xa00 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 3, 1, 7, 0x780 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 3, 2, 7, 0xf00 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 4, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 4, 1, 7, 0x780 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 4, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 4, 2, 7, 0xf00 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 5, 1, 7, 0xc80 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 5, 2, 7, 0x1900 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 7, 1, 7, 0xc80 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 7, 2, 7, 0x1900 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 8, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 8, 1, 7, 0xc80 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 8, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 8, 2, 7, 0x1900 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 9, 1, 7, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 9, 2, 7, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 15, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 15, 1, 7, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 15, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 15, 2, 7, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 1, 1, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 1, 1, 7, 0x580 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 1, 2, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 1, 2, 7, 0xb00 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 2, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 2, 1, 7, 0x780 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 2, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 2, 2, 7, 0xf00 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 3, 1, 7, 0xc80 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 3, 2, 7, 0x1900 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 4, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 4, 1, 7, 0xc80 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 4, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 4, 2, 7, 0x1900 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 5, 1, 7, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 5, 2, 7, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 7, 1, 7, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 7, 2, 7, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 8, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 8, 1, 7, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 8, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 8, 2, 7, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 9, 1, 7, 0x2c00 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 9, 2, 7, 0x5800 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 15, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 15, 1, 7, 0x2c00 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 15, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 15, 2, 7, 0x5800 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 1, 1, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 1, 1, 7, 0x580 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 1, 2, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 1, 2, 7, 0xb00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 2, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 2, 1, 7, 0x780 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 2, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 2, 2, 7, 0xf00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 3, 1, 7, 0xc80 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 3, 2, 7, 0x1900 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 4, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 4, 1, 7, 0xc80 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 4, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 4, 2, 7, 0x1900 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 5, 1, 7, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 5, 2, 7, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 7, 1, 7, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 7, 2, 7, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 8, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 8, 1, 7, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 8, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 8, 2, 7, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 9, 1, 7, 0x2c00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 9, 2, 7, 0x5800 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 15, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 15, 1, 7, 0x2c00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 15, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 15, 2, 7, 0x5800 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 1, 1, 1, 0x200 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 1, 1, 8, 0x600 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 1, 2, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 1, 2, 8, 0xc00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 2, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 2, 1, 8, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 2, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 2, 2, 8, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 3, 1, 8, 0xd00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 3, 2, 8, 0x1a00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 4, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 4, 1, 8, 0xd00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 4, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 4, 2, 8, 0x1a00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 5, 1, 8, 0x1780 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 5, 2, 8, 0x2f00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 7, 1, 8, 0x1780 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 7, 2, 8, 0x2f00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 8, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 8, 1, 8, 0x1780 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 8, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 8, 2, 8, 0x2f00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 9, 1, 8, 0x2c80 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 9, 2, 8, 0x5900 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 15, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 15, 1, 8, 0x2c80 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 15, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 15, 2, 8, 0x5900 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 1, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 1, 1, 8, 0x980 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 1, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 1, 2, 8, 0x1300 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 2, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 2, 1, 8, 0xd80 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 2, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 2, 2, 8, 0x1b00 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 3, 1, 8, 0x1780 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 3, 2, 8, 0x2f00 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 4, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 4, 1, 8, 0x1780 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 4, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 4, 2, 8, 0x2f00 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 5, 1, 8, 0x2c80 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 5, 2, 8, 0x5900 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 7, 1, 8, 0x2c80 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 7, 2, 8, 0x5900 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 8, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 8, 1, 8, 0x2c80 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 8, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 8, 2, 8, 0x5900 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 9, 1, 8, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 9, 2, 8, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 15, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 15, 1, 8, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 15, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 15, 2, 8, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 1, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 1, 1, 8, 0x980 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 1, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 1, 2, 8, 0x1300 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 2, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 2, 1, 8, 0xd80 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 2, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 2, 2, 8, 0x1b00 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 3, 1, 8, 0x1780 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 3, 2, 8, 0x2f00 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 4, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 4, 1, 8, 0x1780 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 4, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 4, 2, 8, 0x2f00 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 5, 1, 8, 0x2c80 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 5, 2, 8, 0x5900 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 7, 1, 8, 0x2c80 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 7, 2, 8, 0x5900 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 8, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 8, 1, 8, 0x2c80 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 8, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 8, 2, 8, 0x5900 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 9, 1, 8, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 9, 2, 8, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 15, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 15, 1, 8, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 15, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 15, 2, 8, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 1, 1, 1, 0x400 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 1, 1, 9, 0xa00 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 1, 2, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 1, 2, 9, 0x1400 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 2, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 2, 1, 9, 0xe00 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 2, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 2, 2, 9, 0x1c00 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 3, 1, 9, 0x1800 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 3, 2, 9, 0x3000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 4, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 4, 1, 9, 0x1800 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 4, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 4, 2, 9, 0x3000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 5, 1, 9, 0x2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 5, 2, 9, 0x5a00 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 7, 1, 9, 0x2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 7, 2, 9, 0x5a00 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 8, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 8, 1, 9, 0x2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 8, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 8, 2, 9, 0x5a00 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 9, 1, 9, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 9, 2, 9, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 15, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 15, 1, 9, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 15, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 15, 2, 9, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 1, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 1, 1, 9, 0x1180 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 1, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 1, 2, 9, 0x2300 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 2, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 2, 1, 9, 0x1980 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 2, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 2, 2, 9, 0x3300 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 3, 1, 9, 0x2d80 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 3, 2, 9, 0x5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 4, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 4, 1, 9, 0x2d80 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 4, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 4, 2, 9, 0x5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 5, 1, 9, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 5, 2, 9, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 7, 1, 9, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 7, 2, 9, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 8, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 8, 1, 9, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 8, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 8, 2, 9, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 9, 1, 9, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 9, 2, 9, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 15, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 15, 1, 9, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 15, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 15, 2, 9, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 1, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 1, 1, 9, 0x1180 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 1, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 1, 2, 9, 0x2300 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 2, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 2, 1, 9, 0x1980 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 2, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 2, 2, 9, 0x3300 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 3, 1, 9, 0x2d80 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 3, 2, 9, 0x5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 4, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 4, 1, 9, 0x2d80 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 4, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 4, 2, 9, 0x5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 5, 1, 9, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 5, 2, 9, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 7, 1, 9, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 7, 2, 9, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 8, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 8, 1, 9, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 8, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 8, 2, 9, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 9, 1, 9, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 9, 2, 9, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 15, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 15, 1, 9, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 15, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 15, 2, 9, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 1, 1, 1, 0x800 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 1, 1, 10, 0x1200 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 1, 2, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 1, 2, 10, 0x2400 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 2, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 2, 1, 10, 0x1a00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 2, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 2, 2, 10, 0x3400 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 3, 1, 10, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 3, 2, 10, 0x5c00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 4, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 4, 1, 10, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 4, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 4, 2, 10, 0x5c00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 5, 1, 10, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 5, 2, 10, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 7, 1, 10, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 7, 2, 10, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 8, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 8, 1, 10, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 8, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 8, 2, 10, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 9, 1, 10, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 9, 2, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 15, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 15, 1, 10, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 15, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 15, 2, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 1, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 1, 1, 10, 0x2180 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 1, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 1, 2, 10, 0x4300 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 2, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 2, 1, 10, 0x3180 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 2, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 2, 2, 10, 0x6300 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 3, 1, 10, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 3, 2, 10, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 4, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 4, 1, 10, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 4, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 4, 2, 10, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 5, 1, 10, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 5, 2, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 7, 1, 10, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 7, 2, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 8, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 8, 1, 10, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 8, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 8, 2, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 9, 1, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 9, 2, 10, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 15, 1, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 15, 1, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 15, 2, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 15, 2, 10, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 1, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 1, 1, 10, 0x2180 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 1, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 1, 2, 10, 0x4300 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 2, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 2, 1, 10, 0x3180 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 2, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 2, 2, 10, 0x6300 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 3, 1, 10, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 3, 2, 10, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 4, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 4, 1, 10, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 4, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 4, 2, 10, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 5, 1, 10, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 5, 2, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 7, 1, 10, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 7, 2, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 8, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 8, 1, 10, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 8, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 8, 2, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 9, 1, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 9, 2, 10, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 15, 1, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 15, 1, 10, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 15, 2, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 15, 2, 10, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 1, 1, 1, 0x1000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 1, 1, 11, 0x2200 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 1, 2, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 1, 2, 11, 0x4400 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 2, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 2, 1, 11, 0x3200 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 2, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 2, 2, 11, 0x6400 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 3, 1, 11, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 3, 2, 11, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 4, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 4, 1, 11, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 4, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 4, 2, 11, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 5, 1, 11, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 5, 2, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 7, 1, 11, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 7, 2, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 8, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 8, 1, 11, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 8, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 8, 2, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 9, 1, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 9, 2, 11, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 15, 1, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 15, 1, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 15, 2, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 15, 2, 11, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 1, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 1, 1, 11, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 1, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 1, 2, 11, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 2, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 2, 1, 11, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 2, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 2, 2, 11, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 3, 1, 11, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 3, 2, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 4, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 4, 1, 11, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 4, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 4, 2, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 5, 1, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 5, 2, 11, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 7, 1, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 7, 2, 11, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 8, 1, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 8, 1, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 8, 2, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 8, 2, 11, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 9, 1, 11, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 9, 2, 11, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 15, 1, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 15, 1, 11, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 15, 2, 1, 0x40000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 15, 2, 11, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 1, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 1, 1, 11, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 1, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 1, 2, 11, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 2, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 2, 1, 11, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 2, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 2, 2, 11, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 3, 1, 11, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 3, 2, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 4, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 4, 1, 11, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 4, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 4, 2, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 5, 1, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 5, 2, 11, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 7, 1, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 7, 2, 11, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 8, 1, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 8, 1, 11, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 8, 2, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 8, 2, 11, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 9, 1, 11, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 9, 2, 11, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 15, 1, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 15, 1, 11, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 15, 2, 1, 0x40000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 15, 2, 11, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 1, 1, 1, 0x2000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 1, 1, 12, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 1, 2, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 1, 2, 12, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 2, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 2, 1, 12, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 2, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 2, 2, 12, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 3, 1, 12, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 3, 2, 12, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 4, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 4, 1, 12, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 4, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 4, 2, 12, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 5, 1, 12, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 5, 2, 12, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 7, 1, 12, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 7, 2, 12, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 8, 1, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 8, 1, 12, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 8, 2, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 8, 2, 12, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 9, 1, 12, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 9, 2, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 15, 1, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 15, 1, 12, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 15, 2, 1, 0x40000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 15, 2, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 1, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 1, 1, 12, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 1, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 1, 2, 12, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 2, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 2, 1, 12, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 2, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 2, 2, 12, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 3, 1, 12, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 3, 2, 12, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 4, 1, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 4, 1, 12, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 4, 2, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 4, 2, 12, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 5, 1, 12, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 5, 2, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 7, 1, 12, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 7, 2, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 8, 1, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 8, 1, 12, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 8, 2, 1, 0x40000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 8, 2, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 9, 1, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 9, 2, 12, 0xb0000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 15, 1, 1, 0x40000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 15, 1, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 15, 2, 1, 0x80000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 15, 2, 12, 0xb0000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 1, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 1, 1, 12, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 1, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 1, 2, 12, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 2, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 2, 1, 12, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 2, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 2, 2, 12, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 3, 1, 12, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 3, 2, 12, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 4, 1, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 4, 1, 12, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 4, 2, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 4, 2, 12, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 5, 1, 12, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 5, 2, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 7, 1, 12, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 7, 2, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 8, 1, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 8, 1, 12, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 8, 2, 1, 0x40000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 8, 2, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 9, 1, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 9, 2, 12, 0xb0000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 15, 1, 1, 0x40000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 15, 1, 12, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 15, 2, 1, 0x80000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 15, 2, 12, 0xb0000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 1, 1, 1, 0x4000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 1, 1, 13, 0xc000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 1, 2, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 1, 2, 13, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 2, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 2, 1, 13, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 2, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 2, 2, 13, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 3, 1, 13, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 3, 2, 13, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 4, 1, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 4, 1, 13, 0x18000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 4, 2, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 4, 2, 13, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 5, 1, 13, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 5, 2, 13, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 7, 1, 13, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 7, 2, 13, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 8, 1, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 8, 1, 13, 0x2c000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 8, 2, 1, 0x40000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 8, 2, 13, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 9, 1, 13, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 9, 2, 13, 0xb0000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 15, 1, 1, 0x40000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 15, 1, 13, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 15, 2, 1, 0x80000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 15, 2, 13, 0xb0000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 1, 1, 1, 0x8000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 1, 1, 13, 0x14000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 1, 2, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 1, 2, 13, 0x28000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 2, 1, 1, 0x10000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 2, 1, 13, 0x1c000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 2, 2, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 2, 2, 13, 0x38000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 3, 1, 13, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 3, 2, 13, 0x60000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 4, 1, 1, 0x20000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 4, 1, 13, 0x30000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 4, 2, 1, 0x40000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 4, 2, 13, 0x60000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 5, 1, 13, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 5, 2, 13, 0xb0000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 7, 1, 13, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 7, 2, 13, 0xb0000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 8, 1, 1, 0x40000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 8, 1, 13, 0x58000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 8, 2, 1, 0x80000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 8, 2, 13, 0xb0000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 9, 1, 13, 0xac000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 9, 2, 13, 0x158000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 15, 1, 1, 0x80000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 15, 1, 13, 0xac000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 15, 2, 1, 0x100000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 15, 2, 13, 0x158000 },
};

TEST(UncompTwiddled, SizeTests)
{
   for (unsigned i = 0; i < ARRAY_SIZE(sizetests); ++i) {
      struct sizetest test = sizetests[i];

      struct ail_layout layout = {
         .width_px = test.width,
         .height_px = test.height,
         .depth_px = test.depth,
         .sample_count_sa = 1,
         .levels = test.levels,
         .tiling = AIL_TILING_TWIDDLED,
         .format = test.format,
      };

      ail_make_miptree(&layout);

      EXPECT_EQ(layout.size_B, test.size) <<
         test.width << "x" << test.height << "x" << test.depth << " " << (int)test.levels <<
         "L " << util_format_short_name(test.format) <<
         " uncompressed texture has wrong allocation size, off by " << ((int)layout.size_B - (int)test.size);
   }
}
