/*
 * Copyright 2022 Asahi Lina
 * SPDX-License-Identifier: MIT
 */

#include <gtest/gtest.h>
#include "layout.h"

/*
 * Test compressed texture sizes. All test cases in this file are extracted from
 * texture structure dumps in Metal.
 */
struct sizetest {
   enum pipe_format format;
   uint32_t width, height, depth;
   uint8_t levels;
   uint32_t size;
};

/* Sort: `sort -t"," -k1,1 -k2,5n | uniq` */
static struct sizetest comptests[] = {
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 16, 1, 1, 0x880 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 24, 1, 1, 0x1080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 32, 1, 1, 0x1080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 40, 1, 1, 0x2080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 48, 1, 1, 0x2080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 56, 1, 1, 0x2080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 64, 1, 1, 0x2080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 72, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 80, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 88, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 96, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 104, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 112, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 120, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 128, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 136, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 144, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 152, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 160, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 168, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 176, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 184, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 192, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 200, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 208, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 216, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 224, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 232, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 240, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 248, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 16, 256, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 24, 1, 1, 0x2080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 32, 1, 1, 0x2080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 40, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 48, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 56, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 64, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 72, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 80, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 88, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 96, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 104, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 112, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 120, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 128, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 136, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 144, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 152, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 160, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 168, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 176, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 184, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 192, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 200, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 208, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 216, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 224, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 232, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 240, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 248, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 24, 256, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 24, 1, 1, 0x2080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 32, 1, 1, 0x2080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 40, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 48, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 56, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 64, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 72, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 80, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 88, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 96, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 104, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 112, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 120, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 128, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 136, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 144, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 152, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 160, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 168, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 176, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 184, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 192, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 200, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 208, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 216, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 224, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 232, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 240, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 248, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 32, 256, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 24, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 32, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 40, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 48, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 56, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 64, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 72, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 80, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 88, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 96, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 104, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 112, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 120, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 128, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 136, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 144, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 152, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 160, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 168, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 176, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 184, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 192, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 200, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 208, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 216, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 224, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 232, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 240, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 248, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 40, 256, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 24, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 32, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 40, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 48, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 56, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 64, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 72, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 80, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 88, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 96, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 104, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 112, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 120, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 128, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 136, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 144, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 152, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 160, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 168, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 176, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 184, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 192, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 200, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 208, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 216, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 224, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 232, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 240, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 248, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 48, 256, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 24, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 32, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 40, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 48, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 56, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 64, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 72, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 80, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 88, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 96, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 104, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 112, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 120, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 128, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 136, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 144, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 152, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 160, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 168, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 176, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 184, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 192, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 200, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 208, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 216, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 224, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 232, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 240, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 248, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 56, 256, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 24, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 32, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 40, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 48, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 56, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 64, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 72, 1, 1, 0xc100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 80, 1, 1, 0xc100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 88, 1, 1, 0xc100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 96, 1, 1, 0xc100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 104, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 112, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 120, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 128, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 136, 1, 1, 0x14200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 144, 1, 1, 0x14200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 152, 1, 1, 0x14200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 160, 1, 1, 0x14200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 168, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 176, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 184, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 192, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 200, 1, 1, 0x1c200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 208, 1, 1, 0x1c200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 216, 1, 1, 0x1c200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 224, 1, 1, 0x1c200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 232, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 240, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 248, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 64, 256, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 24, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 32, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 40, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 48, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 56, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 64, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 72, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 80, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 88, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 96, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 104, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 112, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 120, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 128, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 136, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 144, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 152, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 160, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 168, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 176, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 184, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 192, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 200, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 208, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 216, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 224, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 232, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 240, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 248, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 72, 256, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 24, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 32, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 40, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 48, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 56, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 64, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 72, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 80, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 88, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 96, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 104, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 112, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 120, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 128, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 136, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 144, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 152, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 160, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 168, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 176, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 184, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 192, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 200, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 208, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 216, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 224, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 232, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 240, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 248, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 80, 256, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 24, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 32, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 40, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 48, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 56, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 64, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 72, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 80, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 88, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 96, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 104, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 112, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 120, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 128, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 136, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 144, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 152, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 160, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 168, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 176, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 184, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 192, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 200, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 208, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 216, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 224, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 232, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 240, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 248, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 88, 256, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 24, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 32, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 40, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 48, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 56, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 64, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 72, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 80, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 88, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 96, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 104, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 112, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 120, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 128, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 136, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 144, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 152, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 160, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 168, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 176, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 184, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 192, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 200, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 208, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 216, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 224, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 232, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 240, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 248, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 96, 256, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 24, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 32, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 40, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 48, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 56, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 64, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 72, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 80, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 88, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 96, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 104, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 112, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 120, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 128, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 136, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 144, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 152, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 160, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 168, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 176, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 184, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 192, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 200, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 208, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 216, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 224, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 232, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 240, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 248, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 104, 256, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 24, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 32, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 40, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 48, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 56, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 64, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 72, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 80, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 88, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 96, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 104, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 112, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 120, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 128, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 136, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 144, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 152, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 160, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 168, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 176, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 184, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 192, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 200, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 208, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 216, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 224, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 232, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 240, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 248, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 112, 256, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 24, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 32, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 40, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 48, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 56, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 64, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 72, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 80, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 88, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 96, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 104, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 112, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 120, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 128, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 136, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 144, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 152, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 160, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 168, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 176, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 184, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 192, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 200, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 208, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 216, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 224, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 232, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 240, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 248, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 120, 256, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 24, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 32, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 40, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 48, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 56, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 64, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 72, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 80, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 88, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 96, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 104, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 112, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 120, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 128, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 136, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 144, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 152, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 160, 1, 1, 0x28400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 168, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 176, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 184, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 192, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 200, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 208, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 216, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 224, 1, 1, 0x38400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 232, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 240, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 248, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 128, 256, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 16, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 24, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 32, 1, 1, 0xc100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 40, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 48, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 56, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 64, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 72, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 80, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 88, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 96, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 104, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 112, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 120, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 128, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 136, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 144, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 152, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 160, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 168, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 176, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 184, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 192, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 200, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 208, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 216, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 224, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 232, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 240, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 248, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 136, 256, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 16, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 24, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 32, 1, 1, 0xc100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 40, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 48, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 56, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 64, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 72, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 80, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 88, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 96, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 104, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 112, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 120, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 128, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 136, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 144, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 152, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 160, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 168, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 176, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 184, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 192, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 200, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 208, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 216, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 224, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 232, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 240, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 248, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 144, 256, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 16, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 24, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 32, 1, 1, 0xc100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 40, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 48, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 56, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 64, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 72, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 80, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 88, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 96, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 104, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 112, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 120, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 128, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 136, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 144, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 152, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 160, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 168, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 176, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 184, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 192, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 200, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 208, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 216, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 224, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 232, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 240, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 248, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 152, 256, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 16, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 24, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 32, 1, 1, 0xc100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 40, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 48, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 56, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 64, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 72, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 80, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 88, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 96, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 104, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 112, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 120, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 128, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 136, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 144, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 152, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 160, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 168, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 176, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 184, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 192, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 200, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 208, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 216, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 224, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 232, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 240, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 248, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 160, 256, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 16, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 24, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 32, 1, 1, 0xc100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 40, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 48, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 56, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 64, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 72, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 80, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 88, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 96, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 104, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 112, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 120, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 128, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 136, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 144, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 152, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 160, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 168, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 176, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 184, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 192, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 200, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 208, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 216, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 224, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 232, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 240, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 248, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 168, 256, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 16, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 24, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 32, 1, 1, 0xc100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 40, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 48, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 56, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 64, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 72, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 80, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 88, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 96, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 104, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 112, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 120, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 128, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 136, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 144, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 152, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 160, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 168, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 176, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 184, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 192, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 200, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 208, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 216, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 224, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 232, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 240, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 248, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 176, 256, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 16, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 24, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 32, 1, 1, 0xc100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 40, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 48, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 56, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 64, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 72, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 80, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 88, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 96, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 104, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 112, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 120, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 128, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 136, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 144, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 152, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 160, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 168, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 176, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 184, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 192, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 200, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 208, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 216, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 224, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 232, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 240, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 248, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 184, 256, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 16, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 24, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 32, 1, 1, 0xc100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 40, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 48, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 56, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 64, 1, 1, 0x18200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 72, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 80, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 88, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 96, 1, 1, 0x24400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 104, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 112, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 120, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 128, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 136, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 144, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 152, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 160, 1, 1, 0x3c800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 168, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 176, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 184, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 192, 1, 1, 0x48800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 200, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 208, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 216, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 224, 1, 1, 0x54800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 232, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 240, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 248, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 192, 256, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 16, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 24, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 32, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 40, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 48, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 56, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 64, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 72, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 80, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 88, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 96, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 104, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 112, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 120, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 128, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 136, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 144, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 152, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 160, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 168, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 176, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 184, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 192, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 200, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 208, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 216, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 224, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 232, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 240, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 248, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 200, 256, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 16, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 24, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 32, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 40, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 48, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 56, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 64, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 72, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 80, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 88, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 96, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 104, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 112, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 120, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 128, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 136, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 144, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 152, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 160, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 168, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 176, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 184, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 192, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 200, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 208, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 216, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 224, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 232, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 240, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 248, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 208, 256, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 16, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 24, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 32, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 40, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 48, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 56, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 64, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 72, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 80, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 88, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 96, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 104, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 112, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 120, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 128, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 136, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 144, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 152, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 160, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 168, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 176, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 184, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 192, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 200, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 208, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 216, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 224, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 232, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 240, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 248, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 216, 256, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 16, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 24, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 32, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 40, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 48, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 56, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 64, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 72, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 80, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 88, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 96, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 104, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 112, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 120, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 128, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 136, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 144, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 152, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 160, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 168, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 176, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 184, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 192, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 200, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 208, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 216, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 224, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 232, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 240, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 248, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 224, 256, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 16, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 24, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 32, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 40, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 48, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 56, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 64, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 72, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 80, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 88, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 96, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 104, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 112, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 120, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 128, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 136, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 144, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 152, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 160, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 168, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 176, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 184, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 192, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 200, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 208, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 216, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 224, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 232, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 240, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 248, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 232, 256, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 16, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 24, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 32, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 40, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 48, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 56, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 64, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 72, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 80, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 88, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 96, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 104, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 112, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 120, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 128, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 136, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 144, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 152, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 160, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 168, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 176, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 184, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 192, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 200, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 208, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 216, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 224, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 232, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 240, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 248, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 240, 256, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 16, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 24, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 32, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 40, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 48, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 56, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 64, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 72, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 80, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 88, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 96, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 104, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 112, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 120, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 128, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 136, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 144, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 152, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 160, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 168, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 176, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 184, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 192, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 200, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 208, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 216, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 224, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 232, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 240, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 248, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 248, 256, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 16, 1, 1, 0x8080 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 24, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 32, 1, 1, 0x10100 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 40, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 48, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 56, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 64, 1, 1, 0x20200 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 72, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 80, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 88, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 96, 1, 1, 0x30400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 104, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 112, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 120, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 128, 1, 1, 0x40400 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 136, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 144, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 152, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 160, 1, 1, 0x50800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 168, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 176, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 184, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 192, 1, 1, 0x60800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 200, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 208, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 216, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 224, 1, 1, 0x70800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 232, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 240, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 248, 1, 1, 0x80800 },
   { PIPE_FORMAT_R16G16B16A16_UNORM, 256, 256, 1, 1, 0x80800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 16, 1, 1, 0x480 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 16, 1, 5, 0x700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 16, 2, 1, 0x900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 16, 2, 5, 0xe00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 16, 3, 1, 0xd80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 16, 3, 5, 0x1500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 16, 4, 1, 0x1200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 16, 4, 5, 0x1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 16, 5, 1, 0x1680 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 16, 6, 1, 0x1b00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 16, 7, 1, 0x1f80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 16, 8, 1, 0x2400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 24, 1, 1, 0x880 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 32, 1, 1, 0x880 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 32, 1, 6, 0xd00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 32, 2, 1, 0x1100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 32, 2, 6, 0x1a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 32, 3, 1, 0x1980 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 32, 3, 6, 0x2700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 32, 4, 1, 0x2200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 32, 4, 6, 0x3400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 32, 5, 1, 0x2a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 32, 6, 1, 0x3300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 32, 7, 1, 0x3b80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 32, 8, 1, 0x4400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 40, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 48, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 48, 1, 6, 0x1780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 48, 2, 1, 0x2100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 48, 2, 6, 0x2f00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 48, 3, 1, 0x3180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 48, 3, 6, 0x4680 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 48, 4, 1, 0x4200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 48, 4, 6, 0x5e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 48, 5, 1, 0x5280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 48, 6, 1, 0x6300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 48, 7, 1, 0x7380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 48, 8, 1, 0x8400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 56, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 64, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 64, 1, 7, 0x1880 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 64, 2, 1, 0x2100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 64, 2, 7, 0x3100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 64, 3, 1, 0x3180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 64, 3, 7, 0x4980 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 64, 4, 1, 0x4200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 64, 4, 7, 0x6200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 64, 5, 1, 0x5280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 64, 6, 1, 0x6300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 64, 7, 1, 0x7380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 64, 8, 1, 0x8400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 72, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 80, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 80, 1, 7, 0x2d80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 80, 2, 1, 0x4100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 80, 2, 7, 0x5b00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 80, 3, 1, 0x6180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 80, 3, 7, 0x8880 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 80, 4, 1, 0x8200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 80, 4, 7, 0xb600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 80, 5, 1, 0xa280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 80, 6, 1, 0xc300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 80, 7, 1, 0xe380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 80, 8, 1, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 88, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 96, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 96, 1, 7, 0x2d80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 96, 2, 1, 0x4100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 96, 2, 7, 0x5b00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 96, 3, 1, 0x6180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 96, 3, 7, 0x8880 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 96, 4, 1, 0x8200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 96, 4, 7, 0xb600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 96, 5, 1, 0xa280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 96, 6, 1, 0xc300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 96, 7, 1, 0xe380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 96, 8, 1, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 104, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 112, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 112, 1, 7, 0x2d80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 112, 2, 1, 0x4100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 112, 2, 7, 0x5b00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 112, 3, 1, 0x6180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 112, 3, 7, 0x8880 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 112, 4, 1, 0x8200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 112, 4, 7, 0xb600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 112, 5, 1, 0xa280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 112, 6, 1, 0xc300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 112, 7, 1, 0xe380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 112, 8, 1, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 120, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 128, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 128, 1, 8, 0x2e80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 128, 2, 1, 0x4100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 128, 2, 8, 0x5d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 128, 3, 1, 0x6180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 128, 3, 8, 0x8b80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 128, 4, 1, 0x8200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 128, 4, 8, 0xba00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 128, 5, 1, 0xa280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 128, 6, 1, 0xc300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 128, 7, 1, 0xe380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 128, 8, 1, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 136, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 144, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 144, 1, 8, 0x5900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 144, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 144, 2, 8, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 144, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 144, 3, 8, 0x18600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 144, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 144, 4, 8, 0x20800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 144, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 144, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 144, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 144, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 152, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 160, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 160, 1, 8, 0x5900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 160, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 160, 2, 8, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 160, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 160, 3, 8, 0x18600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 160, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 160, 4, 8, 0x20800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 160, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 160, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 160, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 160, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 168, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 176, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 176, 1, 8, 0x5900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 176, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 176, 2, 8, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 176, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 176, 3, 8, 0x18600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 176, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 176, 4, 8, 0x20800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 176, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 176, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 176, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 176, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 184, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 192, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 192, 1, 8, 0x5900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 192, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 192, 2, 8, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 192, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 192, 3, 8, 0x18600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 192, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 192, 4, 8, 0x20800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 192, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 192, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 192, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 192, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 200, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 208, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 208, 1, 8, 0x5900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 208, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 208, 2, 8, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 208, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 208, 3, 8, 0x18600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 208, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 208, 4, 8, 0x20800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 208, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 208, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 208, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 208, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 216, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 224, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 224, 1, 8, 0x5900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 224, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 224, 2, 8, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 224, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 224, 3, 8, 0x18600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 224, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 224, 4, 8, 0x20800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 224, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 224, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 224, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 224, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 232, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 240, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 240, 1, 8, 0x5900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 240, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 240, 2, 8, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 240, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 240, 3, 8, 0x18600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 240, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 240, 4, 8, 0x20800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 240, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 240, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 240, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 240, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 248, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 256, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 256, 1, 9, 0x5a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 256, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 256, 2, 9, 0x10500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 256, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 256, 3, 9, 0x18780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 256, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 256, 4, 9, 0x20a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 256, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 256, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 16, 256, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 16, 1, 1, 0x880 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 24, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 32, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 40, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 48, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 56, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 64, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 72, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 80, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 88, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 96, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 104, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 112, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 120, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 128, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 136, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 144, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 152, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 160, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 168, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 176, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 184, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 192, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 200, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 208, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 216, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 224, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 232, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 240, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 248, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 24, 256, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 16, 1, 1, 0x880 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 16, 1, 6, 0xd00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 16, 2, 1, 0x1100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 16, 2, 6, 0x1a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 16, 3, 1, 0x1980 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 16, 3, 6, 0x2700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 16, 4, 1, 0x2200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 16, 4, 6, 0x3400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 16, 5, 1, 0x2a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 16, 6, 1, 0x3300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 16, 7, 1, 0x3b80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 16, 8, 1, 0x4400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 24, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 32, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 32, 1, 6, 0x1780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 32, 2, 1, 0x2100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 32, 2, 6, 0x2f00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 32, 3, 1, 0x3180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 32, 3, 6, 0x4680 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 32, 4, 1, 0x4200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 32, 4, 6, 0x5e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 32, 5, 1, 0x5280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 32, 6, 1, 0x6300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 32, 7, 1, 0x7380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 32, 8, 1, 0x8400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 40, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 48, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 48, 1, 6, 0x2c80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 48, 2, 1, 0x4100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 48, 2, 6, 0x5900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 48, 3, 1, 0x6180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 48, 3, 6, 0x8580 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 48, 4, 1, 0x8200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 48, 4, 6, 0xb200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 48, 5, 1, 0xa280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 48, 6, 1, 0xc300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 48, 7, 1, 0xe380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 48, 8, 1, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 56, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 64, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 64, 1, 7, 0x2d80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 64, 2, 1, 0x4100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 64, 2, 7, 0x5b00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 64, 3, 1, 0x6180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 64, 3, 7, 0x8880 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 64, 4, 1, 0x8200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 64, 4, 7, 0xb600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 64, 5, 1, 0xa280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 64, 6, 1, 0xc300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 64, 7, 1, 0xe380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 64, 8, 1, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 72, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 80, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 80, 1, 7, 0x5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 80, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 80, 2, 7, 0x10300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 80, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 80, 3, 7, 0x18480 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 80, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 80, 4, 7, 0x20600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 80, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 80, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 80, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 80, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 88, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 96, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 96, 1, 7, 0x5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 96, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 96, 2, 7, 0x10300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 96, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 96, 3, 7, 0x18480 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 96, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 96, 4, 7, 0x20600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 96, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 96, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 96, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 96, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 104, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 112, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 112, 1, 7, 0x5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 112, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 112, 2, 7, 0x10300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 112, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 112, 3, 7, 0x18480 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 112, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 112, 4, 7, 0x20600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 112, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 112, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 112, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 112, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 120, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 128, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 128, 1, 8, 0x5900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 128, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 128, 2, 8, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 128, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 128, 3, 8, 0x18600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 128, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 128, 4, 8, 0x20800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 128, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 128, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 128, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 128, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 136, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 144, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 144, 1, 8, 0xae80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 144, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 144, 2, 8, 0x18500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 144, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 144, 3, 8, 0x24780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 144, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 144, 4, 8, 0x30a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 144, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 144, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 144, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 144, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 152, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 160, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 160, 1, 8, 0xae80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 160, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 160, 2, 8, 0x18500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 160, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 160, 3, 8, 0x24780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 160, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 160, 4, 8, 0x30a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 160, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 160, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 160, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 160, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 168, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 176, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 176, 1, 8, 0xae80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 176, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 176, 2, 8, 0x18500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 176, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 176, 3, 8, 0x24780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 176, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 176, 4, 8, 0x30a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 176, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 176, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 176, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 176, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 184, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 192, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 192, 1, 8, 0xae80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 192, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 192, 2, 8, 0x18500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 192, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 192, 3, 8, 0x24780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 192, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 192, 4, 8, 0x30a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 192, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 192, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 192, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 192, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 200, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 208, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 208, 1, 8, 0xae80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 208, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 208, 2, 8, 0x18500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 208, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 208, 3, 8, 0x24780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 208, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 208, 4, 8, 0x30a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 208, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 208, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 208, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 208, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 216, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 224, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 224, 1, 8, 0xae80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 224, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 224, 2, 8, 0x18500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 224, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 224, 3, 8, 0x24780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 224, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 224, 4, 8, 0x30a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 224, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 224, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 224, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 224, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 232, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 240, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 240, 1, 8, 0xae80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 240, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 240, 2, 8, 0x18500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 240, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 240, 3, 8, 0x24780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 240, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 240, 4, 8, 0x30a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 240, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 240, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 240, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 248, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 256, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 256, 1, 9, 0xaf80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 256, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 256, 2, 9, 0x18600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 256, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 256, 3, 9, 0x24900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 256, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 256, 4, 9, 0x30c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 256, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 256, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 32, 256, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 24, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 32, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 40, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 48, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 56, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 64, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 72, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 80, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 88, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 96, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 104, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 112, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 120, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 128, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 136, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 144, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 152, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 160, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 168, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 176, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 184, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 192, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 200, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 208, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 216, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 224, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 232, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 240, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 248, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 40, 256, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 16, 1, 6, 0x1780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 16, 2, 1, 0x2100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 16, 2, 6, 0x2f00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 16, 3, 1, 0x3180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 16, 3, 6, 0x4680 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 16, 4, 1, 0x4200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 16, 4, 6, 0x5e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 16, 5, 1, 0x5280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 16, 6, 1, 0x6300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 16, 7, 1, 0x7380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 16, 8, 1, 0x8400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 24, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 32, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 32, 1, 6, 0x2c80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 32, 2, 1, 0x4100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 32, 2, 6, 0x5900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 32, 3, 1, 0x6180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 32, 3, 6, 0x8580 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 32, 4, 1, 0x8200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 32, 4, 6, 0xb200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 32, 5, 1, 0xa280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 32, 6, 1, 0xc300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 32, 7, 1, 0xe380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 32, 8, 1, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 40, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 48, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 48, 1, 6, 0x5700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 48, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 48, 2, 6, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 48, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 48, 3, 6, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 48, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 48, 4, 6, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 48, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 48, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 48, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 48, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 56, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 64, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 64, 1, 7, 0x5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 64, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 64, 2, 7, 0x10300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 64, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 64, 3, 7, 0x18480 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 64, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 64, 4, 7, 0x20600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 64, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 64, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 64, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 64, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 72, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 80, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 80, 1, 7, 0xad80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 80, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 80, 2, 7, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 80, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 80, 3, 7, 0x24600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 80, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 80, 4, 7, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 80, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 80, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 80, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 80, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 88, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 96, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 96, 1, 7, 0xad80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 96, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 96, 2, 7, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 96, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 96, 3, 7, 0x24600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 96, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 96, 4, 7, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 96, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 96, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 96, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 96, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 104, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 112, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 112, 1, 7, 0xad80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 112, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 112, 2, 7, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 112, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 112, 3, 7, 0x24600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 112, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 112, 4, 7, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 112, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 112, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 112, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 112, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 120, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 128, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 128, 1, 8, 0xae80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 128, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 128, 2, 8, 0x18500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 128, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 128, 3, 8, 0x24780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 128, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 128, 4, 8, 0x30a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 128, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 128, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 128, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 128, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 136, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 144, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 144, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 144, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 144, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 144, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 144, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 144, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 144, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 144, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 144, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 144, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 144, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 152, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 160, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 160, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 160, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 160, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 160, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 160, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 160, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 160, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 160, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 160, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 160, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 160, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 168, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 176, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 176, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 176, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 176, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 176, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 176, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 176, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 176, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 176, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 176, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 176, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 176, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 184, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 192, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 192, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 192, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 192, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 192, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 192, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 192, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 192, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 192, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 192, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 192, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 192, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 200, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 208, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 208, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 208, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 208, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 208, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 208, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 208, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 208, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 208, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 208, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 208, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 208, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 216, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 224, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 224, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 224, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 224, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 224, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 224, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 224, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 224, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 224, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 224, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 224, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 224, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 232, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 240, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 240, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 240, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 240, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 240, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 240, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 240, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 240, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 240, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 240, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 240, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 248, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 256, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 256, 1, 9, 0x15b00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 256, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 256, 2, 9, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 256, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 256, 3, 9, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 256, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 256, 4, 9, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 256, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 256, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 48, 256, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 24, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 32, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 40, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 48, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 56, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 64, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 72, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 80, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 88, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 96, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 104, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 112, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 120, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 128, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 136, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 144, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 152, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 160, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 168, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 176, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 184, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 192, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 200, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 208, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 216, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 224, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 232, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 240, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 248, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 56, 256, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 16, 1, 7, 0x1880 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 16, 2, 1, 0x2100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 16, 2, 7, 0x3100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 16, 3, 1, 0x3180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 16, 3, 7, 0x4980 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 16, 4, 1, 0x4200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 16, 4, 7, 0x6200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 16, 5, 1, 0x5280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 16, 6, 1, 0x6300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 16, 7, 1, 0x7380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 16, 8, 1, 0x8400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 24, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 32, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 32, 1, 7, 0x2d80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 32, 2, 1, 0x4100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 32, 2, 7, 0x5b00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 32, 3, 1, 0x6180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 32, 3, 7, 0x8880 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 32, 4, 1, 0x8200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 32, 4, 7, 0xb600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 32, 5, 1, 0xa280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 32, 6, 1, 0xc300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 32, 7, 1, 0xe380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 32, 8, 1, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 40, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 48, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 48, 1, 7, 0x5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 48, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 48, 2, 7, 0x10300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 48, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 48, 3, 7, 0x18480 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 48, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 48, 4, 7, 0x20600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 48, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 48, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 48, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 48, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 56, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 64, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 64, 1, 7, 0x5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 64, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 64, 2, 7, 0x10300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 64, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 64, 3, 7, 0x18480 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 64, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 64, 4, 7, 0x20600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 64, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 64, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 64, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 64, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 72, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 80, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 80, 1, 7, 0xad80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 80, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 80, 2, 7, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 80, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 80, 3, 7, 0x24600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 80, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 80, 4, 7, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 80, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 80, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 80, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 80, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 88, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 96, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 96, 1, 7, 0xad80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 96, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 96, 2, 7, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 96, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 96, 3, 7, 0x24600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 96, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 96, 4, 7, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 96, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 96, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 96, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 96, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 104, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 112, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 112, 1, 7, 0xad80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 112, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 112, 2, 7, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 112, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 112, 3, 7, 0x24600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 112, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 112, 4, 7, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 112, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 112, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 112, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 112, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 120, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 128, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 128, 1, 8, 0xae80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 128, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 128, 2, 8, 0x18500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 128, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 128, 3, 8, 0x24780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 128, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 128, 4, 8, 0x30a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 128, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 128, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 128, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 128, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 136, 1, 1, 0xc200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 144, 1, 1, 0xc200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 144, 1, 8, 0x11a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 144, 2, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 144, 2, 8, 0x28700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 144, 3, 1, 0x24600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 144, 3, 8, 0x3ca80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 144, 4, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 144, 4, 8, 0x50e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 144, 5, 1, 0x3ca00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 144, 6, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 144, 7, 1, 0x54e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 144, 8, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 152, 1, 1, 0xc200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 160, 1, 1, 0xc200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 160, 1, 8, 0x11a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 160, 2, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 160, 2, 8, 0x28700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 160, 3, 1, 0x24600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 160, 3, 8, 0x3ca80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 160, 4, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 160, 4, 8, 0x50e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 160, 5, 1, 0x3ca00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 160, 6, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 160, 7, 1, 0x54e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 160, 8, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 168, 1, 1, 0xc200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 176, 1, 1, 0xc200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 176, 1, 8, 0x11a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 176, 2, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 176, 2, 8, 0x28700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 176, 3, 1, 0x24600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 176, 3, 8, 0x3ca80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 176, 4, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 176, 4, 8, 0x50e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 176, 5, 1, 0x3ca00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 176, 6, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 176, 7, 1, 0x54e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 176, 8, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 184, 1, 1, 0xc200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 192, 1, 1, 0xc200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 192, 1, 8, 0x11a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 192, 2, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 192, 2, 8, 0x28700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 192, 3, 1, 0x24600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 192, 3, 8, 0x3ca80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 192, 4, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 192, 4, 8, 0x50e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 192, 5, 1, 0x3ca00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 192, 6, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 192, 7, 1, 0x54e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 192, 8, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 200, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 208, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 208, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 208, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 208, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 208, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 208, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 208, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 208, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 208, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 208, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 208, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 208, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 216, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 224, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 224, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 224, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 224, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 224, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 224, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 224, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 224, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 224, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 224, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 224, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 224, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 232, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 240, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 240, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 240, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 240, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 240, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 240, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 240, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 240, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 240, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 240, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 240, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 248, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 256, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 256, 1, 9, 0x15b00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 256, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 256, 2, 9, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 256, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 256, 3, 9, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 256, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 256, 4, 9, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 256, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 256, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 64, 256, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 24, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 32, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 40, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 48, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 56, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 64, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 72, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 80, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 88, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 96, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 104, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 112, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 120, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 128, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 136, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 144, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 152, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 160, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 168, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 176, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 184, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 192, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 200, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 208, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 216, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 224, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 232, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 240, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 248, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 72, 256, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 16, 1, 7, 0x2d80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 16, 2, 1, 0x4100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 16, 2, 7, 0x5b00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 16, 3, 1, 0x6180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 16, 3, 7, 0x8880 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 16, 4, 1, 0x8200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 16, 4, 7, 0xb600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 16, 5, 1, 0xa280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 16, 6, 1, 0xc300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 16, 7, 1, 0xe380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 16, 8, 1, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 24, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 32, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 32, 1, 7, 0x5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 32, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 32, 2, 7, 0x10300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 32, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 32, 3, 7, 0x18480 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 32, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 32, 4, 7, 0x20600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 32, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 32, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 32, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 32, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 40, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 48, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 48, 1, 7, 0xad80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 48, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 48, 2, 7, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 48, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 48, 3, 7, 0x24600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 48, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 48, 4, 7, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 48, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 48, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 48, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 48, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 56, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 64, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 64, 1, 7, 0xad80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 64, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 64, 2, 7, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 64, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 64, 3, 7, 0x24600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 64, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 64, 4, 7, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 64, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 64, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 64, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 64, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 72, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 80, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 80, 1, 7, 0x15900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 80, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 80, 2, 7, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 80, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 80, 3, 7, 0x48900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 80, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 80, 4, 7, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 80, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 80, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 80, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 80, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 88, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 96, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 96, 1, 7, 0x15900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 96, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 96, 2, 7, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 96, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 96, 3, 7, 0x48900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 96, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 96, 4, 7, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 96, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 96, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 96, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 96, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 104, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 112, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 112, 1, 7, 0x15900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 112, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 112, 2, 7, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 112, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 112, 3, 7, 0x48900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 112, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 112, 4, 7, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 112, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 112, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 112, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 112, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 120, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 128, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 128, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 128, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 128, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 128, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 128, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 128, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 128, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 128, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 128, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 128, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 128, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 136, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 144, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 144, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 144, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 144, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 144, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 144, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 144, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 144, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 144, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 144, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 144, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 144, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 152, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 160, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 160, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 160, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 160, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 160, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 160, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 160, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 160, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 160, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 160, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 160, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 160, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 168, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 176, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 176, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 176, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 176, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 176, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 176, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 176, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 176, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 176, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 176, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 176, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 176, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 184, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 192, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 192, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 192, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 192, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 192, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 192, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 192, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 192, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 192, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 192, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 192, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 192, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 200, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 208, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 208, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 208, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 208, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 208, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 208, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 208, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 208, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 208, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 208, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 208, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 208, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 216, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 224, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 224, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 224, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 224, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 224, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 224, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 224, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 224, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 224, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 224, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 224, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 224, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 232, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 240, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 240, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 240, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 240, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 240, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 240, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 240, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 240, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 240, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 240, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 240, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 248, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 256, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 256, 1, 9, 0x2b280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 256, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 256, 2, 9, 0x58d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 256, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 256, 3, 9, 0x85380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 256, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 256, 4, 9, 0xb1a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 256, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 256, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 80, 256, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 24, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 32, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 40, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 48, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 56, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 64, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 72, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 80, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 88, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 96, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 104, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 112, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 120, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 128, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 136, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 144, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 152, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 160, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 168, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 176, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 184, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 192, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 200, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 208, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 216, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 224, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 232, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 240, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 248, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 88, 256, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 16, 1, 7, 0x2d80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 16, 2, 1, 0x4100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 16, 2, 7, 0x5b00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 16, 3, 1, 0x6180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 16, 3, 7, 0x8880 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 16, 4, 1, 0x8200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 16, 4, 7, 0xb600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 16, 5, 1, 0xa280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 16, 6, 1, 0xc300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 16, 7, 1, 0xe380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 16, 8, 1, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 24, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 32, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 32, 1, 7, 0x5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 32, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 32, 2, 7, 0x10300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 32, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 32, 3, 7, 0x18480 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 32, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 32, 4, 7, 0x20600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 32, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 32, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 32, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 32, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 40, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 48, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 48, 1, 7, 0xad80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 48, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 48, 2, 7, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 48, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 48, 3, 7, 0x24600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 48, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 48, 4, 7, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 48, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 48, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 48, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 48, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 56, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 64, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 64, 1, 7, 0xad80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 64, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 64, 2, 7, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 64, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 64, 3, 7, 0x24600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 64, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 64, 4, 7, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 64, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 64, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 64, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 64, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 72, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 80, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 80, 1, 7, 0x15900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 80, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 80, 2, 7, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 80, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 80, 3, 7, 0x48900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 80, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 80, 4, 7, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 80, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 80, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 80, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 80, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 88, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 96, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 96, 1, 7, 0x15900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 96, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 96, 2, 7, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 96, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 96, 3, 7, 0x48900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 96, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 96, 4, 7, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 96, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 96, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 96, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 96, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 104, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 112, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 112, 1, 7, 0x15900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 112, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 112, 2, 7, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 112, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 112, 3, 7, 0x48900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 112, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 112, 4, 7, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 112, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 112, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 112, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 112, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 120, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 128, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 128, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 128, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 128, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 128, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 128, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 128, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 128, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 128, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 128, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 128, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 128, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 136, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 144, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 144, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 144, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 144, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 144, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 144, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 144, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 144, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 144, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 144, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 144, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 144, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 152, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 160, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 160, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 160, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 160, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 160, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 160, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 160, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 160, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 160, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 160, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 160, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 160, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 168, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 176, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 176, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 176, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 176, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 176, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 176, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 176, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 176, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 176, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 176, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 176, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 176, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 184, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 192, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 192, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 192, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 192, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 192, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 192, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 192, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 192, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 192, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 192, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 192, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 192, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 200, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 208, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 208, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 208, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 208, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 208, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 208, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 208, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 208, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 208, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 208, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 208, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 208, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 216, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 224, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 224, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 224, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 224, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 224, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 224, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 224, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 224, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 224, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 224, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 224, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 224, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 232, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 240, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 240, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 240, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 240, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 240, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 240, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 240, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 240, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 240, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 240, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 240, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 248, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 256, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 256, 1, 9, 0x2b280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 256, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 256, 2, 9, 0x58d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 256, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 256, 3, 9, 0x85380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 256, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 256, 4, 9, 0xb1a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 256, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 256, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 96, 256, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 24, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 32, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 40, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 48, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 56, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 64, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 72, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 80, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 88, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 96, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 104, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 112, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 120, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 128, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 136, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 144, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 152, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 160, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 168, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 176, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 184, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 192, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 200, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 208, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 216, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 224, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 232, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 240, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 248, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 104, 256, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 16, 1, 7, 0x2d80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 16, 2, 1, 0x4100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 16, 2, 7, 0x5b00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 16, 3, 1, 0x6180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 16, 3, 7, 0x8880 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 16, 4, 1, 0x8200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 16, 4, 7, 0xb600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 16, 5, 1, 0xa280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 16, 6, 1, 0xc300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 16, 7, 1, 0xe380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 16, 8, 1, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 24, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 32, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 32, 1, 7, 0x5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 32, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 32, 2, 7, 0x10300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 32, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 32, 3, 7, 0x18480 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 32, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 32, 4, 7, 0x20600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 32, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 32, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 32, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 32, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 40, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 48, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 48, 1, 7, 0xad80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 48, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 48, 2, 7, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 48, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 48, 3, 7, 0x24600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 48, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 48, 4, 7, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 48, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 48, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 48, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 48, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 56, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 64, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 64, 1, 7, 0xad80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 64, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 64, 2, 7, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 64, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 64, 3, 7, 0x24600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 64, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 64, 4, 7, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 64, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 64, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 64, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 64, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 72, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 80, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 80, 1, 7, 0x15900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 80, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 80, 2, 7, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 80, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 80, 3, 7, 0x48900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 80, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 80, 4, 7, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 80, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 80, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 80, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 80, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 88, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 96, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 96, 1, 7, 0x15900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 96, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 96, 2, 7, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 96, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 96, 3, 7, 0x48900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 96, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 96, 4, 7, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 96, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 96, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 96, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 96, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 104, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 112, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 112, 1, 7, 0x15900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 112, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 112, 2, 7, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 112, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 112, 3, 7, 0x48900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 112, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 112, 4, 7, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 112, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 112, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 112, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 112, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 120, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 128, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 128, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 128, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 128, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 128, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 128, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 128, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 128, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 128, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 128, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 128, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 128, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 136, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 144, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 144, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 144, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 144, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 144, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 144, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 144, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 144, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 144, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 144, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 144, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 144, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 152, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 160, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 160, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 160, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 160, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 160, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 160, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 160, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 160, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 160, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 160, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 160, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 160, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 168, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 176, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 176, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 176, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 176, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 176, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 176, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 176, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 176, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 176, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 176, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 176, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 176, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 184, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 192, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 192, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 192, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 192, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 192, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 192, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 192, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 192, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 192, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 192, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 192, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 192, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 200, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 208, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 208, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 208, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 208, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 208, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 208, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 208, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 208, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 208, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 208, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 208, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 208, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 216, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 224, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 224, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 224, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 224, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 224, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 224, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 224, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 224, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 224, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 224, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 224, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 224, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 232, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 240, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 240, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 240, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 240, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 240, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 240, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 240, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 240, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 240, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 240, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 240, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 248, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 256, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 256, 1, 9, 0x2b280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 256, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 256, 2, 9, 0x58d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 256, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 256, 3, 9, 0x85380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 256, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 256, 4, 9, 0xb1a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 256, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 256, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 112, 256, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 24, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 32, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 40, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 48, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 56, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 64, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 72, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 80, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 88, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 96, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 104, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 112, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 120, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 128, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 136, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 144, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 152, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 160, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 168, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 176, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 184, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 192, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 200, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 208, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 216, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 224, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 232, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 240, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 248, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 120, 256, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 16, 1, 8, 0x2e80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 16, 2, 1, 0x4100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 16, 2, 8, 0x5d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 16, 3, 1, 0x6180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 16, 3, 8, 0x8b80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 16, 4, 1, 0x8200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 16, 4, 8, 0xba00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 16, 5, 1, 0xa280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 16, 6, 1, 0xc300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 16, 7, 1, 0xe380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 16, 8, 1, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 24, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 32, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 32, 1, 8, 0x5900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 32, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 32, 2, 8, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 32, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 32, 3, 8, 0x18600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 32, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 32, 4, 8, 0x20800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 32, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 32, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 32, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 32, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 40, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 48, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 48, 1, 8, 0xae80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 48, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 48, 2, 8, 0x18500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 48, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 48, 3, 8, 0x24780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 48, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 48, 4, 8, 0x30a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 48, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 48, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 48, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 48, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 56, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 64, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 64, 1, 8, 0xae80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 64, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 64, 2, 8, 0x18500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 64, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 64, 3, 8, 0x24780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 64, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 64, 4, 8, 0x30a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 64, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 64, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 64, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 64, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 72, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 80, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 80, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 80, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 80, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 80, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 80, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 80, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 80, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 80, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 80, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 80, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 80, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 88, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 96, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 96, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 96, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 96, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 96, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 96, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 96, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 96, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 96, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 96, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 96, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 96, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 104, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 112, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 112, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 112, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 112, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 112, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 112, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 112, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 112, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 112, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 112, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 112, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 112, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 120, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 128, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 128, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 128, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 128, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 128, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 128, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 128, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 128, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 128, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 128, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 128, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 128, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 136, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 144, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 144, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 144, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 144, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 144, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 144, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 144, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 144, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 144, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 144, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 144, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 144, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 152, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 160, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 160, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 160, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 160, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 160, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 160, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 160, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 160, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 160, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 160, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 160, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 160, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 168, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 176, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 176, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 176, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 176, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 176, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 176, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 176, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 176, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 176, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 176, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 176, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 176, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 184, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 192, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 192, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 192, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 192, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 192, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 192, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 192, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 192, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 192, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 192, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 192, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 192, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 200, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 208, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 208, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 208, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 208, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 208, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 208, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 208, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 208, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 208, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 208, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 208, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 208, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 216, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 224, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 224, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 224, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 224, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 224, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 224, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 224, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 224, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 224, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 224, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 224, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 224, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 232, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 240, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 240, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 240, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 240, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 240, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 240, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 240, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 240, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 240, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 240, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 240, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 248, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 256, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 256, 1, 9, 0x2b280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 256, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 256, 2, 9, 0x58d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 256, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 256, 3, 9, 0x85380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 256, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 256, 4, 9, 0xb1a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 256, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 256, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 128, 256, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 24, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 32, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 40, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 48, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 56, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 64, 1, 1, 0xc200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 72, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 80, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 88, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 96, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 104, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 112, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 120, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 128, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 136, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 144, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 152, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 160, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 168, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 176, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 184, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 192, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 200, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 208, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 216, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 224, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 232, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 240, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 248, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 136, 256, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 16, 1, 8, 0x5900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 16, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 16, 2, 8, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 16, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 16, 3, 8, 0x18600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 16, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 16, 4, 8, 0x20800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 16, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 16, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 16, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 16, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 24, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 32, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 32, 1, 8, 0xae80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 32, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 32, 2, 8, 0x18500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 32, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 32, 3, 8, 0x24780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 32, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 32, 4, 8, 0x30a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 32, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 32, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 32, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 32, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 40, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 48, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 48, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 48, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 48, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 48, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 48, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 48, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 48, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 48, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 48, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 48, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 48, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 56, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 64, 1, 1, 0xc200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 64, 1, 8, 0x11a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 64, 2, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 64, 2, 8, 0x28700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 64, 3, 1, 0x24600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 64, 3, 8, 0x3ca80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 64, 4, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 64, 4, 8, 0x50e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 64, 5, 1, 0x3ca00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 64, 6, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 64, 7, 1, 0x54e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 64, 8, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 72, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 80, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 80, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 80, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 80, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 80, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 80, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 80, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 80, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 80, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 80, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 80, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 80, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 88, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 96, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 96, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 96, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 96, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 96, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 96, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 96, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 96, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 96, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 96, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 96, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 96, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 104, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 112, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 112, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 112, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 112, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 112, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 112, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 112, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 112, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 112, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 112, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 112, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 112, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 120, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 128, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 128, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 128, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 128, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 128, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 128, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 128, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 128, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 128, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 128, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 128, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 128, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 136, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 144, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 144, 1, 8, 0x3e100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 144, 2, 1, 0x49000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 144, 2, 8, 0x81600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 144, 3, 1, 0x6d800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 144, 3, 8, 0xc2100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 144, 4, 1, 0x92000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 144, 4, 8, 0x102c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 144, 5, 1, 0xb6800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 144, 6, 1, 0xdb000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 144, 7, 1, 0xff800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 144, 8, 1, 0x124000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 152, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 160, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 160, 1, 8, 0x3e100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 160, 2, 1, 0x49000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 160, 2, 8, 0x81600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 160, 3, 1, 0x6d800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 160, 3, 8, 0xc2100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 160, 4, 1, 0x92000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 160, 4, 8, 0x102c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 160, 5, 1, 0xb6800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 160, 6, 1, 0xdb000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 160, 7, 1, 0xff800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 160, 8, 1, 0x124000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 168, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 176, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 176, 1, 8, 0x3e100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 176, 2, 1, 0x49000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 176, 2, 8, 0x81600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 176, 3, 1, 0x6d800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 176, 3, 8, 0xc2100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 176, 4, 1, 0x92000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 176, 4, 8, 0x102c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 176, 5, 1, 0xb6800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 176, 6, 1, 0xdb000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 176, 7, 1, 0xff800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 176, 8, 1, 0x124000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 184, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 192, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 192, 1, 8, 0x3e100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 192, 2, 1, 0x49000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 192, 2, 8, 0x81600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 192, 3, 1, 0x6d800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 192, 3, 8, 0xc2100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 192, 4, 1, 0x92000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 192, 4, 8, 0x102c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 192, 5, 1, 0xb6800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 192, 6, 1, 0xdb000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 192, 7, 1, 0xff800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 192, 8, 1, 0x124000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 200, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 208, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 208, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 208, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 208, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 208, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 208, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 208, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 208, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 208, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 208, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 208, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 208, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 216, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 224, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 224, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 224, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 224, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 224, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 224, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 224, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 224, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 224, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 224, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 224, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 224, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 232, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 240, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 240, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 240, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 240, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 240, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 240, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 240, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 240, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 240, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 240, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 240, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 248, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 256, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 256, 1, 9, 0x4a200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 256, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 256, 2, 9, 0x99700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 256, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 256, 3, 9, 0xe6280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 256, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 256, 4, 9, 0x132e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 256, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 256, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 144, 256, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 24, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 32, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 40, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 48, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 56, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 64, 1, 1, 0xc200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 72, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 80, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 88, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 96, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 104, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 112, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 120, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 128, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 136, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 144, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 152, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 160, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 168, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 176, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 184, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 192, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 200, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 208, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 216, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 224, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 232, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 240, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 248, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 152, 256, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 16, 1, 8, 0x5900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 16, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 16, 2, 8, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 16, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 16, 3, 8, 0x18600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 16, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 16, 4, 8, 0x20800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 16, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 16, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 16, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 16, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 24, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 32, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 32, 1, 8, 0xae80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 32, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 32, 2, 8, 0x18500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 32, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 32, 3, 8, 0x24780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 32, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 32, 4, 8, 0x30a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 32, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 32, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 32, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 32, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 40, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 48, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 48, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 48, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 48, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 48, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 48, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 48, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 48, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 48, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 48, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 48, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 48, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 56, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 64, 1, 1, 0xc200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 64, 1, 8, 0x11a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 64, 2, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 64, 2, 8, 0x28700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 64, 3, 1, 0x24600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 64, 3, 8, 0x3ca80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 64, 4, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 64, 4, 8, 0x50e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 64, 5, 1, 0x3ca00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 64, 6, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 64, 7, 1, 0x54e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 64, 8, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 72, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 80, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 80, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 80, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 80, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 80, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 80, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 80, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 80, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 80, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 80, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 80, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 80, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 88, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 96, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 96, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 96, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 96, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 96, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 96, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 96, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 96, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 96, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 96, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 96, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 96, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 104, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 112, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 112, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 112, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 112, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 112, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 112, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 112, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 112, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 112, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 112, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 112, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 112, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 120, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 128, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 128, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 128, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 128, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 128, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 128, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 128, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 128, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 128, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 128, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 128, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 128, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 136, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 144, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 144, 1, 8, 0x3e100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 144, 2, 1, 0x49000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 144, 2, 8, 0x81600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 144, 3, 1, 0x6d800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 144, 3, 8, 0xc2100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 144, 4, 1, 0x92000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 144, 4, 8, 0x102c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 144, 5, 1, 0xb6800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 144, 6, 1, 0xdb000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 144, 7, 1, 0xff800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 144, 8, 1, 0x124000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 152, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 160, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 160, 1, 8, 0x3e100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 160, 2, 1, 0x49000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 160, 2, 8, 0x81600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 160, 3, 1, 0x6d800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 160, 3, 8, 0xc2100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 160, 4, 1, 0x92000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 160, 4, 8, 0x102c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 160, 5, 1, 0xb6800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 160, 6, 1, 0xdb000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 160, 7, 1, 0xff800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 160, 8, 1, 0x124000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 168, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 176, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 176, 1, 8, 0x3e100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 176, 2, 1, 0x49000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 176, 2, 8, 0x81600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 176, 3, 1, 0x6d800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 176, 3, 8, 0xc2100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 176, 4, 1, 0x92000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 176, 4, 8, 0x102c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 176, 5, 1, 0xb6800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 176, 6, 1, 0xdb000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 176, 7, 1, 0xff800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 176, 8, 1, 0x124000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 184, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 192, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 192, 1, 8, 0x3e100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 192, 2, 1, 0x49000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 192, 2, 8, 0x81600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 192, 3, 1, 0x6d800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 192, 3, 8, 0xc2100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 192, 4, 1, 0x92000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 192, 4, 8, 0x102c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 192, 5, 1, 0xb6800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 192, 6, 1, 0xdb000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 192, 7, 1, 0xff800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 192, 8, 1, 0x124000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 200, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 208, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 208, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 208, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 208, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 208, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 208, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 208, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 208, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 208, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 208, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 208, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 208, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 216, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 224, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 224, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 224, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 224, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 224, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 224, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 224, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 224, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 224, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 224, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 224, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 224, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 232, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 240, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 240, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 240, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 240, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 240, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 240, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 240, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 240, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 240, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 240, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 240, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 248, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 256, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 256, 1, 9, 0x4a200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 256, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 256, 2, 9, 0x99700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 256, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 256, 3, 9, 0xe6280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 256, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 256, 4, 9, 0x132e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 256, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 256, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 160, 256, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 24, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 32, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 40, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 48, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 56, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 64, 1, 1, 0xc200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 72, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 80, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 88, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 96, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 104, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 112, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 120, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 128, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 136, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 144, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 152, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 160, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 168, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 176, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 184, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 192, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 200, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 208, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 216, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 224, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 232, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 240, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 248, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 168, 256, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 16, 1, 8, 0x5900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 16, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 16, 2, 8, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 16, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 16, 3, 8, 0x18600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 16, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 16, 4, 8, 0x20800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 16, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 16, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 16, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 16, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 24, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 32, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 32, 1, 8, 0xae80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 32, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 32, 2, 8, 0x18500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 32, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 32, 3, 8, 0x24780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 32, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 32, 4, 8, 0x30a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 32, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 32, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 32, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 32, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 40, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 48, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 48, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 48, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 48, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 48, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 48, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 48, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 48, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 48, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 48, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 48, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 48, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 56, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 64, 1, 1, 0xc200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 64, 1, 8, 0x11a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 64, 2, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 64, 2, 8, 0x28700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 64, 3, 1, 0x24600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 64, 3, 8, 0x3ca80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 64, 4, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 64, 4, 8, 0x50e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 64, 5, 1, 0x3ca00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 64, 6, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 64, 7, 1, 0x54e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 64, 8, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 72, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 80, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 80, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 80, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 80, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 80, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 80, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 80, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 80, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 80, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 80, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 80, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 80, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 88, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 96, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 96, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 96, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 96, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 96, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 96, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 96, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 96, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 96, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 96, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 96, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 96, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 104, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 112, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 112, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 112, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 112, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 112, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 112, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 112, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 112, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 112, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 112, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 112, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 112, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 120, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 128, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 128, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 128, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 128, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 128, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 128, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 128, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 128, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 128, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 128, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 128, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 128, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 136, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 144, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 144, 1, 8, 0x3e100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 144, 2, 1, 0x49000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 144, 2, 8, 0x81600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 144, 3, 1, 0x6d800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 144, 3, 8, 0xc2100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 144, 4, 1, 0x92000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 144, 4, 8, 0x102c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 144, 5, 1, 0xb6800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 144, 6, 1, 0xdb000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 144, 7, 1, 0xff800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 144, 8, 1, 0x124000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 152, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 160, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 160, 1, 8, 0x3e100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 160, 2, 1, 0x49000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 160, 2, 8, 0x81600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 160, 3, 1, 0x6d800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 160, 3, 8, 0xc2100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 160, 4, 1, 0x92000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 160, 4, 8, 0x102c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 160, 5, 1, 0xb6800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 160, 6, 1, 0xdb000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 160, 7, 1, 0xff800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 160, 8, 1, 0x124000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 168, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 176, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 176, 1, 8, 0x3e100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 176, 2, 1, 0x49000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 176, 2, 8, 0x81600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 176, 3, 1, 0x6d800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 176, 3, 8, 0xc2100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 176, 4, 1, 0x92000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 176, 4, 8, 0x102c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 176, 5, 1, 0xb6800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 176, 6, 1, 0xdb000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 176, 7, 1, 0xff800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 176, 8, 1, 0x124000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 184, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 192, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 192, 1, 8, 0x3e100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 192, 2, 1, 0x49000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 192, 2, 8, 0x81600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 192, 3, 1, 0x6d800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 192, 3, 8, 0xc2100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 192, 4, 1, 0x92000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 192, 4, 8, 0x102c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 192, 5, 1, 0xb6800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 192, 6, 1, 0xdb000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 192, 7, 1, 0xff800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 192, 8, 1, 0x124000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 200, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 208, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 208, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 208, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 208, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 208, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 208, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 208, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 208, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 208, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 208, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 208, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 208, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 216, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 224, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 224, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 224, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 224, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 224, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 224, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 224, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 224, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 224, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 224, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 224, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 224, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 232, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 240, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 240, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 240, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 240, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 240, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 240, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 240, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 240, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 240, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 240, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 240, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 248, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 256, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 256, 1, 9, 0x4a200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 256, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 256, 2, 9, 0x99700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 256, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 256, 3, 9, 0xe6280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 256, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 256, 4, 9, 0x132e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 256, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 256, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 176, 256, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 24, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 32, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 40, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 48, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 56, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 64, 1, 1, 0xc200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 72, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 80, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 88, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 96, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 104, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 112, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 120, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 128, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 136, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 144, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 152, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 160, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 168, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 176, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 184, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 192, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 200, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 208, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 216, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 224, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 232, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 240, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 248, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 184, 256, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 16, 1, 8, 0x5900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 16, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 16, 2, 8, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 16, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 16, 3, 8, 0x18600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 16, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 16, 4, 8, 0x20800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 16, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 16, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 16, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 16, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 24, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 32, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 32, 1, 8, 0xae80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 32, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 32, 2, 8, 0x18500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 32, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 32, 3, 8, 0x24780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 32, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 32, 4, 8, 0x30a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 32, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 32, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 32, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 32, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 40, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 48, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 48, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 48, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 48, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 48, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 48, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 48, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 48, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 48, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 48, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 48, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 48, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 56, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 64, 1, 1, 0xc200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 64, 1, 8, 0x11a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 64, 2, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 64, 2, 8, 0x28700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 64, 3, 1, 0x24600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 64, 3, 8, 0x3ca80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 64, 4, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 64, 4, 8, 0x50e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 64, 5, 1, 0x3ca00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 64, 6, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 64, 7, 1, 0x54e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 64, 8, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 72, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 80, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 80, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 80, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 80, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 80, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 80, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 80, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 80, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 80, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 80, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 80, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 80, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 88, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 96, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 96, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 96, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 96, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 96, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 96, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 96, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 96, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 96, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 96, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 96, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 96, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 104, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 112, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 112, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 112, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 112, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 112, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 112, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 112, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 112, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 112, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 112, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 112, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 112, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 120, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 128, 1, 1, 0x18400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 128, 1, 8, 0x23180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 128, 2, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 128, 2, 8, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 128, 3, 1, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 128, 3, 8, 0x6d200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 128, 4, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 128, 4, 8, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 128, 5, 1, 0x79400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 128, 6, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 128, 7, 1, 0xa9c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 128, 8, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 136, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 144, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 144, 1, 8, 0x3e100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 144, 2, 1, 0x49000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 144, 2, 8, 0x81600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 144, 3, 1, 0x6d800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 144, 3, 8, 0xc2100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 144, 4, 1, 0x92000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 144, 4, 8, 0x102c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 144, 5, 1, 0xb6800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 144, 6, 1, 0xdb000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 144, 7, 1, 0xff800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 144, 8, 1, 0x124000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 152, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 160, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 160, 1, 8, 0x3e100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 160, 2, 1, 0x49000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 160, 2, 8, 0x81600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 160, 3, 1, 0x6d800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 160, 3, 8, 0xc2100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 160, 4, 1, 0x92000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 160, 4, 8, 0x102c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 160, 5, 1, 0xb6800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 160, 6, 1, 0xdb000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 160, 7, 1, 0xff800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 160, 8, 1, 0x124000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 168, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 176, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 176, 1, 8, 0x3e100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 176, 2, 1, 0x49000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 176, 2, 8, 0x81600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 176, 3, 1, 0x6d800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 176, 3, 8, 0xc2100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 176, 4, 1, 0x92000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 176, 4, 8, 0x102c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 176, 5, 1, 0xb6800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 176, 6, 1, 0xdb000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 176, 7, 1, 0xff800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 176, 8, 1, 0x124000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 184, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 192, 1, 1, 0x24800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 192, 1, 8, 0x3e100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 192, 2, 1, 0x49000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 192, 2, 8, 0x81600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 192, 3, 1, 0x6d800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 192, 3, 8, 0xc2100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 192, 4, 1, 0x92000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 192, 4, 8, 0x102c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 192, 5, 1, 0xb6800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 192, 6, 1, 0xdb000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 192, 7, 1, 0xff800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 192, 8, 1, 0x124000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 200, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 208, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 208, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 208, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 208, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 208, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 208, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 208, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 208, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 208, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 208, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 208, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 208, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 216, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 224, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 224, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 224, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 224, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 224, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 224, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 224, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 224, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 224, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 224, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 224, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 224, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 232, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 240, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 240, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 240, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 240, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 240, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 240, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 240, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 240, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 240, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 240, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 240, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 248, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 256, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 256, 1, 9, 0x4a200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 256, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 256, 2, 9, 0x99700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 256, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 256, 3, 9, 0xe6280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 256, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 256, 4, 9, 0x132e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 256, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 256, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 192, 256, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 24, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 32, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 40, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 48, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 56, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 64, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 72, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 80, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 88, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 96, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 104, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 112, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 120, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 128, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 136, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 144, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 152, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 160, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 168, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 176, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 184, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 192, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 200, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 208, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 216, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 224, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 232, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 240, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 248, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 200, 256, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 16, 1, 8, 0x5900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 16, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 16, 2, 8, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 16, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 16, 3, 8, 0x18600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 16, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 16, 4, 8, 0x20800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 16, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 16, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 16, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 16, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 24, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 32, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 32, 1, 8, 0xae80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 32, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 32, 2, 8, 0x18500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 32, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 32, 3, 8, 0x24780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 32, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 32, 4, 8, 0x30a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 32, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 32, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 32, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 32, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 40, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 48, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 48, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 48, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 48, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 48, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 48, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 48, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 48, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 48, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 48, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 48, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 48, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 56, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 64, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 64, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 64, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 64, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 64, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 64, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 64, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 64, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 64, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 64, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 64, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 64, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 72, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 80, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 80, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 80, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 80, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 80, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 80, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 80, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 80, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 80, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 80, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 80, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 80, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 88, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 96, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 96, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 96, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 96, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 96, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 96, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 96, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 96, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 96, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 96, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 96, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 96, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 104, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 112, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 112, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 112, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 112, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 112, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 112, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 112, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 112, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 112, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 112, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 112, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 112, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 120, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 128, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 128, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 128, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 128, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 128, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 128, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 128, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 128, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 128, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 128, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 128, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 128, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 136, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 144, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 144, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 144, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 144, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 144, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 144, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 144, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 144, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 144, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 144, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 144, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 144, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 152, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 160, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 160, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 160, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 160, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 160, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 160, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 160, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 160, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 160, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 160, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 160, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 160, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 168, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 176, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 176, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 176, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 176, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 176, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 176, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 176, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 176, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 176, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 176, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 176, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 176, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 184, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 192, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 192, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 192, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 192, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 192, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 192, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 192, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 192, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 192, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 192, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 192, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 192, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 200, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 208, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 208, 1, 8, 0x56100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 208, 2, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 208, 2, 8, 0xb1600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 208, 3, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 208, 3, 8, 0x10a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 208, 4, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 208, 4, 8, 0x162c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 208, 5, 1, 0x142800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 208, 6, 1, 0x183000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 208, 7, 1, 0x1c3800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 208, 8, 1, 0x204000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 216, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 224, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 224, 1, 8, 0x56100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 224, 2, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 224, 2, 8, 0xb1600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 224, 3, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 224, 3, 8, 0x10a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 224, 4, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 224, 4, 8, 0x162c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 224, 5, 1, 0x142800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 224, 6, 1, 0x183000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 224, 7, 1, 0x1c3800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 224, 8, 1, 0x204000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 232, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 240, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 240, 1, 8, 0x56100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 240, 2, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 240, 2, 8, 0xb1600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 240, 3, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 240, 3, 8, 0x10a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 240, 4, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 240, 4, 8, 0x162c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 240, 5, 1, 0x142800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 240, 6, 1, 0x183000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 240, 7, 1, 0x1c3800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 248, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 256, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 256, 1, 9, 0x56200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 256, 2, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 256, 2, 9, 0xb1700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 256, 3, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 256, 3, 9, 0x10a280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 256, 4, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 256, 4, 9, 0x162e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 256, 5, 1, 0x142800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 256, 6, 1, 0x183000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 208, 256, 7, 1, 0x1c3800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 24, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 32, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 40, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 48, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 56, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 64, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 72, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 80, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 88, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 96, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 104, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 112, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 120, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 128, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 136, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 144, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 152, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 160, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 168, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 176, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 184, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 192, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 200, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 208, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 216, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 224, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 232, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 240, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 248, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 216, 256, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 16, 1, 8, 0x5900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 16, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 16, 2, 8, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 16, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 16, 3, 8, 0x18600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 16, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 16, 4, 8, 0x20800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 16, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 16, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 16, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 16, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 24, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 32, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 32, 1, 8, 0xae80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 32, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 32, 2, 8, 0x18500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 32, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 32, 3, 8, 0x24780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 32, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 32, 4, 8, 0x30a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 32, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 32, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 32, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 32, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 40, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 48, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 48, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 48, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 48, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 48, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 48, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 48, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 48, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 48, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 48, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 48, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 48, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 56, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 64, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 64, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 64, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 64, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 64, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 64, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 64, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 64, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 64, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 64, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 64, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 64, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 72, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 80, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 80, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 80, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 80, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 80, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 80, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 80, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 80, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 80, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 80, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 80, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 80, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 88, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 96, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 96, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 96, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 96, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 96, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 96, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 96, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 96, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 96, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 96, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 96, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 96, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 104, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 112, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 112, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 112, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 112, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 112, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 112, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 112, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 112, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 112, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 112, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 112, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 112, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 120, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 128, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 128, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 128, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 128, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 128, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 128, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 128, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 128, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 128, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 128, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 128, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 128, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 136, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 144, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 144, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 144, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 144, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 144, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 144, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 144, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 144, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 144, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 144, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 144, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 144, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 152, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 160, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 160, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 160, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 160, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 160, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 160, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 160, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 160, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 160, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 160, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 160, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 160, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 168, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 176, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 176, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 176, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 176, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 176, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 176, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 176, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 176, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 176, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 176, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 176, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 176, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 184, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 192, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 192, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 192, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 192, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 192, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 192, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 192, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 192, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 192, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 192, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 192, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 192, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 200, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 208, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 208, 1, 8, 0x56100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 208, 2, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 208, 2, 8, 0xb1600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 208, 3, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 208, 3, 8, 0x10a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 208, 4, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 208, 4, 8, 0x162c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 208, 5, 1, 0x142800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 208, 6, 1, 0x183000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 208, 7, 1, 0x1c3800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 208, 8, 1, 0x204000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 216, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 224, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 224, 1, 8, 0x56100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 224, 2, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 224, 2, 8, 0xb1600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 224, 3, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 224, 3, 8, 0x10a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 224, 4, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 224, 4, 8, 0x162c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 224, 5, 1, 0x142800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 224, 6, 1, 0x183000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 224, 7, 1, 0x1c3800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 224, 8, 1, 0x204000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 232, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 240, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 240, 1, 8, 0x56100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 240, 2, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 240, 2, 8, 0xb1600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 240, 3, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 240, 3, 8, 0x10a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 240, 4, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 240, 4, 8, 0x162c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 240, 5, 1, 0x142800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 240, 6, 1, 0x183000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 240, 7, 1, 0x1c3800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 248, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 256, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 256, 1, 9, 0x56200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 256, 2, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 256, 2, 9, 0xb1700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 256, 3, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 256, 3, 9, 0x10a280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 256, 4, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 256, 4, 9, 0x162e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 256, 5, 1, 0x142800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 256, 6, 1, 0x183000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 224, 256, 7, 1, 0x1c3800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 24, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 32, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 40, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 48, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 56, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 64, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 72, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 80, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 88, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 96, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 104, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 112, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 120, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 128, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 136, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 144, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 152, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 160, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 168, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 176, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 184, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 192, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 200, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 208, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 216, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 224, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 232, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 240, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 248, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 232, 256, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 16, 1, 8, 0x5900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 16, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 16, 2, 8, 0x10400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 16, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 16, 3, 8, 0x18600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 16, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 16, 4, 8, 0x20800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 16, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 16, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 16, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 16, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 24, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 32, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 32, 1, 8, 0xae80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 32, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 32, 2, 8, 0x18500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 32, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 32, 3, 8, 0x24780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 32, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 32, 4, 8, 0x30a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 32, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 32, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 32, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 32, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 40, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 48, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 48, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 48, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 48, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 48, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 48, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 48, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 48, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 48, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 48, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 48, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 48, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 56, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 64, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 64, 1, 8, 0x15a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 64, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 64, 2, 8, 0x30700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 64, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 64, 3, 8, 0x48a80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 64, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 64, 4, 8, 0x60e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 64, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 64, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 64, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 64, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 72, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 80, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 80, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 80, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 80, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 80, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 80, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 80, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 80, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 80, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 80, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 80, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 80, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 88, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 96, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 96, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 96, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 96, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 96, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 96, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 96, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 96, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 96, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 96, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 96, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 96, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 104, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 112, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 112, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 112, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 112, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 112, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 112, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 112, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 112, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 112, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 112, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 112, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 112, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 120, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 128, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 128, 1, 8, 0x2b180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 128, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 128, 2, 8, 0x58c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 128, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 128, 3, 8, 0x85200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 128, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 128, 4, 8, 0xb1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 128, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 128, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 128, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 128, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 136, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 144, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 144, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 144, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 144, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 144, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 144, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 144, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 144, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 144, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 144, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 144, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 144, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 152, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 160, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 160, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 160, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 160, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 160, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 160, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 160, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 160, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 160, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 160, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 160, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 160, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 168, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 176, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 176, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 176, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 176, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 176, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 176, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 176, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 176, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 176, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 176, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 176, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 176, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 184, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 192, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 192, 1, 8, 0x4a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 192, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 192, 2, 8, 0x99600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 192, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 192, 3, 8, 0xe6100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 192, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 192, 4, 8, 0x132c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 192, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 192, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 192, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 192, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 200, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 208, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 208, 1, 8, 0x56100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 208, 2, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 208, 2, 8, 0xb1600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 208, 3, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 208, 3, 8, 0x10a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 208, 4, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 208, 4, 8, 0x162c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 208, 5, 1, 0x142800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 208, 6, 1, 0x183000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 208, 7, 1, 0x1c3800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 208, 8, 1, 0x204000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 216, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 224, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 224, 1, 8, 0x56100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 224, 2, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 224, 2, 8, 0xb1600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 224, 3, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 224, 3, 8, 0x10a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 224, 4, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 224, 4, 8, 0x162c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 224, 5, 1, 0x142800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 224, 6, 1, 0x183000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 224, 7, 1, 0x1c3800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 224, 8, 1, 0x204000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 232, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 240, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 240, 1, 8, 0x56100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 240, 2, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 240, 2, 8, 0xb1600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 240, 3, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 240, 3, 8, 0x10a100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 240, 4, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 240, 4, 8, 0x162c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 240, 5, 1, 0x142800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 240, 6, 1, 0x183000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 240, 7, 1, 0x1c3800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 248, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 256, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 256, 1, 9, 0x56200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 256, 2, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 256, 2, 9, 0xb1700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 256, 3, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 256, 3, 9, 0x10a280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 256, 4, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 256, 4, 9, 0x162e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 256, 5, 1, 0x142800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 256, 6, 1, 0x183000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 240, 256, 7, 1, 0x1c3800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 24, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 32, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 40, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 48, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 56, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 64, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 72, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 80, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 88, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 96, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 104, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 112, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 120, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 128, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 136, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 144, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 152, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 160, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 168, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 176, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 184, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 192, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 200, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 208, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 216, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 224, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 232, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 240, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 248, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 248, 256, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 16, 1, 9, 0x5a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 16, 2, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 16, 2, 9, 0x10500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 16, 3, 1, 0xc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 16, 3, 9, 0x18780 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 16, 4, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 16, 4, 9, 0x20a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 16, 5, 1, 0x14280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 16, 6, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 16, 7, 1, 0x1c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 16, 8, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 24, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 32, 1, 1, 0x8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 32, 1, 9, 0xaf80 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 32, 2, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 32, 2, 9, 0x18600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 32, 3, 1, 0x18300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 32, 3, 9, 0x24900 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 32, 4, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 32, 4, 9, 0x30c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 32, 5, 1, 0x28500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 32, 6, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 32, 7, 1, 0x38700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 32, 8, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 40, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 48, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 48, 1, 9, 0x15b00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 48, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 48, 2, 9, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 48, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 48, 3, 9, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 48, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 48, 4, 9, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 48, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 48, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 48, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 48, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 56, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 64, 1, 1, 0x10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 64, 1, 9, 0x15b00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 64, 2, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 64, 2, 9, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 64, 3, 1, 0x30600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 64, 3, 9, 0x48c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 64, 4, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 64, 4, 9, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 64, 5, 1, 0x50a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 64, 6, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 64, 7, 1, 0x70e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 64, 8, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 72, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 80, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 80, 1, 9, 0x2b280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 80, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 80, 2, 9, 0x58d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 80, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 80, 3, 9, 0x85380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 80, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 80, 4, 9, 0xb1a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 80, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 80, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 80, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 80, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 88, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 96, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 96, 1, 9, 0x2b280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 96, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 96, 2, 9, 0x58d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 96, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 96, 3, 9, 0x85380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 96, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 96, 4, 9, 0xb1a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 96, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 96, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 96, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 96, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 104, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 112, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 112, 1, 9, 0x2b280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 112, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 112, 2, 9, 0x58d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 112, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 112, 3, 9, 0x85380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 112, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 112, 4, 9, 0xb1a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 112, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 112, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 112, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 112, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 120, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 128, 1, 1, 0x20400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 128, 1, 9, 0x2b280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 128, 2, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 128, 2, 9, 0x58d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 128, 3, 1, 0x60c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 128, 3, 9, 0x85380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 128, 4, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 128, 4, 9, 0xb1a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 128, 5, 1, 0xa1400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 128, 6, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 128, 7, 1, 0xe1c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 128, 8, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 136, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 144, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 144, 1, 9, 0x4a200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 144, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 144, 2, 9, 0x99700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 144, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 144, 3, 9, 0xe6280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 144, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 144, 4, 9, 0x132e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 144, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 144, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 144, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 144, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 152, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 160, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 160, 1, 9, 0x4a200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 160, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 160, 2, 9, 0x99700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 160, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 160, 3, 9, 0xe6280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 160, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 160, 4, 9, 0x132e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 160, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 160, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 160, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 160, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 168, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 176, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 176, 1, 9, 0x4a200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 176, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 176, 2, 9, 0x99700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 176, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 176, 3, 9, 0xe6280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 176, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 176, 4, 9, 0x132e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 176, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 176, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 176, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 176, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 184, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 192, 1, 1, 0x30800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 192, 1, 9, 0x4a200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 192, 2, 1, 0x61000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 192, 2, 9, 0x99700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 192, 3, 1, 0x91800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 192, 3, 9, 0xe6280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 192, 4, 1, 0xc2000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 192, 4, 9, 0x132e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 192, 5, 1, 0xf2800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 192, 6, 1, 0x123000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 192, 7, 1, 0x153800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 192, 8, 1, 0x184000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 200, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 208, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 208, 1, 9, 0x56200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 208, 2, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 208, 2, 9, 0xb1700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 208, 3, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 208, 3, 9, 0x10a280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 208, 4, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 208, 4, 9, 0x162e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 208, 5, 1, 0x142800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 208, 6, 1, 0x183000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 208, 7, 1, 0x1c3800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 208, 8, 1, 0x204000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 216, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 224, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 224, 1, 9, 0x56200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 224, 2, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 224, 2, 9, 0xb1700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 224, 3, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 224, 3, 9, 0x10a280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 224, 4, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 224, 4, 9, 0x162e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 224, 5, 1, 0x142800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 224, 6, 1, 0x183000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 224, 7, 1, 0x1c3800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 224, 8, 1, 0x204000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 232, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 240, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 240, 1, 9, 0x56200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 240, 2, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 240, 2, 9, 0xb1700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 240, 3, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 240, 3, 9, 0x10a280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 240, 4, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 240, 4, 9, 0x162e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 240, 5, 1, 0x142800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 240, 6, 1, 0x183000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 240, 7, 1, 0x1c3800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 248, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 256, 1, 1, 0x40800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 256, 1, 9, 0x56200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 256, 1, 9, 0x56200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 256, 2, 1, 0x81000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 256, 2, 9, 0xb1700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 256, 2, 9, 0xb1700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 256, 3, 1, 0xc1800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 256, 3, 9, 0x10a280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 256, 3, 9, 0x10a280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 256, 4, 1, 0x102000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 256, 4, 9, 0x162e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 256, 4, 9, 0x162e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 256, 5, 1, 0x142800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 256, 6, 1, 0x183000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 256, 7, 1, 0x1c3800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 384, 1, 9, 0x84180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 384, 2, 9, 0x10ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 384, 3, 9, 0x190200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 384, 4, 9, 0x215800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 512, 1, 10, 0xac280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 512, 2, 10, 0x15ad00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 512, 3, 10, 0x208380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 512, 4, 10, 0x2b5a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 640, 1, 10, 0xdc200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 640, 2, 10, 0x1bd700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 640, 3, 10, 0x29c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 640, 4, 10, 0x37ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 768, 1, 10, 0x104200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 768, 2, 10, 0x20d700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 768, 3, 10, 0x314280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 768, 4, 10, 0x41ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 896, 1, 10, 0x130200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 896, 2, 10, 0x265700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 896, 3, 10, 0x398280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 896, 4, 10, 0x4cae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1024, 1, 11, 0x158300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1024, 2, 11, 0x2b5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1024, 3, 11, 0x410400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1024, 4, 11, 0x56b000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1152, 1, 11, 0x18c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1152, 2, 11, 0x31ad00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1152, 3, 11, 0x4a8380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1152, 4, 11, 0x635a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1280, 1, 11, 0x1b4280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1280, 2, 11, 0x36ad00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1280, 3, 11, 0x520380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1280, 4, 11, 0x6d5a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1408, 1, 11, 0x1e0280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1408, 2, 11, 0x3c2d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1408, 3, 11, 0x5a4380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1408, 4, 11, 0x785a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1536, 1, 11, 0x208280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1536, 2, 11, 0x412d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1536, 3, 11, 0x61c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1536, 4, 11, 0x825a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1664, 1, 11, 0x234280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1664, 2, 11, 0x46ad00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1664, 3, 11, 0x6a0380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1664, 4, 11, 0x8d5a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1792, 1, 11, 0x25c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1792, 2, 11, 0x4bad00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1792, 3, 11, 0x718380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1792, 4, 11, 0x975a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1920, 1, 11, 0x288280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1920, 2, 11, 0x512d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1920, 3, 11, 0x79c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 1920, 4, 11, 0xa25a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 2048, 1, 12, 0x2b0380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 2048, 2, 12, 0x562e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 2048, 3, 12, 0x814500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 256, 2048, 4, 12, 0xac5c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 256, 1, 9, 0x84180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 256, 2, 9, 0x10ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 256, 3, 9, 0x190200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 256, 4, 9, 0x215800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 384, 1, 9, 0xd0100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 384, 2, 9, 0x1a5600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 384, 3, 9, 0x278100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 384, 4, 9, 0x34ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 512, 1, 10, 0x10c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 512, 2, 10, 0x21d700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 512, 3, 10, 0x32c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 512, 4, 10, 0x43ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 640, 1, 10, 0x158180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 640, 2, 10, 0x2b2c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 640, 3, 10, 0x40c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 640, 4, 10, 0x565800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 768, 1, 10, 0x194180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 768, 2, 10, 0x32ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 768, 3, 10, 0x4c0200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 768, 4, 10, 0x655800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 896, 1, 10, 0x1dc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 896, 2, 10, 0x3bac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 896, 3, 10, 0x598200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 896, 4, 10, 0x775800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1024, 1, 11, 0x218280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1024, 2, 11, 0x432d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1024, 3, 11, 0x64c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1024, 4, 11, 0x865a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1152, 1, 11, 0x26c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1152, 2, 11, 0x4dd700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1152, 3, 11, 0x74c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1152, 4, 11, 0x9bae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1280, 1, 11, 0x2a8200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1280, 2, 11, 0x555700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1280, 3, 11, 0x800280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1280, 4, 11, 0xaaae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1408, 1, 11, 0x2f0200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1408, 2, 11, 0x5e5700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1408, 3, 11, 0x8d8280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1408, 4, 11, 0xbcae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1536, 1, 11, 0x32c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1536, 2, 11, 0x65d700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1536, 3, 11, 0x98c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1536, 4, 11, 0xcbae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1664, 1, 11, 0x370200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1664, 2, 11, 0x6e5700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1664, 3, 11, 0xa58280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1664, 4, 11, 0xdcae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1792, 1, 11, 0x3ac200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1792, 2, 11, 0x75d700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1792, 3, 11, 0xb0c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1792, 4, 11, 0xebae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1920, 1, 11, 0x3f4200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1920, 2, 11, 0x7ed700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1920, 3, 11, 0xbe4280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 1920, 4, 11, 0xfdae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 2048, 1, 12, 0x430300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 2048, 2, 12, 0x865800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 2048, 3, 12, 0xc98400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 384, 2048, 4, 12, 0x10cb000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 256, 1, 10, 0xac280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 256, 2, 10, 0x15ad00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 256, 3, 10, 0x208380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 256, 4, 10, 0x2b5a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 384, 1, 10, 0x10c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 384, 2, 10, 0x21d700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 384, 3, 10, 0x32c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 384, 4, 10, 0x43ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 512, 1, 10, 0x158200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 512, 2, 10, 0x2b5700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 512, 3, 10, 0x410280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 512, 4, 10, 0x56ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 640, 1, 10, 0x1bc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 640, 2, 10, 0x37ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 640, 3, 10, 0x538200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 640, 4, 10, 0x6f5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 768, 1, 10, 0x208180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 768, 2, 10, 0x412c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 768, 3, 10, 0x61c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 768, 4, 10, 0x825800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 896, 1, 10, 0x264180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 896, 2, 10, 0x4cac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 896, 3, 10, 0x730200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 896, 4, 10, 0x995800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1024, 1, 11, 0x2b0280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1024, 2, 11, 0x562d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1024, 3, 11, 0x814380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1024, 4, 11, 0xac5a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1152, 1, 11, 0x318200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1152, 2, 11, 0x635700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1152, 3, 11, 0x950280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1152, 4, 11, 0xc6ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1280, 1, 11, 0x364200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1280, 2, 11, 0x6cd700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1280, 3, 11, 0xa34280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1280, 4, 11, 0xd9ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1408, 1, 11, 0x3c0200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1408, 2, 11, 0x785700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1408, 3, 11, 0xb48280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1408, 4, 11, 0xf0ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1536, 1, 11, 0x40c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1536, 2, 11, 0x81d700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1536, 3, 11, 0xc2c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1536, 4, 11, 0x103ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1664, 1, 11, 0x46c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1664, 2, 11, 0x8dd700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1664, 3, 11, 0xd4c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1664, 4, 11, 0x11bae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1792, 1, 11, 0x4b8200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1792, 2, 11, 0x975700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1792, 3, 11, 0xe30280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1792, 4, 11, 0x12eae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1920, 1, 11, 0x514200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1920, 2, 11, 0xa2d700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1920, 3, 11, 0xf44280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 1920, 4, 11, 0x145ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 2048, 1, 12, 0x560300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 2048, 2, 12, 0xac5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 2048, 3, 12, 0x1028400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 512, 2048, 4, 12, 0x158b000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 256, 1, 10, 0xdc200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 256, 2, 10, 0x1bd700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 256, 3, 10, 0x29c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 256, 4, 10, 0x37ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 384, 1, 10, 0x158180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 384, 2, 10, 0x2b2c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 384, 3, 10, 0x40c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 384, 4, 10, 0x565800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 512, 1, 10, 0x1bc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 512, 2, 10, 0x37ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 512, 3, 10, 0x538200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 512, 4, 10, 0x6f5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 640, 1, 10, 0x240100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 640, 2, 10, 0x485600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 640, 3, 10, 0x6c8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 640, 4, 10, 0x90ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 768, 1, 10, 0x2a0100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 768, 2, 10, 0x545600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 768, 3, 10, 0x7e8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 768, 4, 10, 0xa8ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 896, 1, 10, 0x318100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 896, 2, 10, 0x635600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 896, 3, 10, 0x950100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 896, 4, 10, 0xc6ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1024, 1, 11, 0x378200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1024, 2, 11, 0x6f5700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1024, 3, 11, 0xa70280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1024, 4, 11, 0xdeae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1152, 1, 11, 0x404180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1152, 2, 11, 0x80ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1152, 3, 11, 0xc10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1152, 4, 11, 0x1015800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1280, 1, 11, 0x468180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1280, 2, 11, 0x8d2c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1280, 3, 11, 0xd3c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1280, 4, 11, 0x11a5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1408, 1, 11, 0x4dc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1408, 2, 11, 0x9bac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1408, 3, 11, 0xe98200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1408, 4, 11, 0x1375800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1536, 1, 11, 0x53c180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1536, 2, 11, 0xa7ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1536, 3, 11, 0xfb8200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1536, 4, 11, 0x14f5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1664, 1, 11, 0x5bc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1664, 2, 11, 0xb7ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1664, 3, 11, 0x1138200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1664, 4, 11, 0x16f5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1792, 1, 11, 0x61c180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1792, 2, 11, 0xc3ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1792, 3, 11, 0x1258200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1792, 4, 11, 0x1875800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1920, 1, 11, 0x690180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1920, 2, 11, 0xd22c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1920, 3, 11, 0x13b4200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 1920, 4, 11, 0x1a45800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 2048, 1, 12, 0x6f4280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 2048, 2, 12, 0xdead00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 2048, 3, 12, 0x14e0380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 640, 2048, 4, 12, 0x1bd5a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 256, 1, 10, 0x104200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 256, 2, 10, 0x20d700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 256, 3, 10, 0x314280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 256, 4, 10, 0x41ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 384, 1, 10, 0x194180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 384, 2, 10, 0x32ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 384, 3, 10, 0x4c0200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 384, 4, 10, 0x655800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 512, 1, 10, 0x208180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 512, 2, 10, 0x412c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 512, 3, 10, 0x61c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 512, 4, 10, 0x825800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 640, 1, 10, 0x2a0100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 640, 2, 10, 0x545600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 640, 3, 10, 0x7e8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 640, 4, 10, 0xa8ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 768, 1, 10, 0x318100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 768, 2, 10, 0x635600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 768, 3, 10, 0x950100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 768, 4, 10, 0xc6ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 896, 1, 10, 0x3a0100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 896, 2, 10, 0x745600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 896, 3, 10, 0xae8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 896, 4, 10, 0xe8ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1024, 1, 11, 0x414200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1024, 2, 11, 0x82d700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1024, 3, 11, 0xc44280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1024, 4, 11, 0x105ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1152, 1, 11, 0x4b4180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1152, 2, 11, 0x96ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1152, 3, 11, 0xe20200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1152, 4, 11, 0x12d5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1280, 1, 11, 0x528180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1280, 2, 11, 0xa52c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1280, 3, 11, 0xf7c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1280, 4, 11, 0x14a5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1408, 1, 11, 0x5b4180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1408, 2, 11, 0xb6ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1408, 3, 11, 0x1120200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1408, 4, 11, 0x16d5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1536, 1, 11, 0x624180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1536, 2, 11, 0xc4ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1536, 3, 11, 0x1270200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1536, 4, 11, 0x1895800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1664, 1, 11, 0x6b4180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1664, 2, 11, 0xd6ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1664, 3, 11, 0x1420200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1664, 4, 11, 0x1ad5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1792, 1, 11, 0x72c180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1792, 2, 11, 0xe5ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1792, 3, 11, 0x1588200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1792, 4, 11, 0x1cb5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1920, 1, 11, 0x7b4180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1920, 2, 11, 0xf6ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1920, 3, 11, 0x1720200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 1920, 4, 11, 0x1ed5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 2048, 1, 12, 0x828280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 2048, 2, 12, 0x1052d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 2048, 3, 12, 0x187c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 768, 2048, 4, 12, 0x20a5a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 256, 1, 10, 0x130200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 256, 2, 10, 0x265700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 256, 3, 10, 0x398280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 256, 4, 10, 0x4cae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 384, 1, 10, 0x1dc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 384, 2, 10, 0x3bac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 384, 3, 10, 0x598200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 384, 4, 10, 0x775800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 512, 1, 10, 0x264180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 512, 2, 10, 0x4cac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 512, 3, 10, 0x730200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 512, 4, 10, 0x995800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 640, 1, 10, 0x318100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 640, 2, 10, 0x635600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 640, 3, 10, 0x950100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 640, 4, 10, 0xc6ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 768, 1, 10, 0x3a0100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 768, 2, 10, 0x745600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 768, 3, 10, 0xae8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 768, 4, 10, 0xe8ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 896, 1, 10, 0x448100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 896, 2, 10, 0x895600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 896, 3, 10, 0xce0100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 896, 4, 10, 0x112ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1024, 1, 11, 0x4cc200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1024, 2, 11, 0x99d700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1024, 3, 11, 0xe6c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1024, 4, 11, 0x133ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1152, 1, 11, 0x584180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1152, 2, 11, 0xb0ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1152, 3, 11, 0x1090200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1152, 4, 11, 0x1615800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1280, 1, 11, 0x610180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1280, 2, 11, 0xc22c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1280, 3, 11, 0x1234200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1280, 4, 11, 0x1845800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1408, 1, 11, 0x6b4180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1408, 2, 11, 0xd6ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1408, 3, 11, 0x1420200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1408, 4, 11, 0x1ad5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1536, 1, 11, 0x73c180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1536, 2, 11, 0xe7ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1536, 3, 11, 0x15b8200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1536, 4, 11, 0x1cf5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1664, 1, 11, 0x7e4180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1664, 2, 11, 0xfcac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1664, 3, 11, 0x17b0200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1664, 4, 11, 0x1f95800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1792, 1, 11, 0x870180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1792, 2, 11, 0x10e2c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1792, 3, 11, 0x1954200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1792, 4, 11, 0x21c5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1920, 1, 11, 0x914180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1920, 2, 11, 0x122ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1920, 3, 11, 0x1b40200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 1920, 4, 11, 0x2455800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 2048, 1, 12, 0x99c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 2048, 2, 12, 0x133ad00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 2048, 3, 12, 0x1cd8380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 896, 2048, 4, 12, 0x2675a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 256, 1, 11, 0x158300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 256, 2, 11, 0x2b5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 256, 3, 11, 0x410400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 256, 4, 11, 0x56b000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 384, 1, 11, 0x218280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 384, 2, 11, 0x432d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 384, 3, 11, 0x64c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 384, 4, 11, 0x865a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 512, 1, 11, 0x2b0280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 512, 2, 11, 0x562d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 512, 3, 11, 0x814380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 512, 4, 11, 0xac5a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 640, 1, 11, 0x378200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 640, 2, 11, 0x6f5700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 640, 3, 11, 0xa70280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 640, 4, 11, 0xdeae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 768, 1, 11, 0x414200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 768, 2, 11, 0x82d700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 768, 3, 11, 0xc44280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 768, 4, 11, 0x105ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 896, 1, 11, 0x4cc200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 896, 2, 11, 0x99d700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 896, 3, 11, 0xe6c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 896, 4, 11, 0x133ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1024, 1, 11, 0x560200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1024, 2, 11, 0xac5700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1024, 3, 11, 0x1028280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1024, 4, 11, 0x158ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1152, 1, 11, 0x630180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1152, 2, 11, 0xc62c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1152, 3, 11, 0x1294200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1152, 4, 11, 0x18c5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1280, 1, 11, 0x6cc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1280, 2, 11, 0xd9ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1280, 3, 11, 0x1468200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1280, 4, 11, 0x1b35800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1408, 1, 11, 0x784180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1408, 2, 11, 0xf0ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1408, 3, 11, 0x1690200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1408, 4, 11, 0x1e15800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1536, 1, 11, 0x818180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1536, 2, 11, 0x1032c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1536, 3, 11, 0x184c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1536, 4, 11, 0x2065800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1664, 1, 11, 0x8d8180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1664, 2, 11, 0x11b2c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1664, 3, 11, 0x1a8c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1664, 4, 11, 0x2365800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1792, 1, 11, 0x974180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1792, 2, 11, 0x12eac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1792, 3, 11, 0x1c60200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1792, 4, 11, 0x25d5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1920, 1, 11, 0xa2c180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1920, 2, 11, 0x145ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1920, 3, 11, 0x1e88200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 1920, 4, 11, 0x28b5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 2048, 1, 12, 0xac0280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 2048, 2, 12, 0x1582d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 2048, 3, 12, 0x2044380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1024, 2048, 4, 12, 0x2b05a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 256, 1, 11, 0x18c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 256, 2, 11, 0x31ad00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 256, 3, 11, 0x4a8380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 256, 4, 11, 0x635a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 384, 1, 11, 0x26c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 384, 2, 11, 0x4dd700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 384, 3, 11, 0x74c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 384, 4, 11, 0x9bae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 512, 1, 11, 0x318200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 512, 2, 11, 0x635700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 512, 3, 11, 0x950280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 512, 4, 11, 0xc6ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 640, 1, 11, 0x404180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 640, 2, 11, 0x80ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 640, 3, 11, 0xc10200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 640, 4, 11, 0x1015800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 768, 1, 11, 0x4b4180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 768, 2, 11, 0x96ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 768, 3, 11, 0xe20200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 768, 4, 11, 0x12d5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 896, 1, 11, 0x584180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 896, 2, 11, 0xb0ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 896, 3, 11, 0x1090200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 896, 4, 11, 0x1615800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1024, 1, 11, 0x630180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1024, 2, 11, 0xc62c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1024, 3, 11, 0x1294200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1024, 4, 11, 0x18c5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1152, 1, 11, 0x730100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1152, 2, 11, 0xe65600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1152, 3, 11, 0x1598100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1152, 4, 11, 0x1ccac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1280, 1, 11, 0x7dc100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1280, 2, 11, 0xfbd600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1280, 3, 11, 0x179c100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1280, 4, 11, 0x1f7ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1408, 1, 11, 0x8b0100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1408, 2, 11, 0x1165600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1408, 3, 11, 0x1a18100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1408, 4, 11, 0x22cac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1536, 1, 11, 0x958100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1536, 2, 11, 0x12b5600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1536, 3, 11, 0x1c10100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1536, 4, 11, 0x256ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1664, 1, 11, 0xa38100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1664, 2, 11, 0x1475600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1664, 3, 11, 0x1eb0100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1664, 4, 11, 0x28eac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1792, 1, 11, 0xae4100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1792, 2, 11, 0x15cd600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1792, 3, 11, 0x20b4100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1792, 4, 11, 0x2b9ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1920, 1, 11, 0xbbc100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1920, 2, 11, 0x177d600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1920, 3, 11, 0x233c100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 1920, 4, 11, 0x2efac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 2048, 1, 12, 0xc64200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 2048, 2, 12, 0x18cd700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 2048, 3, 12, 0x2534280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1152, 2048, 4, 12, 0x319ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 256, 1, 11, 0x1b4280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 256, 2, 11, 0x36ad00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 256, 3, 11, 0x520380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 256, 4, 11, 0x6d5a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 384, 1, 11, 0x2a8200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 384, 2, 11, 0x555700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 384, 3, 11, 0x800280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 384, 4, 11, 0xaaae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 512, 1, 11, 0x364200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 512, 2, 11, 0x6cd700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 512, 3, 11, 0xa34280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 512, 4, 11, 0xd9ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 640, 1, 11, 0x468180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 640, 2, 11, 0x8d2c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 640, 3, 11, 0xd3c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 640, 4, 11, 0x11a5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 768, 1, 11, 0x528180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 768, 2, 11, 0xa52c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 768, 3, 11, 0xf7c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 768, 4, 11, 0x14a5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 896, 1, 11, 0x610180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 896, 2, 11, 0xc22c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 896, 3, 11, 0x1234200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 896, 4, 11, 0x1845800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1024, 1, 11, 0x6cc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1024, 2, 11, 0xd9ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1024, 3, 11, 0x1468200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1024, 4, 11, 0x1b35800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1152, 1, 11, 0x7dc100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1152, 2, 11, 0xfbd600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1152, 3, 11, 0x179c100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1152, 4, 11, 0x1f7ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1280, 1, 11, 0x8a0100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1280, 2, 11, 0x1145600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1280, 3, 11, 0x19e8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1280, 4, 11, 0x228ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1408, 1, 11, 0x984100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1408, 2, 11, 0x130d600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1408, 3, 11, 0x1c94100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1408, 4, 11, 0x261ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1536, 1, 11, 0xa40100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1536, 2, 11, 0x1485600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1536, 3, 11, 0x1ec8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1536, 4, 11, 0x290ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1664, 1, 11, 0xb38100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1664, 2, 11, 0x1675600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1664, 3, 11, 0x21b0100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1664, 4, 11, 0x2ceac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1792, 1, 11, 0xbf8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1792, 2, 11, 0x17f5600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1792, 3, 11, 0x23f0100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1792, 4, 11, 0x2feac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1920, 1, 11, 0xce0100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1920, 2, 11, 0x19c5600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1920, 3, 11, 0x26a8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 1920, 4, 11, 0x338ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 2048, 1, 12, 0xd98200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 2048, 2, 12, 0x1b35700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 2048, 3, 12, 0x28d0280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1280, 2048, 4, 12, 0x366ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 256, 1, 11, 0x1e0280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 256, 2, 11, 0x3c2d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 256, 3, 11, 0x5a4380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 256, 4, 11, 0x785a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 384, 1, 11, 0x2f0200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 384, 2, 11, 0x5e5700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 384, 3, 11, 0x8d8280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 384, 4, 11, 0xbcae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 512, 1, 11, 0x3c0200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 512, 2, 11, 0x785700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 512, 3, 11, 0xb48280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 512, 4, 11, 0xf0ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 640, 1, 11, 0x4dc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 640, 2, 11, 0x9bac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 640, 3, 11, 0xe98200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 640, 4, 11, 0x1375800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 768, 1, 11, 0x5b4180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 768, 2, 11, 0xb6ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 768, 3, 11, 0x1120200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 768, 4, 11, 0x16d5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 896, 1, 11, 0x6b4180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 896, 2, 11, 0xd6ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 896, 3, 11, 0x1420200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 896, 4, 11, 0x1ad5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1024, 1, 11, 0x784180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1024, 2, 11, 0xf0ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1024, 3, 11, 0x1690200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1024, 4, 11, 0x1e15800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1152, 1, 11, 0x8b0100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1152, 2, 11, 0x1165600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1152, 3, 11, 0x1a18100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1152, 4, 11, 0x22cac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1280, 1, 11, 0x984100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1280, 2, 11, 0x130d600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1280, 3, 11, 0x1c94100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1280, 4, 11, 0x261ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1408, 1, 11, 0xa88100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1408, 2, 11, 0x1515600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1408, 3, 11, 0x1fa0100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1408, 4, 11, 0x2a2ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1536, 1, 11, 0xb5c100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1536, 2, 11, 0x16bd600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1536, 3, 11, 0x221c100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1536, 4, 11, 0x2d7ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1664, 1, 11, 0xc64100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1664, 2, 11, 0x18cd600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1664, 3, 11, 0x2534100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1664, 4, 11, 0x319ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1792, 1, 11, 0xd3c100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1792, 2, 11, 0x1a7d600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1792, 3, 11, 0x27bc100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1792, 4, 11, 0x34fac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1920, 1, 11, 0xe40100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1920, 2, 11, 0x1c85600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1920, 3, 11, 0x2ac8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 1920, 4, 11, 0x390ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 2048, 1, 12, 0xf0c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 2048, 2, 12, 0x1e1d700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 2048, 3, 12, 0x2d2c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1408, 2048, 4, 12, 0x3c3ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 256, 1, 11, 0x208280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 256, 2, 11, 0x412d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 256, 3, 11, 0x61c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 256, 4, 11, 0x825a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 384, 1, 11, 0x32c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 384, 2, 11, 0x65d700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 384, 3, 11, 0x98c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 384, 4, 11, 0xcbae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 512, 1, 11, 0x40c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 512, 2, 11, 0x81d700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 512, 3, 11, 0xc2c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 512, 4, 11, 0x103ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 640, 1, 11, 0x53c180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 640, 2, 11, 0xa7ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 640, 3, 11, 0xfb8200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 640, 4, 11, 0x14f5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 768, 1, 11, 0x624180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 768, 2, 11, 0xc4ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 768, 3, 11, 0x1270200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 768, 4, 11, 0x1895800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 896, 1, 11, 0x73c180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 896, 2, 11, 0xe7ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 896, 3, 11, 0x15b8200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 896, 4, 11, 0x1cf5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1024, 1, 11, 0x818180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1024, 2, 11, 0x1032c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1024, 3, 11, 0x184c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1024, 4, 11, 0x2065800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1152, 1, 11, 0x958100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1152, 2, 11, 0x12b5600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1152, 3, 11, 0x1c10100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1152, 4, 11, 0x256ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1280, 1, 11, 0xa40100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1280, 2, 11, 0x1485600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1280, 3, 11, 0x1ec8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1280, 4, 11, 0x290ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1408, 1, 11, 0xb5c100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1408, 2, 11, 0x16bd600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1408, 3, 11, 0x221c100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1408, 4, 11, 0x2d7ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1536, 1, 11, 0xc38100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1536, 2, 11, 0x1875600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1536, 3, 11, 0x24b0100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1536, 4, 11, 0x30eac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1664, 1, 11, 0xd58100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1664, 2, 11, 0x1ab5600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1664, 3, 11, 0x2810100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1664, 4, 11, 0x356ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1792, 1, 11, 0xe40100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1792, 2, 11, 0x1c85600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1792, 3, 11, 0x2ac8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1792, 4, 11, 0x390ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1920, 1, 11, 0xf58100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1920, 2, 11, 0x1eb5600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1920, 3, 11, 0x2e10100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 1920, 4, 11, 0x3d6ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 2048, 1, 12, 0x1034200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 2048, 2, 12, 0x206d700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 2048, 3, 12, 0x30a4280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1536, 2048, 4, 12, 0x40dae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 256, 1, 11, 0x234280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 256, 2, 11, 0x46ad00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 256, 3, 11, 0x6a0380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 256, 4, 11, 0x8d5a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 384, 1, 11, 0x370200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 384, 2, 11, 0x6e5700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 384, 3, 11, 0xa58280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 384, 4, 11, 0xdcae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 512, 1, 11, 0x46c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 512, 2, 11, 0x8dd700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 512, 3, 11, 0xd4c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 512, 4, 11, 0x11bae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 640, 1, 11, 0x5bc180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 640, 2, 11, 0xb7ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 640, 3, 11, 0x1138200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 640, 4, 11, 0x16f5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 768, 1, 11, 0x6b4180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 768, 2, 11, 0xd6ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 768, 3, 11, 0x1420200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 768, 4, 11, 0x1ad5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 896, 1, 11, 0x7e4180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 896, 2, 11, 0xfcac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 896, 3, 11, 0x17b0200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 896, 4, 11, 0x1f95800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1024, 1, 11, 0x8d8180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1024, 2, 11, 0x11b2c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1024, 3, 11, 0x1a8c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1024, 4, 11, 0x2365800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1152, 1, 11, 0xa38100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1152, 2, 11, 0x1475600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1152, 3, 11, 0x1eb0100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1152, 4, 11, 0x28eac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1280, 1, 11, 0xb38100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1280, 2, 11, 0x1675600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1280, 3, 11, 0x21b0100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1280, 4, 11, 0x2ceac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1408, 1, 11, 0xc64100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1408, 2, 11, 0x18cd600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1408, 3, 11, 0x2534100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1408, 4, 11, 0x319ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1536, 1, 11, 0xd58100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1536, 2, 11, 0x1ab5600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1536, 3, 11, 0x2810100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1536, 4, 11, 0x356ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1664, 1, 11, 0xe98100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1664, 2, 11, 0x1d35600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1664, 3, 11, 0x2bd0100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1664, 4, 11, 0x3a6ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1792, 1, 11, 0xf94100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1792, 2, 11, 0x1f2d600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1792, 3, 11, 0x2ec4100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1792, 4, 11, 0x3e5ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1920, 1, 11, 0x10c8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1920, 2, 11, 0x2195600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1920, 3, 11, 0x3260100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 1920, 4, 11, 0x432ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 2048, 1, 12, 0x11b8200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 2048, 2, 12, 0x2375700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 2048, 3, 12, 0x3530280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1664, 2048, 4, 12, 0x46eae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 256, 1, 11, 0x25c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 256, 2, 11, 0x4bad00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 256, 3, 11, 0x718380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 256, 4, 11, 0x975a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 384, 1, 11, 0x3ac200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 384, 2, 11, 0x75d700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 384, 3, 11, 0xb0c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 384, 4, 11, 0xebae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 512, 1, 11, 0x4b8200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 512, 2, 11, 0x975700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 512, 3, 11, 0xe30280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 512, 4, 11, 0x12eae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 640, 1, 11, 0x61c180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 640, 2, 11, 0xc3ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 640, 3, 11, 0x1258200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 640, 4, 11, 0x1875800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 768, 1, 11, 0x72c180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 768, 2, 11, 0xe5ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 768, 3, 11, 0x1588200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 768, 4, 11, 0x1cb5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 896, 1, 11, 0x870180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 896, 2, 11, 0x10e2c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 896, 3, 11, 0x1954200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 896, 4, 11, 0x21c5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1024, 1, 11, 0x974180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1024, 2, 11, 0x12eac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1024, 3, 11, 0x1c60200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1024, 4, 11, 0x25d5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1152, 1, 11, 0xae4100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1152, 2, 11, 0x15cd600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1152, 3, 11, 0x20b4100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1152, 4, 11, 0x2b9ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1280, 1, 11, 0xbf8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1280, 2, 11, 0x17f5600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1280, 3, 11, 0x23f0100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1280, 4, 11, 0x2feac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1408, 1, 11, 0xd3c100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1408, 2, 11, 0x1a7d600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1408, 3, 11, 0x27bc100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1408, 4, 11, 0x34fac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1536, 1, 11, 0xe40100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1536, 2, 11, 0x1c85600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1536, 3, 11, 0x2ac8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1536, 4, 11, 0x390ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1664, 1, 11, 0xf94100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1664, 2, 11, 0x1f2d600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1664, 3, 11, 0x2ec4100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1664, 4, 11, 0x3e5ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1792, 1, 11, 0x10a8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1792, 2, 11, 0x2155600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1792, 3, 11, 0x3200100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1792, 4, 11, 0x42aac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1920, 1, 11, 0x11ec100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1920, 2, 11, 0x23dd600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1920, 3, 11, 0x35cc100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 1920, 4, 11, 0x47bac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 2048, 1, 12, 0x12ec200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 2048, 2, 12, 0x25dd700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 2048, 3, 12, 0x38cc280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1792, 2048, 4, 12, 0x4bbae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 256, 1, 11, 0x288280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 256, 2, 11, 0x512d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 256, 3, 11, 0x79c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 256, 4, 11, 0xa25a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 384, 1, 11, 0x3f4200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 384, 2, 11, 0x7ed700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 384, 3, 11, 0xbe4280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 384, 4, 11, 0xfdae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 512, 1, 11, 0x514200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 512, 2, 11, 0xa2d700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 512, 3, 11, 0xf44280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 512, 4, 11, 0x145ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 640, 1, 11, 0x690180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 640, 2, 11, 0xd22c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 640, 3, 11, 0x13b4200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 640, 4, 11, 0x1a45800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 768, 1, 11, 0x7b4180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 768, 2, 11, 0xf6ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 768, 3, 11, 0x1720200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 768, 4, 11, 0x1ed5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 896, 1, 11, 0x914180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 896, 2, 11, 0x122ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 896, 3, 11, 0x1b40200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 896, 4, 11, 0x2455800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1024, 1, 11, 0xa2c180 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1024, 2, 11, 0x145ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1024, 3, 11, 0x1e88200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1024, 4, 11, 0x28b5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1152, 1, 11, 0xbbc100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1152, 2, 11, 0x177d600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1152, 3, 11, 0x233c100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1152, 4, 11, 0x2efac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1280, 1, 11, 0xce0100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1280, 2, 11, 0x19c5600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1280, 3, 11, 0x26a8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1280, 4, 11, 0x338ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1408, 1, 11, 0xe40100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1408, 2, 11, 0x1c85600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1408, 3, 11, 0x2ac8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1408, 4, 11, 0x390ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1536, 1, 11, 0xf58100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1536, 2, 11, 0x1eb5600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1536, 3, 11, 0x2e10100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1536, 4, 11, 0x3d6ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1664, 1, 11, 0x10c8100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1664, 2, 11, 0x2195600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1664, 3, 11, 0x3260100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1664, 4, 11, 0x432ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1792, 1, 11, 0x11ec100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1792, 2, 11, 0x23dd600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1792, 3, 11, 0x35cc100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1792, 4, 11, 0x47bac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1920, 1, 11, 0x134c100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1920, 2, 11, 0x269d600 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1920, 3, 11, 0x39ec100 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 1920, 4, 11, 0x4d3ac00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 2048, 1, 12, 0x1460200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 2048, 2, 12, 0x28c5700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 2048, 3, 12, 0x3d28280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 1920, 2048, 4, 12, 0x518ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 256, 1, 12, 0x2b0380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 256, 2, 12, 0x562e00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 256, 3, 12, 0x814500 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 256, 4, 12, 0xac5c00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 384, 1, 12, 0x430300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 384, 2, 12, 0x865800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 384, 3, 12, 0xc98400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 384, 4, 12, 0x10cb000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 512, 1, 12, 0x560300 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 512, 2, 12, 0xac5800 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 512, 3, 12, 0x1028400 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 512, 4, 12, 0x158b000 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 640, 1, 12, 0x6f4280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 640, 2, 12, 0xdead00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 640, 3, 12, 0x14e0380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 640, 4, 12, 0x1bd5a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 768, 1, 12, 0x828280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 768, 2, 12, 0x1052d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 768, 3, 12, 0x187c380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 768, 4, 12, 0x20a5a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 896, 1, 12, 0x99c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 896, 2, 12, 0x133ad00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 896, 3, 12, 0x1cd8380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 896, 4, 12, 0x2675a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1024, 1, 12, 0xac0280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1024, 2, 12, 0x1582d00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1024, 3, 12, 0x2044380 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1024, 4, 12, 0x2b05a00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1152, 1, 12, 0xc64200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1152, 2, 12, 0x18cd700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1152, 3, 12, 0x2534280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1152, 4, 12, 0x319ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1280, 1, 12, 0xd98200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1280, 2, 12, 0x1b35700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1280, 3, 12, 0x28d0280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1280, 4, 12, 0x366ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1408, 1, 12, 0xf0c200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1408, 2, 12, 0x1e1d700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1408, 3, 12, 0x2d2c280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1408, 4, 12, 0x3c3ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1536, 1, 12, 0x1034200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1536, 2, 12, 0x206d700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1536, 3, 12, 0x30a4280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1536, 4, 12, 0x40dae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1664, 1, 12, 0x11b8200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1664, 2, 12, 0x2375700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1664, 3, 12, 0x3530280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1664, 4, 12, 0x46eae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1792, 1, 12, 0x12ec200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1792, 2, 12, 0x25dd700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1792, 3, 12, 0x38cc280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1792, 4, 12, 0x4bbae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1920, 1, 12, 0x1460200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1920, 2, 12, 0x28c5700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1920, 3, 12, 0x3d28280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 1920, 4, 12, 0x518ae00 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 2048, 1, 12, 0x1580200 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 2048, 2, 12, 0x2b05700 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 2048, 3, 12, 0x4088280 },
   { PIPE_FORMAT_R8G8B8A8_UNORM, 2048, 2048, 4, 12, 0x560ae00 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 16, 1, 1, 0x280 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 24, 1, 1, 0x480 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 32, 1, 1, 0x480 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 40, 1, 1, 0x880 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 48, 1, 1, 0x880 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 56, 1, 1, 0x880 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 64, 1, 1, 0x880 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 72, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 80, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 88, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 96, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 104, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 112, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 120, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 128, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 136, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 144, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 152, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 160, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 168, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 176, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 184, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 192, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 200, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 208, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 216, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 224, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 232, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 240, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 248, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 16, 256, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 16, 1, 1, 0x480 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 24, 1, 1, 0x880 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 32, 1, 1, 0x880 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 40, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 48, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 56, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 64, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 72, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 80, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 88, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 96, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 104, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 112, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 120, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 128, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 136, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 144, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 152, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 160, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 168, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 176, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 184, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 192, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 200, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 208, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 216, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 224, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 232, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 240, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 248, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 24, 256, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 16, 1, 1, 0x480 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 24, 1, 1, 0x880 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 32, 1, 1, 0x880 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 40, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 48, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 56, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 64, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 72, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 80, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 88, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 96, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 104, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 112, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 120, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 128, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 136, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 144, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 152, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 160, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 168, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 176, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 184, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 192, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 200, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 208, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 216, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 224, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 232, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 240, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 248, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 32, 256, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 16, 1, 1, 0x880 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 24, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 32, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 40, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 48, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 56, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 64, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 72, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 80, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 88, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 96, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 104, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 112, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 120, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 128, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 136, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 144, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 152, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 160, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 168, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 176, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 184, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 192, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 200, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 208, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 216, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 224, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 232, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 240, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 248, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 40, 256, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 16, 1, 1, 0x880 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 24, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 32, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 40, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 48, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 56, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 64, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 72, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 80, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 88, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 96, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 104, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 112, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 120, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 128, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 136, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 144, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 152, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 160, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 168, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 176, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 184, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 192, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 200, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 208, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 216, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 224, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 232, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 240, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 248, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 48, 256, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 16, 1, 1, 0x880 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 24, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 32, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 40, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 48, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 56, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 64, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 72, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 80, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 88, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 96, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 104, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 112, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 120, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 128, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 136, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 144, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 152, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 160, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 168, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 176, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 184, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 192, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 200, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 208, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 216, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 224, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 232, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 240, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 248, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 56, 256, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 16, 1, 1, 0x880 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 24, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 32, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 40, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 48, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 56, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 64, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 72, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 80, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 88, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 96, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 104, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 112, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 120, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 128, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 136, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 144, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 152, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 160, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 168, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 176, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 184, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 192, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 200, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 208, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 216, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 224, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 232, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 240, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 248, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 64, 256, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 24, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 32, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 40, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 48, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 56, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 64, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 72, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 80, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 88, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 96, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 104, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 112, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 120, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 128, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 136, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 144, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 152, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 160, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 168, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 176, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 184, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 192, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 200, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 208, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 216, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 224, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 232, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 240, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 248, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 72, 256, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 24, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 32, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 40, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 48, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 56, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 64, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 72, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 80, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 88, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 96, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 104, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 112, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 120, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 128, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 136, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 144, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 152, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 160, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 168, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 176, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 184, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 192, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 200, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 208, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 216, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 224, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 232, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 240, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 248, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 80, 256, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 24, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 32, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 40, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 48, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 56, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 64, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 72, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 80, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 88, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 96, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 104, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 112, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 120, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 128, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 136, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 144, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 152, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 160, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 168, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 176, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 184, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 192, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 200, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 208, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 216, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 224, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 232, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 240, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 248, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 88, 256, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 24, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 32, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 40, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 48, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 56, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 64, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 72, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 80, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 88, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 96, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 104, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 112, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 120, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 128, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 136, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 144, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 152, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 160, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 168, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 176, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 184, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 192, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 200, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 208, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 216, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 224, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 232, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 240, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 248, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 96, 256, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 24, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 32, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 40, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 48, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 56, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 64, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 72, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 80, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 88, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 96, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 104, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 112, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 120, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 128, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 136, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 144, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 152, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 160, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 168, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 176, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 184, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 192, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 200, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 208, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 216, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 224, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 232, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 240, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 248, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 104, 256, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 24, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 32, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 40, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 48, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 56, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 64, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 72, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 80, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 88, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 96, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 104, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 112, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 120, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 128, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 136, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 144, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 152, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 160, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 168, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 176, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 184, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 192, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 200, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 208, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 216, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 224, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 232, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 240, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 248, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 112, 256, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 24, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 32, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 40, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 48, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 56, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 64, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 72, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 80, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 88, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 96, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 104, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 112, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 120, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 128, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 136, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 144, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 152, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 160, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 168, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 176, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 184, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 192, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 200, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 208, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 216, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 224, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 232, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 240, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 248, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 120, 256, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 24, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 32, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 40, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 48, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 56, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 64, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 72, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 80, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 88, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 96, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 104, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 112, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 120, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 128, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 136, 1, 1, 0xc400 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 144, 1, 1, 0xc400 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 152, 1, 1, 0xc400 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 160, 1, 1, 0xc400 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 168, 1, 1, 0xc400 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 176, 1, 1, 0xc400 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 184, 1, 1, 0xc400 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 192, 1, 1, 0xc400 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 200, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 208, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 216, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 224, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 232, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 240, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 248, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 128, 256, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 24, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 32, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 40, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 48, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 56, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 64, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 72, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 80, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 88, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 96, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 104, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 112, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 120, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 128, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 136, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 144, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 152, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 160, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 168, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 176, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 184, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 192, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 200, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 208, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 216, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 224, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 232, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 240, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 248, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 136, 256, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 24, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 32, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 40, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 48, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 56, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 64, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 72, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 80, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 88, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 96, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 104, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 112, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 120, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 128, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 136, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 144, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 152, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 160, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 168, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 176, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 184, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 192, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 200, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 208, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 216, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 224, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 232, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 240, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 248, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 144, 256, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 24, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 32, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 40, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 48, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 56, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 64, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 72, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 80, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 88, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 96, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 104, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 112, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 120, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 128, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 136, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 144, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 152, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 160, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 168, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 176, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 184, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 192, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 200, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 208, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 216, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 224, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 232, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 240, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 248, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 152, 256, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 24, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 32, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 40, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 48, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 56, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 64, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 72, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 80, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 88, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 96, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 104, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 112, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 120, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 128, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 136, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 144, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 152, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 160, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 168, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 176, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 184, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 192, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 200, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 208, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 216, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 224, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 232, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 240, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 248, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 160, 256, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 24, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 32, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 40, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 48, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 56, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 64, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 72, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 80, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 88, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 96, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 104, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 112, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 120, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 128, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 136, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 144, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 152, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 160, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 168, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 176, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 184, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 192, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 200, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 208, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 216, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 224, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 232, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 240, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 248, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 168, 256, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 24, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 32, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 40, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 48, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 56, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 64, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 72, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 80, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 88, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 96, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 104, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 112, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 120, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 128, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 136, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 144, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 152, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 160, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 168, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 176, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 184, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 192, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 200, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 208, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 216, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 224, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 232, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 240, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 248, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 176, 256, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 24, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 32, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 40, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 48, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 56, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 64, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 72, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 80, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 88, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 96, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 104, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 112, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 120, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 128, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 136, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 144, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 152, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 160, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 168, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 176, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 184, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 192, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 200, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 208, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 216, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 224, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 232, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 240, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 248, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 184, 256, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 24, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 32, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 40, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 48, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 56, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 64, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 72, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 80, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 88, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 96, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 104, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 112, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 120, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 128, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 136, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 144, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 152, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 160, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 168, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 176, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 184, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 192, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 200, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 208, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 216, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 224, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 232, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 240, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 248, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 192, 256, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 24, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 32, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 40, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 48, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 56, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 64, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 72, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 80, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 88, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 96, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 104, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 112, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 120, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 128, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 136, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 144, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 152, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 160, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 168, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 176, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 184, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 192, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 200, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 208, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 216, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 224, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 232, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 240, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 248, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 200, 256, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 24, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 32, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 40, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 48, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 56, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 64, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 72, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 80, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 88, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 96, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 104, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 112, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 120, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 128, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 136, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 144, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 152, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 160, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 168, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 176, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 184, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 192, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 200, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 208, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 216, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 224, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 232, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 240, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 248, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 208, 256, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 24, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 32, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 40, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 48, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 56, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 64, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 72, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 80, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 88, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 96, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 104, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 112, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 120, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 128, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 136, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 144, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 152, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 160, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 168, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 176, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 184, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 192, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 200, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 208, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 216, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 224, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 232, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 240, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 248, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 216, 256, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 24, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 32, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 40, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 48, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 56, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 64, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 72, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 80, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 88, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 96, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 104, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 112, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 120, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 128, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 136, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 144, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 152, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 160, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 168, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 176, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 184, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 192, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 200, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 208, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 216, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 224, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 232, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 240, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 248, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 224, 256, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 24, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 32, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 40, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 48, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 56, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 64, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 72, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 80, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 88, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 96, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 104, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 112, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 120, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 128, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 136, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 144, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 152, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 160, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 168, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 176, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 184, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 192, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 200, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 208, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 216, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 224, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 232, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 240, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 248, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 232, 256, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 24, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 32, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 40, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 48, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 56, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 64, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 72, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 80, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 88, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 96, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 104, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 112, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 120, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 128, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 136, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 144, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 152, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 160, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 168, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 176, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 184, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 192, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 200, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 208, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 216, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 224, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 232, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 240, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 248, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 240, 256, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 24, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 32, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 40, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 48, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 56, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 64, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 72, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 80, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 88, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 96, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 104, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 112, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 120, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 128, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 136, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 144, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 152, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 160, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 168, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 176, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 184, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 192, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 200, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 208, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 216, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 224, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 232, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 240, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 248, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 248, 256, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 24, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 32, 1, 1, 0x4100 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 40, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 48, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 56, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 64, 1, 1, 0x8200 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 72, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 80, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 88, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 96, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 104, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 112, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 120, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 128, 1, 1, 0x10400 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 136, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 144, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 152, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 160, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 168, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 176, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 184, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 192, 1, 1, 0x18800 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 200, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 208, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 216, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 224, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 232, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 240, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 248, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8G8_UNORM, 256, 256, 1, 1, 0x20800 },
   { PIPE_FORMAT_R8_UNORM, 16, 16, 1, 1, 0x180 },
   { PIPE_FORMAT_R8_UNORM, 16, 16, 1, 5, 0x380 },
   { PIPE_FORMAT_R8_UNORM, 16, 16, 2, 5, 0x700 },
   { PIPE_FORMAT_R8_UNORM, 16, 17, 1, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 16, 17, 2, 5, 0xa00 },
   { PIPE_FORMAT_R8_UNORM, 16, 24, 1, 1, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 16, 31, 1, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 16, 31, 2, 5, 0xa00 },
   { PIPE_FORMAT_R8_UNORM, 16, 32, 1, 1, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 16, 32, 1, 6, 0x580 },
   { PIPE_FORMAT_R8_UNORM, 16, 32, 2, 6, 0xb00 },
   { PIPE_FORMAT_R8_UNORM, 16, 33, 1, 6, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 16, 33, 2, 6, 0x1000 },
   { PIPE_FORMAT_R8_UNORM, 16, 40, 1, 1, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 16, 48, 1, 1, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 16, 56, 1, 1, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 16, 63, 1, 6, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 16, 63, 2, 6, 0x1100 },
   { PIPE_FORMAT_R8_UNORM, 16, 64, 1, 1, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 16, 64, 1, 7, 0x900 },
   { PIPE_FORMAT_R8_UNORM, 16, 64, 2, 7, 0x1200 },
   { PIPE_FORMAT_R8_UNORM, 16, 65, 1, 7, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 16, 65, 2, 7, 0x1c00 },
   { PIPE_FORMAT_R8_UNORM, 16, 72, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 16, 80, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 16, 88, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 16, 96, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 16, 104, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 16, 112, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 16, 120, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 16, 127, 1, 7, 0xe80 },
   { PIPE_FORMAT_R8_UNORM, 16, 127, 2, 7, 0x1d00 },
   { PIPE_FORMAT_R8_UNORM, 16, 128, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 16, 128, 1, 8, 0xf00 },
   { PIPE_FORMAT_R8_UNORM, 16, 128, 2, 8, 0x1e00 },
   { PIPE_FORMAT_R8_UNORM, 16, 129, 1, 8, 0x1980 },
   { PIPE_FORMAT_R8_UNORM, 16, 129, 2, 8, 0x3300 },
   { PIPE_FORMAT_R8_UNORM, 16, 136, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 16, 144, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 16, 152, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 16, 160, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 16, 168, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 16, 176, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 16, 184, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 16, 192, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 16, 200, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 16, 208, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 16, 216, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 16, 224, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 16, 232, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 16, 240, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 16, 248, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 16, 255, 1, 8, 0x1a00 },
   { PIPE_FORMAT_R8_UNORM, 16, 255, 2, 8, 0x3400 },
   { PIPE_FORMAT_R8_UNORM, 16, 256, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 16, 256, 1, 9, 0x1a80 },
   { PIPE_FORMAT_R8_UNORM, 16, 256, 2, 9, 0x3500 },
   { PIPE_FORMAT_R8_UNORM, 16, 257, 1, 9, 0x3000 },
   { PIPE_FORMAT_R8_UNORM, 16, 257, 2, 9, 0x6000 },
   { PIPE_FORMAT_R8_UNORM, 16, 511, 1, 9, 0x3080 },
   { PIPE_FORMAT_R8_UNORM, 16, 511, 2, 9, 0x6100 },
   { PIPE_FORMAT_R8_UNORM, 16, 512, 1, 10, 0x3100 },
   { PIPE_FORMAT_R8_UNORM, 16, 512, 2, 10, 0x6200 },
   { PIPE_FORMAT_R8_UNORM, 16, 513, 1, 10, 0x5d00 },
   { PIPE_FORMAT_R8_UNORM, 16, 513, 2, 10, 0x10a00 },
   { PIPE_FORMAT_R8_UNORM, 16, 1023, 1, 10, 0x5d80 },
   { PIPE_FORMAT_R8_UNORM, 16, 1023, 2, 10, 0x10b00 },
   { PIPE_FORMAT_R8_UNORM, 16, 1024, 1, 11, 0x5e00 },
   { PIPE_FORMAT_R8_UNORM, 16, 1024, 2, 11, 0x10b00 },
   { PIPE_FORMAT_R8_UNORM, 16, 1025, 1, 11, 0xb680 },
   { PIPE_FORMAT_R8_UNORM, 16, 1025, 2, 11, 0x19200 },
   { PIPE_FORMAT_R8_UNORM, 16, 2047, 1, 11, 0xb700 },
   { PIPE_FORMAT_R8_UNORM, 16, 2047, 2, 11, 0x19300 },
   { PIPE_FORMAT_R8_UNORM, 16, 2048, 1, 12, 0xb780 },
   { PIPE_FORMAT_R8_UNORM, 16, 2048, 2, 12, 0x19300 },
   { PIPE_FORMAT_R8_UNORM, 16, 2049, 1, 12, 0x16980 },
   { PIPE_FORMAT_R8_UNORM, 16, 2049, 2, 12, 0x32200 },
   { PIPE_FORMAT_R8_UNORM, 16, 4095, 1, 12, 0x16a00 },
   { PIPE_FORMAT_R8_UNORM, 16, 4095, 2, 12, 0x32300 },
   { PIPE_FORMAT_R8_UNORM, 16, 4096, 1, 13, 0x16a80 },
   { PIPE_FORMAT_R8_UNORM, 16, 4096, 2, 13, 0x32300 },
   { PIPE_FORMAT_R8_UNORM, 16, 4097, 1, 13, 0x2cf80 },
   { PIPE_FORMAT_R8_UNORM, 16, 4097, 2, 13, 0x5c200 },
   { PIPE_FORMAT_R8_UNORM, 17, 16, 1, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 17, 16, 2, 5, 0xa00 },
   { PIPE_FORMAT_R8_UNORM, 17, 17, 1, 5, 0x780 },
   { PIPE_FORMAT_R8_UNORM, 17, 17, 2, 5, 0xf00 },
   { PIPE_FORMAT_R8_UNORM, 17, 31, 1, 5, 0x780 },
   { PIPE_FORMAT_R8_UNORM, 17, 31, 2, 5, 0xf00 },
   { PIPE_FORMAT_R8_UNORM, 17, 32, 1, 6, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 17, 32, 2, 6, 0x1000 },
   { PIPE_FORMAT_R8_UNORM, 17, 33, 1, 6, 0xd00 },
   { PIPE_FORMAT_R8_UNORM, 17, 33, 2, 6, 0x1a00 },
   { PIPE_FORMAT_R8_UNORM, 17, 63, 1, 6, 0xd80 },
   { PIPE_FORMAT_R8_UNORM, 17, 63, 2, 6, 0x1b00 },
   { PIPE_FORMAT_R8_UNORM, 17, 64, 1, 7, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 17, 64, 2, 7, 0x1c00 },
   { PIPE_FORMAT_R8_UNORM, 17, 65, 1, 7, 0x1880 },
   { PIPE_FORMAT_R8_UNORM, 17, 65, 2, 7, 0x3100 },
   { PIPE_FORMAT_R8_UNORM, 17, 127, 1, 7, 0x1900 },
   { PIPE_FORMAT_R8_UNORM, 17, 127, 2, 7, 0x3200 },
   { PIPE_FORMAT_R8_UNORM, 17, 128, 1, 8, 0x1980 },
   { PIPE_FORMAT_R8_UNORM, 17, 128, 2, 8, 0x3300 },
   { PIPE_FORMAT_R8_UNORM, 17, 129, 1, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 17, 129, 2, 8, 0x5e00 },
   { PIPE_FORMAT_R8_UNORM, 17, 255, 1, 8, 0x2f80 },
   { PIPE_FORMAT_R8_UNORM, 17, 255, 2, 8, 0x5f00 },
   { PIPE_FORMAT_R8_UNORM, 17, 256, 1, 9, 0x3000 },
   { PIPE_FORMAT_R8_UNORM, 17, 256, 2, 9, 0x6000 },
   { PIPE_FORMAT_R8_UNORM, 17, 257, 1, 9, 0x5b80 },
   { PIPE_FORMAT_R8_UNORM, 17, 257, 2, 9, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 17, 511, 1, 9, 0x5c00 },
   { PIPE_FORMAT_R8_UNORM, 17, 511, 2, 9, 0x10900 },
   { PIPE_FORMAT_R8_UNORM, 17, 512, 1, 10, 0x5c80 },
   { PIPE_FORMAT_R8_UNORM, 17, 512, 2, 10, 0x10900 },
   { PIPE_FORMAT_R8_UNORM, 17, 513, 1, 10, 0xb400 },
   { PIPE_FORMAT_R8_UNORM, 17, 513, 2, 10, 0x18e00 },
   { PIPE_FORMAT_R8_UNORM, 17, 1023, 1, 10, 0xb480 },
   { PIPE_FORMAT_R8_UNORM, 17, 1023, 2, 10, 0x18f00 },
   { PIPE_FORMAT_R8_UNORM, 17, 1024, 1, 11, 0xb500 },
   { PIPE_FORMAT_R8_UNORM, 17, 1024, 2, 11, 0x18f00 },
   { PIPE_FORMAT_R8_UNORM, 17, 1025, 1, 11, 0x16500 },
   { PIPE_FORMAT_R8_UNORM, 17, 1025, 2, 11, 0x31a00 },
   { PIPE_FORMAT_R8_UNORM, 17, 2047, 1, 11, 0x16580 },
   { PIPE_FORMAT_R8_UNORM, 17, 2047, 2, 11, 0x31b00 },
   { PIPE_FORMAT_R8_UNORM, 17, 2048, 1, 12, 0x16600 },
   { PIPE_FORMAT_R8_UNORM, 17, 2048, 2, 12, 0x31b00 },
   { PIPE_FORMAT_R8_UNORM, 17, 2049, 1, 12, 0x2c680 },
   { PIPE_FORMAT_R8_UNORM, 17, 2049, 2, 12, 0x5b200 },
   { PIPE_FORMAT_R8_UNORM, 17, 4095, 1, 12, 0x2c700 },
   { PIPE_FORMAT_R8_UNORM, 17, 4095, 2, 12, 0x5b300 },
   { PIPE_FORMAT_R8_UNORM, 17, 4096, 1, 13, 0x2c780 },
   { PIPE_FORMAT_R8_UNORM, 17, 4096, 2, 13, 0x5b300 },
   { PIPE_FORMAT_R8_UNORM, 17, 4097, 1, 13, 0x58980 },
   { PIPE_FORMAT_R8_UNORM, 17, 4097, 2, 13, 0xb6200 },
   { PIPE_FORMAT_R8_UNORM, 24, 16, 1, 1, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 24, 24, 1, 1, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 24, 32, 1, 1, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 24, 40, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 24, 48, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 24, 56, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 24, 64, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 24, 72, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 24, 80, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 24, 88, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 24, 96, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 24, 104, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 24, 112, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 24, 120, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 24, 128, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 24, 136, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 24, 144, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 24, 152, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 24, 160, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 24, 168, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 24, 176, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 24, 184, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 24, 192, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 24, 200, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 24, 208, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 24, 216, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 24, 224, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 24, 232, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 24, 240, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 24, 248, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 24, 256, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 31, 16, 1, 5, 0x500 },
   { PIPE_FORMAT_R8_UNORM, 31, 16, 2, 5, 0xa00 },
   { PIPE_FORMAT_R8_UNORM, 31, 17, 1, 5, 0x780 },
   { PIPE_FORMAT_R8_UNORM, 31, 17, 2, 5, 0xf00 },
   { PIPE_FORMAT_R8_UNORM, 31, 31, 1, 5, 0x780 },
   { PIPE_FORMAT_R8_UNORM, 31, 31, 2, 5, 0xf00 },
   { PIPE_FORMAT_R8_UNORM, 31, 32, 1, 6, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 31, 32, 2, 6, 0x1000 },
   { PIPE_FORMAT_R8_UNORM, 31, 33, 1, 6, 0xd00 },
   { PIPE_FORMAT_R8_UNORM, 31, 33, 2, 6, 0x1a00 },
   { PIPE_FORMAT_R8_UNORM, 31, 63, 1, 6, 0xd80 },
   { PIPE_FORMAT_R8_UNORM, 31, 63, 2, 6, 0x1b00 },
   { PIPE_FORMAT_R8_UNORM, 31, 64, 1, 7, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 31, 64, 2, 7, 0x1c00 },
   { PIPE_FORMAT_R8_UNORM, 31, 65, 1, 7, 0x1880 },
   { PIPE_FORMAT_R8_UNORM, 31, 65, 2, 7, 0x3100 },
   { PIPE_FORMAT_R8_UNORM, 31, 127, 1, 7, 0x1900 },
   { PIPE_FORMAT_R8_UNORM, 31, 127, 2, 7, 0x3200 },
   { PIPE_FORMAT_R8_UNORM, 31, 128, 1, 8, 0x1980 },
   { PIPE_FORMAT_R8_UNORM, 31, 128, 2, 8, 0x3300 },
   { PIPE_FORMAT_R8_UNORM, 31, 129, 1, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 31, 129, 2, 8, 0x5e00 },
   { PIPE_FORMAT_R8_UNORM, 31, 255, 1, 8, 0x2f80 },
   { PIPE_FORMAT_R8_UNORM, 31, 255, 2, 8, 0x5f00 },
   { PIPE_FORMAT_R8_UNORM, 31, 256, 1, 9, 0x3000 },
   { PIPE_FORMAT_R8_UNORM, 31, 256, 2, 9, 0x6000 },
   { PIPE_FORMAT_R8_UNORM, 31, 257, 1, 9, 0x5b80 },
   { PIPE_FORMAT_R8_UNORM, 31, 257, 2, 9, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 31, 511, 1, 9, 0x5c00 },
   { PIPE_FORMAT_R8_UNORM, 31, 511, 2, 9, 0x10900 },
   { PIPE_FORMAT_R8_UNORM, 31, 512, 1, 10, 0x5c80 },
   { PIPE_FORMAT_R8_UNORM, 31, 512, 2, 10, 0x10900 },
   { PIPE_FORMAT_R8_UNORM, 31, 513, 1, 10, 0xb400 },
   { PIPE_FORMAT_R8_UNORM, 31, 513, 2, 10, 0x18e00 },
   { PIPE_FORMAT_R8_UNORM, 31, 1023, 1, 10, 0xb480 },
   { PIPE_FORMAT_R8_UNORM, 31, 1023, 2, 10, 0x18f00 },
   { PIPE_FORMAT_R8_UNORM, 31, 1024, 1, 11, 0xb500 },
   { PIPE_FORMAT_R8_UNORM, 31, 1024, 2, 11, 0x18f00 },
   { PIPE_FORMAT_R8_UNORM, 31, 1025, 1, 11, 0x16500 },
   { PIPE_FORMAT_R8_UNORM, 31, 1025, 2, 11, 0x31a00 },
   { PIPE_FORMAT_R8_UNORM, 31, 2047, 1, 11, 0x16580 },
   { PIPE_FORMAT_R8_UNORM, 31, 2047, 2, 11, 0x31b00 },
   { PIPE_FORMAT_R8_UNORM, 31, 2048, 1, 12, 0x16600 },
   { PIPE_FORMAT_R8_UNORM, 31, 2048, 2, 12, 0x31b00 },
   { PIPE_FORMAT_R8_UNORM, 31, 2049, 1, 12, 0x2c680 },
   { PIPE_FORMAT_R8_UNORM, 31, 2049, 2, 12, 0x5b200 },
   { PIPE_FORMAT_R8_UNORM, 31, 4095, 1, 12, 0x2c700 },
   { PIPE_FORMAT_R8_UNORM, 31, 4095, 2, 12, 0x5b300 },
   { PIPE_FORMAT_R8_UNORM, 31, 4096, 1, 13, 0x2c780 },
   { PIPE_FORMAT_R8_UNORM, 31, 4096, 2, 13, 0x5b300 },
   { PIPE_FORMAT_R8_UNORM, 31, 4097, 1, 13, 0x58980 },
   { PIPE_FORMAT_R8_UNORM, 31, 4097, 2, 13, 0xb6200 },
   { PIPE_FORMAT_R8_UNORM, 32, 16, 1, 1, 0x280 },
   { PIPE_FORMAT_R8_UNORM, 32, 16, 1, 6, 0x580 },
   { PIPE_FORMAT_R8_UNORM, 32, 16, 2, 6, 0xb00 },
   { PIPE_FORMAT_R8_UNORM, 32, 17, 1, 6, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 32, 17, 2, 6, 0x1000 },
   { PIPE_FORMAT_R8_UNORM, 32, 24, 1, 1, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 32, 31, 1, 6, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 32, 31, 2, 6, 0x1000 },
   { PIPE_FORMAT_R8_UNORM, 32, 32, 1, 1, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 32, 32, 1, 6, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 32, 32, 2, 6, 0x1000 },
   { PIPE_FORMAT_R8_UNORM, 32, 33, 1, 6, 0xd00 },
   { PIPE_FORMAT_R8_UNORM, 32, 33, 2, 6, 0x1a00 },
   { PIPE_FORMAT_R8_UNORM, 32, 40, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 32, 48, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 32, 56, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 32, 63, 1, 6, 0xd80 },
   { PIPE_FORMAT_R8_UNORM, 32, 63, 2, 6, 0x1b00 },
   { PIPE_FORMAT_R8_UNORM, 32, 64, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 32, 64, 1, 7, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 32, 64, 2, 7, 0x1c00 },
   { PIPE_FORMAT_R8_UNORM, 32, 65, 1, 7, 0x1880 },
   { PIPE_FORMAT_R8_UNORM, 32, 65, 2, 7, 0x3100 },
   { PIPE_FORMAT_R8_UNORM, 32, 72, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 32, 80, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 32, 88, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 32, 96, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 32, 104, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 32, 112, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 32, 120, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 32, 127, 1, 7, 0x1900 },
   { PIPE_FORMAT_R8_UNORM, 32, 127, 2, 7, 0x3200 },
   { PIPE_FORMAT_R8_UNORM, 32, 128, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 32, 128, 1, 8, 0x1980 },
   { PIPE_FORMAT_R8_UNORM, 32, 128, 2, 8, 0x3300 },
   { PIPE_FORMAT_R8_UNORM, 32, 129, 1, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 32, 129, 2, 8, 0x5e00 },
   { PIPE_FORMAT_R8_UNORM, 32, 136, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 32, 144, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 32, 152, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 32, 160, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 32, 168, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 32, 176, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 32, 184, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 32, 192, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 32, 200, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 32, 208, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 32, 216, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 32, 224, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 32, 232, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 32, 240, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 32, 248, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 32, 255, 1, 8, 0x2f80 },
   { PIPE_FORMAT_R8_UNORM, 32, 255, 2, 8, 0x5f00 },
   { PIPE_FORMAT_R8_UNORM, 32, 256, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 32, 256, 1, 9, 0x3000 },
   { PIPE_FORMAT_R8_UNORM, 32, 256, 2, 9, 0x6000 },
   { PIPE_FORMAT_R8_UNORM, 32, 257, 1, 9, 0x5b80 },
   { PIPE_FORMAT_R8_UNORM, 32, 257, 2, 9, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 32, 511, 1, 9, 0x5c00 },
   { PIPE_FORMAT_R8_UNORM, 32, 511, 2, 9, 0x10900 },
   { PIPE_FORMAT_R8_UNORM, 32, 512, 1, 10, 0x5c80 },
   { PIPE_FORMAT_R8_UNORM, 32, 512, 2, 10, 0x10900 },
   { PIPE_FORMAT_R8_UNORM, 32, 513, 1, 10, 0xb400 },
   { PIPE_FORMAT_R8_UNORM, 32, 513, 2, 10, 0x18e00 },
   { PIPE_FORMAT_R8_UNORM, 32, 1023, 1, 10, 0xb480 },
   { PIPE_FORMAT_R8_UNORM, 32, 1023, 2, 10, 0x18f00 },
   { PIPE_FORMAT_R8_UNORM, 32, 1024, 1, 11, 0xb500 },
   { PIPE_FORMAT_R8_UNORM, 32, 1024, 2, 11, 0x18f00 },
   { PIPE_FORMAT_R8_UNORM, 32, 1025, 1, 11, 0x16500 },
   { PIPE_FORMAT_R8_UNORM, 32, 1025, 2, 11, 0x31a00 },
   { PIPE_FORMAT_R8_UNORM, 32, 2047, 1, 11, 0x16580 },
   { PIPE_FORMAT_R8_UNORM, 32, 2047, 2, 11, 0x31b00 },
   { PIPE_FORMAT_R8_UNORM, 32, 2048, 1, 12, 0x16600 },
   { PIPE_FORMAT_R8_UNORM, 32, 2048, 2, 12, 0x31b00 },
   { PIPE_FORMAT_R8_UNORM, 32, 2049, 1, 12, 0x2c680 },
   { PIPE_FORMAT_R8_UNORM, 32, 2049, 2, 12, 0x5b200 },
   { PIPE_FORMAT_R8_UNORM, 32, 4095, 1, 12, 0x2c700 },
   { PIPE_FORMAT_R8_UNORM, 32, 4095, 2, 12, 0x5b300 },
   { PIPE_FORMAT_R8_UNORM, 32, 4096, 1, 13, 0x2c780 },
   { PIPE_FORMAT_R8_UNORM, 32, 4096, 2, 13, 0x5b300 },
   { PIPE_FORMAT_R8_UNORM, 32, 4097, 1, 13, 0x58980 },
   { PIPE_FORMAT_R8_UNORM, 32, 4097, 2, 13, 0xb6200 },
   { PIPE_FORMAT_R8_UNORM, 33, 16, 1, 6, 0x800 },
   { PIPE_FORMAT_R8_UNORM, 33, 16, 2, 6, 0x1000 },
   { PIPE_FORMAT_R8_UNORM, 33, 17, 1, 6, 0xd00 },
   { PIPE_FORMAT_R8_UNORM, 33, 17, 2, 6, 0x1a00 },
   { PIPE_FORMAT_R8_UNORM, 33, 31, 1, 6, 0xd00 },
   { PIPE_FORMAT_R8_UNORM, 33, 31, 2, 6, 0x1a00 },
   { PIPE_FORMAT_R8_UNORM, 33, 32, 1, 6, 0xd00 },
   { PIPE_FORMAT_R8_UNORM, 33, 32, 2, 6, 0x1a00 },
   { PIPE_FORMAT_R8_UNORM, 33, 33, 1, 6, 0x1780 },
   { PIPE_FORMAT_R8_UNORM, 33, 33, 2, 6, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 33, 63, 1, 6, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 33, 63, 2, 6, 0x3000 },
   { PIPE_FORMAT_R8_UNORM, 33, 64, 1, 7, 0x1880 },
   { PIPE_FORMAT_R8_UNORM, 33, 64, 2, 7, 0x3100 },
   { PIPE_FORMAT_R8_UNORM, 33, 65, 1, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 33, 65, 2, 7, 0x5c00 },
   { PIPE_FORMAT_R8_UNORM, 33, 127, 1, 7, 0x2e80 },
   { PIPE_FORMAT_R8_UNORM, 33, 127, 2, 7, 0x5d00 },
   { PIPE_FORMAT_R8_UNORM, 33, 128, 1, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 33, 128, 2, 8, 0x5e00 },
   { PIPE_FORMAT_R8_UNORM, 33, 129, 1, 8, 0x5a80 },
   { PIPE_FORMAT_R8_UNORM, 33, 129, 2, 8, 0x10700 },
   { PIPE_FORMAT_R8_UNORM, 33, 255, 1, 8, 0x5b00 },
   { PIPE_FORMAT_R8_UNORM, 33, 255, 2, 8, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 33, 256, 1, 9, 0x5b80 },
   { PIPE_FORMAT_R8_UNORM, 33, 256, 2, 9, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 33, 257, 1, 9, 0xb300 },
   { PIPE_FORMAT_R8_UNORM, 33, 257, 2, 9, 0x18d00 },
   { PIPE_FORMAT_R8_UNORM, 33, 511, 1, 9, 0xb380 },
   { PIPE_FORMAT_R8_UNORM, 33, 511, 2, 9, 0x18e00 },
   { PIPE_FORMAT_R8_UNORM, 33, 512, 1, 10, 0xb400 },
   { PIPE_FORMAT_R8_UNORM, 33, 512, 2, 10, 0x18e00 },
   { PIPE_FORMAT_R8_UNORM, 33, 513, 1, 10, 0x16380 },
   { PIPE_FORMAT_R8_UNORM, 33, 513, 2, 10, 0x31800 },
   { PIPE_FORMAT_R8_UNORM, 33, 1023, 1, 10, 0x16400 },
   { PIPE_FORMAT_R8_UNORM, 33, 1023, 2, 10, 0x31900 },
   { PIPE_FORMAT_R8_UNORM, 33, 1024, 1, 11, 0x16480 },
   { PIPE_FORMAT_R8_UNORM, 33, 1024, 2, 11, 0x31900 },
   { PIPE_FORMAT_R8_UNORM, 33, 1025, 1, 11, 0x2c400 },
   { PIPE_FORMAT_R8_UNORM, 33, 1025, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_R8_UNORM, 33, 2047, 1, 11, 0x2c480 },
   { PIPE_FORMAT_R8_UNORM, 33, 2047, 2, 11, 0x5af00 },
   { PIPE_FORMAT_R8_UNORM, 33, 2048, 1, 12, 0x2c500 },
   { PIPE_FORMAT_R8_UNORM, 33, 2048, 2, 12, 0x5af00 },
   { PIPE_FORMAT_R8_UNORM, 33, 2049, 1, 12, 0x58500 },
   { PIPE_FORMAT_R8_UNORM, 33, 2049, 2, 12, 0xb5a00 },
   { PIPE_FORMAT_R8_UNORM, 33, 4095, 1, 12, 0x58580 },
   { PIPE_FORMAT_R8_UNORM, 33, 4095, 2, 12, 0xb5b00 },
   { PIPE_FORMAT_R8_UNORM, 33, 4096, 1, 13, 0x58600 },
   { PIPE_FORMAT_R8_UNORM, 33, 4096, 2, 13, 0xb5b00 },
   { PIPE_FORMAT_R8_UNORM, 33, 4097, 1, 13, 0xb0680 },
   { PIPE_FORMAT_R8_UNORM, 33, 4097, 2, 13, 0x163200 },
   { PIPE_FORMAT_R8_UNORM, 40, 16, 1, 1, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 40, 24, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 40, 32, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 40, 40, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 40, 48, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 40, 56, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 40, 64, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 40, 72, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 40, 80, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 40, 88, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 40, 96, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 40, 104, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 40, 112, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 40, 120, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 40, 128, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 40, 136, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 40, 144, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 40, 152, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 40, 160, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 40, 168, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 40, 176, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 40, 184, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 40, 192, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 40, 200, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 40, 208, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 40, 216, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 40, 224, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 40, 232, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 40, 240, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 40, 248, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 40, 256, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 48, 16, 1, 1, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 48, 24, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 48, 32, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 48, 40, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 48, 48, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 48, 56, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 48, 64, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 48, 72, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 48, 80, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 48, 88, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 48, 96, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 48, 104, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 48, 112, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 48, 120, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 48, 128, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 48, 136, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 48, 144, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 48, 152, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 48, 160, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 48, 168, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 48, 176, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 48, 184, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 48, 192, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 48, 200, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 48, 208, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 48, 216, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 48, 224, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 48, 232, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 48, 240, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 48, 248, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 48, 256, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 56, 16, 1, 1, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 56, 24, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 56, 32, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 56, 40, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 56, 48, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 56, 56, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 56, 64, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 56, 72, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 56, 80, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 56, 88, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 56, 96, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 56, 104, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 56, 112, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 56, 120, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 56, 128, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 56, 136, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 56, 144, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 56, 152, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 56, 160, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 56, 168, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 56, 176, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 56, 184, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 56, 192, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 56, 200, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 56, 208, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 56, 216, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 56, 224, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 56, 232, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 56, 240, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 56, 248, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 56, 256, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 63, 16, 1, 6, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 63, 16, 2, 6, 0x1100 },
   { PIPE_FORMAT_R8_UNORM, 63, 17, 1, 6, 0xd80 },
   { PIPE_FORMAT_R8_UNORM, 63, 17, 2, 6, 0x1b00 },
   { PIPE_FORMAT_R8_UNORM, 63, 31, 1, 6, 0xd80 },
   { PIPE_FORMAT_R8_UNORM, 63, 31, 2, 6, 0x1b00 },
   { PIPE_FORMAT_R8_UNORM, 63, 32, 1, 6, 0xd80 },
   { PIPE_FORMAT_R8_UNORM, 63, 32, 2, 6, 0x1b00 },
   { PIPE_FORMAT_R8_UNORM, 63, 33, 1, 6, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 63, 33, 2, 6, 0x3000 },
   { PIPE_FORMAT_R8_UNORM, 63, 63, 1, 6, 0x1800 },
   { PIPE_FORMAT_R8_UNORM, 63, 63, 2, 6, 0x3000 },
   { PIPE_FORMAT_R8_UNORM, 63, 64, 1, 7, 0x1880 },
   { PIPE_FORMAT_R8_UNORM, 63, 64, 2, 7, 0x3100 },
   { PIPE_FORMAT_R8_UNORM, 63, 65, 1, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 63, 65, 2, 7, 0x5c00 },
   { PIPE_FORMAT_R8_UNORM, 63, 127, 1, 7, 0x2e80 },
   { PIPE_FORMAT_R8_UNORM, 63, 127, 2, 7, 0x5d00 },
   { PIPE_FORMAT_R8_UNORM, 63, 128, 1, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 63, 128, 2, 8, 0x5e00 },
   { PIPE_FORMAT_R8_UNORM, 63, 129, 1, 8, 0x5a80 },
   { PIPE_FORMAT_R8_UNORM, 63, 129, 2, 8, 0x10700 },
   { PIPE_FORMAT_R8_UNORM, 63, 255, 1, 8, 0x5b00 },
   { PIPE_FORMAT_R8_UNORM, 63, 255, 2, 8, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 63, 256, 1, 9, 0x5b80 },
   { PIPE_FORMAT_R8_UNORM, 63, 256, 2, 9, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 63, 257, 1, 9, 0xb300 },
   { PIPE_FORMAT_R8_UNORM, 63, 257, 2, 9, 0x18d00 },
   { PIPE_FORMAT_R8_UNORM, 63, 511, 1, 9, 0xb380 },
   { PIPE_FORMAT_R8_UNORM, 63, 511, 2, 9, 0x18e00 },
   { PIPE_FORMAT_R8_UNORM, 63, 512, 1, 10, 0xb400 },
   { PIPE_FORMAT_R8_UNORM, 63, 512, 2, 10, 0x18e00 },
   { PIPE_FORMAT_R8_UNORM, 63, 513, 1, 10, 0x16380 },
   { PIPE_FORMAT_R8_UNORM, 63, 513, 2, 10, 0x31800 },
   { PIPE_FORMAT_R8_UNORM, 63, 1023, 1, 10, 0x16400 },
   { PIPE_FORMAT_R8_UNORM, 63, 1023, 2, 10, 0x31900 },
   { PIPE_FORMAT_R8_UNORM, 63, 1024, 1, 11, 0x16480 },
   { PIPE_FORMAT_R8_UNORM, 63, 1024, 2, 11, 0x31900 },
   { PIPE_FORMAT_R8_UNORM, 63, 1025, 1, 11, 0x2c400 },
   { PIPE_FORMAT_R8_UNORM, 63, 1025, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_R8_UNORM, 63, 2047, 1, 11, 0x2c480 },
   { PIPE_FORMAT_R8_UNORM, 63, 2047, 2, 11, 0x5af00 },
   { PIPE_FORMAT_R8_UNORM, 63, 2048, 1, 12, 0x2c500 },
   { PIPE_FORMAT_R8_UNORM, 63, 2048, 2, 12, 0x5af00 },
   { PIPE_FORMAT_R8_UNORM, 63, 2049, 1, 12, 0x58500 },
   { PIPE_FORMAT_R8_UNORM, 63, 2049, 2, 12, 0xb5a00 },
   { PIPE_FORMAT_R8_UNORM, 63, 4095, 1, 12, 0x58580 },
   { PIPE_FORMAT_R8_UNORM, 63, 4095, 2, 12, 0xb5b00 },
   { PIPE_FORMAT_R8_UNORM, 63, 4096, 1, 13, 0x58600 },
   { PIPE_FORMAT_R8_UNORM, 63, 4096, 2, 13, 0xb5b00 },
   { PIPE_FORMAT_R8_UNORM, 63, 4097, 1, 13, 0xb0680 },
   { PIPE_FORMAT_R8_UNORM, 63, 4097, 2, 13, 0x163200 },
   { PIPE_FORMAT_R8_UNORM, 64, 16, 1, 1, 0x480 },
   { PIPE_FORMAT_R8_UNORM, 64, 16, 1, 7, 0x900 },
   { PIPE_FORMAT_R8_UNORM, 64, 16, 2, 7, 0x1200 },
   { PIPE_FORMAT_R8_UNORM, 64, 17, 1, 7, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 64, 17, 2, 7, 0x1c00 },
   { PIPE_FORMAT_R8_UNORM, 64, 24, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 64, 31, 1, 7, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 64, 31, 2, 7, 0x1c00 },
   { PIPE_FORMAT_R8_UNORM, 64, 32, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 64, 32, 1, 7, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 64, 32, 2, 7, 0x1c00 },
   { PIPE_FORMAT_R8_UNORM, 64, 33, 1, 7, 0x1880 },
   { PIPE_FORMAT_R8_UNORM, 64, 33, 2, 7, 0x3100 },
   { PIPE_FORMAT_R8_UNORM, 64, 40, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 64, 48, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 64, 56, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 64, 63, 1, 7, 0x1880 },
   { PIPE_FORMAT_R8_UNORM, 64, 63, 2, 7, 0x3100 },
   { PIPE_FORMAT_R8_UNORM, 64, 64, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 64, 64, 1, 7, 0x1880 },
   { PIPE_FORMAT_R8_UNORM, 64, 64, 2, 7, 0x3100 },
   { PIPE_FORMAT_R8_UNORM, 64, 65, 1, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 64, 65, 2, 7, 0x5c00 },
   { PIPE_FORMAT_R8_UNORM, 64, 72, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 64, 80, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 64, 88, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 64, 96, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 64, 104, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 64, 112, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 64, 120, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 64, 127, 1, 7, 0x2e80 },
   { PIPE_FORMAT_R8_UNORM, 64, 127, 2, 7, 0x5d00 },
   { PIPE_FORMAT_R8_UNORM, 64, 128, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 64, 128, 1, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 64, 128, 2, 8, 0x5e00 },
   { PIPE_FORMAT_R8_UNORM, 64, 129, 1, 8, 0x5a80 },
   { PIPE_FORMAT_R8_UNORM, 64, 129, 2, 8, 0x10700 },
   { PIPE_FORMAT_R8_UNORM, 64, 136, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 64, 144, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 64, 152, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 64, 160, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 64, 168, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 64, 176, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 64, 184, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 64, 192, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 64, 200, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 64, 208, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 64, 216, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 64, 224, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 64, 232, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 64, 240, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 64, 248, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 64, 255, 1, 8, 0x5b00 },
   { PIPE_FORMAT_R8_UNORM, 64, 255, 2, 8, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 64, 256, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 64, 256, 1, 9, 0x5b80 },
   { PIPE_FORMAT_R8_UNORM, 64, 256, 2, 9, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 64, 257, 1, 9, 0xb300 },
   { PIPE_FORMAT_R8_UNORM, 64, 257, 2, 9, 0x18d00 },
   { PIPE_FORMAT_R8_UNORM, 64, 511, 1, 9, 0xb380 },
   { PIPE_FORMAT_R8_UNORM, 64, 511, 2, 9, 0x18e00 },
   { PIPE_FORMAT_R8_UNORM, 64, 512, 1, 10, 0xb400 },
   { PIPE_FORMAT_R8_UNORM, 64, 512, 2, 10, 0x18e00 },
   { PIPE_FORMAT_R8_UNORM, 64, 513, 1, 10, 0x16380 },
   { PIPE_FORMAT_R8_UNORM, 64, 513, 2, 10, 0x31800 },
   { PIPE_FORMAT_R8_UNORM, 64, 1023, 1, 10, 0x16400 },
   { PIPE_FORMAT_R8_UNORM, 64, 1023, 2, 10, 0x31900 },
   { PIPE_FORMAT_R8_UNORM, 64, 1024, 1, 11, 0x16480 },
   { PIPE_FORMAT_R8_UNORM, 64, 1024, 2, 11, 0x31900 },
   { PIPE_FORMAT_R8_UNORM, 64, 1025, 1, 11, 0x2c400 },
   { PIPE_FORMAT_R8_UNORM, 64, 1025, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_R8_UNORM, 64, 2047, 1, 11, 0x2c480 },
   { PIPE_FORMAT_R8_UNORM, 64, 2047, 2, 11, 0x5af00 },
   { PIPE_FORMAT_R8_UNORM, 64, 2048, 1, 12, 0x2c500 },
   { PIPE_FORMAT_R8_UNORM, 64, 2048, 2, 12, 0x5af00 },
   { PIPE_FORMAT_R8_UNORM, 64, 2049, 1, 12, 0x58500 },
   { PIPE_FORMAT_R8_UNORM, 64, 2049, 2, 12, 0xb5a00 },
   { PIPE_FORMAT_R8_UNORM, 64, 4095, 1, 12, 0x58580 },
   { PIPE_FORMAT_R8_UNORM, 64, 4095, 2, 12, 0xb5b00 },
   { PIPE_FORMAT_R8_UNORM, 64, 4096, 1, 13, 0x58600 },
   { PIPE_FORMAT_R8_UNORM, 64, 4096, 2, 13, 0xb5b00 },
   { PIPE_FORMAT_R8_UNORM, 64, 4097, 1, 13, 0xb0680 },
   { PIPE_FORMAT_R8_UNORM, 64, 4097, 2, 13, 0x163200 },
   { PIPE_FORMAT_R8_UNORM, 65, 16, 1, 7, 0xe00 },
   { PIPE_FORMAT_R8_UNORM, 65, 16, 2, 7, 0x1c00 },
   { PIPE_FORMAT_R8_UNORM, 65, 17, 1, 7, 0x1880 },
   { PIPE_FORMAT_R8_UNORM, 65, 17, 2, 7, 0x3100 },
   { PIPE_FORMAT_R8_UNORM, 65, 31, 1, 7, 0x1880 },
   { PIPE_FORMAT_R8_UNORM, 65, 31, 2, 7, 0x3100 },
   { PIPE_FORMAT_R8_UNORM, 65, 32, 1, 7, 0x1880 },
   { PIPE_FORMAT_R8_UNORM, 65, 32, 2, 7, 0x3100 },
   { PIPE_FORMAT_R8_UNORM, 65, 33, 1, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 65, 33, 2, 7, 0x5c00 },
   { PIPE_FORMAT_R8_UNORM, 65, 63, 1, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 65, 63, 2, 7, 0x5c00 },
   { PIPE_FORMAT_R8_UNORM, 65, 64, 1, 7, 0x2e00 },
   { PIPE_FORMAT_R8_UNORM, 65, 64, 2, 7, 0x5c00 },
   { PIPE_FORMAT_R8_UNORM, 65, 65, 1, 7, 0x5980 },
   { PIPE_FORMAT_R8_UNORM, 65, 65, 2, 7, 0x10600 },
   { PIPE_FORMAT_R8_UNORM, 65, 127, 1, 7, 0x5a00 },
   { PIPE_FORMAT_R8_UNORM, 65, 127, 2, 7, 0x10700 },
   { PIPE_FORMAT_R8_UNORM, 65, 128, 1, 8, 0x5a80 },
   { PIPE_FORMAT_R8_UNORM, 65, 128, 2, 8, 0x10700 },
   { PIPE_FORMAT_R8_UNORM, 65, 129, 1, 8, 0xb200 },
   { PIPE_FORMAT_R8_UNORM, 65, 129, 2, 8, 0x18c00 },
   { PIPE_FORMAT_R8_UNORM, 65, 255, 1, 8, 0xb280 },
   { PIPE_FORMAT_R8_UNORM, 65, 255, 2, 8, 0x18d00 },
   { PIPE_FORMAT_R8_UNORM, 65, 256, 1, 9, 0xb300 },
   { PIPE_FORMAT_R8_UNORM, 65, 256, 2, 9, 0x18d00 },
   { PIPE_FORMAT_R8_UNORM, 65, 257, 1, 9, 0x16280 },
   { PIPE_FORMAT_R8_UNORM, 65, 257, 2, 9, 0x31700 },
   { PIPE_FORMAT_R8_UNORM, 65, 511, 1, 9, 0x16300 },
   { PIPE_FORMAT_R8_UNORM, 65, 511, 2, 9, 0x31800 },
   { PIPE_FORMAT_R8_UNORM, 65, 512, 1, 10, 0x16380 },
   { PIPE_FORMAT_R8_UNORM, 65, 512, 2, 10, 0x31800 },
   { PIPE_FORMAT_R8_UNORM, 65, 513, 1, 10, 0x2c300 },
   { PIPE_FORMAT_R8_UNORM, 65, 513, 2, 10, 0x5ad00 },
   { PIPE_FORMAT_R8_UNORM, 65, 1023, 1, 10, 0x2c380 },
   { PIPE_FORMAT_R8_UNORM, 65, 1023, 2, 10, 0x5ae00 },
   { PIPE_FORMAT_R8_UNORM, 65, 1024, 1, 11, 0x2c400 },
   { PIPE_FORMAT_R8_UNORM, 65, 1024, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_R8_UNORM, 65, 1025, 1, 11, 0x58380 },
   { PIPE_FORMAT_R8_UNORM, 65, 1025, 2, 11, 0xb5800 },
   { PIPE_FORMAT_R8_UNORM, 65, 2047, 1, 11, 0x58400 },
   { PIPE_FORMAT_R8_UNORM, 65, 2047, 2, 11, 0xb5900 },
   { PIPE_FORMAT_R8_UNORM, 65, 2048, 1, 12, 0x58480 },
   { PIPE_FORMAT_R8_UNORM, 65, 2048, 2, 12, 0xb5900 },
   { PIPE_FORMAT_R8_UNORM, 65, 2049, 1, 12, 0xb0400 },
   { PIPE_FORMAT_R8_UNORM, 65, 2049, 2, 12, 0x162e00 },
   { PIPE_FORMAT_R8_UNORM, 65, 4095, 1, 12, 0xb0480 },
   { PIPE_FORMAT_R8_UNORM, 65, 4095, 2, 12, 0x162f00 },
   { PIPE_FORMAT_R8_UNORM, 65, 4096, 1, 13, 0xb0500 },
   { PIPE_FORMAT_R8_UNORM, 65, 4096, 2, 13, 0x162f00 },
   { PIPE_FORMAT_R8_UNORM, 65, 4097, 1, 13, 0x160500 },
   { PIPE_FORMAT_R8_UNORM, 65, 4097, 2, 13, 0x2c5a00 },
   { PIPE_FORMAT_R8_UNORM, 72, 16, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 72, 24, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 72, 32, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 72, 40, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 72, 48, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 72, 56, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 72, 64, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 72, 72, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 72, 80, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 72, 88, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 72, 96, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 72, 104, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 72, 112, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 72, 120, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 72, 128, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 72, 136, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 72, 144, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 72, 152, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 72, 160, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 72, 168, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 72, 176, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 72, 184, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 72, 192, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 72, 200, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 72, 208, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 72, 216, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 72, 224, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 72, 232, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 72, 240, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 72, 248, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 72, 256, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 80, 16, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 80, 24, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 80, 32, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 80, 40, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 80, 48, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 80, 56, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 80, 64, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 80, 72, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 80, 80, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 80, 88, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 80, 96, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 80, 104, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 80, 112, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 80, 120, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 80, 128, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 80, 136, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 80, 144, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 80, 152, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 80, 160, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 80, 168, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 80, 176, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 80, 184, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 80, 192, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 80, 200, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 80, 208, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 80, 216, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 80, 224, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 80, 232, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 80, 240, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 80, 248, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 80, 256, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 88, 16, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 88, 24, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 88, 32, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 88, 40, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 88, 48, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 88, 56, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 88, 64, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 88, 72, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 88, 80, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 88, 88, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 88, 96, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 88, 104, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 88, 112, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 88, 120, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 88, 128, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 88, 136, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 88, 144, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 88, 152, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 88, 160, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 88, 168, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 88, 176, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 88, 184, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 88, 192, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 88, 200, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 88, 208, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 88, 216, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 88, 224, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 88, 232, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 88, 240, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 88, 248, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 88, 256, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 96, 16, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 96, 24, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 96, 32, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 96, 40, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 96, 48, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 96, 56, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 96, 64, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 96, 72, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 96, 80, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 96, 88, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 96, 96, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 96, 104, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 96, 112, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 96, 120, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 96, 128, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 96, 136, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 96, 144, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 96, 152, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 96, 160, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 96, 168, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 96, 176, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 96, 184, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 96, 192, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 96, 200, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 96, 208, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 96, 216, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 96, 224, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 96, 232, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 96, 240, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 96, 248, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 96, 256, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 104, 16, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 104, 24, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 104, 32, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 104, 40, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 104, 48, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 104, 56, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 104, 64, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 104, 72, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 104, 80, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 104, 88, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 104, 96, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 104, 104, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 104, 112, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 104, 120, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 104, 128, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 104, 136, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 104, 144, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 104, 152, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 104, 160, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 104, 168, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 104, 176, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 104, 184, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 104, 192, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 104, 200, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 104, 208, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 104, 216, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 104, 224, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 104, 232, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 104, 240, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 104, 248, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 104, 256, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 112, 16, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 112, 24, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 112, 32, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 112, 40, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 112, 48, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 112, 56, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 112, 64, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 112, 72, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 112, 80, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 112, 88, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 112, 96, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 112, 104, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 112, 112, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 112, 120, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 112, 128, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 112, 136, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 112, 144, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 112, 152, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 112, 160, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 112, 168, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 112, 176, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 112, 184, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 112, 192, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 112, 200, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 112, 208, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 112, 216, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 112, 224, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 112, 232, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 112, 240, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 112, 248, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 112, 256, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 120, 16, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 120, 24, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 120, 32, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 120, 40, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 120, 48, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 120, 56, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 120, 64, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 120, 72, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 120, 80, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 120, 88, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 120, 96, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 120, 104, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 120, 112, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 120, 120, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 120, 128, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 120, 136, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 120, 144, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 120, 152, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 120, 160, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 120, 168, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 120, 176, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 120, 184, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 120, 192, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 120, 200, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 120, 208, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 120, 216, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 120, 224, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 120, 232, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 120, 240, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 120, 248, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 120, 256, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 127, 16, 1, 7, 0xe80 },
   { PIPE_FORMAT_R8_UNORM, 127, 16, 2, 7, 0x1d00 },
   { PIPE_FORMAT_R8_UNORM, 127, 17, 1, 7, 0x1900 },
   { PIPE_FORMAT_R8_UNORM, 127, 17, 2, 7, 0x3200 },
   { PIPE_FORMAT_R8_UNORM, 127, 31, 1, 7, 0x1900 },
   { PIPE_FORMAT_R8_UNORM, 127, 31, 2, 7, 0x3200 },
   { PIPE_FORMAT_R8_UNORM, 127, 32, 1, 7, 0x1900 },
   { PIPE_FORMAT_R8_UNORM, 127, 32, 2, 7, 0x3200 },
   { PIPE_FORMAT_R8_UNORM, 127, 33, 1, 7, 0x2e80 },
   { PIPE_FORMAT_R8_UNORM, 127, 33, 2, 7, 0x5d00 },
   { PIPE_FORMAT_R8_UNORM, 127, 63, 1, 7, 0x2e80 },
   { PIPE_FORMAT_R8_UNORM, 127, 63, 2, 7, 0x5d00 },
   { PIPE_FORMAT_R8_UNORM, 127, 64, 1, 7, 0x2e80 },
   { PIPE_FORMAT_R8_UNORM, 127, 64, 2, 7, 0x5d00 },
   { PIPE_FORMAT_R8_UNORM, 127, 65, 1, 7, 0x5a00 },
   { PIPE_FORMAT_R8_UNORM, 127, 65, 2, 7, 0x10700 },
   { PIPE_FORMAT_R8_UNORM, 127, 127, 1, 7, 0x5a00 },
   { PIPE_FORMAT_R8_UNORM, 127, 127, 2, 7, 0x10700 },
   { PIPE_FORMAT_R8_UNORM, 127, 128, 1, 8, 0x5a80 },
   { PIPE_FORMAT_R8_UNORM, 127, 128, 2, 8, 0x10700 },
   { PIPE_FORMAT_R8_UNORM, 127, 129, 1, 8, 0xb200 },
   { PIPE_FORMAT_R8_UNORM, 127, 129, 2, 8, 0x18c00 },
   { PIPE_FORMAT_R8_UNORM, 127, 255, 1, 8, 0xb280 },
   { PIPE_FORMAT_R8_UNORM, 127, 255, 2, 8, 0x18d00 },
   { PIPE_FORMAT_R8_UNORM, 127, 256, 1, 9, 0xb300 },
   { PIPE_FORMAT_R8_UNORM, 127, 256, 2, 9, 0x18d00 },
   { PIPE_FORMAT_R8_UNORM, 127, 257, 1, 9, 0x16280 },
   { PIPE_FORMAT_R8_UNORM, 127, 257, 2, 9, 0x31700 },
   { PIPE_FORMAT_R8_UNORM, 127, 511, 1, 9, 0x16300 },
   { PIPE_FORMAT_R8_UNORM, 127, 511, 2, 9, 0x31800 },
   { PIPE_FORMAT_R8_UNORM, 127, 512, 1, 10, 0x16380 },
   { PIPE_FORMAT_R8_UNORM, 127, 512, 2, 10, 0x31800 },
   { PIPE_FORMAT_R8_UNORM, 127, 513, 1, 10, 0x2c300 },
   { PIPE_FORMAT_R8_UNORM, 127, 513, 2, 10, 0x5ad00 },
   { PIPE_FORMAT_R8_UNORM, 127, 1023, 1, 10, 0x2c380 },
   { PIPE_FORMAT_R8_UNORM, 127, 1023, 2, 10, 0x5ae00 },
   { PIPE_FORMAT_R8_UNORM, 127, 1024, 1, 11, 0x2c400 },
   { PIPE_FORMAT_R8_UNORM, 127, 1024, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_R8_UNORM, 127, 1025, 1, 11, 0x58380 },
   { PIPE_FORMAT_R8_UNORM, 127, 1025, 2, 11, 0xb5800 },
   { PIPE_FORMAT_R8_UNORM, 127, 2047, 1, 11, 0x58400 },
   { PIPE_FORMAT_R8_UNORM, 127, 2047, 2, 11, 0xb5900 },
   { PIPE_FORMAT_R8_UNORM, 127, 2048, 1, 12, 0x58480 },
   { PIPE_FORMAT_R8_UNORM, 127, 2048, 2, 12, 0xb5900 },
   { PIPE_FORMAT_R8_UNORM, 127, 2049, 1, 12, 0xb0400 },
   { PIPE_FORMAT_R8_UNORM, 127, 2049, 2, 12, 0x162e00 },
   { PIPE_FORMAT_R8_UNORM, 127, 4095, 1, 12, 0xb0480 },
   { PIPE_FORMAT_R8_UNORM, 127, 4095, 2, 12, 0x162f00 },
   { PIPE_FORMAT_R8_UNORM, 127, 4096, 1, 13, 0xb0500 },
   { PIPE_FORMAT_R8_UNORM, 127, 4096, 2, 13, 0x162f00 },
   { PIPE_FORMAT_R8_UNORM, 127, 4097, 1, 13, 0x160500 },
   { PIPE_FORMAT_R8_UNORM, 127, 4097, 2, 13, 0x2c5a00 },
   { PIPE_FORMAT_R8_UNORM, 128, 16, 1, 1, 0x880 },
   { PIPE_FORMAT_R8_UNORM, 128, 16, 1, 8, 0xf00 },
   { PIPE_FORMAT_R8_UNORM, 128, 16, 2, 8, 0x1e00 },
   { PIPE_FORMAT_R8_UNORM, 128, 17, 1, 8, 0x1980 },
   { PIPE_FORMAT_R8_UNORM, 128, 17, 2, 8, 0x3300 },
   { PIPE_FORMAT_R8_UNORM, 128, 24, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 128, 31, 1, 8, 0x1980 },
   { PIPE_FORMAT_R8_UNORM, 128, 31, 2, 8, 0x3300 },
   { PIPE_FORMAT_R8_UNORM, 128, 32, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 128, 32, 1, 8, 0x1980 },
   { PIPE_FORMAT_R8_UNORM, 128, 32, 2, 8, 0x3300 },
   { PIPE_FORMAT_R8_UNORM, 128, 33, 1, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 128, 33, 2, 8, 0x5e00 },
   { PIPE_FORMAT_R8_UNORM, 128, 40, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 128, 48, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 128, 56, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 128, 63, 1, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 128, 63, 2, 8, 0x5e00 },
   { PIPE_FORMAT_R8_UNORM, 128, 64, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 128, 64, 1, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 128, 64, 2, 8, 0x5e00 },
   { PIPE_FORMAT_R8_UNORM, 128, 65, 1, 8, 0x5a80 },
   { PIPE_FORMAT_R8_UNORM, 128, 65, 2, 8, 0x10700 },
   { PIPE_FORMAT_R8_UNORM, 128, 72, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 128, 80, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 128, 88, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 128, 96, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 128, 104, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 128, 112, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 128, 120, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 128, 127, 1, 8, 0x5a80 },
   { PIPE_FORMAT_R8_UNORM, 128, 127, 2, 8, 0x10700 },
   { PIPE_FORMAT_R8_UNORM, 128, 128, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 128, 128, 1, 8, 0x5a80 },
   { PIPE_FORMAT_R8_UNORM, 128, 128, 2, 8, 0x10700 },
   { PIPE_FORMAT_R8_UNORM, 128, 129, 1, 8, 0x9d00 },
   { PIPE_FORMAT_R8_UNORM, 128, 129, 2, 8, 0x18c00 },
   { PIPE_FORMAT_R8_UNORM, 128, 136, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 128, 144, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 128, 152, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 128, 160, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 128, 168, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 128, 176, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 128, 184, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 128, 192, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 128, 200, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 128, 208, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 128, 216, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 128, 224, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 128, 232, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 128, 240, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 128, 248, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 128, 255, 1, 8, 0xb280 },
   { PIPE_FORMAT_R8_UNORM, 128, 255, 2, 8, 0x18d00 },
   { PIPE_FORMAT_R8_UNORM, 128, 256, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 128, 256, 1, 9, 0xb300 },
   { PIPE_FORMAT_R8_UNORM, 128, 256, 2, 9, 0x18d00 },
   { PIPE_FORMAT_R8_UNORM, 128, 257, 1, 9, 0xf800 },
   { PIPE_FORMAT_R8_UNORM, 128, 257, 2, 9, 0x21700 },
   { PIPE_FORMAT_R8_UNORM, 128, 511, 1, 9, 0x16300 },
   { PIPE_FORMAT_R8_UNORM, 128, 511, 2, 9, 0x31800 },
   { PIPE_FORMAT_R8_UNORM, 128, 512, 1, 10, 0x16380 },
   { PIPE_FORMAT_R8_UNORM, 128, 512, 2, 10, 0x31800 },
   { PIPE_FORMAT_R8_UNORM, 128, 513, 1, 10, 0x1ae00 },
   { PIPE_FORMAT_R8_UNORM, 128, 513, 2, 10, 0x3ad00 },
   { PIPE_FORMAT_R8_UNORM, 128, 1023, 1, 10, 0x2c380 },
   { PIPE_FORMAT_R8_UNORM, 128, 1023, 2, 10, 0x5ae00 },
   { PIPE_FORMAT_R8_UNORM, 128, 1024, 1, 11, 0x2c400 },
   { PIPE_FORMAT_R8_UNORM, 128, 1024, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_R8_UNORM, 128, 1025, 1, 11, 0x31900 },
   { PIPE_FORMAT_R8_UNORM, 128, 1025, 2, 11, 0x65800 },
   { PIPE_FORMAT_R8_UNORM, 128, 2047, 1, 11, 0x58400 },
   { PIPE_FORMAT_R8_UNORM, 128, 2047, 2, 11, 0xb5900 },
   { PIPE_FORMAT_R8_UNORM, 128, 2048, 1, 12, 0x58480 },
   { PIPE_FORMAT_R8_UNORM, 128, 2048, 2, 12, 0xb5900 },
   { PIPE_FORMAT_R8_UNORM, 128, 2049, 1, 12, 0x5ef00 },
   { PIPE_FORMAT_R8_UNORM, 128, 2049, 2, 12, 0xc2e00 },
   { PIPE_FORMAT_R8_UNORM, 128, 4095, 1, 12, 0xb0480 },
   { PIPE_FORMAT_R8_UNORM, 128, 4095, 2, 12, 0x162f00 },
   { PIPE_FORMAT_R8_UNORM, 128, 4096, 1, 13, 0xb0500 },
   { PIPE_FORMAT_R8_UNORM, 128, 4096, 2, 13, 0x162f00 },
   { PIPE_FORMAT_R8_UNORM, 128, 4097, 1, 13, 0xb9a80 },
   { PIPE_FORMAT_R8_UNORM, 128, 4097, 2, 13, 0x175a00 },
   { PIPE_FORMAT_R8_UNORM, 129, 16, 1, 8, 0x1980 },
   { PIPE_FORMAT_R8_UNORM, 129, 16, 2, 8, 0x3300 },
   { PIPE_FORMAT_R8_UNORM, 129, 17, 1, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 129, 17, 2, 8, 0x5e00 },
   { PIPE_FORMAT_R8_UNORM, 129, 31, 1, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 129, 31, 2, 8, 0x5e00 },
   { PIPE_FORMAT_R8_UNORM, 129, 32, 1, 8, 0x2f00 },
   { PIPE_FORMAT_R8_UNORM, 129, 32, 2, 8, 0x5e00 },
   { PIPE_FORMAT_R8_UNORM, 129, 33, 1, 8, 0x5a80 },
   { PIPE_FORMAT_R8_UNORM, 129, 33, 2, 8, 0x10700 },
   { PIPE_FORMAT_R8_UNORM, 129, 63, 1, 8, 0x5a80 },
   { PIPE_FORMAT_R8_UNORM, 129, 63, 2, 8, 0x10700 },
   { PIPE_FORMAT_R8_UNORM, 129, 64, 1, 8, 0x5a80 },
   { PIPE_FORMAT_R8_UNORM, 129, 64, 2, 8, 0x10700 },
   { PIPE_FORMAT_R8_UNORM, 129, 65, 1, 8, 0xb200 },
   { PIPE_FORMAT_R8_UNORM, 129, 65, 2, 8, 0x18c00 },
   { PIPE_FORMAT_R8_UNORM, 129, 127, 1, 8, 0xb200 },
   { PIPE_FORMAT_R8_UNORM, 129, 127, 2, 8, 0x18c00 },
   { PIPE_FORMAT_R8_UNORM, 129, 128, 1, 8, 0x9d00 },
   { PIPE_FORMAT_R8_UNORM, 129, 128, 2, 8, 0x18c00 },
   { PIPE_FORMAT_R8_UNORM, 129, 129, 1, 8, 0x12200 },
   { PIPE_FORMAT_R8_UNORM, 129, 129, 2, 8, 0x29600 },
   { PIPE_FORMAT_R8_UNORM, 129, 255, 1, 8, 0x13780 },
   { PIPE_FORMAT_R8_UNORM, 129, 255, 2, 8, 0x29700 },
   { PIPE_FORMAT_R8_UNORM, 129, 256, 1, 9, 0x13800 },
   { PIPE_FORMAT_R8_UNORM, 129, 256, 2, 9, 0x29700 },
   { PIPE_FORMAT_R8_UNORM, 129, 257, 1, 9, 0x1c280 },
   { PIPE_FORMAT_R8_UNORM, 129, 257, 2, 9, 0x3ac00 },
   { PIPE_FORMAT_R8_UNORM, 129, 511, 1, 9, 0x26d80 },
   { PIPE_FORMAT_R8_UNORM, 129, 511, 2, 9, 0x52d00 },
   { PIPE_FORMAT_R8_UNORM, 129, 512, 1, 10, 0x26e00 },
   { PIPE_FORMAT_R8_UNORM, 129, 512, 2, 10, 0x52d00 },
   { PIPE_FORMAT_R8_UNORM, 129, 513, 1, 10, 0x30300 },
   { PIPE_FORMAT_R8_UNORM, 129, 513, 2, 10, 0x65700 },
   { PIPE_FORMAT_R8_UNORM, 129, 1023, 1, 10, 0x4d880 },
   { PIPE_FORMAT_R8_UNORM, 129, 1023, 2, 10, 0x9d800 },
   { PIPE_FORMAT_R8_UNORM, 129, 1024, 1, 11, 0x4d900 },
   { PIPE_FORMAT_R8_UNORM, 129, 1024, 2, 11, 0x9d800 },
   { PIPE_FORMAT_R8_UNORM, 129, 1025, 1, 11, 0x58380 },
   { PIPE_FORMAT_R8_UNORM, 129, 1025, 2, 11, 0xb2d00 },
   { PIPE_FORMAT_R8_UNORM, 129, 2047, 1, 11, 0x9ae80 },
   { PIPE_FORMAT_R8_UNORM, 129, 2047, 2, 11, 0x13ae00 },
   { PIPE_FORMAT_R8_UNORM, 129, 2048, 1, 12, 0x9af00 },
   { PIPE_FORMAT_R8_UNORM, 129, 2048, 2, 12, 0x13ae00 },
   { PIPE_FORMAT_R8_UNORM, 129, 2049, 1, 12, 0xa8400 },
   { PIPE_FORMAT_R8_UNORM, 129, 2049, 2, 12, 0x155800 },
   { PIPE_FORMAT_R8_UNORM, 129, 4095, 1, 12, 0x135980 },
   { PIPE_FORMAT_R8_UNORM, 129, 4095, 2, 12, 0x26d900 },
   { PIPE_FORMAT_R8_UNORM, 129, 4096, 1, 13, 0x135a00 },
   { PIPE_FORMAT_R8_UNORM, 129, 4096, 2, 13, 0x26d900 },
   { PIPE_FORMAT_R8_UNORM, 129, 4097, 1, 13, 0x148480 },
   { PIPE_FORMAT_R8_UNORM, 129, 4097, 2, 13, 0x292e00 },
   { PIPE_FORMAT_R8_UNORM, 136, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 136, 24, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 136, 32, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 136, 40, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 136, 48, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 136, 56, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 136, 64, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 136, 72, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 136, 80, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 136, 88, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 136, 96, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 136, 104, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 136, 112, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 136, 120, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 136, 128, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 136, 136, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 136, 144, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 136, 152, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 136, 160, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 136, 168, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 136, 176, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 136, 184, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 136, 192, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 136, 200, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 136, 208, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 136, 216, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 136, 224, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 136, 232, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 136, 240, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 136, 248, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 136, 256, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 144, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 144, 24, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 144, 32, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 144, 40, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 144, 48, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 144, 56, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 144, 64, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 144, 72, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 144, 80, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 144, 88, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 144, 96, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 144, 104, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 144, 112, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 144, 120, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 144, 128, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 144, 136, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 144, 144, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 144, 152, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 144, 160, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 144, 168, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 144, 176, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 144, 184, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 144, 192, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 144, 200, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 144, 208, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 144, 216, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 144, 224, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 144, 232, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 144, 240, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 144, 248, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 144, 256, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 152, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 152, 24, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 152, 32, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 152, 40, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 152, 48, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 152, 56, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 152, 64, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 152, 72, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 152, 80, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 152, 88, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 152, 96, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 152, 104, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 152, 112, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 152, 120, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 152, 128, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 152, 136, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 152, 144, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 152, 152, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 152, 160, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 152, 168, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 152, 176, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 152, 184, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 152, 192, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 152, 200, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 152, 208, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 152, 216, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 152, 224, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 152, 232, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 152, 240, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 152, 248, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 152, 256, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 160, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 160, 24, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 160, 32, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 160, 40, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 160, 48, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 160, 56, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 160, 64, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 160, 72, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 160, 80, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 160, 88, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 160, 96, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 160, 104, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 160, 112, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 160, 120, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 160, 128, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 160, 136, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 160, 144, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 160, 152, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 160, 160, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 160, 168, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 160, 176, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 160, 184, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 160, 192, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 160, 200, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 160, 208, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 160, 216, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 160, 224, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 160, 232, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 160, 240, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 160, 248, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 160, 256, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 168, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 168, 24, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 168, 32, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 168, 40, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 168, 48, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 168, 56, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 168, 64, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 168, 72, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 168, 80, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 168, 88, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 168, 96, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 168, 104, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 168, 112, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 168, 120, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 168, 128, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 168, 136, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 168, 144, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 168, 152, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 168, 160, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 168, 168, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 168, 176, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 168, 184, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 168, 192, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 168, 200, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 168, 208, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 168, 216, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 168, 224, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 168, 232, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 168, 240, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 168, 248, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 168, 256, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 176, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 176, 24, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 176, 32, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 176, 40, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 176, 48, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 176, 56, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 176, 64, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 176, 72, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 176, 80, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 176, 88, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 176, 96, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 176, 104, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 176, 112, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 176, 120, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 176, 128, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 176, 136, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 176, 144, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 176, 152, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 176, 160, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 176, 168, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 176, 176, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 176, 184, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 176, 192, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 176, 200, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 176, 208, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 176, 216, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 176, 224, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 176, 232, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 176, 240, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 176, 248, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 176, 256, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 184, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 184, 24, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 184, 32, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 184, 40, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 184, 48, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 184, 56, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 184, 64, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 184, 72, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 184, 80, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 184, 88, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 184, 96, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 184, 104, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 184, 112, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 184, 120, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 184, 128, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 184, 136, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 184, 144, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 184, 152, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 184, 160, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 184, 168, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 184, 176, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 184, 184, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 184, 192, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 184, 200, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 184, 208, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 184, 216, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 184, 224, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 184, 232, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 184, 240, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 184, 248, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 184, 256, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 192, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 192, 24, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 192, 32, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 192, 40, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 192, 48, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 192, 56, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 192, 64, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 192, 72, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 192, 80, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 192, 88, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 192, 96, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 192, 104, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 192, 112, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 192, 120, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 192, 128, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 192, 136, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 192, 144, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 192, 152, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 192, 160, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 192, 168, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 192, 176, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 192, 184, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 192, 192, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 192, 200, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 192, 208, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 192, 216, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 192, 224, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 192, 232, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 192, 240, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 192, 248, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 192, 256, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 200, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 200, 24, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 200, 32, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 200, 40, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 200, 48, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 200, 56, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 200, 64, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 200, 72, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 200, 80, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 200, 88, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 200, 96, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 200, 104, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 200, 112, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 200, 120, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 200, 128, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 200, 136, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 200, 144, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 200, 152, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 200, 160, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 200, 168, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 200, 176, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 200, 184, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 200, 192, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 200, 200, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 200, 208, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 200, 216, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 200, 224, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 200, 232, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 200, 240, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 200, 248, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 200, 256, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 208, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 208, 24, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 208, 32, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 208, 40, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 208, 48, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 208, 56, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 208, 64, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 208, 72, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 208, 80, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 208, 88, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 208, 96, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 208, 104, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 208, 112, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 208, 120, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 208, 128, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 208, 136, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 208, 144, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 208, 152, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 208, 160, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 208, 168, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 208, 176, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 208, 184, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 208, 192, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 208, 200, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 208, 208, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 208, 216, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 208, 224, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 208, 232, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 208, 240, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 208, 248, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 208, 256, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 216, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 216, 24, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 216, 32, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 216, 40, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 216, 48, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 216, 56, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 216, 64, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 216, 72, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 216, 80, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 216, 88, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 216, 96, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 216, 104, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 216, 112, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 216, 120, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 216, 128, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 216, 136, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 216, 144, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 216, 152, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 216, 160, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 216, 168, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 216, 176, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 216, 184, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 216, 192, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 216, 200, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 216, 208, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 216, 216, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 216, 224, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 216, 232, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 216, 240, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 216, 248, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 216, 256, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 224, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 224, 24, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 224, 32, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 224, 40, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 224, 48, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 224, 56, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 224, 64, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 224, 72, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 224, 80, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 224, 88, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 224, 96, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 224, 104, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 224, 112, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 224, 120, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 224, 128, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 224, 136, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 224, 144, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 224, 152, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 224, 160, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 224, 168, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 224, 176, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 224, 184, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 224, 192, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 224, 200, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 224, 208, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 224, 216, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 224, 224, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 224, 232, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 224, 240, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 224, 248, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 224, 256, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 232, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 232, 24, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 232, 32, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 232, 40, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 232, 48, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 232, 56, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 232, 64, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 232, 72, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 232, 80, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 232, 88, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 232, 96, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 232, 104, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 232, 112, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 232, 120, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 232, 128, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 232, 136, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 232, 144, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 232, 152, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 232, 160, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 232, 168, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 232, 176, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 232, 184, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 232, 192, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 232, 200, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 232, 208, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 232, 216, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 232, 224, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 232, 232, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 232, 240, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 232, 248, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 232, 256, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 240, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 240, 24, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 240, 32, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 240, 40, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 240, 48, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 240, 56, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 240, 64, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 240, 72, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 240, 80, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 240, 88, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 240, 96, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 240, 104, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 240, 112, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 240, 120, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 240, 128, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 240, 136, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 240, 144, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 240, 152, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 240, 160, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 240, 168, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 240, 176, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 240, 184, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 240, 192, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 240, 200, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 240, 208, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 240, 216, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 240, 224, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 240, 232, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 240, 240, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 240, 248, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 240, 256, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 248, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 248, 24, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 248, 32, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 248, 40, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 248, 48, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 248, 56, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 248, 64, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 248, 72, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 248, 80, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 248, 88, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 248, 96, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 248, 104, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 248, 112, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 248, 120, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 248, 128, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 248, 136, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 248, 144, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 248, 152, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 248, 160, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 248, 168, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 248, 176, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 248, 184, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 248, 192, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 248, 200, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 248, 208, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 248, 216, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 248, 224, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 248, 232, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 248, 240, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 248, 248, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 248, 256, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 255, 16, 1, 8, 0x1a00 },
   { PIPE_FORMAT_R8_UNORM, 255, 16, 2, 8, 0x3400 },
   { PIPE_FORMAT_R8_UNORM, 255, 17, 1, 8, 0x2f80 },
   { PIPE_FORMAT_R8_UNORM, 255, 17, 2, 8, 0x5f00 },
   { PIPE_FORMAT_R8_UNORM, 255, 31, 1, 8, 0x2f80 },
   { PIPE_FORMAT_R8_UNORM, 255, 31, 2, 8, 0x5f00 },
   { PIPE_FORMAT_R8_UNORM, 255, 32, 1, 8, 0x2f80 },
   { PIPE_FORMAT_R8_UNORM, 255, 32, 2, 8, 0x5f00 },
   { PIPE_FORMAT_R8_UNORM, 255, 33, 1, 8, 0x5b00 },
   { PIPE_FORMAT_R8_UNORM, 255, 33, 2, 8, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 255, 63, 1, 8, 0x5b00 },
   { PIPE_FORMAT_R8_UNORM, 255, 63, 2, 8, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 255, 64, 1, 8, 0x5b00 },
   { PIPE_FORMAT_R8_UNORM, 255, 64, 2, 8, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 255, 65, 1, 8, 0xb280 },
   { PIPE_FORMAT_R8_UNORM, 255, 65, 2, 8, 0x18d00 },
   { PIPE_FORMAT_R8_UNORM, 255, 127, 1, 8, 0xb280 },
   { PIPE_FORMAT_R8_UNORM, 255, 127, 2, 8, 0x18d00 },
   { PIPE_FORMAT_R8_UNORM, 255, 128, 1, 8, 0xb280 },
   { PIPE_FORMAT_R8_UNORM, 255, 128, 2, 8, 0x18d00 },
   { PIPE_FORMAT_R8_UNORM, 255, 129, 1, 8, 0x13780 },
   { PIPE_FORMAT_R8_UNORM, 255, 129, 2, 8, 0x29700 },
   { PIPE_FORMAT_R8_UNORM, 255, 255, 1, 8, 0x16200 },
   { PIPE_FORMAT_R8_UNORM, 255, 255, 2, 8, 0x31700 },
   { PIPE_FORMAT_R8_UNORM, 255, 256, 1, 9, 0x16280 },
   { PIPE_FORMAT_R8_UNORM, 255, 256, 2, 9, 0x31700 },
   { PIPE_FORMAT_R8_UNORM, 255, 257, 1, 9, 0x1ed00 },
   { PIPE_FORMAT_R8_UNORM, 255, 257, 2, 9, 0x42c00 },
   { PIPE_FORMAT_R8_UNORM, 255, 511, 1, 9, 0x2c280 },
   { PIPE_FORMAT_R8_UNORM, 255, 511, 2, 9, 0x5ad00 },
   { PIPE_FORMAT_R8_UNORM, 255, 512, 1, 10, 0x2c300 },
   { PIPE_FORMAT_R8_UNORM, 255, 512, 2, 10, 0x5ad00 },
   { PIPE_FORMAT_R8_UNORM, 255, 513, 1, 10, 0x35800 },
   { PIPE_FORMAT_R8_UNORM, 255, 513, 2, 10, 0x6d700 },
   { PIPE_FORMAT_R8_UNORM, 255, 1023, 1, 10, 0x58300 },
   { PIPE_FORMAT_R8_UNORM, 255, 1023, 2, 10, 0xb5800 },
   { PIPE_FORMAT_R8_UNORM, 255, 1024, 1, 11, 0x58380 },
   { PIPE_FORMAT_R8_UNORM, 255, 1024, 2, 11, 0xb5800 },
   { PIPE_FORMAT_R8_UNORM, 255, 1025, 1, 11, 0x62e00 },
   { PIPE_FORMAT_R8_UNORM, 255, 1025, 2, 11, 0xcad00 },
   { PIPE_FORMAT_R8_UNORM, 255, 2047, 1, 11, 0xb0380 },
   { PIPE_FORMAT_R8_UNORM, 255, 2047, 2, 11, 0x162e00 },
   { PIPE_FORMAT_R8_UNORM, 255, 2048, 1, 12, 0xb0400 },
   { PIPE_FORMAT_R8_UNORM, 255, 2048, 2, 12, 0x162e00 },
   { PIPE_FORMAT_R8_UNORM, 255, 2049, 1, 12, 0xbd900 },
   { PIPE_FORMAT_R8_UNORM, 255, 2049, 2, 12, 0x17d800 },
   { PIPE_FORMAT_R8_UNORM, 255, 4095, 1, 12, 0x160400 },
   { PIPE_FORMAT_R8_UNORM, 255, 4095, 2, 12, 0x2c5900 },
   { PIPE_FORMAT_R8_UNORM, 255, 4096, 1, 13, 0x160480 },
   { PIPE_FORMAT_R8_UNORM, 255, 4096, 2, 13, 0x2c5900 },
   { PIPE_FORMAT_R8_UNORM, 255, 4097, 1, 13, 0x172f00 },
   { PIPE_FORMAT_R8_UNORM, 255, 4097, 2, 13, 0x2eae00 },
   { PIPE_FORMAT_R8_UNORM, 256, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_R8_UNORM, 256, 16, 1, 9, 0x1a80 },
   { PIPE_FORMAT_R8_UNORM, 256, 16, 2, 9, 0x3500 },
   { PIPE_FORMAT_R8_UNORM, 256, 17, 1, 9, 0x3000 },
   { PIPE_FORMAT_R8_UNORM, 256, 17, 2, 9, 0x6000 },
   { PIPE_FORMAT_R8_UNORM, 256, 24, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 256, 31, 1, 9, 0x3000 },
   { PIPE_FORMAT_R8_UNORM, 256, 31, 2, 9, 0x6000 },
   { PIPE_FORMAT_R8_UNORM, 256, 32, 1, 1, 0x2100 },
   { PIPE_FORMAT_R8_UNORM, 256, 32, 1, 9, 0x3000 },
   { PIPE_FORMAT_R8_UNORM, 256, 32, 2, 9, 0x6000 },
   { PIPE_FORMAT_R8_UNORM, 256, 33, 1, 9, 0x5b80 },
   { PIPE_FORMAT_R8_UNORM, 256, 33, 2, 9, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 256, 40, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 256, 48, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 256, 56, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 256, 63, 1, 9, 0x5b80 },
   { PIPE_FORMAT_R8_UNORM, 256, 63, 2, 9, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 256, 64, 1, 1, 0x4200 },
   { PIPE_FORMAT_R8_UNORM, 256, 64, 1, 9, 0x5b80 },
   { PIPE_FORMAT_R8_UNORM, 256, 64, 2, 9, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 256, 65, 1, 9, 0xb300 },
   { PIPE_FORMAT_R8_UNORM, 256, 65, 2, 9, 0x18d00 },
   { PIPE_FORMAT_R8_UNORM, 256, 72, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 256, 80, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 256, 88, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 256, 96, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 256, 104, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 256, 112, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 256, 120, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 256, 127, 1, 9, 0xb300 },
   { PIPE_FORMAT_R8_UNORM, 256, 127, 2, 9, 0x18d00 },
   { PIPE_FORMAT_R8_UNORM, 256, 128, 1, 1, 0x8400 },
   { PIPE_FORMAT_R8_UNORM, 256, 128, 1, 9, 0xb300 },
   { PIPE_FORMAT_R8_UNORM, 256, 128, 2, 9, 0x18d00 },
   { PIPE_FORMAT_R8_UNORM, 256, 129, 1, 9, 0x13800 },
   { PIPE_FORMAT_R8_UNORM, 256, 129, 2, 9, 0x29700 },
   { PIPE_FORMAT_R8_UNORM, 256, 136, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 256, 144, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 256, 152, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 256, 160, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 256, 168, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 256, 176, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 256, 184, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 256, 192, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 256, 200, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 256, 208, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 256, 216, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 256, 224, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 256, 232, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 256, 240, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 256, 248, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 256, 255, 1, 9, 0x16280 },
   { PIPE_FORMAT_R8_UNORM, 256, 255, 2, 9, 0x31700 },
   { PIPE_FORMAT_R8_UNORM, 256, 256, 1, 1, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 256, 256, 1, 9, 0x16280 },
   { PIPE_FORMAT_R8_UNORM, 256, 256, 2, 9, 0x31700 },
   { PIPE_FORMAT_R8_UNORM, 256, 257, 1, 9, 0x22d00 },
   { PIPE_FORMAT_R8_UNORM, 256, 257, 2, 9, 0x4ac00 },
   { PIPE_FORMAT_R8_UNORM, 256, 511, 1, 9, 0x2c280 },
   { PIPE_FORMAT_R8_UNORM, 256, 511, 2, 9, 0x5ad00 },
   { PIPE_FORMAT_R8_UNORM, 256, 512, 1, 10, 0x2c300 },
   { PIPE_FORMAT_R8_UNORM, 256, 512, 2, 10, 0x5ad00 },
   { PIPE_FORMAT_R8_UNORM, 256, 513, 1, 10, 0x39800 },
   { PIPE_FORMAT_R8_UNORM, 256, 513, 2, 10, 0x75700 },
   { PIPE_FORMAT_R8_UNORM, 256, 1023, 1, 10, 0x58300 },
   { PIPE_FORMAT_R8_UNORM, 256, 1023, 2, 10, 0xb5800 },
   { PIPE_FORMAT_R8_UNORM, 256, 1024, 1, 11, 0x58380 },
   { PIPE_FORMAT_R8_UNORM, 256, 1024, 2, 11, 0xb5800 },
   { PIPE_FORMAT_R8_UNORM, 256, 1025, 1, 11, 0x66e00 },
   { PIPE_FORMAT_R8_UNORM, 256, 1025, 2, 11, 0xd2d00 },
   { PIPE_FORMAT_R8_UNORM, 256, 2047, 1, 11, 0xb0380 },
   { PIPE_FORMAT_R8_UNORM, 256, 2047, 2, 11, 0x162e00 },
   { PIPE_FORMAT_R8_UNORM, 256, 2048, 1, 12, 0xb0400 },
   { PIPE_FORMAT_R8_UNORM, 256, 2048, 2, 12, 0x162e00 },
   { PIPE_FORMAT_R8_UNORM, 256, 2049, 1, 12, 0xc1900 },
   { PIPE_FORMAT_R8_UNORM, 256, 2049, 2, 12, 0x185800 },
   { PIPE_FORMAT_R8_UNORM, 256, 4095, 1, 12, 0x160400 },
   { PIPE_FORMAT_R8_UNORM, 256, 4095, 2, 12, 0x2c5900 },
   { PIPE_FORMAT_R8_UNORM, 256, 4096, 1, 13, 0x160480 },
   { PIPE_FORMAT_R8_UNORM, 256, 4096, 2, 13, 0x2c5900 },
   { PIPE_FORMAT_R8_UNORM, 256, 4097, 1, 13, 0x176f00 },
   { PIPE_FORMAT_R8_UNORM, 256, 4097, 2, 13, 0x2f2e00 },
   { PIPE_FORMAT_R8_UNORM, 257, 16, 1, 9, 0x3000 },
   { PIPE_FORMAT_R8_UNORM, 257, 16, 2, 9, 0x6000 },
   { PIPE_FORMAT_R8_UNORM, 257, 17, 1, 9, 0x5b80 },
   { PIPE_FORMAT_R8_UNORM, 257, 17, 2, 9, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 257, 31, 1, 9, 0x5b80 },
   { PIPE_FORMAT_R8_UNORM, 257, 31, 2, 9, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 257, 32, 1, 9, 0x5b80 },
   { PIPE_FORMAT_R8_UNORM, 257, 32, 2, 9, 0x10800 },
   { PIPE_FORMAT_R8_UNORM, 257, 33, 1, 9, 0xb300 },
   { PIPE_FORMAT_R8_UNORM, 257, 33, 2, 9, 0x18d00 },
   { PIPE_FORMAT_R8_UNORM, 257, 63, 1, 9, 0xb300 },
   { PIPE_FORMAT_R8_UNORM, 257, 63, 2, 9, 0x18d00 },
   { PIPE_FORMAT_R8_UNORM, 257, 64, 1, 9, 0xb300 },
   { PIPE_FORMAT_R8_UNORM, 257, 64, 2, 9, 0x18d00 },
   { PIPE_FORMAT_R8_UNORM, 257, 65, 1, 9, 0x16280 },
   { PIPE_FORMAT_R8_UNORM, 257, 65, 2, 9, 0x31700 },
   { PIPE_FORMAT_R8_UNORM, 257, 127, 1, 9, 0x16280 },
   { PIPE_FORMAT_R8_UNORM, 257, 127, 2, 9, 0x31700 },
   { PIPE_FORMAT_R8_UNORM, 257, 128, 1, 9, 0xf800 },
   { PIPE_FORMAT_R8_UNORM, 257, 128, 2, 9, 0x21700 },
   { PIPE_FORMAT_R8_UNORM, 257, 129, 1, 9, 0x1c280 },
   { PIPE_FORMAT_R8_UNORM, 257, 129, 2, 9, 0x3ac00 },
   { PIPE_FORMAT_R8_UNORM, 257, 255, 1, 9, 0x1ed00 },
   { PIPE_FORMAT_R8_UNORM, 257, 255, 2, 9, 0x42c00 },
   { PIPE_FORMAT_R8_UNORM, 257, 256, 1, 9, 0x22d00 },
   { PIPE_FORMAT_R8_UNORM, 257, 256, 2, 9, 0x4ac00 },
   { PIPE_FORMAT_R8_UNORM, 257, 257, 1, 9, 0x3c200 },
   { PIPE_FORMAT_R8_UNORM, 257, 257, 2, 9, 0x7d600 },
   { PIPE_FORMAT_R8_UNORM, 257, 511, 1, 9, 0x49780 },
   { PIPE_FORMAT_R8_UNORM, 257, 511, 2, 9, 0x95700 },
   { PIPE_FORMAT_R8_UNORM, 257, 512, 1, 10, 0x49800 },
   { PIPE_FORMAT_R8_UNORM, 257, 512, 2, 10, 0x95700 },
   { PIPE_FORMAT_R8_UNORM, 257, 513, 1, 10, 0x60280 },
   { PIPE_FORMAT_R8_UNORM, 257, 513, 2, 10, 0xc2c00 },
   { PIPE_FORMAT_R8_UNORM, 257, 1023, 1, 10, 0x92d80 },
   { PIPE_FORMAT_R8_UNORM, 257, 1023, 2, 10, 0x12ad00 },
   { PIPE_FORMAT_R8_UNORM, 257, 1024, 1, 11, 0x92e00 },
   { PIPE_FORMAT_R8_UNORM, 257, 1024, 2, 11, 0x12ad00 },
   { PIPE_FORMAT_R8_UNORM, 257, 1025, 1, 11, 0xac300 },
   { PIPE_FORMAT_R8_UNORM, 257, 1025, 2, 11, 0x15d700 },
   { PIPE_FORMAT_R8_UNORM, 257, 2047, 1, 11, 0x125880 },
   { PIPE_FORMAT_R8_UNORM, 257, 2047, 2, 11, 0x24d800 },
   { PIPE_FORMAT_R8_UNORM, 257, 2048, 1, 12, 0x125900 },
   { PIPE_FORMAT_R8_UNORM, 257, 2048, 2, 12, 0x24d800 },
   { PIPE_FORMAT_R8_UNORM, 257, 2049, 1, 12, 0x144380 },
   { PIPE_FORMAT_R8_UNORM, 257, 2049, 2, 12, 0x28ad00 },
   { PIPE_FORMAT_R8_UNORM, 257, 4095, 1, 12, 0x24ae80 },
   { PIPE_FORMAT_R8_UNORM, 257, 4095, 2, 12, 0x49ae00 },
   { PIPE_FORMAT_R8_UNORM, 257, 4096, 1, 13, 0x24af00 },
   { PIPE_FORMAT_R8_UNORM, 257, 4096, 2, 13, 0x49ae00 },
   { PIPE_FORMAT_R8_UNORM, 257, 4097, 1, 13, 0x274400 },
   { PIPE_FORMAT_R8_UNORM, 257, 4097, 2, 13, 0x4ed800 },
   { PIPE_FORMAT_R8_UNORM, 511, 16, 1, 9, 0x3080 },
   { PIPE_FORMAT_R8_UNORM, 511, 16, 2, 9, 0x6100 },
   { PIPE_FORMAT_R8_UNORM, 511, 17, 1, 9, 0x5c00 },
   { PIPE_FORMAT_R8_UNORM, 511, 17, 2, 9, 0x10900 },
   { PIPE_FORMAT_R8_UNORM, 511, 31, 1, 9, 0x5c00 },
   { PIPE_FORMAT_R8_UNORM, 511, 31, 2, 9, 0x10900 },
   { PIPE_FORMAT_R8_UNORM, 511, 32, 1, 9, 0x5c00 },
   { PIPE_FORMAT_R8_UNORM, 511, 32, 2, 9, 0x10900 },
   { PIPE_FORMAT_R8_UNORM, 511, 33, 1, 9, 0xb380 },
   { PIPE_FORMAT_R8_UNORM, 511, 33, 2, 9, 0x18e00 },
   { PIPE_FORMAT_R8_UNORM, 511, 63, 1, 9, 0xb380 },
   { PIPE_FORMAT_R8_UNORM, 511, 63, 2, 9, 0x18e00 },
   { PIPE_FORMAT_R8_UNORM, 511, 64, 1, 9, 0xb380 },
   { PIPE_FORMAT_R8_UNORM, 511, 64, 2, 9, 0x18e00 },
   { PIPE_FORMAT_R8_UNORM, 511, 65, 1, 9, 0x16300 },
   { PIPE_FORMAT_R8_UNORM, 511, 65, 2, 9, 0x31800 },
   { PIPE_FORMAT_R8_UNORM, 511, 127, 1, 9, 0x16300 },
   { PIPE_FORMAT_R8_UNORM, 511, 127, 2, 9, 0x31800 },
   { PIPE_FORMAT_R8_UNORM, 511, 128, 1, 9, 0x16300 },
   { PIPE_FORMAT_R8_UNORM, 511, 128, 2, 9, 0x31800 },
   { PIPE_FORMAT_R8_UNORM, 511, 129, 1, 9, 0x26d80 },
   { PIPE_FORMAT_R8_UNORM, 511, 129, 2, 9, 0x52d00 },
   { PIPE_FORMAT_R8_UNORM, 511, 255, 1, 9, 0x2c280 },
   { PIPE_FORMAT_R8_UNORM, 511, 255, 2, 9, 0x5ad00 },
   { PIPE_FORMAT_R8_UNORM, 511, 256, 1, 9, 0x2c280 },
   { PIPE_FORMAT_R8_UNORM, 511, 256, 2, 9, 0x5ad00 },
   { PIPE_FORMAT_R8_UNORM, 511, 257, 1, 9, 0x49780 },
   { PIPE_FORMAT_R8_UNORM, 511, 257, 2, 9, 0x95700 },
   { PIPE_FORMAT_R8_UNORM, 511, 511, 1, 9, 0x58200 },
   { PIPE_FORMAT_R8_UNORM, 511, 511, 2, 9, 0xb5700 },
   { PIPE_FORMAT_R8_UNORM, 511, 512, 1, 10, 0x58280 },
   { PIPE_FORMAT_R8_UNORM, 511, 512, 2, 10, 0xb5700 },
   { PIPE_FORMAT_R8_UNORM, 511, 513, 1, 10, 0x76d00 },
   { PIPE_FORMAT_R8_UNORM, 511, 513, 2, 10, 0xf2c00 },
   { PIPE_FORMAT_R8_UNORM, 511, 1023, 1, 10, 0xb0280 },
   { PIPE_FORMAT_R8_UNORM, 511, 1023, 2, 10, 0x162d00 },
   { PIPE_FORMAT_R8_UNORM, 511, 1024, 1, 11, 0xb0300 },
   { PIPE_FORMAT_R8_UNORM, 511, 1024, 2, 11, 0x162d00 },
   { PIPE_FORMAT_R8_UNORM, 511, 1025, 1, 11, 0xd1800 },
   { PIPE_FORMAT_R8_UNORM, 511, 1025, 2, 11, 0x1a5700 },
   { PIPE_FORMAT_R8_UNORM, 511, 2047, 1, 11, 0x160300 },
   { PIPE_FORMAT_R8_UNORM, 511, 2047, 2, 11, 0x2c5800 },
   { PIPE_FORMAT_R8_UNORM, 511, 2048, 1, 12, 0x160380 },
   { PIPE_FORMAT_R8_UNORM, 511, 2048, 2, 12, 0x2c5800 },
   { PIPE_FORMAT_R8_UNORM, 511, 2049, 1, 12, 0x186e00 },
   { PIPE_FORMAT_R8_UNORM, 511, 2049, 2, 12, 0x312d00 },
   { PIPE_FORMAT_R8_UNORM, 511, 4095, 1, 12, 0x2c0380 },
   { PIPE_FORMAT_R8_UNORM, 511, 4095, 2, 12, 0x582e00 },
   { PIPE_FORMAT_R8_UNORM, 511, 4096, 1, 13, 0x2c0400 },
   { PIPE_FORMAT_R8_UNORM, 511, 4096, 2, 13, 0x582e00 },
   { PIPE_FORMAT_R8_UNORM, 511, 4097, 1, 13, 0x2f1900 },
   { PIPE_FORMAT_R8_UNORM, 511, 4097, 2, 13, 0x5e5800 },
   { PIPE_FORMAT_R8_UNORM, 512, 16, 1, 10, 0x3100 },
   { PIPE_FORMAT_R8_UNORM, 512, 16, 2, 10, 0x6200 },
   { PIPE_FORMAT_R8_UNORM, 512, 17, 1, 10, 0x5c80 },
   { PIPE_FORMAT_R8_UNORM, 512, 17, 2, 10, 0x10900 },
   { PIPE_FORMAT_R8_UNORM, 512, 31, 1, 10, 0x5c80 },
   { PIPE_FORMAT_R8_UNORM, 512, 31, 2, 10, 0x10900 },
   { PIPE_FORMAT_R8_UNORM, 512, 32, 1, 10, 0x5c80 },
   { PIPE_FORMAT_R8_UNORM, 512, 32, 2, 10, 0x10900 },
   { PIPE_FORMAT_R8_UNORM, 512, 33, 1, 10, 0xb400 },
   { PIPE_FORMAT_R8_UNORM, 512, 33, 2, 10, 0x18e00 },
   { PIPE_FORMAT_R8_UNORM, 512, 63, 1, 10, 0xb400 },
   { PIPE_FORMAT_R8_UNORM, 512, 63, 2, 10, 0x18e00 },
   { PIPE_FORMAT_R8_UNORM, 512, 64, 1, 10, 0xb400 },
   { PIPE_FORMAT_R8_UNORM, 512, 64, 2, 10, 0x18e00 },
   { PIPE_FORMAT_R8_UNORM, 512, 65, 1, 10, 0x16380 },
   { PIPE_FORMAT_R8_UNORM, 512, 65, 2, 10, 0x31800 },
   { PIPE_FORMAT_R8_UNORM, 512, 127, 1, 10, 0x16380 },
   { PIPE_FORMAT_R8_UNORM, 512, 127, 2, 10, 0x31800 },
   { PIPE_FORMAT_R8_UNORM, 512, 128, 1, 10, 0x16380 },
   { PIPE_FORMAT_R8_UNORM, 512, 128, 2, 10, 0x31800 },
   { PIPE_FORMAT_R8_UNORM, 512, 129, 1, 10, 0x26e00 },
   { PIPE_FORMAT_R8_UNORM, 512, 129, 2, 10, 0x52d00 },
   { PIPE_FORMAT_R8_UNORM, 512, 255, 1, 10, 0x2c300 },
   { PIPE_FORMAT_R8_UNORM, 512, 255, 2, 10, 0x5ad00 },
   { PIPE_FORMAT_R8_UNORM, 512, 256, 1, 10, 0x2c300 },
   { PIPE_FORMAT_R8_UNORM, 512, 256, 2, 10, 0x5ad00 },
   { PIPE_FORMAT_R8_UNORM, 512, 257, 1, 10, 0x49800 },
   { PIPE_FORMAT_R8_UNORM, 512, 257, 2, 10, 0x95700 },
   { PIPE_FORMAT_R8_UNORM, 512, 511, 1, 10, 0x58280 },
   { PIPE_FORMAT_R8_UNORM, 512, 511, 2, 10, 0xb5700 },
   { PIPE_FORMAT_R8_UNORM, 512, 512, 1, 10, 0x58280 },
   { PIPE_FORMAT_R8_UNORM, 512, 512, 2, 10, 0xb5700 },
   { PIPE_FORMAT_R8_UNORM, 512, 513, 1, 10, 0x7ad00 },
   { PIPE_FORMAT_R8_UNORM, 512, 513, 2, 10, 0xfac00 },
   { PIPE_FORMAT_R8_UNORM, 512, 1023, 1, 10, 0xb0280 },
   { PIPE_FORMAT_R8_UNORM, 512, 1023, 2, 10, 0x162d00 },
   { PIPE_FORMAT_R8_UNORM, 512, 1024, 1, 11, 0xb0300 },
   { PIPE_FORMAT_R8_UNORM, 512, 1024, 2, 11, 0x162d00 },
   { PIPE_FORMAT_R8_UNORM, 512, 1025, 1, 11, 0xd5800 },
   { PIPE_FORMAT_R8_UNORM, 512, 1025, 2, 11, 0x1ad700 },
   { PIPE_FORMAT_R8_UNORM, 512, 2047, 1, 11, 0x160300 },
   { PIPE_FORMAT_R8_UNORM, 512, 2047, 2, 11, 0x2c5800 },
   { PIPE_FORMAT_R8_UNORM, 512, 2048, 1, 12, 0x160380 },
   { PIPE_FORMAT_R8_UNORM, 512, 2048, 2, 12, 0x2c5800 },
   { PIPE_FORMAT_R8_UNORM, 512, 2049, 1, 12, 0x18ae00 },
   { PIPE_FORMAT_R8_UNORM, 512, 2049, 2, 12, 0x31ad00 },
   { PIPE_FORMAT_R8_UNORM, 512, 4095, 1, 12, 0x2c0380 },
   { PIPE_FORMAT_R8_UNORM, 512, 4095, 2, 12, 0x582e00 },
   { PIPE_FORMAT_R8_UNORM, 512, 4096, 1, 13, 0x2c0400 },
   { PIPE_FORMAT_R8_UNORM, 512, 4096, 2, 13, 0x582e00 },
   { PIPE_FORMAT_R8_UNORM, 512, 4097, 1, 13, 0x2f5900 },
   { PIPE_FORMAT_R8_UNORM, 512, 4097, 2, 13, 0x5ed800 },
   { PIPE_FORMAT_R8_UNORM, 513, 16, 1, 10, 0x5d00 },
   { PIPE_FORMAT_R8_UNORM, 513, 16, 2, 10, 0x10a00 },
   { PIPE_FORMAT_R8_UNORM, 513, 17, 1, 10, 0xb400 },
   { PIPE_FORMAT_R8_UNORM, 513, 17, 2, 10, 0x18e00 },
   { PIPE_FORMAT_R8_UNORM, 513, 31, 1, 10, 0xb400 },
   { PIPE_FORMAT_R8_UNORM, 513, 31, 2, 10, 0x18e00 },
   { PIPE_FORMAT_R8_UNORM, 513, 32, 1, 10, 0xb400 },
   { PIPE_FORMAT_R8_UNORM, 513, 32, 2, 10, 0x18e00 },
   { PIPE_FORMAT_R8_UNORM, 513, 33, 1, 10, 0x16380 },
   { PIPE_FORMAT_R8_UNORM, 513, 33, 2, 10, 0x31800 },
   { PIPE_FORMAT_R8_UNORM, 513, 63, 1, 10, 0x16380 },
   { PIPE_FORMAT_R8_UNORM, 513, 63, 2, 10, 0x31800 },
   { PIPE_FORMAT_R8_UNORM, 513, 64, 1, 10, 0x16380 },
   { PIPE_FORMAT_R8_UNORM, 513, 64, 2, 10, 0x31800 },
   { PIPE_FORMAT_R8_UNORM, 513, 65, 1, 10, 0x2c300 },
   { PIPE_FORMAT_R8_UNORM, 513, 65, 2, 10, 0x5ad00 },
   { PIPE_FORMAT_R8_UNORM, 513, 127, 1, 10, 0x2c300 },
   { PIPE_FORMAT_R8_UNORM, 513, 127, 2, 10, 0x5ad00 },
   { PIPE_FORMAT_R8_UNORM, 513, 128, 1, 10, 0x1ae00 },
   { PIPE_FORMAT_R8_UNORM, 513, 128, 2, 10, 0x3ad00 },
   { PIPE_FORMAT_R8_UNORM, 513, 129, 1, 10, 0x30300 },
   { PIPE_FORMAT_R8_UNORM, 513, 129, 2, 10, 0x65700 },
   { PIPE_FORMAT_R8_UNORM, 513, 255, 1, 10, 0x35800 },
   { PIPE_FORMAT_R8_UNORM, 513, 255, 2, 10, 0x6d700 },
   { PIPE_FORMAT_R8_UNORM, 513, 256, 1, 10, 0x39800 },
   { PIPE_FORMAT_R8_UNORM, 513, 256, 2, 10, 0x75700 },
   { PIPE_FORMAT_R8_UNORM, 513, 257, 1, 10, 0x60280 },
   { PIPE_FORMAT_R8_UNORM, 513, 257, 2, 10, 0xc2c00 },
   { PIPE_FORMAT_R8_UNORM, 513, 511, 1, 10, 0x76d00 },
   { PIPE_FORMAT_R8_UNORM, 513, 511, 2, 10, 0xf2c00 },
   { PIPE_FORMAT_R8_UNORM, 513, 512, 1, 10, 0x7ad00 },
   { PIPE_FORMAT_R8_UNORM, 513, 512, 2, 10, 0xfac00 },
   { PIPE_FORMAT_R8_UNORM, 513, 513, 1, 10, 0xac200 },
   { PIPE_FORMAT_R8_UNORM, 513, 513, 2, 10, 0x15d600 },
   { PIPE_FORMAT_R8_UNORM, 513, 1023, 1, 10, 0xf5780 },
   { PIPE_FORMAT_R8_UNORM, 513, 1023, 2, 10, 0x1ed700 },
   { PIPE_FORMAT_R8_UNORM, 513, 1024, 1, 11, 0xf5800 },
   { PIPE_FORMAT_R8_UNORM, 513, 1024, 2, 11, 0x1ed700 },
   { PIPE_FORMAT_R8_UNORM, 513, 1025, 1, 11, 0x12c280 },
   { PIPE_FORMAT_R8_UNORM, 513, 1025, 2, 11, 0x25ac00 },
   { PIPE_FORMAT_R8_UNORM, 513, 2047, 1, 11, 0x1eed80 },
   { PIPE_FORMAT_R8_UNORM, 513, 2047, 2, 11, 0x3e2d00 },
   { PIPE_FORMAT_R8_UNORM, 513, 2048, 1, 12, 0x1eee00 },
   { PIPE_FORMAT_R8_UNORM, 513, 2048, 2, 12, 0x3e2d00 },
   { PIPE_FORMAT_R8_UNORM, 513, 2049, 1, 12, 0x230300 },
   { PIPE_FORMAT_R8_UNORM, 513, 2049, 2, 12, 0x465700 },
   { PIPE_FORMAT_R8_UNORM, 513, 4095, 1, 12, 0x3dd880 },
   { PIPE_FORMAT_R8_UNORM, 513, 4095, 2, 12, 0x7bd800 },
   { PIPE_FORMAT_R8_UNORM, 513, 4096, 1, 13, 0x3dd900 },
   { PIPE_FORMAT_R8_UNORM, 513, 4096, 2, 13, 0x7bd800 },
   { PIPE_FORMAT_R8_UNORM, 513, 4097, 1, 13, 0x434380 },
   { PIPE_FORMAT_R8_UNORM, 513, 4097, 2, 13, 0x86ad00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 16, 1, 10, 0x5d80 },
   { PIPE_FORMAT_R8_UNORM, 1023, 16, 2, 10, 0x10b00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 17, 1, 10, 0xb480 },
   { PIPE_FORMAT_R8_UNORM, 1023, 17, 2, 10, 0x18f00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 31, 1, 10, 0xb480 },
   { PIPE_FORMAT_R8_UNORM, 1023, 31, 2, 10, 0x18f00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 32, 1, 10, 0xb480 },
   { PIPE_FORMAT_R8_UNORM, 1023, 32, 2, 10, 0x18f00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 33, 1, 10, 0x16400 },
   { PIPE_FORMAT_R8_UNORM, 1023, 33, 2, 10, 0x31900 },
   { PIPE_FORMAT_R8_UNORM, 1023, 63, 1, 10, 0x16400 },
   { PIPE_FORMAT_R8_UNORM, 1023, 63, 2, 10, 0x31900 },
   { PIPE_FORMAT_R8_UNORM, 1023, 64, 1, 10, 0x16400 },
   { PIPE_FORMAT_R8_UNORM, 1023, 64, 2, 10, 0x31900 },
   { PIPE_FORMAT_R8_UNORM, 1023, 65, 1, 10, 0x2c380 },
   { PIPE_FORMAT_R8_UNORM, 1023, 65, 2, 10, 0x5ae00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 127, 1, 10, 0x2c380 },
   { PIPE_FORMAT_R8_UNORM, 1023, 127, 2, 10, 0x5ae00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 128, 1, 10, 0x2c380 },
   { PIPE_FORMAT_R8_UNORM, 1023, 128, 2, 10, 0x5ae00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 129, 1, 10, 0x4d880 },
   { PIPE_FORMAT_R8_UNORM, 1023, 129, 2, 10, 0x9d800 },
   { PIPE_FORMAT_R8_UNORM, 1023, 255, 1, 10, 0x58300 },
   { PIPE_FORMAT_R8_UNORM, 1023, 255, 2, 10, 0xb5800 },
   { PIPE_FORMAT_R8_UNORM, 1023, 256, 1, 10, 0x58300 },
   { PIPE_FORMAT_R8_UNORM, 1023, 256, 2, 10, 0xb5800 },
   { PIPE_FORMAT_R8_UNORM, 1023, 257, 1, 10, 0x92d80 },
   { PIPE_FORMAT_R8_UNORM, 1023, 257, 2, 10, 0x12ad00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 511, 1, 10, 0xb0280 },
   { PIPE_FORMAT_R8_UNORM, 1023, 511, 2, 10, 0x162d00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 512, 1, 10, 0xb0280 },
   { PIPE_FORMAT_R8_UNORM, 1023, 512, 2, 10, 0x162d00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 513, 1, 10, 0xf5780 },
   { PIPE_FORMAT_R8_UNORM, 1023, 513, 2, 10, 0x1ed700 },
   { PIPE_FORMAT_R8_UNORM, 1023, 1023, 1, 10, 0x160200 },
   { PIPE_FORMAT_R8_UNORM, 1023, 1023, 2, 10, 0x2c5700 },
   { PIPE_FORMAT_R8_UNORM, 1023, 1024, 1, 11, 0x160280 },
   { PIPE_FORMAT_R8_UNORM, 1023, 1024, 2, 11, 0x2c5700 },
   { PIPE_FORMAT_R8_UNORM, 1023, 1025, 1, 11, 0x1aad00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 1025, 2, 11, 0x35ac00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 2047, 1, 11, 0x2c0280 },
   { PIPE_FORMAT_R8_UNORM, 1023, 2047, 2, 11, 0x582d00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 2048, 1, 12, 0x2c0300 },
   { PIPE_FORMAT_R8_UNORM, 1023, 2048, 2, 12, 0x582d00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 2049, 1, 12, 0x315800 },
   { PIPE_FORMAT_R8_UNORM, 1023, 2049, 2, 12, 0x62d700 },
   { PIPE_FORMAT_R8_UNORM, 1023, 4095, 1, 12, 0x580300 },
   { PIPE_FORMAT_R8_UNORM, 1023, 4095, 2, 12, 0xb05800 },
   { PIPE_FORMAT_R8_UNORM, 1023, 4096, 1, 13, 0x580380 },
   { PIPE_FORMAT_R8_UNORM, 1023, 4096, 2, 13, 0xb05800 },
   { PIPE_FORMAT_R8_UNORM, 1023, 4097, 1, 13, 0x5eae00 },
   { PIPE_FORMAT_R8_UNORM, 1023, 4097, 2, 13, 0xbdad00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 16, 1, 11, 0x5e00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 16, 2, 11, 0x10b00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 17, 1, 11, 0xb500 },
   { PIPE_FORMAT_R8_UNORM, 1024, 17, 2, 11, 0x18f00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 31, 1, 11, 0xb500 },
   { PIPE_FORMAT_R8_UNORM, 1024, 31, 2, 11, 0x18f00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 32, 1, 11, 0xb500 },
   { PIPE_FORMAT_R8_UNORM, 1024, 32, 2, 11, 0x18f00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 33, 1, 11, 0x16480 },
   { PIPE_FORMAT_R8_UNORM, 1024, 33, 2, 11, 0x31900 },
   { PIPE_FORMAT_R8_UNORM, 1024, 63, 1, 11, 0x16480 },
   { PIPE_FORMAT_R8_UNORM, 1024, 63, 2, 11, 0x31900 },
   { PIPE_FORMAT_R8_UNORM, 1024, 64, 1, 11, 0x16480 },
   { PIPE_FORMAT_R8_UNORM, 1024, 64, 2, 11, 0x31900 },
   { PIPE_FORMAT_R8_UNORM, 1024, 65, 1, 11, 0x2c400 },
   { PIPE_FORMAT_R8_UNORM, 1024, 65, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 127, 1, 11, 0x2c400 },
   { PIPE_FORMAT_R8_UNORM, 1024, 127, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 128, 1, 11, 0x2c400 },
   { PIPE_FORMAT_R8_UNORM, 1024, 128, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 129, 1, 11, 0x4d900 },
   { PIPE_FORMAT_R8_UNORM, 1024, 129, 2, 11, 0x9d800 },
   { PIPE_FORMAT_R8_UNORM, 1024, 255, 1, 11, 0x58380 },
   { PIPE_FORMAT_R8_UNORM, 1024, 255, 2, 11, 0xb5800 },
   { PIPE_FORMAT_R8_UNORM, 1024, 256, 1, 11, 0x58380 },
   { PIPE_FORMAT_R8_UNORM, 1024, 256, 2, 11, 0xb5800 },
   { PIPE_FORMAT_R8_UNORM, 1024, 257, 1, 11, 0x92e00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 257, 2, 11, 0x12ad00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 511, 1, 11, 0xb0300 },
   { PIPE_FORMAT_R8_UNORM, 1024, 511, 2, 11, 0x162d00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 512, 1, 11, 0xb0300 },
   { PIPE_FORMAT_R8_UNORM, 1024, 512, 2, 11, 0x162d00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 513, 1, 11, 0xf5800 },
   { PIPE_FORMAT_R8_UNORM, 1024, 513, 2, 11, 0x1ed700 },
   { PIPE_FORMAT_R8_UNORM, 1024, 1023, 1, 11, 0x160280 },
   { PIPE_FORMAT_R8_UNORM, 1024, 1023, 2, 11, 0x2c5700 },
   { PIPE_FORMAT_R8_UNORM, 1024, 1024, 1, 11, 0x160280 },
   { PIPE_FORMAT_R8_UNORM, 1024, 1024, 2, 11, 0x2c5700 },
   { PIPE_FORMAT_R8_UNORM, 1024, 1025, 1, 11, 0x1aed00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 1025, 2, 11, 0x362c00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 2047, 1, 11, 0x2c0280 },
   { PIPE_FORMAT_R8_UNORM, 1024, 2047, 2, 11, 0x582d00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 2048, 1, 12, 0x2c0300 },
   { PIPE_FORMAT_R8_UNORM, 1024, 2048, 2, 12, 0x582d00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 2049, 1, 12, 0x319800 },
   { PIPE_FORMAT_R8_UNORM, 1024, 2049, 2, 12, 0x635700 },
   { PIPE_FORMAT_R8_UNORM, 1024, 4095, 1, 12, 0x580300 },
   { PIPE_FORMAT_R8_UNORM, 1024, 4095, 2, 12, 0xb05800 },
   { PIPE_FORMAT_R8_UNORM, 1024, 4096, 1, 13, 0x580380 },
   { PIPE_FORMAT_R8_UNORM, 1024, 4096, 2, 13, 0xb05800 },
   { PIPE_FORMAT_R8_UNORM, 1024, 4097, 1, 13, 0x5eee00 },
   { PIPE_FORMAT_R8_UNORM, 1024, 4097, 2, 13, 0xbe2d00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 16, 1, 11, 0xb680 },
   { PIPE_FORMAT_R8_UNORM, 1025, 16, 2, 11, 0x19200 },
   { PIPE_FORMAT_R8_UNORM, 1025, 17, 1, 11, 0x16500 },
   { PIPE_FORMAT_R8_UNORM, 1025, 17, 2, 11, 0x31a00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 31, 1, 11, 0x16500 },
   { PIPE_FORMAT_R8_UNORM, 1025, 31, 2, 11, 0x31a00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 32, 1, 11, 0x16500 },
   { PIPE_FORMAT_R8_UNORM, 1025, 32, 2, 11, 0x31a00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 33, 1, 11, 0x2c400 },
   { PIPE_FORMAT_R8_UNORM, 1025, 33, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 63, 1, 11, 0x2c400 },
   { PIPE_FORMAT_R8_UNORM, 1025, 63, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 64, 1, 11, 0x2c400 },
   { PIPE_FORMAT_R8_UNORM, 1025, 64, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 65, 1, 11, 0x58380 },
   { PIPE_FORMAT_R8_UNORM, 1025, 65, 2, 11, 0xb5800 },
   { PIPE_FORMAT_R8_UNORM, 1025, 127, 1, 11, 0x58380 },
   { PIPE_FORMAT_R8_UNORM, 1025, 127, 2, 11, 0xb5800 },
   { PIPE_FORMAT_R8_UNORM, 1025, 128, 1, 11, 0x31900 },
   { PIPE_FORMAT_R8_UNORM, 1025, 128, 2, 11, 0x65800 },
   { PIPE_FORMAT_R8_UNORM, 1025, 129, 1, 11, 0x58380 },
   { PIPE_FORMAT_R8_UNORM, 1025, 129, 2, 11, 0xb2d00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 255, 1, 11, 0x62e00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 255, 2, 11, 0xcad00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 256, 1, 11, 0x66e00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 256, 2, 11, 0xd2d00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 257, 1, 11, 0xac300 },
   { PIPE_FORMAT_R8_UNORM, 1025, 257, 2, 11, 0x15d700 },
   { PIPE_FORMAT_R8_UNORM, 1025, 511, 1, 11, 0xd1800 },
   { PIPE_FORMAT_R8_UNORM, 1025, 511, 2, 11, 0x1a5700 },
   { PIPE_FORMAT_R8_UNORM, 1025, 512, 1, 11, 0xd5800 },
   { PIPE_FORMAT_R8_UNORM, 1025, 512, 2, 11, 0x1ad700 },
   { PIPE_FORMAT_R8_UNORM, 1025, 513, 1, 11, 0x12c280 },
   { PIPE_FORMAT_R8_UNORM, 1025, 513, 2, 11, 0x25ac00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 1023, 1, 11, 0x1aad00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 1023, 2, 11, 0x35ac00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 1024, 1, 11, 0x1aed00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 1024, 2, 11, 0x362c00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 1025, 1, 11, 0x21c200 },
   { PIPE_FORMAT_R8_UNORM, 1025, 1025, 2, 11, 0x43d600 },
   { PIPE_FORMAT_R8_UNORM, 1025, 2047, 1, 11, 0x361780 },
   { PIPE_FORMAT_R8_UNORM, 1025, 2047, 2, 11, 0x6c5700 },
   { PIPE_FORMAT_R8_UNORM, 1025, 2048, 1, 12, 0x361800 },
   { PIPE_FORMAT_R8_UNORM, 1025, 2048, 2, 12, 0x6c5700 },
   { PIPE_FORMAT_R8_UNORM, 1025, 2049, 1, 12, 0x3e0280 },
   { PIPE_FORMAT_R8_UNORM, 1025, 2049, 2, 12, 0x7c2c00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 4095, 1, 12, 0x6c2d80 },
   { PIPE_FORMAT_R8_UNORM, 1025, 4095, 2, 12, 0xd8ad00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 4096, 1, 13, 0x6c2e00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 4096, 2, 13, 0xd8ad00 },
   { PIPE_FORMAT_R8_UNORM, 1025, 4097, 1, 13, 0x76c300 },
   { PIPE_FORMAT_R8_UNORM, 1025, 4097, 2, 13, 0xedd700 },
   { PIPE_FORMAT_R8_UNORM, 2047, 16, 1, 11, 0xb700 },
   { PIPE_FORMAT_R8_UNORM, 2047, 16, 2, 11, 0x19300 },
   { PIPE_FORMAT_R8_UNORM, 2047, 17, 1, 11, 0x16580 },
   { PIPE_FORMAT_R8_UNORM, 2047, 17, 2, 11, 0x31b00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 31, 1, 11, 0x16580 },
   { PIPE_FORMAT_R8_UNORM, 2047, 31, 2, 11, 0x31b00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 32, 1, 11, 0x16580 },
   { PIPE_FORMAT_R8_UNORM, 2047, 32, 2, 11, 0x31b00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 33, 1, 11, 0x2c480 },
   { PIPE_FORMAT_R8_UNORM, 2047, 33, 2, 11, 0x5af00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 63, 1, 11, 0x2c480 },
   { PIPE_FORMAT_R8_UNORM, 2047, 63, 2, 11, 0x5af00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 64, 1, 11, 0x2c480 },
   { PIPE_FORMAT_R8_UNORM, 2047, 64, 2, 11, 0x5af00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 65, 1, 11, 0x58400 },
   { PIPE_FORMAT_R8_UNORM, 2047, 65, 2, 11, 0xb5900 },
   { PIPE_FORMAT_R8_UNORM, 2047, 127, 1, 11, 0x58400 },
   { PIPE_FORMAT_R8_UNORM, 2047, 127, 2, 11, 0xb5900 },
   { PIPE_FORMAT_R8_UNORM, 2047, 128, 1, 11, 0x58400 },
   { PIPE_FORMAT_R8_UNORM, 2047, 128, 2, 11, 0xb5900 },
   { PIPE_FORMAT_R8_UNORM, 2047, 129, 1, 11, 0x9ae80 },
   { PIPE_FORMAT_R8_UNORM, 2047, 129, 2, 11, 0x13ae00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 255, 1, 11, 0xb0380 },
   { PIPE_FORMAT_R8_UNORM, 2047, 255, 2, 11, 0x162e00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 256, 1, 11, 0xb0380 },
   { PIPE_FORMAT_R8_UNORM, 2047, 256, 2, 11, 0x162e00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 257, 1, 11, 0x125880 },
   { PIPE_FORMAT_R8_UNORM, 2047, 257, 2, 11, 0x24d800 },
   { PIPE_FORMAT_R8_UNORM, 2047, 511, 1, 11, 0x160300 },
   { PIPE_FORMAT_R8_UNORM, 2047, 511, 2, 11, 0x2c5800 },
   { PIPE_FORMAT_R8_UNORM, 2047, 512, 1, 11, 0x160300 },
   { PIPE_FORMAT_R8_UNORM, 2047, 512, 2, 11, 0x2c5800 },
   { PIPE_FORMAT_R8_UNORM, 2047, 513, 1, 11, 0x1eed80 },
   { PIPE_FORMAT_R8_UNORM, 2047, 513, 2, 11, 0x3e2d00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 1023, 1, 11, 0x2c0280 },
   { PIPE_FORMAT_R8_UNORM, 2047, 1023, 2, 11, 0x582d00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 1024, 1, 11, 0x2c0280 },
   { PIPE_FORMAT_R8_UNORM, 2047, 1024, 2, 11, 0x582d00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 1025, 1, 11, 0x361780 },
   { PIPE_FORMAT_R8_UNORM, 2047, 1025, 2, 11, 0x6c5700 },
   { PIPE_FORMAT_R8_UNORM, 2047, 2047, 1, 11, 0x580200 },
   { PIPE_FORMAT_R8_UNORM, 2047, 2047, 2, 11, 0xb05700 },
   { PIPE_FORMAT_R8_UNORM, 2047, 2048, 1, 12, 0x580280 },
   { PIPE_FORMAT_R8_UNORM, 2047, 2048, 2, 12, 0xb05700 },
   { PIPE_FORMAT_R8_UNORM, 2047, 2049, 1, 12, 0x636d00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 2049, 2, 12, 0xc72c00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 4095, 1, 12, 0xb00280 },
   { PIPE_FORMAT_R8_UNORM, 2047, 4095, 2, 12, 0x1602d00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 4096, 1, 13, 0xb00300 },
   { PIPE_FORMAT_R8_UNORM, 2047, 4096, 2, 13, 0x1602d00 },
   { PIPE_FORMAT_R8_UNORM, 2047, 4097, 1, 13, 0xbe1800 },
   { PIPE_FORMAT_R8_UNORM, 2047, 4097, 2, 13, 0x17c5700 },
   { PIPE_FORMAT_R8_UNORM, 2048, 16, 1, 12, 0xb780 },
   { PIPE_FORMAT_R8_UNORM, 2048, 16, 2, 12, 0x19300 },
   { PIPE_FORMAT_R8_UNORM, 2048, 17, 1, 12, 0x16600 },
   { PIPE_FORMAT_R8_UNORM, 2048, 17, 2, 12, 0x31b00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 31, 1, 12, 0x16600 },
   { PIPE_FORMAT_R8_UNORM, 2048, 31, 2, 12, 0x31b00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 32, 1, 12, 0x16600 },
   { PIPE_FORMAT_R8_UNORM, 2048, 32, 2, 12, 0x31b00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 33, 1, 12, 0x2c500 },
   { PIPE_FORMAT_R8_UNORM, 2048, 33, 2, 12, 0x5af00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 63, 1, 12, 0x2c500 },
   { PIPE_FORMAT_R8_UNORM, 2048, 63, 2, 12, 0x5af00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 64, 1, 12, 0x2c500 },
   { PIPE_FORMAT_R8_UNORM, 2048, 64, 2, 12, 0x5af00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 65, 1, 12, 0x58480 },
   { PIPE_FORMAT_R8_UNORM, 2048, 65, 2, 12, 0xb5900 },
   { PIPE_FORMAT_R8_UNORM, 2048, 127, 1, 12, 0x58480 },
   { PIPE_FORMAT_R8_UNORM, 2048, 127, 2, 12, 0xb5900 },
   { PIPE_FORMAT_R8_UNORM, 2048, 128, 1, 12, 0x58480 },
   { PIPE_FORMAT_R8_UNORM, 2048, 128, 2, 12, 0xb5900 },
   { PIPE_FORMAT_R8_UNORM, 2048, 129, 1, 12, 0x9af00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 129, 2, 12, 0x13ae00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 255, 1, 12, 0xb0400 },
   { PIPE_FORMAT_R8_UNORM, 2048, 255, 2, 12, 0x162e00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 256, 1, 12, 0xb0400 },
   { PIPE_FORMAT_R8_UNORM, 2048, 256, 2, 12, 0x162e00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 257, 1, 12, 0x125900 },
   { PIPE_FORMAT_R8_UNORM, 2048, 257, 2, 12, 0x24d800 },
   { PIPE_FORMAT_R8_UNORM, 2048, 511, 1, 12, 0x160380 },
   { PIPE_FORMAT_R8_UNORM, 2048, 511, 2, 12, 0x2c5800 },
   { PIPE_FORMAT_R8_UNORM, 2048, 512, 1, 12, 0x160380 },
   { PIPE_FORMAT_R8_UNORM, 2048, 512, 2, 12, 0x2c5800 },
   { PIPE_FORMAT_R8_UNORM, 2048, 513, 1, 12, 0x1eee00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 513, 2, 12, 0x3e2d00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 1023, 1, 12, 0x2c0300 },
   { PIPE_FORMAT_R8_UNORM, 2048, 1023, 2, 12, 0x582d00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 1024, 1, 12, 0x2c0300 },
   { PIPE_FORMAT_R8_UNORM, 2048, 1024, 2, 12, 0x582d00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 1025, 1, 12, 0x361800 },
   { PIPE_FORMAT_R8_UNORM, 2048, 1025, 2, 12, 0x6c5700 },
   { PIPE_FORMAT_R8_UNORM, 2048, 2047, 1, 12, 0x580280 },
   { PIPE_FORMAT_R8_UNORM, 2048, 2047, 2, 12, 0xb05700 },
   { PIPE_FORMAT_R8_UNORM, 2048, 2048, 1, 12, 0x580280 },
   { PIPE_FORMAT_R8_UNORM, 2048, 2048, 2, 12, 0xb05700 },
   { PIPE_FORMAT_R8_UNORM, 2048, 2049, 1, 12, 0x63ad00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 2049, 2, 12, 0xc7ac00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 4095, 1, 12, 0xb00280 },
   { PIPE_FORMAT_R8_UNORM, 2048, 4095, 2, 12, 0x1602d00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 4096, 1, 13, 0xb00300 },
   { PIPE_FORMAT_R8_UNORM, 2048, 4096, 2, 13, 0x1602d00 },
   { PIPE_FORMAT_R8_UNORM, 2048, 4097, 1, 13, 0xbe5800 },
   { PIPE_FORMAT_R8_UNORM, 2048, 4097, 2, 13, 0x17cd700 },
   { PIPE_FORMAT_R8_UNORM, 2049, 16, 1, 12, 0x16980 },
   { PIPE_FORMAT_R8_UNORM, 2049, 16, 2, 12, 0x32200 },
   { PIPE_FORMAT_R8_UNORM, 2049, 17, 1, 12, 0x2c680 },
   { PIPE_FORMAT_R8_UNORM, 2049, 17, 2, 12, 0x5b200 },
   { PIPE_FORMAT_R8_UNORM, 2049, 31, 1, 12, 0x2c680 },
   { PIPE_FORMAT_R8_UNORM, 2049, 31, 2, 12, 0x5b200 },
   { PIPE_FORMAT_R8_UNORM, 2049, 32, 1, 12, 0x2c680 },
   { PIPE_FORMAT_R8_UNORM, 2049, 32, 2, 12, 0x5b200 },
   { PIPE_FORMAT_R8_UNORM, 2049, 33, 1, 12, 0x58500 },
   { PIPE_FORMAT_R8_UNORM, 2049, 33, 2, 12, 0xb5a00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 63, 1, 12, 0x58500 },
   { PIPE_FORMAT_R8_UNORM, 2049, 63, 2, 12, 0xb5a00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 64, 1, 12, 0x58500 },
   { PIPE_FORMAT_R8_UNORM, 2049, 64, 2, 12, 0xb5a00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 65, 1, 12, 0xb0400 },
   { PIPE_FORMAT_R8_UNORM, 2049, 65, 2, 12, 0x162e00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 127, 1, 12, 0xb0400 },
   { PIPE_FORMAT_R8_UNORM, 2049, 127, 2, 12, 0x162e00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 128, 1, 12, 0x5ef00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 128, 2, 12, 0xc2e00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 129, 1, 12, 0xa8400 },
   { PIPE_FORMAT_R8_UNORM, 2049, 129, 2, 12, 0x155800 },
   { PIPE_FORMAT_R8_UNORM, 2049, 255, 1, 12, 0xbd900 },
   { PIPE_FORMAT_R8_UNORM, 2049, 255, 2, 12, 0x17d800 },
   { PIPE_FORMAT_R8_UNORM, 2049, 256, 1, 12, 0xc1900 },
   { PIPE_FORMAT_R8_UNORM, 2049, 256, 2, 12, 0x185800 },
   { PIPE_FORMAT_R8_UNORM, 2049, 257, 1, 12, 0x144380 },
   { PIPE_FORMAT_R8_UNORM, 2049, 257, 2, 12, 0x28ad00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 511, 1, 12, 0x186e00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 511, 2, 12, 0x312d00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 512, 1, 12, 0x18ae00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 512, 2, 12, 0x31ad00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 513, 1, 12, 0x230300 },
   { PIPE_FORMAT_R8_UNORM, 2049, 513, 2, 12, 0x465700 },
   { PIPE_FORMAT_R8_UNORM, 2049, 1023, 1, 12, 0x315800 },
   { PIPE_FORMAT_R8_UNORM, 2049, 1023, 2, 12, 0x62d700 },
   { PIPE_FORMAT_R8_UNORM, 2049, 1024, 1, 12, 0x319800 },
   { PIPE_FORMAT_R8_UNORM, 2049, 1024, 2, 12, 0x635700 },
   { PIPE_FORMAT_R8_UNORM, 2049, 1025, 1, 12, 0x3e0280 },
   { PIPE_FORMAT_R8_UNORM, 2049, 1025, 2, 12, 0x7c2c00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 2047, 1, 12, 0x636d00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 2047, 2, 12, 0xc72c00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 2048, 1, 12, 0x63ad00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 2048, 2, 12, 0xc7ac00 },
   { PIPE_FORMAT_R8_UNORM, 2049, 2049, 1, 12, 0x734200 },
   { PIPE_FORMAT_R8_UNORM, 2049, 2049, 2, 12, 0xe6d600 },
   { PIPE_FORMAT_R8_UNORM, 2049, 4095, 1, 12, 0xc75780 },
   { PIPE_FORMAT_R8_UNORM, 2049, 4095, 2, 12, 0x18ed700 },
   { PIPE_FORMAT_R8_UNORM, 2049, 4096, 1, 13, 0xc75800 },
   { PIPE_FORMAT_R8_UNORM, 2049, 4096, 2, 13, 0x18ed700 },
   { PIPE_FORMAT_R8_UNORM, 2049, 4097, 1, 13, 0xdc4280 },
   { PIPE_FORMAT_R8_UNORM, 2049, 4097, 2, 13, 0x1b8ac00 },
   { PIPE_FORMAT_R8_UNORM, 4095, 16, 1, 12, 0x16a00 },
   { PIPE_FORMAT_R8_UNORM, 4095, 16, 2, 12, 0x32300 },
   { PIPE_FORMAT_R8_UNORM, 4095, 17, 1, 12, 0x2c700 },
   { PIPE_FORMAT_R8_UNORM, 4095, 17, 2, 12, 0x5b300 },
   { PIPE_FORMAT_R8_UNORM, 4095, 31, 1, 12, 0x2c700 },
   { PIPE_FORMAT_R8_UNORM, 4095, 31, 2, 12, 0x5b300 },
   { PIPE_FORMAT_R8_UNORM, 4095, 32, 1, 12, 0x2c700 },
   { PIPE_FORMAT_R8_UNORM, 4095, 32, 2, 12, 0x5b300 },
   { PIPE_FORMAT_R8_UNORM, 4095, 33, 1, 12, 0x58580 },
   { PIPE_FORMAT_R8_UNORM, 4095, 33, 2, 12, 0xb5b00 },
   { PIPE_FORMAT_R8_UNORM, 4095, 63, 1, 12, 0x58580 },
   { PIPE_FORMAT_R8_UNORM, 4095, 63, 2, 12, 0xb5b00 },
   { PIPE_FORMAT_R8_UNORM, 4095, 64, 1, 12, 0x58580 },
   { PIPE_FORMAT_R8_UNORM, 4095, 64, 2, 12, 0xb5b00 },
   { PIPE_FORMAT_R8_UNORM, 4095, 65, 1, 12, 0xb0480 },
   { PIPE_FORMAT_R8_UNORM, 4095, 65, 2, 12, 0x162f00 },
   { PIPE_FORMAT_R8_UNORM, 4095, 127, 1, 12, 0xb0480 },
   { PIPE_FORMAT_R8_UNORM, 4095, 127, 2, 12, 0x162f00 },
   { PIPE_FORMAT_R8_UNORM, 4095, 128, 1, 12, 0xb0480 },
   { PIPE_FORMAT_R8_UNORM, 4095, 128, 2, 12, 0x162f00 },
   { PIPE_FORMAT_R8_UNORM, 4095, 129, 1, 12, 0x135980 },
   { PIPE_FORMAT_R8_UNORM, 4095, 129, 2, 12, 0x26d900 },
   { PIPE_FORMAT_R8_UNORM, 4095, 255, 1, 12, 0x160400 },
   { PIPE_FORMAT_R8_UNORM, 4095, 255, 2, 12, 0x2c5900 },
   { PIPE_FORMAT_R8_UNORM, 4095, 256, 1, 12, 0x160400 },
   { PIPE_FORMAT_R8_UNORM, 4095, 256, 2, 12, 0x2c5900 },
   { PIPE_FORMAT_R8_UNORM, 4095, 257, 1, 12, 0x24ae80 },
   { PIPE_FORMAT_R8_UNORM, 4095, 257, 2, 12, 0x49ae00 },
   { PIPE_FORMAT_R8_UNORM, 4095, 511, 1, 12, 0x2c0380 },
   { PIPE_FORMAT_R8_UNORM, 4095, 511, 2, 12, 0x582e00 },
   { PIPE_FORMAT_R8_UNORM, 4095, 512, 1, 12, 0x2c0380 },
   { PIPE_FORMAT_R8_UNORM, 4095, 512, 2, 12, 0x582e00 },
   { PIPE_FORMAT_R8_UNORM, 4095, 513, 1, 12, 0x3dd880 },
   { PIPE_FORMAT_R8_UNORM, 4095, 513, 2, 12, 0x7bd800 },
   { PIPE_FORMAT_R8_UNORM, 4095, 1023, 1, 12, 0x580300 },
   { PIPE_FORMAT_R8_UNORM, 4095, 1023, 2, 12, 0xb05800 },
   { PIPE_FORMAT_R8_UNORM, 4095, 1024, 1, 12, 0x580300 },
   { PIPE_FORMAT_R8_UNORM, 4095, 1024, 2, 12, 0xb05800 },
   { PIPE_FORMAT_R8_UNORM, 4095, 1025, 1, 12, 0x6c2d80 },
   { PIPE_FORMAT_R8_UNORM, 4095, 1025, 2, 12, 0xd8ad00 },
   { PIPE_FORMAT_R8_UNORM, 4095, 2047, 1, 12, 0xb00280 },
   { PIPE_FORMAT_R8_UNORM, 4095, 2047, 2, 12, 0x1602d00 },
   { PIPE_FORMAT_R8_UNORM, 4095, 2048, 1, 12, 0xb00280 },
   { PIPE_FORMAT_R8_UNORM, 4095, 2048, 2, 12, 0x1602d00 },
   { PIPE_FORMAT_R8_UNORM, 4095, 2049, 1, 12, 0xc75780 },
   { PIPE_FORMAT_R8_UNORM, 4095, 2049, 2, 12, 0x18ed700 },
   { PIPE_FORMAT_R8_UNORM, 4095, 4095, 1, 12, 0x1600200 },
   { PIPE_FORMAT_R8_UNORM, 4095, 4095, 2, 12, 0x2c05700 },
   { PIPE_FORMAT_R8_UNORM, 4095, 4096, 1, 13, 0x1600280 },
   { PIPE_FORMAT_R8_UNORM, 4095, 4096, 2, 13, 0x2c05700 },
   { PIPE_FORMAT_R8_UNORM, 4095, 4097, 1, 13, 0x17cad00 },
   { PIPE_FORMAT_R8_UNORM, 4095, 4097, 2, 13, 0x2f9ac00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 16, 1, 13, 0x16a80 },
   { PIPE_FORMAT_R8_UNORM, 4096, 16, 2, 13, 0x32300 },
   { PIPE_FORMAT_R8_UNORM, 4096, 17, 1, 13, 0x2c780 },
   { PIPE_FORMAT_R8_UNORM, 4096, 17, 2, 13, 0x5b300 },
   { PIPE_FORMAT_R8_UNORM, 4096, 31, 1, 13, 0x2c780 },
   { PIPE_FORMAT_R8_UNORM, 4096, 31, 2, 13, 0x5b300 },
   { PIPE_FORMAT_R8_UNORM, 4096, 32, 1, 13, 0x2c780 },
   { PIPE_FORMAT_R8_UNORM, 4096, 32, 2, 13, 0x5b300 },
   { PIPE_FORMAT_R8_UNORM, 4096, 33, 1, 13, 0x58600 },
   { PIPE_FORMAT_R8_UNORM, 4096, 33, 2, 13, 0xb5b00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 63, 1, 13, 0x58600 },
   { PIPE_FORMAT_R8_UNORM, 4096, 63, 2, 13, 0xb5b00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 64, 1, 13, 0x58600 },
   { PIPE_FORMAT_R8_UNORM, 4096, 64, 2, 13, 0xb5b00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 65, 1, 13, 0xb0500 },
   { PIPE_FORMAT_R8_UNORM, 4096, 65, 2, 13, 0x162f00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 127, 1, 13, 0xb0500 },
   { PIPE_FORMAT_R8_UNORM, 4096, 127, 2, 13, 0x162f00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 128, 1, 13, 0xb0500 },
   { PIPE_FORMAT_R8_UNORM, 4096, 128, 2, 13, 0x162f00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 129, 1, 13, 0x135a00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 129, 2, 13, 0x26d900 },
   { PIPE_FORMAT_R8_UNORM, 4096, 255, 1, 13, 0x160480 },
   { PIPE_FORMAT_R8_UNORM, 4096, 255, 2, 13, 0x2c5900 },
   { PIPE_FORMAT_R8_UNORM, 4096, 256, 1, 13, 0x160480 },
   { PIPE_FORMAT_R8_UNORM, 4096, 256, 2, 13, 0x2c5900 },
   { PIPE_FORMAT_R8_UNORM, 4096, 257, 1, 13, 0x24af00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 257, 2, 13, 0x49ae00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 511, 1, 13, 0x2c0400 },
   { PIPE_FORMAT_R8_UNORM, 4096, 511, 2, 13, 0x582e00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 512, 1, 13, 0x2c0400 },
   { PIPE_FORMAT_R8_UNORM, 4096, 512, 2, 13, 0x582e00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 513, 1, 13, 0x3dd900 },
   { PIPE_FORMAT_R8_UNORM, 4096, 513, 2, 13, 0x7bd800 },
   { PIPE_FORMAT_R8_UNORM, 4096, 1023, 1, 13, 0x580380 },
   { PIPE_FORMAT_R8_UNORM, 4096, 1023, 2, 13, 0xb05800 },
   { PIPE_FORMAT_R8_UNORM, 4096, 1024, 1, 13, 0x580380 },
   { PIPE_FORMAT_R8_UNORM, 4096, 1024, 2, 13, 0xb05800 },
   { PIPE_FORMAT_R8_UNORM, 4096, 1025, 1, 13, 0x6c2e00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 1025, 2, 13, 0xd8ad00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 2047, 1, 13, 0xb00300 },
   { PIPE_FORMAT_R8_UNORM, 4096, 2047, 2, 13, 0x1602d00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 2048, 1, 13, 0xb00300 },
   { PIPE_FORMAT_R8_UNORM, 4096, 2048, 2, 13, 0x1602d00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 2049, 1, 13, 0xc75800 },
   { PIPE_FORMAT_R8_UNORM, 4096, 2049, 2, 13, 0x18ed700 },
   { PIPE_FORMAT_R8_UNORM, 4096, 4095, 1, 13, 0x1600280 },
   { PIPE_FORMAT_R8_UNORM, 4096, 4095, 2, 13, 0x2c05700 },
   { PIPE_FORMAT_R8_UNORM, 4096, 4096, 1, 13, 0x1600280 },
   { PIPE_FORMAT_R8_UNORM, 4096, 4096, 2, 13, 0x2c05700 },
   { PIPE_FORMAT_R8_UNORM, 4096, 4097, 1, 13, 0x17ced00 },
   { PIPE_FORMAT_R8_UNORM, 4096, 4097, 2, 13, 0x2fa2c00 },
   { PIPE_FORMAT_R8_UNORM, 4097, 16, 1, 13, 0x2cf80 },
   { PIPE_FORMAT_R8_UNORM, 4097, 16, 2, 13, 0x5c200 },
   { PIPE_FORMAT_R8_UNORM, 4097, 17, 1, 13, 0x58980 },
   { PIPE_FORMAT_R8_UNORM, 4097, 17, 2, 13, 0xb6200 },
   { PIPE_FORMAT_R8_UNORM, 4097, 31, 1, 13, 0x58980 },
   { PIPE_FORMAT_R8_UNORM, 4097, 31, 2, 13, 0xb6200 },
   { PIPE_FORMAT_R8_UNORM, 4097, 32, 1, 13, 0x58980 },
   { PIPE_FORMAT_R8_UNORM, 4097, 32, 2, 13, 0xb6200 },
   { PIPE_FORMAT_R8_UNORM, 4097, 33, 1, 13, 0xb0680 },
   { PIPE_FORMAT_R8_UNORM, 4097, 33, 2, 13, 0x163200 },
   { PIPE_FORMAT_R8_UNORM, 4097, 63, 1, 13, 0xb0680 },
   { PIPE_FORMAT_R8_UNORM, 4097, 63, 2, 13, 0x163200 },
   { PIPE_FORMAT_R8_UNORM, 4097, 64, 1, 13, 0xb0680 },
   { PIPE_FORMAT_R8_UNORM, 4097, 64, 2, 13, 0x163200 },
   { PIPE_FORMAT_R8_UNORM, 4097, 65, 1, 13, 0x160500 },
   { PIPE_FORMAT_R8_UNORM, 4097, 65, 2, 13, 0x2c5a00 },
   { PIPE_FORMAT_R8_UNORM, 4097, 127, 1, 13, 0x160500 },
   { PIPE_FORMAT_R8_UNORM, 4097, 127, 2, 13, 0x2c5a00 },
   { PIPE_FORMAT_R8_UNORM, 4097, 128, 1, 13, 0xb9a80 },
   { PIPE_FORMAT_R8_UNORM, 4097, 128, 2, 13, 0x175a00 },
   { PIPE_FORMAT_R8_UNORM, 4097, 129, 1, 13, 0x148480 },
   { PIPE_FORMAT_R8_UNORM, 4097, 129, 2, 13, 0x292e00 },
   { PIPE_FORMAT_R8_UNORM, 4097, 255, 1, 13, 0x172f00 },
   { PIPE_FORMAT_R8_UNORM, 4097, 255, 2, 13, 0x2eae00 },
   { PIPE_FORMAT_R8_UNORM, 4097, 256, 1, 13, 0x176f00 },
   { PIPE_FORMAT_R8_UNORM, 4097, 256, 2, 13, 0x2f2e00 },
   { PIPE_FORMAT_R8_UNORM, 4097, 257, 1, 13, 0x274400 },
   { PIPE_FORMAT_R8_UNORM, 4097, 257, 2, 13, 0x4ed800 },
   { PIPE_FORMAT_R8_UNORM, 4097, 511, 1, 13, 0x2f1900 },
   { PIPE_FORMAT_R8_UNORM, 4097, 511, 2, 13, 0x5e5800 },
   { PIPE_FORMAT_R8_UNORM, 4097, 512, 1, 13, 0x2f5900 },
   { PIPE_FORMAT_R8_UNORM, 4097, 512, 2, 13, 0x5ed800 },
   { PIPE_FORMAT_R8_UNORM, 4097, 513, 1, 13, 0x434380 },
   { PIPE_FORMAT_R8_UNORM, 4097, 513, 2, 13, 0x86ad00 },
   { PIPE_FORMAT_R8_UNORM, 4097, 1023, 1, 13, 0x5eae00 },
   { PIPE_FORMAT_R8_UNORM, 4097, 1023, 2, 13, 0xbdad00 },
   { PIPE_FORMAT_R8_UNORM, 4097, 1024, 1, 13, 0x5eee00 },
   { PIPE_FORMAT_R8_UNORM, 4097, 1024, 2, 13, 0xbe2d00 },
   { PIPE_FORMAT_R8_UNORM, 4097, 1025, 1, 13, 0x76c300 },
   { PIPE_FORMAT_R8_UNORM, 4097, 1025, 2, 13, 0xedd700 },
   { PIPE_FORMAT_R8_UNORM, 4097, 2047, 1, 13, 0xbe1800 },
   { PIPE_FORMAT_R8_UNORM, 4097, 2047, 2, 13, 0x17c5700 },
   { PIPE_FORMAT_R8_UNORM, 4097, 2048, 1, 13, 0xbe5800 },
   { PIPE_FORMAT_R8_UNORM, 4097, 2048, 2, 13, 0x17cd700 },
   { PIPE_FORMAT_R8_UNORM, 4097, 2049, 1, 13, 0xdc4280 },
   { PIPE_FORMAT_R8_UNORM, 4097, 2049, 2, 13, 0x1b8ac00 },
   { PIPE_FORMAT_R8_UNORM, 4097, 4095, 1, 13, 0x17cad00 },
   { PIPE_FORMAT_R8_UNORM, 4097, 4095, 2, 13, 0x2f9ac00 },
   { PIPE_FORMAT_R8_UNORM, 4097, 4096, 1, 13, 0x17ced00 },
   { PIPE_FORMAT_R8_UNORM, 4097, 4096, 2, 13, 0x2fa2c00 },
   { PIPE_FORMAT_R8_UNORM, 4097, 4097, 1, 13, 0x1a64200 },
   { PIPE_FORMAT_R8_UNORM, 4097, 4097, 2, 13, 0x34cd600 },
   { PIPE_FORMAT_S8_UINT, 16, 16, 1, 1, 0x180 },
   { PIPE_FORMAT_S8_UINT, 16, 16, 1, 5, 0x380 },
   { PIPE_FORMAT_S8_UINT, 16, 16, 2, 1, 0x300 },
   { PIPE_FORMAT_S8_UINT, 16, 16, 2, 5, 0x700 },
   { PIPE_FORMAT_S8_UINT, 16, 17, 1, 1, 0x280 },
   { PIPE_FORMAT_S8_UINT, 16, 17, 1, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 16, 17, 2, 1, 0x500 },
   { PIPE_FORMAT_S8_UINT, 16, 17, 2, 5, 0xa00 },
   { PIPE_FORMAT_S8_UINT, 16, 31, 1, 1, 0x280 },
   { PIPE_FORMAT_S8_UINT, 16, 31, 1, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 16, 31, 2, 1, 0x500 },
   { PIPE_FORMAT_S8_UINT, 16, 31, 2, 5, 0xa00 },
   { PIPE_FORMAT_S8_UINT, 16, 32, 1, 1, 0x280 },
   { PIPE_FORMAT_S8_UINT, 16, 32, 1, 6, 0x580 },
   { PIPE_FORMAT_S8_UINT, 16, 32, 2, 1, 0x500 },
   { PIPE_FORMAT_S8_UINT, 16, 32, 2, 6, 0xb00 },
   { PIPE_FORMAT_S8_UINT, 16, 33, 1, 1, 0x480 },
   { PIPE_FORMAT_S8_UINT, 16, 33, 1, 6, 0x800 },
   { PIPE_FORMAT_S8_UINT, 16, 33, 2, 1, 0x900 },
   { PIPE_FORMAT_S8_UINT, 16, 33, 2, 6, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 16, 63, 1, 1, 0x480 },
   { PIPE_FORMAT_S8_UINT, 16, 63, 1, 6, 0x880 },
   { PIPE_FORMAT_S8_UINT, 16, 63, 2, 1, 0x900 },
   { PIPE_FORMAT_S8_UINT, 16, 63, 2, 6, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 16, 64, 1, 1, 0x480 },
   { PIPE_FORMAT_S8_UINT, 16, 64, 1, 7, 0x900 },
   { PIPE_FORMAT_S8_UINT, 16, 64, 2, 1, 0x900 },
   { PIPE_FORMAT_S8_UINT, 16, 64, 2, 7, 0x1200 },
   { PIPE_FORMAT_S8_UINT, 16, 65, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 16, 65, 1, 7, 0xe00 },
   { PIPE_FORMAT_S8_UINT, 16, 65, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 16, 65, 2, 7, 0x1c00 },
   { PIPE_FORMAT_S8_UINT, 16, 127, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 16, 127, 1, 7, 0xe80 },
   { PIPE_FORMAT_S8_UINT, 16, 127, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 16, 127, 2, 7, 0x1d00 },
   { PIPE_FORMAT_S8_UINT, 16, 128, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 16, 128, 1, 8, 0xf00 },
   { PIPE_FORMAT_S8_UINT, 16, 128, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 16, 128, 2, 8, 0x1e00 },
   { PIPE_FORMAT_S8_UINT, 16, 129, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 16, 129, 1, 8, 0x1980 },
   { PIPE_FORMAT_S8_UINT, 16, 129, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 16, 129, 2, 8, 0x3300 },
   { PIPE_FORMAT_S8_UINT, 16, 255, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 16, 255, 1, 8, 0x1a00 },
   { PIPE_FORMAT_S8_UINT, 16, 255, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 16, 255, 2, 8, 0x3400 },
   { PIPE_FORMAT_S8_UINT, 16, 256, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 16, 256, 1, 9, 0x1a80 },
   { PIPE_FORMAT_S8_UINT, 16, 256, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 16, 256, 2, 9, 0x3500 },
   { PIPE_FORMAT_S8_UINT, 16, 257, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 16, 257, 1, 9, 0x3000 },
   { PIPE_FORMAT_S8_UINT, 16, 257, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 16, 257, 2, 9, 0x6000 },
   { PIPE_FORMAT_S8_UINT, 16, 511, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 16, 511, 1, 9, 0x3080 },
   { PIPE_FORMAT_S8_UINT, 16, 511, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 16, 511, 2, 9, 0x6100 },
   { PIPE_FORMAT_S8_UINT, 16, 512, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 16, 512, 1, 10, 0x3100 },
   { PIPE_FORMAT_S8_UINT, 16, 512, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 16, 512, 2, 10, 0x6200 },
   { PIPE_FORMAT_S8_UINT, 16, 513, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 16, 513, 1, 10, 0x8500 },
   { PIPE_FORMAT_S8_UINT, 16, 513, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 16, 513, 2, 10, 0x10a00 },
   { PIPE_FORMAT_S8_UINT, 16, 1023, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 16, 1023, 1, 10, 0x8580 },
   { PIPE_FORMAT_S8_UINT, 16, 1023, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 16, 1023, 2, 10, 0x10b00 },
   { PIPE_FORMAT_S8_UINT, 16, 1024, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 16, 1024, 1, 11, 0x8580 },
   { PIPE_FORMAT_S8_UINT, 16, 1024, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 16, 1024, 2, 11, 0x10b00 },
   { PIPE_FORMAT_S8_UINT, 16, 1025, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 16, 1025, 1, 11, 0xc900 },
   { PIPE_FORMAT_S8_UINT, 16, 1025, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 16, 1025, 2, 11, 0x19200 },
   { PIPE_FORMAT_S8_UINT, 16, 2047, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 16, 2047, 1, 11, 0xc980 },
   { PIPE_FORMAT_S8_UINT, 16, 2047, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 16, 2047, 2, 11, 0x19300 },
   { PIPE_FORMAT_S8_UINT, 16, 2048, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 16, 2048, 1, 12, 0xc980 },
   { PIPE_FORMAT_S8_UINT, 16, 2048, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 16, 2048, 2, 12, 0x19300 },
   { PIPE_FORMAT_S8_UINT, 16, 2049, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 16, 2049, 1, 12, 0x19100 },
   { PIPE_FORMAT_S8_UINT, 16, 2049, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 16, 2049, 2, 12, 0x32200 },
   { PIPE_FORMAT_S8_UINT, 16, 4095, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 16, 4095, 1, 12, 0x19180 },
   { PIPE_FORMAT_S8_UINT, 16, 4095, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 16, 4095, 2, 12, 0x32300 },
   { PIPE_FORMAT_S8_UINT, 16, 4096, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 16, 4096, 1, 13, 0x19180 },
   { PIPE_FORMAT_S8_UINT, 16, 4096, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 16, 4096, 2, 13, 0x32300 },
   { PIPE_FORMAT_S8_UINT, 16, 4097, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 16, 4097, 1, 13, 0x2e100 },
   { PIPE_FORMAT_S8_UINT, 16, 4097, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 16, 4097, 2, 13, 0x5c200 },
   { PIPE_FORMAT_S8_UINT, 17, 16, 1, 1, 0x280 },
   { PIPE_FORMAT_S8_UINT, 17, 16, 1, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 17, 16, 2, 1, 0x500 },
   { PIPE_FORMAT_S8_UINT, 17, 16, 2, 5, 0xa00 },
   { PIPE_FORMAT_S8_UINT, 17, 17, 1, 1, 0x480 },
   { PIPE_FORMAT_S8_UINT, 17, 17, 1, 5, 0x780 },
   { PIPE_FORMAT_S8_UINT, 17, 17, 2, 1, 0x900 },
   { PIPE_FORMAT_S8_UINT, 17, 17, 2, 5, 0xf00 },
   { PIPE_FORMAT_S8_UINT, 17, 31, 1, 1, 0x480 },
   { PIPE_FORMAT_S8_UINT, 17, 31, 1, 5, 0x780 },
   { PIPE_FORMAT_S8_UINT, 17, 31, 2, 1, 0x900 },
   { PIPE_FORMAT_S8_UINT, 17, 31, 2, 5, 0xf00 },
   { PIPE_FORMAT_S8_UINT, 17, 32, 1, 1, 0x480 },
   { PIPE_FORMAT_S8_UINT, 17, 32, 1, 6, 0x800 },
   { PIPE_FORMAT_S8_UINT, 17, 32, 2, 1, 0x900 },
   { PIPE_FORMAT_S8_UINT, 17, 32, 2, 6, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 17, 33, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 17, 33, 1, 6, 0xd00 },
   { PIPE_FORMAT_S8_UINT, 17, 33, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 17, 33, 2, 6, 0x1a00 },
   { PIPE_FORMAT_S8_UINT, 17, 63, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 17, 63, 1, 6, 0xd80 },
   { PIPE_FORMAT_S8_UINT, 17, 63, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 17, 63, 2, 6, 0x1b00 },
   { PIPE_FORMAT_S8_UINT, 17, 64, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 17, 64, 1, 7, 0xe00 },
   { PIPE_FORMAT_S8_UINT, 17, 64, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 17, 64, 2, 7, 0x1c00 },
   { PIPE_FORMAT_S8_UINT, 17, 65, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 17, 65, 1, 7, 0x1880 },
   { PIPE_FORMAT_S8_UINT, 17, 65, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 17, 65, 2, 7, 0x3100 },
   { PIPE_FORMAT_S8_UINT, 17, 127, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 17, 127, 1, 7, 0x1900 },
   { PIPE_FORMAT_S8_UINT, 17, 127, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 17, 127, 2, 7, 0x3200 },
   { PIPE_FORMAT_S8_UINT, 17, 128, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 17, 128, 1, 8, 0x1980 },
   { PIPE_FORMAT_S8_UINT, 17, 128, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 17, 128, 2, 8, 0x3300 },
   { PIPE_FORMAT_S8_UINT, 17, 129, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 17, 129, 1, 8, 0x2f00 },
   { PIPE_FORMAT_S8_UINT, 17, 129, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 17, 129, 2, 8, 0x5e00 },
   { PIPE_FORMAT_S8_UINT, 17, 255, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 17, 255, 1, 8, 0x2f80 },
   { PIPE_FORMAT_S8_UINT, 17, 255, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 17, 255, 2, 8, 0x5f00 },
   { PIPE_FORMAT_S8_UINT, 17, 256, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 17, 256, 1, 9, 0x3000 },
   { PIPE_FORMAT_S8_UINT, 17, 256, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 17, 256, 2, 9, 0x6000 },
   { PIPE_FORMAT_S8_UINT, 17, 257, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 17, 257, 1, 9, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 17, 257, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 17, 257, 2, 9, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 17, 511, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 17, 511, 1, 9, 0x8480 },
   { PIPE_FORMAT_S8_UINT, 17, 511, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 17, 511, 2, 9, 0x10900 },
   { PIPE_FORMAT_S8_UINT, 17, 512, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 17, 512, 1, 10, 0x8480 },
   { PIPE_FORMAT_S8_UINT, 17, 512, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 17, 512, 2, 10, 0x10900 },
   { PIPE_FORMAT_S8_UINT, 17, 513, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 17, 513, 1, 10, 0xc700 },
   { PIPE_FORMAT_S8_UINT, 17, 513, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 17, 513, 2, 10, 0x18e00 },
   { PIPE_FORMAT_S8_UINT, 17, 1023, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 17, 1023, 1, 10, 0xc780 },
   { PIPE_FORMAT_S8_UINT, 17, 1023, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 17, 1023, 2, 10, 0x18f00 },
   { PIPE_FORMAT_S8_UINT, 17, 1024, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 17, 1024, 1, 11, 0xc780 },
   { PIPE_FORMAT_S8_UINT, 17, 1024, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 17, 1024, 2, 11, 0x18f00 },
   { PIPE_FORMAT_S8_UINT, 17, 1025, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 17, 1025, 1, 11, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 17, 1025, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 17, 1025, 2, 11, 0x31a00 },
   { PIPE_FORMAT_S8_UINT, 17, 2047, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 17, 2047, 1, 11, 0x18d80 },
   { PIPE_FORMAT_S8_UINT, 17, 2047, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 17, 2047, 2, 11, 0x31b00 },
   { PIPE_FORMAT_S8_UINT, 17, 2048, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 17, 2048, 1, 12, 0x18d80 },
   { PIPE_FORMAT_S8_UINT, 17, 2048, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 17, 2048, 2, 12, 0x31b00 },
   { PIPE_FORMAT_S8_UINT, 17, 2049, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 17, 2049, 1, 12, 0x2d900 },
   { PIPE_FORMAT_S8_UINT, 17, 2049, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 17, 2049, 2, 12, 0x5b200 },
   { PIPE_FORMAT_S8_UINT, 17, 4095, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 17, 4095, 1, 12, 0x2d980 },
   { PIPE_FORMAT_S8_UINT, 17, 4095, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 17, 4095, 2, 12, 0x5b300 },
   { PIPE_FORMAT_S8_UINT, 17, 4096, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 17, 4096, 1, 13, 0x2d980 },
   { PIPE_FORMAT_S8_UINT, 17, 4096, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 17, 4096, 2, 13, 0x5b300 },
   { PIPE_FORMAT_S8_UINT, 17, 4097, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 17, 4097, 1, 13, 0x5b100 },
   { PIPE_FORMAT_S8_UINT, 17, 4097, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 17, 4097, 2, 13, 0xb6200 },
   { PIPE_FORMAT_S8_UINT, 31, 16, 1, 1, 0x280 },
   { PIPE_FORMAT_S8_UINT, 31, 16, 1, 5, 0x500 },
   { PIPE_FORMAT_S8_UINT, 31, 16, 2, 1, 0x500 },
   { PIPE_FORMAT_S8_UINT, 31, 16, 2, 5, 0xa00 },
   { PIPE_FORMAT_S8_UINT, 31, 17, 1, 1, 0x480 },
   { PIPE_FORMAT_S8_UINT, 31, 17, 1, 5, 0x780 },
   { PIPE_FORMAT_S8_UINT, 31, 17, 2, 1, 0x900 },
   { PIPE_FORMAT_S8_UINT, 31, 17, 2, 5, 0xf00 },
   { PIPE_FORMAT_S8_UINT, 31, 31, 1, 1, 0x480 },
   { PIPE_FORMAT_S8_UINT, 31, 31, 1, 5, 0x780 },
   { PIPE_FORMAT_S8_UINT, 31, 31, 2, 1, 0x900 },
   { PIPE_FORMAT_S8_UINT, 31, 31, 2, 5, 0xf00 },
   { PIPE_FORMAT_S8_UINT, 31, 32, 1, 1, 0x480 },
   { PIPE_FORMAT_S8_UINT, 31, 32, 1, 6, 0x800 },
   { PIPE_FORMAT_S8_UINT, 31, 32, 2, 1, 0x900 },
   { PIPE_FORMAT_S8_UINT, 31, 32, 2, 6, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 31, 33, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 31, 33, 1, 6, 0xd00 },
   { PIPE_FORMAT_S8_UINT, 31, 33, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 31, 33, 2, 6, 0x1a00 },
   { PIPE_FORMAT_S8_UINT, 31, 63, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 31, 63, 1, 6, 0xd80 },
   { PIPE_FORMAT_S8_UINT, 31, 63, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 31, 63, 2, 6, 0x1b00 },
   { PIPE_FORMAT_S8_UINT, 31, 64, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 31, 64, 1, 7, 0xe00 },
   { PIPE_FORMAT_S8_UINT, 31, 64, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 31, 64, 2, 7, 0x1c00 },
   { PIPE_FORMAT_S8_UINT, 31, 65, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 31, 65, 1, 7, 0x1880 },
   { PIPE_FORMAT_S8_UINT, 31, 65, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 31, 65, 2, 7, 0x3100 },
   { PIPE_FORMAT_S8_UINT, 31, 127, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 31, 127, 1, 7, 0x1900 },
   { PIPE_FORMAT_S8_UINT, 31, 127, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 31, 127, 2, 7, 0x3200 },
   { PIPE_FORMAT_S8_UINT, 31, 128, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 31, 128, 1, 8, 0x1980 },
   { PIPE_FORMAT_S8_UINT, 31, 128, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 31, 128, 2, 8, 0x3300 },
   { PIPE_FORMAT_S8_UINT, 31, 129, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 31, 129, 1, 8, 0x2f00 },
   { PIPE_FORMAT_S8_UINT, 31, 129, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 31, 129, 2, 8, 0x5e00 },
   { PIPE_FORMAT_S8_UINT, 31, 255, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 31, 255, 1, 8, 0x2f80 },
   { PIPE_FORMAT_S8_UINT, 31, 255, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 31, 255, 2, 8, 0x5f00 },
   { PIPE_FORMAT_S8_UINT, 31, 256, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 31, 256, 1, 9, 0x3000 },
   { PIPE_FORMAT_S8_UINT, 31, 256, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 31, 256, 2, 9, 0x6000 },
   { PIPE_FORMAT_S8_UINT, 31, 257, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 31, 257, 1, 9, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 31, 257, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 31, 257, 2, 9, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 31, 511, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 31, 511, 1, 9, 0x8480 },
   { PIPE_FORMAT_S8_UINT, 31, 511, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 31, 511, 2, 9, 0x10900 },
   { PIPE_FORMAT_S8_UINT, 31, 512, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 31, 512, 1, 10, 0x8480 },
   { PIPE_FORMAT_S8_UINT, 31, 512, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 31, 512, 2, 10, 0x10900 },
   { PIPE_FORMAT_S8_UINT, 31, 513, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 31, 513, 1, 10, 0xc700 },
   { PIPE_FORMAT_S8_UINT, 31, 513, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 31, 513, 2, 10, 0x18e00 },
   { PIPE_FORMAT_S8_UINT, 31, 1023, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 31, 1023, 1, 10, 0xc780 },
   { PIPE_FORMAT_S8_UINT, 31, 1023, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 31, 1023, 2, 10, 0x18f00 },
   { PIPE_FORMAT_S8_UINT, 31, 1024, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 31, 1024, 1, 11, 0xc780 },
   { PIPE_FORMAT_S8_UINT, 31, 1024, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 31, 1024, 2, 11, 0x18f00 },
   { PIPE_FORMAT_S8_UINT, 31, 1025, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 31, 1025, 1, 11, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 31, 1025, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 31, 1025, 2, 11, 0x31a00 },
   { PIPE_FORMAT_S8_UINT, 31, 2047, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 31, 2047, 1, 11, 0x18d80 },
   { PIPE_FORMAT_S8_UINT, 31, 2047, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 31, 2047, 2, 11, 0x31b00 },
   { PIPE_FORMAT_S8_UINT, 31, 2048, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 31, 2048, 1, 12, 0x18d80 },
   { PIPE_FORMAT_S8_UINT, 31, 2048, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 31, 2048, 2, 12, 0x31b00 },
   { PIPE_FORMAT_S8_UINT, 31, 2049, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 31, 2049, 1, 12, 0x2d900 },
   { PIPE_FORMAT_S8_UINT, 31, 2049, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 31, 2049, 2, 12, 0x5b200 },
   { PIPE_FORMAT_S8_UINT, 31, 4095, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 31, 4095, 1, 12, 0x2d980 },
   { PIPE_FORMAT_S8_UINT, 31, 4095, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 31, 4095, 2, 12, 0x5b300 },
   { PIPE_FORMAT_S8_UINT, 31, 4096, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 31, 4096, 1, 13, 0x2d980 },
   { PIPE_FORMAT_S8_UINT, 31, 4096, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 31, 4096, 2, 13, 0x5b300 },
   { PIPE_FORMAT_S8_UINT, 31, 4097, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 31, 4097, 1, 13, 0x5b100 },
   { PIPE_FORMAT_S8_UINT, 31, 4097, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 31, 4097, 2, 13, 0xb6200 },
   { PIPE_FORMAT_S8_UINT, 32, 16, 1, 1, 0x280 },
   { PIPE_FORMAT_S8_UINT, 32, 16, 1, 6, 0x580 },
   { PIPE_FORMAT_S8_UINT, 32, 16, 2, 1, 0x500 },
   { PIPE_FORMAT_S8_UINT, 32, 16, 2, 6, 0xb00 },
   { PIPE_FORMAT_S8_UINT, 32, 17, 1, 1, 0x480 },
   { PIPE_FORMAT_S8_UINT, 32, 17, 1, 6, 0x800 },
   { PIPE_FORMAT_S8_UINT, 32, 17, 2, 1, 0x900 },
   { PIPE_FORMAT_S8_UINT, 32, 17, 2, 6, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 32, 31, 1, 1, 0x480 },
   { PIPE_FORMAT_S8_UINT, 32, 31, 1, 6, 0x800 },
   { PIPE_FORMAT_S8_UINT, 32, 31, 2, 1, 0x900 },
   { PIPE_FORMAT_S8_UINT, 32, 31, 2, 6, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 32, 32, 1, 1, 0x480 },
   { PIPE_FORMAT_S8_UINT, 32, 32, 1, 6, 0x800 },
   { PIPE_FORMAT_S8_UINT, 32, 32, 2, 1, 0x900 },
   { PIPE_FORMAT_S8_UINT, 32, 32, 2, 6, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 32, 33, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 32, 33, 1, 6, 0xd00 },
   { PIPE_FORMAT_S8_UINT, 32, 33, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 32, 33, 2, 6, 0x1a00 },
   { PIPE_FORMAT_S8_UINT, 32, 63, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 32, 63, 1, 6, 0xd80 },
   { PIPE_FORMAT_S8_UINT, 32, 63, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 32, 63, 2, 6, 0x1b00 },
   { PIPE_FORMAT_S8_UINT, 32, 64, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 32, 64, 1, 7, 0xe00 },
   { PIPE_FORMAT_S8_UINT, 32, 64, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 32, 64, 2, 7, 0x1c00 },
   { PIPE_FORMAT_S8_UINT, 32, 65, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 32, 65, 1, 7, 0x1880 },
   { PIPE_FORMAT_S8_UINT, 32, 65, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 32, 65, 2, 7, 0x3100 },
   { PIPE_FORMAT_S8_UINT, 32, 127, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 32, 127, 1, 7, 0x1900 },
   { PIPE_FORMAT_S8_UINT, 32, 127, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 32, 127, 2, 7, 0x3200 },
   { PIPE_FORMAT_S8_UINT, 32, 128, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 32, 128, 1, 8, 0x1980 },
   { PIPE_FORMAT_S8_UINT, 32, 128, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 32, 128, 2, 8, 0x3300 },
   { PIPE_FORMAT_S8_UINT, 32, 129, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 32, 129, 1, 8, 0x2f00 },
   { PIPE_FORMAT_S8_UINT, 32, 129, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 32, 129, 2, 8, 0x5e00 },
   { PIPE_FORMAT_S8_UINT, 32, 255, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 32, 255, 1, 8, 0x2f80 },
   { PIPE_FORMAT_S8_UINT, 32, 255, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 32, 255, 2, 8, 0x5f00 },
   { PIPE_FORMAT_S8_UINT, 32, 256, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 32, 256, 1, 9, 0x3000 },
   { PIPE_FORMAT_S8_UINT, 32, 256, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 32, 256, 2, 9, 0x6000 },
   { PIPE_FORMAT_S8_UINT, 32, 257, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 32, 257, 1, 9, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 32, 257, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 32, 257, 2, 9, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 32, 511, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 32, 511, 1, 9, 0x8480 },
   { PIPE_FORMAT_S8_UINT, 32, 511, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 32, 511, 2, 9, 0x10900 },
   { PIPE_FORMAT_S8_UINT, 32, 512, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 32, 512, 1, 10, 0x8480 },
   { PIPE_FORMAT_S8_UINT, 32, 512, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 32, 512, 2, 10, 0x10900 },
   { PIPE_FORMAT_S8_UINT, 32, 513, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 32, 513, 1, 10, 0xc700 },
   { PIPE_FORMAT_S8_UINT, 32, 513, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 32, 513, 2, 10, 0x18e00 },
   { PIPE_FORMAT_S8_UINT, 32, 1023, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 32, 1023, 1, 10, 0xc780 },
   { PIPE_FORMAT_S8_UINT, 32, 1023, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 32, 1023, 2, 10, 0x18f00 },
   { PIPE_FORMAT_S8_UINT, 32, 1024, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 32, 1024, 1, 11, 0xc780 },
   { PIPE_FORMAT_S8_UINT, 32, 1024, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 32, 1024, 2, 11, 0x18f00 },
   { PIPE_FORMAT_S8_UINT, 32, 1025, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 32, 1025, 1, 11, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 32, 1025, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 32, 1025, 2, 11, 0x31a00 },
   { PIPE_FORMAT_S8_UINT, 32, 2047, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 32, 2047, 1, 11, 0x18d80 },
   { PIPE_FORMAT_S8_UINT, 32, 2047, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 32, 2047, 2, 11, 0x31b00 },
   { PIPE_FORMAT_S8_UINT, 32, 2048, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 32, 2048, 1, 12, 0x18d80 },
   { PIPE_FORMAT_S8_UINT, 32, 2048, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 32, 2048, 2, 12, 0x31b00 },
   { PIPE_FORMAT_S8_UINT, 32, 2049, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 32, 2049, 1, 12, 0x2d900 },
   { PIPE_FORMAT_S8_UINT, 32, 2049, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 32, 2049, 2, 12, 0x5b200 },
   { PIPE_FORMAT_S8_UINT, 32, 4095, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 32, 4095, 1, 12, 0x2d980 },
   { PIPE_FORMAT_S8_UINT, 32, 4095, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 32, 4095, 2, 12, 0x5b300 },
   { PIPE_FORMAT_S8_UINT, 32, 4096, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 32, 4096, 1, 13, 0x2d980 },
   { PIPE_FORMAT_S8_UINT, 32, 4096, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 32, 4096, 2, 13, 0x5b300 },
   { PIPE_FORMAT_S8_UINT, 32, 4097, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 32, 4097, 1, 13, 0x5b100 },
   { PIPE_FORMAT_S8_UINT, 32, 4097, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 32, 4097, 2, 13, 0xb6200 },
   { PIPE_FORMAT_S8_UINT, 33, 16, 1, 1, 0x480 },
   { PIPE_FORMAT_S8_UINT, 33, 16, 1, 6, 0x800 },
   { PIPE_FORMAT_S8_UINT, 33, 16, 2, 1, 0x900 },
   { PIPE_FORMAT_S8_UINT, 33, 16, 2, 6, 0x1000 },
   { PIPE_FORMAT_S8_UINT, 33, 17, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 33, 17, 1, 6, 0xd00 },
   { PIPE_FORMAT_S8_UINT, 33, 17, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 33, 17, 2, 6, 0x1a00 },
   { PIPE_FORMAT_S8_UINT, 33, 31, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 33, 31, 1, 6, 0xd00 },
   { PIPE_FORMAT_S8_UINT, 33, 31, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 33, 31, 2, 6, 0x1a00 },
   { PIPE_FORMAT_S8_UINT, 33, 32, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 33, 32, 1, 6, 0xd00 },
   { PIPE_FORMAT_S8_UINT, 33, 32, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 33, 32, 2, 6, 0x1a00 },
   { PIPE_FORMAT_S8_UINT, 33, 33, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 33, 33, 1, 6, 0x1780 },
   { PIPE_FORMAT_S8_UINT, 33, 33, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 33, 33, 2, 6, 0x2f00 },
   { PIPE_FORMAT_S8_UINT, 33, 63, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 33, 63, 1, 6, 0x1800 },
   { PIPE_FORMAT_S8_UINT, 33, 63, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 33, 63, 2, 6, 0x3000 },
   { PIPE_FORMAT_S8_UINT, 33, 64, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 33, 64, 1, 7, 0x1880 },
   { PIPE_FORMAT_S8_UINT, 33, 64, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 33, 64, 2, 7, 0x3100 },
   { PIPE_FORMAT_S8_UINT, 33, 65, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 33, 65, 1, 7, 0x2e00 },
   { PIPE_FORMAT_S8_UINT, 33, 65, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 33, 65, 2, 7, 0x5c00 },
   { PIPE_FORMAT_S8_UINT, 33, 127, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 33, 127, 1, 7, 0x2e80 },
   { PIPE_FORMAT_S8_UINT, 33, 127, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 33, 127, 2, 7, 0x5d00 },
   { PIPE_FORMAT_S8_UINT, 33, 128, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 33, 128, 1, 8, 0x2f00 },
   { PIPE_FORMAT_S8_UINT, 33, 128, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 33, 128, 2, 8, 0x5e00 },
   { PIPE_FORMAT_S8_UINT, 33, 129, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 33, 129, 1, 8, 0x8380 },
   { PIPE_FORMAT_S8_UINT, 33, 129, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 33, 129, 2, 8, 0x10700 },
   { PIPE_FORMAT_S8_UINT, 33, 255, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 33, 255, 1, 8, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 33, 255, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 33, 255, 2, 8, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 33, 256, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 33, 256, 1, 9, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 33, 256, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 33, 256, 2, 9, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 33, 257, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 33, 257, 1, 9, 0xc680 },
   { PIPE_FORMAT_S8_UINT, 33, 257, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 33, 257, 2, 9, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 33, 511, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 33, 511, 1, 9, 0xc700 },
   { PIPE_FORMAT_S8_UINT, 33, 511, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 33, 511, 2, 9, 0x18e00 },
   { PIPE_FORMAT_S8_UINT, 33, 512, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 33, 512, 1, 10, 0xc700 },
   { PIPE_FORMAT_S8_UINT, 33, 512, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 33, 512, 2, 10, 0x18e00 },
   { PIPE_FORMAT_S8_UINT, 33, 513, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 33, 513, 1, 10, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 33, 513, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 33, 513, 2, 10, 0x31800 },
   { PIPE_FORMAT_S8_UINT, 33, 1023, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 33, 1023, 1, 10, 0x18c80 },
   { PIPE_FORMAT_S8_UINT, 33, 1023, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 33, 1023, 2, 10, 0x31900 },
   { PIPE_FORMAT_S8_UINT, 33, 1024, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 33, 1024, 1, 11, 0x18c80 },
   { PIPE_FORMAT_S8_UINT, 33, 1024, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 33, 1024, 2, 11, 0x31900 },
   { PIPE_FORMAT_S8_UINT, 33, 1025, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 33, 1025, 1, 11, 0x2d700 },
   { PIPE_FORMAT_S8_UINT, 33, 1025, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 33, 1025, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_S8_UINT, 33, 2047, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 33, 2047, 1, 11, 0x2d780 },
   { PIPE_FORMAT_S8_UINT, 33, 2047, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 33, 2047, 2, 11, 0x5af00 },
   { PIPE_FORMAT_S8_UINT, 33, 2048, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 33, 2048, 1, 12, 0x2d780 },
   { PIPE_FORMAT_S8_UINT, 33, 2048, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 33, 2048, 2, 12, 0x5af00 },
   { PIPE_FORMAT_S8_UINT, 33, 2049, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 33, 2049, 1, 12, 0x5ad00 },
   { PIPE_FORMAT_S8_UINT, 33, 2049, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 33, 2049, 2, 12, 0xb5a00 },
   { PIPE_FORMAT_S8_UINT, 33, 4095, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 33, 4095, 1, 12, 0x5ad80 },
   { PIPE_FORMAT_S8_UINT, 33, 4095, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 33, 4095, 2, 12, 0xb5b00 },
   { PIPE_FORMAT_S8_UINT, 33, 4096, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 33, 4096, 1, 13, 0x5ad80 },
   { PIPE_FORMAT_S8_UINT, 33, 4096, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 33, 4096, 2, 13, 0xb5b00 },
   { PIPE_FORMAT_S8_UINT, 33, 4097, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 33, 4097, 1, 13, 0xb1900 },
   { PIPE_FORMAT_S8_UINT, 33, 4097, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 33, 4097, 2, 13, 0x163200 },
   { PIPE_FORMAT_S8_UINT, 63, 16, 1, 1, 0x480 },
   { PIPE_FORMAT_S8_UINT, 63, 16, 1, 6, 0x880 },
   { PIPE_FORMAT_S8_UINT, 63, 16, 2, 1, 0x900 },
   { PIPE_FORMAT_S8_UINT, 63, 16, 2, 6, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 63, 17, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 63, 17, 1, 6, 0xd80 },
   { PIPE_FORMAT_S8_UINT, 63, 17, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 63, 17, 2, 6, 0x1b00 },
   { PIPE_FORMAT_S8_UINT, 63, 31, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 63, 31, 1, 6, 0xd80 },
   { PIPE_FORMAT_S8_UINT, 63, 31, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 63, 31, 2, 6, 0x1b00 },
   { PIPE_FORMAT_S8_UINT, 63, 32, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 63, 32, 1, 6, 0xd80 },
   { PIPE_FORMAT_S8_UINT, 63, 32, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 63, 32, 2, 6, 0x1b00 },
   { PIPE_FORMAT_S8_UINT, 63, 33, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 63, 33, 1, 6, 0x1800 },
   { PIPE_FORMAT_S8_UINT, 63, 33, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 63, 33, 2, 6, 0x3000 },
   { PIPE_FORMAT_S8_UINT, 63, 63, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 63, 63, 1, 6, 0x1800 },
   { PIPE_FORMAT_S8_UINT, 63, 63, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 63, 63, 2, 6, 0x3000 },
   { PIPE_FORMAT_S8_UINT, 63, 64, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 63, 64, 1, 7, 0x1880 },
   { PIPE_FORMAT_S8_UINT, 63, 64, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 63, 64, 2, 7, 0x3100 },
   { PIPE_FORMAT_S8_UINT, 63, 65, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 63, 65, 1, 7, 0x2e00 },
   { PIPE_FORMAT_S8_UINT, 63, 65, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 63, 65, 2, 7, 0x5c00 },
   { PIPE_FORMAT_S8_UINT, 63, 127, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 63, 127, 1, 7, 0x2e80 },
   { PIPE_FORMAT_S8_UINT, 63, 127, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 63, 127, 2, 7, 0x5d00 },
   { PIPE_FORMAT_S8_UINT, 63, 128, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 63, 128, 1, 8, 0x2f00 },
   { PIPE_FORMAT_S8_UINT, 63, 128, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 63, 128, 2, 8, 0x5e00 },
   { PIPE_FORMAT_S8_UINT, 63, 129, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 63, 129, 1, 8, 0x8380 },
   { PIPE_FORMAT_S8_UINT, 63, 129, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 63, 129, 2, 8, 0x10700 },
   { PIPE_FORMAT_S8_UINT, 63, 255, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 63, 255, 1, 8, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 63, 255, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 63, 255, 2, 8, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 63, 256, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 63, 256, 1, 9, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 63, 256, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 63, 256, 2, 9, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 63, 257, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 63, 257, 1, 9, 0xc680 },
   { PIPE_FORMAT_S8_UINT, 63, 257, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 63, 257, 2, 9, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 63, 511, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 63, 511, 1, 9, 0xc700 },
   { PIPE_FORMAT_S8_UINT, 63, 511, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 63, 511, 2, 9, 0x18e00 },
   { PIPE_FORMAT_S8_UINT, 63, 512, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 63, 512, 1, 10, 0xc700 },
   { PIPE_FORMAT_S8_UINT, 63, 512, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 63, 512, 2, 10, 0x18e00 },
   { PIPE_FORMAT_S8_UINT, 63, 513, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 63, 513, 1, 10, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 63, 513, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 63, 513, 2, 10, 0x31800 },
   { PIPE_FORMAT_S8_UINT, 63, 1023, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 63, 1023, 1, 10, 0x18c80 },
   { PIPE_FORMAT_S8_UINT, 63, 1023, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 63, 1023, 2, 10, 0x31900 },
   { PIPE_FORMAT_S8_UINT, 63, 1024, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 63, 1024, 1, 11, 0x18c80 },
   { PIPE_FORMAT_S8_UINT, 63, 1024, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 63, 1024, 2, 11, 0x31900 },
   { PIPE_FORMAT_S8_UINT, 63, 1025, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 63, 1025, 1, 11, 0x2d700 },
   { PIPE_FORMAT_S8_UINT, 63, 1025, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 63, 1025, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_S8_UINT, 63, 2047, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 63, 2047, 1, 11, 0x2d780 },
   { PIPE_FORMAT_S8_UINT, 63, 2047, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 63, 2047, 2, 11, 0x5af00 },
   { PIPE_FORMAT_S8_UINT, 63, 2048, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 63, 2048, 1, 12, 0x2d780 },
   { PIPE_FORMAT_S8_UINT, 63, 2048, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 63, 2048, 2, 12, 0x5af00 },
   { PIPE_FORMAT_S8_UINT, 63, 2049, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 63, 2049, 1, 12, 0x5ad00 },
   { PIPE_FORMAT_S8_UINT, 63, 2049, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 63, 2049, 2, 12, 0xb5a00 },
   { PIPE_FORMAT_S8_UINT, 63, 4095, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 63, 4095, 1, 12, 0x5ad80 },
   { PIPE_FORMAT_S8_UINT, 63, 4095, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 63, 4095, 2, 12, 0xb5b00 },
   { PIPE_FORMAT_S8_UINT, 63, 4096, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 63, 4096, 1, 13, 0x5ad80 },
   { PIPE_FORMAT_S8_UINT, 63, 4096, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 63, 4096, 2, 13, 0xb5b00 },
   { PIPE_FORMAT_S8_UINT, 63, 4097, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 63, 4097, 1, 13, 0xb1900 },
   { PIPE_FORMAT_S8_UINT, 63, 4097, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 63, 4097, 2, 13, 0x163200 },
   { PIPE_FORMAT_S8_UINT, 64, 16, 1, 1, 0x480 },
   { PIPE_FORMAT_S8_UINT, 64, 16, 1, 7, 0x900 },
   { PIPE_FORMAT_S8_UINT, 64, 16, 2, 1, 0x900 },
   { PIPE_FORMAT_S8_UINT, 64, 16, 2, 7, 0x1200 },
   { PIPE_FORMAT_S8_UINT, 64, 17, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 64, 17, 1, 7, 0xe00 },
   { PIPE_FORMAT_S8_UINT, 64, 17, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 64, 17, 2, 7, 0x1c00 },
   { PIPE_FORMAT_S8_UINT, 64, 31, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 64, 31, 1, 7, 0xe00 },
   { PIPE_FORMAT_S8_UINT, 64, 31, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 64, 31, 2, 7, 0x1c00 },
   { PIPE_FORMAT_S8_UINT, 64, 32, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 64, 32, 1, 7, 0xe00 },
   { PIPE_FORMAT_S8_UINT, 64, 32, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 64, 32, 2, 7, 0x1c00 },
   { PIPE_FORMAT_S8_UINT, 64, 33, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 64, 33, 1, 7, 0x1880 },
   { PIPE_FORMAT_S8_UINT, 64, 33, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 64, 33, 2, 7, 0x3100 },
   { PIPE_FORMAT_S8_UINT, 64, 63, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 64, 63, 1, 7, 0x1880 },
   { PIPE_FORMAT_S8_UINT, 64, 63, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 64, 63, 2, 7, 0x3100 },
   { PIPE_FORMAT_S8_UINT, 64, 64, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 64, 64, 1, 7, 0x1880 },
   { PIPE_FORMAT_S8_UINT, 64, 64, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 64, 64, 2, 7, 0x3100 },
   { PIPE_FORMAT_S8_UINT, 64, 65, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 64, 65, 1, 7, 0x2e00 },
   { PIPE_FORMAT_S8_UINT, 64, 65, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 64, 65, 2, 7, 0x5c00 },
   { PIPE_FORMAT_S8_UINT, 64, 127, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 64, 127, 1, 7, 0x2e80 },
   { PIPE_FORMAT_S8_UINT, 64, 127, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 64, 127, 2, 7, 0x5d00 },
   { PIPE_FORMAT_S8_UINT, 64, 128, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 64, 128, 1, 8, 0x2f00 },
   { PIPE_FORMAT_S8_UINT, 64, 128, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 64, 128, 2, 8, 0x5e00 },
   { PIPE_FORMAT_S8_UINT, 64, 129, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 64, 129, 1, 8, 0x8380 },
   { PIPE_FORMAT_S8_UINT, 64, 129, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 64, 129, 2, 8, 0x10700 },
   { PIPE_FORMAT_S8_UINT, 64, 255, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 64, 255, 1, 8, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 64, 255, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 64, 255, 2, 8, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 64, 256, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 64, 256, 1, 9, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 64, 256, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 64, 256, 2, 9, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 64, 257, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 64, 257, 1, 9, 0xc680 },
   { PIPE_FORMAT_S8_UINT, 64, 257, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 64, 257, 2, 9, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 64, 511, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 64, 511, 1, 9, 0xc700 },
   { PIPE_FORMAT_S8_UINT, 64, 511, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 64, 511, 2, 9, 0x18e00 },
   { PIPE_FORMAT_S8_UINT, 64, 512, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 64, 512, 1, 10, 0xc700 },
   { PIPE_FORMAT_S8_UINT, 64, 512, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 64, 512, 2, 10, 0x18e00 },
   { PIPE_FORMAT_S8_UINT, 64, 513, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 64, 513, 1, 10, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 64, 513, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 64, 513, 2, 10, 0x31800 },
   { PIPE_FORMAT_S8_UINT, 64, 1023, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 64, 1023, 1, 10, 0x18c80 },
   { PIPE_FORMAT_S8_UINT, 64, 1023, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 64, 1023, 2, 10, 0x31900 },
   { PIPE_FORMAT_S8_UINT, 64, 1024, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 64, 1024, 1, 11, 0x18c80 },
   { PIPE_FORMAT_S8_UINT, 64, 1024, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 64, 1024, 2, 11, 0x31900 },
   { PIPE_FORMAT_S8_UINT, 64, 1025, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 64, 1025, 1, 11, 0x2d700 },
   { PIPE_FORMAT_S8_UINT, 64, 1025, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 64, 1025, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_S8_UINT, 64, 2047, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 64, 2047, 1, 11, 0x2d780 },
   { PIPE_FORMAT_S8_UINT, 64, 2047, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 64, 2047, 2, 11, 0x5af00 },
   { PIPE_FORMAT_S8_UINT, 64, 2048, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 64, 2048, 1, 12, 0x2d780 },
   { PIPE_FORMAT_S8_UINT, 64, 2048, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 64, 2048, 2, 12, 0x5af00 },
   { PIPE_FORMAT_S8_UINT, 64, 2049, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 64, 2049, 1, 12, 0x5ad00 },
   { PIPE_FORMAT_S8_UINT, 64, 2049, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 64, 2049, 2, 12, 0xb5a00 },
   { PIPE_FORMAT_S8_UINT, 64, 4095, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 64, 4095, 1, 12, 0x5ad80 },
   { PIPE_FORMAT_S8_UINT, 64, 4095, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 64, 4095, 2, 12, 0xb5b00 },
   { PIPE_FORMAT_S8_UINT, 64, 4096, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 64, 4096, 1, 13, 0x5ad80 },
   { PIPE_FORMAT_S8_UINT, 64, 4096, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 64, 4096, 2, 13, 0xb5b00 },
   { PIPE_FORMAT_S8_UINT, 64, 4097, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 64, 4097, 1, 13, 0xb1900 },
   { PIPE_FORMAT_S8_UINT, 64, 4097, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 64, 4097, 2, 13, 0x163200 },
   { PIPE_FORMAT_S8_UINT, 65, 16, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 65, 16, 1, 7, 0xe00 },
   { PIPE_FORMAT_S8_UINT, 65, 16, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 65, 16, 2, 7, 0x1c00 },
   { PIPE_FORMAT_S8_UINT, 65, 17, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 65, 17, 1, 7, 0x1880 },
   { PIPE_FORMAT_S8_UINT, 65, 17, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 65, 17, 2, 7, 0x3100 },
   { PIPE_FORMAT_S8_UINT, 65, 31, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 65, 31, 1, 7, 0x1880 },
   { PIPE_FORMAT_S8_UINT, 65, 31, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 65, 31, 2, 7, 0x3100 },
   { PIPE_FORMAT_S8_UINT, 65, 32, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 65, 32, 1, 7, 0x1880 },
   { PIPE_FORMAT_S8_UINT, 65, 32, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 65, 32, 2, 7, 0x3100 },
   { PIPE_FORMAT_S8_UINT, 65, 33, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 65, 33, 1, 7, 0x2e00 },
   { PIPE_FORMAT_S8_UINT, 65, 33, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 65, 33, 2, 7, 0x5c00 },
   { PIPE_FORMAT_S8_UINT, 65, 63, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 65, 63, 1, 7, 0x2e00 },
   { PIPE_FORMAT_S8_UINT, 65, 63, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 65, 63, 2, 7, 0x5c00 },
   { PIPE_FORMAT_S8_UINT, 65, 64, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 65, 64, 1, 7, 0x2e00 },
   { PIPE_FORMAT_S8_UINT, 65, 64, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 65, 64, 2, 7, 0x5c00 },
   { PIPE_FORMAT_S8_UINT, 65, 65, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 65, 65, 1, 7, 0x8300 },
   { PIPE_FORMAT_S8_UINT, 65, 65, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 65, 65, 2, 7, 0x10600 },
   { PIPE_FORMAT_S8_UINT, 65, 127, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 65, 127, 1, 7, 0x8380 },
   { PIPE_FORMAT_S8_UINT, 65, 127, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 65, 127, 2, 7, 0x10700 },
   { PIPE_FORMAT_S8_UINT, 65, 128, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 65, 128, 1, 8, 0x8380 },
   { PIPE_FORMAT_S8_UINT, 65, 128, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 65, 128, 2, 8, 0x10700 },
   { PIPE_FORMAT_S8_UINT, 65, 129, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 65, 129, 1, 8, 0xc600 },
   { PIPE_FORMAT_S8_UINT, 65, 129, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 65, 129, 2, 8, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 65, 255, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 65, 255, 1, 8, 0xc680 },
   { PIPE_FORMAT_S8_UINT, 65, 255, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 65, 255, 2, 8, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 65, 256, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 65, 256, 1, 9, 0xc680 },
   { PIPE_FORMAT_S8_UINT, 65, 256, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 65, 256, 2, 9, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 65, 257, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 65, 257, 1, 9, 0x18b80 },
   { PIPE_FORMAT_S8_UINT, 65, 257, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 65, 257, 2, 9, 0x31700 },
   { PIPE_FORMAT_S8_UINT, 65, 511, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 65, 511, 1, 9, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 65, 511, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 65, 511, 2, 9, 0x31800 },
   { PIPE_FORMAT_S8_UINT, 65, 512, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 65, 512, 1, 10, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 65, 512, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 65, 512, 2, 10, 0x31800 },
   { PIPE_FORMAT_S8_UINT, 65, 513, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 65, 513, 1, 10, 0x2d680 },
   { PIPE_FORMAT_S8_UINT, 65, 513, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 65, 513, 2, 10, 0x5ad00 },
   { PIPE_FORMAT_S8_UINT, 65, 1023, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 65, 1023, 1, 10, 0x2d700 },
   { PIPE_FORMAT_S8_UINT, 65, 1023, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 65, 1023, 2, 10, 0x5ae00 },
   { PIPE_FORMAT_S8_UINT, 65, 1024, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 65, 1024, 1, 11, 0x2d700 },
   { PIPE_FORMAT_S8_UINT, 65, 1024, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 65, 1024, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_S8_UINT, 65, 1025, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 65, 1025, 1, 11, 0x5ac00 },
   { PIPE_FORMAT_S8_UINT, 65, 1025, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 65, 1025, 2, 11, 0xb5800 },
   { PIPE_FORMAT_S8_UINT, 65, 2047, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 65, 2047, 1, 11, 0x5ac80 },
   { PIPE_FORMAT_S8_UINT, 65, 2047, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 65, 2047, 2, 11, 0xb5900 },
   { PIPE_FORMAT_S8_UINT, 65, 2048, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 65, 2048, 1, 12, 0x5ac80 },
   { PIPE_FORMAT_S8_UINT, 65, 2048, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 65, 2048, 2, 12, 0xb5900 },
   { PIPE_FORMAT_S8_UINT, 65, 2049, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 65, 2049, 1, 12, 0xb1700 },
   { PIPE_FORMAT_S8_UINT, 65, 2049, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 65, 2049, 2, 12, 0x162e00 },
   { PIPE_FORMAT_S8_UINT, 65, 4095, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 65, 4095, 1, 12, 0xb1780 },
   { PIPE_FORMAT_S8_UINT, 65, 4095, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 65, 4095, 2, 12, 0x162f00 },
   { PIPE_FORMAT_S8_UINT, 65, 4096, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 65, 4096, 1, 13, 0xb1780 },
   { PIPE_FORMAT_S8_UINT, 65, 4096, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 65, 4096, 2, 13, 0x162f00 },
   { PIPE_FORMAT_S8_UINT, 65, 4097, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 65, 4097, 1, 13, 0x162d00 },
   { PIPE_FORMAT_S8_UINT, 65, 4097, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 65, 4097, 2, 13, 0x2c5a00 },
   { PIPE_FORMAT_S8_UINT, 127, 16, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 127, 16, 1, 7, 0xe80 },
   { PIPE_FORMAT_S8_UINT, 127, 16, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 127, 16, 2, 7, 0x1d00 },
   { PIPE_FORMAT_S8_UINT, 127, 17, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 127, 17, 1, 7, 0x1900 },
   { PIPE_FORMAT_S8_UINT, 127, 17, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 127, 17, 2, 7, 0x3200 },
   { PIPE_FORMAT_S8_UINT, 127, 31, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 127, 31, 1, 7, 0x1900 },
   { PIPE_FORMAT_S8_UINT, 127, 31, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 127, 31, 2, 7, 0x3200 },
   { PIPE_FORMAT_S8_UINT, 127, 32, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 127, 32, 1, 7, 0x1900 },
   { PIPE_FORMAT_S8_UINT, 127, 32, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 127, 32, 2, 7, 0x3200 },
   { PIPE_FORMAT_S8_UINT, 127, 33, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 127, 33, 1, 7, 0x2e80 },
   { PIPE_FORMAT_S8_UINT, 127, 33, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 127, 33, 2, 7, 0x5d00 },
   { PIPE_FORMAT_S8_UINT, 127, 63, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 127, 63, 1, 7, 0x2e80 },
   { PIPE_FORMAT_S8_UINT, 127, 63, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 127, 63, 2, 7, 0x5d00 },
   { PIPE_FORMAT_S8_UINT, 127, 64, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 127, 64, 1, 7, 0x2e80 },
   { PIPE_FORMAT_S8_UINT, 127, 64, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 127, 64, 2, 7, 0x5d00 },
   { PIPE_FORMAT_S8_UINT, 127, 65, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 127, 65, 1, 7, 0x8380 },
   { PIPE_FORMAT_S8_UINT, 127, 65, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 127, 65, 2, 7, 0x10700 },
   { PIPE_FORMAT_S8_UINT, 127, 127, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 127, 127, 1, 7, 0x8380 },
   { PIPE_FORMAT_S8_UINT, 127, 127, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 127, 127, 2, 7, 0x10700 },
   { PIPE_FORMAT_S8_UINT, 127, 128, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 127, 128, 1, 8, 0x8380 },
   { PIPE_FORMAT_S8_UINT, 127, 128, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 127, 128, 2, 8, 0x10700 },
   { PIPE_FORMAT_S8_UINT, 127, 129, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 127, 129, 1, 8, 0xc600 },
   { PIPE_FORMAT_S8_UINT, 127, 129, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 127, 129, 2, 8, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 127, 255, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 127, 255, 1, 8, 0xc680 },
   { PIPE_FORMAT_S8_UINT, 127, 255, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 127, 255, 2, 8, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 127, 256, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 127, 256, 1, 9, 0xc680 },
   { PIPE_FORMAT_S8_UINT, 127, 256, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 127, 256, 2, 9, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 127, 257, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 127, 257, 1, 9, 0x18b80 },
   { PIPE_FORMAT_S8_UINT, 127, 257, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 127, 257, 2, 9, 0x31700 },
   { PIPE_FORMAT_S8_UINT, 127, 511, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 127, 511, 1, 9, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 127, 511, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 127, 511, 2, 9, 0x31800 },
   { PIPE_FORMAT_S8_UINT, 127, 512, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 127, 512, 1, 10, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 127, 512, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 127, 512, 2, 10, 0x31800 },
   { PIPE_FORMAT_S8_UINT, 127, 513, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 127, 513, 1, 10, 0x2d680 },
   { PIPE_FORMAT_S8_UINT, 127, 513, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 127, 513, 2, 10, 0x5ad00 },
   { PIPE_FORMAT_S8_UINT, 127, 1023, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 127, 1023, 1, 10, 0x2d700 },
   { PIPE_FORMAT_S8_UINT, 127, 1023, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 127, 1023, 2, 10, 0x5ae00 },
   { PIPE_FORMAT_S8_UINT, 127, 1024, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 127, 1024, 1, 11, 0x2d700 },
   { PIPE_FORMAT_S8_UINT, 127, 1024, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 127, 1024, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_S8_UINT, 127, 1025, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 127, 1025, 1, 11, 0x5ac00 },
   { PIPE_FORMAT_S8_UINT, 127, 1025, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 127, 1025, 2, 11, 0xb5800 },
   { PIPE_FORMAT_S8_UINT, 127, 2047, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 127, 2047, 1, 11, 0x5ac80 },
   { PIPE_FORMAT_S8_UINT, 127, 2047, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 127, 2047, 2, 11, 0xb5900 },
   { PIPE_FORMAT_S8_UINT, 127, 2048, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 127, 2048, 1, 12, 0x5ac80 },
   { PIPE_FORMAT_S8_UINT, 127, 2048, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 127, 2048, 2, 12, 0xb5900 },
   { PIPE_FORMAT_S8_UINT, 127, 2049, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 127, 2049, 1, 12, 0xb1700 },
   { PIPE_FORMAT_S8_UINT, 127, 2049, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 127, 2049, 2, 12, 0x162e00 },
   { PIPE_FORMAT_S8_UINT, 127, 4095, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 127, 4095, 1, 12, 0xb1780 },
   { PIPE_FORMAT_S8_UINT, 127, 4095, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 127, 4095, 2, 12, 0x162f00 },
   { PIPE_FORMAT_S8_UINT, 127, 4096, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 127, 4096, 1, 13, 0xb1780 },
   { PIPE_FORMAT_S8_UINT, 127, 4096, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 127, 4096, 2, 13, 0x162f00 },
   { PIPE_FORMAT_S8_UINT, 127, 4097, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 127, 4097, 1, 13, 0x162d00 },
   { PIPE_FORMAT_S8_UINT, 127, 4097, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 127, 4097, 2, 13, 0x2c5a00 },
   { PIPE_FORMAT_S8_UINT, 128, 16, 1, 1, 0x880 },
   { PIPE_FORMAT_S8_UINT, 128, 16, 1, 8, 0xf00 },
   { PIPE_FORMAT_S8_UINT, 128, 16, 2, 1, 0x1100 },
   { PIPE_FORMAT_S8_UINT, 128, 16, 2, 8, 0x1e00 },
   { PIPE_FORMAT_S8_UINT, 128, 17, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 128, 17, 1, 8, 0x1980 },
   { PIPE_FORMAT_S8_UINT, 128, 17, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 128, 17, 2, 8, 0x3300 },
   { PIPE_FORMAT_S8_UINT, 128, 31, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 128, 31, 1, 8, 0x1980 },
   { PIPE_FORMAT_S8_UINT, 128, 31, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 128, 31, 2, 8, 0x3300 },
   { PIPE_FORMAT_S8_UINT, 128, 32, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 128, 32, 1, 8, 0x1980 },
   { PIPE_FORMAT_S8_UINT, 128, 32, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 128, 32, 2, 8, 0x3300 },
   { PIPE_FORMAT_S8_UINT, 128, 33, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 128, 33, 1, 8, 0x2f00 },
   { PIPE_FORMAT_S8_UINT, 128, 33, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 128, 33, 2, 8, 0x5e00 },
   { PIPE_FORMAT_S8_UINT, 128, 63, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 128, 63, 1, 8, 0x2f00 },
   { PIPE_FORMAT_S8_UINT, 128, 63, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 128, 63, 2, 8, 0x5e00 },
   { PIPE_FORMAT_S8_UINT, 128, 64, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 128, 64, 1, 8, 0x2f00 },
   { PIPE_FORMAT_S8_UINT, 128, 64, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 128, 64, 2, 8, 0x5e00 },
   { PIPE_FORMAT_S8_UINT, 128, 65, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 128, 65, 1, 8, 0x8380 },
   { PIPE_FORMAT_S8_UINT, 128, 65, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 128, 65, 2, 8, 0x10700 },
   { PIPE_FORMAT_S8_UINT, 128, 127, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 128, 127, 1, 8, 0x8380 },
   { PIPE_FORMAT_S8_UINT, 128, 127, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 128, 127, 2, 8, 0x10700 },
   { PIPE_FORMAT_S8_UINT, 128, 128, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 128, 128, 1, 8, 0x8380 },
   { PIPE_FORMAT_S8_UINT, 128, 128, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 128, 128, 2, 8, 0x10700 },
   { PIPE_FORMAT_S8_UINT, 128, 129, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 128, 129, 1, 8, 0xc600 },
   { PIPE_FORMAT_S8_UINT, 128, 129, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 128, 129, 2, 8, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 128, 255, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 128, 255, 1, 8, 0xc680 },
   { PIPE_FORMAT_S8_UINT, 128, 255, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 128, 255, 2, 8, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 128, 256, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 128, 256, 1, 9, 0xc680 },
   { PIPE_FORMAT_S8_UINT, 128, 256, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 128, 256, 2, 9, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 128, 257, 1, 1, 0xc800 },
   { PIPE_FORMAT_S8_UINT, 128, 257, 1, 9, 0x10b80 },
   { PIPE_FORMAT_S8_UINT, 128, 257, 2, 1, 0x19000 },
   { PIPE_FORMAT_S8_UINT, 128, 257, 2, 9, 0x21700 },
   { PIPE_FORMAT_S8_UINT, 128, 511, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 128, 511, 1, 9, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 128, 511, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 128, 511, 2, 9, 0x31800 },
   { PIPE_FORMAT_S8_UINT, 128, 512, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 128, 512, 1, 10, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 128, 512, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 128, 512, 2, 10, 0x31800 },
   { PIPE_FORMAT_S8_UINT, 128, 513, 1, 1, 0x15000 },
   { PIPE_FORMAT_S8_UINT, 128, 513, 1, 10, 0x1d680 },
   { PIPE_FORMAT_S8_UINT, 128, 513, 2, 1, 0x2a000 },
   { PIPE_FORMAT_S8_UINT, 128, 513, 2, 10, 0x3ad00 },
   { PIPE_FORMAT_S8_UINT, 128, 1023, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 128, 1023, 1, 10, 0x2d700 },
   { PIPE_FORMAT_S8_UINT, 128, 1023, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 128, 1023, 2, 10, 0x5ae00 },
   { PIPE_FORMAT_S8_UINT, 128, 1024, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 128, 1024, 1, 11, 0x2d700 },
   { PIPE_FORMAT_S8_UINT, 128, 1024, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 128, 1024, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_S8_UINT, 128, 1025, 1, 1, 0x26000 },
   { PIPE_FORMAT_S8_UINT, 128, 1025, 1, 11, 0x32c00 },
   { PIPE_FORMAT_S8_UINT, 128, 1025, 2, 1, 0x4c000 },
   { PIPE_FORMAT_S8_UINT, 128, 1025, 2, 11, 0x65800 },
   { PIPE_FORMAT_S8_UINT, 128, 2047, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 128, 2047, 1, 11, 0x5ac80 },
   { PIPE_FORMAT_S8_UINT, 128, 2047, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 128, 2047, 2, 11, 0xb5900 },
   { PIPE_FORMAT_S8_UINT, 128, 2048, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 128, 2048, 1, 12, 0x5ac80 },
   { PIPE_FORMAT_S8_UINT, 128, 2048, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 128, 2048, 2, 12, 0xb5900 },
   { PIPE_FORMAT_S8_UINT, 128, 2049, 1, 1, 0x48000 },
   { PIPE_FORMAT_S8_UINT, 128, 2049, 1, 12, 0x61700 },
   { PIPE_FORMAT_S8_UINT, 128, 2049, 2, 1, 0x90000 },
   { PIPE_FORMAT_S8_UINT, 128, 2049, 2, 12, 0xc2e00 },
   { PIPE_FORMAT_S8_UINT, 128, 4095, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 128, 4095, 1, 12, 0xb1780 },
   { PIPE_FORMAT_S8_UINT, 128, 4095, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 128, 4095, 2, 12, 0x162f00 },
   { PIPE_FORMAT_S8_UINT, 128, 4096, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 128, 4096, 1, 13, 0xb1780 },
   { PIPE_FORMAT_S8_UINT, 128, 4096, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 128, 4096, 2, 13, 0x162f00 },
   { PIPE_FORMAT_S8_UINT, 128, 4097, 1, 1, 0x8c000 },
   { PIPE_FORMAT_S8_UINT, 128, 4097, 1, 13, 0xbad00 },
   { PIPE_FORMAT_S8_UINT, 128, 4097, 2, 1, 0x118000 },
   { PIPE_FORMAT_S8_UINT, 128, 4097, 2, 13, 0x175a00 },
   { PIPE_FORMAT_S8_UINT, 129, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 129, 16, 1, 8, 0x1980 },
   { PIPE_FORMAT_S8_UINT, 129, 16, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 129, 16, 2, 8, 0x3300 },
   { PIPE_FORMAT_S8_UINT, 129, 17, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 129, 17, 1, 8, 0x2f00 },
   { PIPE_FORMAT_S8_UINT, 129, 17, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 129, 17, 2, 8, 0x5e00 },
   { PIPE_FORMAT_S8_UINT, 129, 31, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 129, 31, 1, 8, 0x2f00 },
   { PIPE_FORMAT_S8_UINT, 129, 31, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 129, 31, 2, 8, 0x5e00 },
   { PIPE_FORMAT_S8_UINT, 129, 32, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 129, 32, 1, 8, 0x2f00 },
   { PIPE_FORMAT_S8_UINT, 129, 32, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 129, 32, 2, 8, 0x5e00 },
   { PIPE_FORMAT_S8_UINT, 129, 33, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 129, 33, 1, 8, 0x8380 },
   { PIPE_FORMAT_S8_UINT, 129, 33, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 129, 33, 2, 8, 0x10700 },
   { PIPE_FORMAT_S8_UINT, 129, 63, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 129, 63, 1, 8, 0x8380 },
   { PIPE_FORMAT_S8_UINT, 129, 63, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 129, 63, 2, 8, 0x10700 },
   { PIPE_FORMAT_S8_UINT, 129, 64, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 129, 64, 1, 8, 0x8380 },
   { PIPE_FORMAT_S8_UINT, 129, 64, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 129, 64, 2, 8, 0x10700 },
   { PIPE_FORMAT_S8_UINT, 129, 65, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 129, 65, 1, 8, 0xc600 },
   { PIPE_FORMAT_S8_UINT, 129, 65, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 129, 65, 2, 8, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 129, 127, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 129, 127, 1, 8, 0xc600 },
   { PIPE_FORMAT_S8_UINT, 129, 127, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 129, 127, 2, 8, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 129, 128, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 129, 128, 1, 8, 0xc600 },
   { PIPE_FORMAT_S8_UINT, 129, 128, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 129, 128, 2, 8, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 129, 129, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 129, 129, 1, 8, 0x14b00 },
   { PIPE_FORMAT_S8_UINT, 129, 129, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 129, 129, 2, 8, 0x29600 },
   { PIPE_FORMAT_S8_UINT, 129, 255, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 129, 255, 1, 8, 0x14b80 },
   { PIPE_FORMAT_S8_UINT, 129, 255, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 129, 255, 2, 8, 0x29700 },
   { PIPE_FORMAT_S8_UINT, 129, 256, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 129, 256, 1, 9, 0x14b80 },
   { PIPE_FORMAT_S8_UINT, 129, 256, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 129, 256, 2, 9, 0x29700 },
   { PIPE_FORMAT_S8_UINT, 129, 257, 1, 1, 0x19000 },
   { PIPE_FORMAT_S8_UINT, 129, 257, 1, 9, 0x1d600 },
   { PIPE_FORMAT_S8_UINT, 129, 257, 2, 1, 0x32000 },
   { PIPE_FORMAT_S8_UINT, 129, 257, 2, 9, 0x3ac00 },
   { PIPE_FORMAT_S8_UINT, 129, 511, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 129, 511, 1, 9, 0x29680 },
   { PIPE_FORMAT_S8_UINT, 129, 511, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 129, 511, 2, 9, 0x52d00 },
   { PIPE_FORMAT_S8_UINT, 129, 512, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 129, 512, 1, 10, 0x29680 },
   { PIPE_FORMAT_S8_UINT, 129, 512, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 129, 512, 2, 10, 0x52d00 },
   { PIPE_FORMAT_S8_UINT, 129, 513, 1, 1, 0x2a000 },
   { PIPE_FORMAT_S8_UINT, 129, 513, 1, 10, 0x32b80 },
   { PIPE_FORMAT_S8_UINT, 129, 513, 2, 1, 0x54000 },
   { PIPE_FORMAT_S8_UINT, 129, 513, 2, 10, 0x65700 },
   { PIPE_FORMAT_S8_UINT, 129, 1023, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 129, 1023, 1, 10, 0x4ec00 },
   { PIPE_FORMAT_S8_UINT, 129, 1023, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 129, 1023, 2, 10, 0x9d800 },
   { PIPE_FORMAT_S8_UINT, 129, 1024, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 129, 1024, 1, 11, 0x4ec00 },
   { PIPE_FORMAT_S8_UINT, 129, 1024, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 129, 1024, 2, 11, 0x9d800 },
   { PIPE_FORMAT_S8_UINT, 129, 1025, 1, 1, 0x4c000 },
   { PIPE_FORMAT_S8_UINT, 129, 1025, 1, 11, 0x59680 },
   { PIPE_FORMAT_S8_UINT, 129, 1025, 2, 1, 0x98000 },
   { PIPE_FORMAT_S8_UINT, 129, 1025, 2, 11, 0xb2d00 },
   { PIPE_FORMAT_S8_UINT, 129, 2047, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 129, 2047, 1, 11, 0x9d700 },
   { PIPE_FORMAT_S8_UINT, 129, 2047, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 129, 2047, 2, 11, 0x13ae00 },
   { PIPE_FORMAT_S8_UINT, 129, 2048, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 129, 2048, 1, 12, 0x9d700 },
   { PIPE_FORMAT_S8_UINT, 129, 2048, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 129, 2048, 2, 12, 0x13ae00 },
   { PIPE_FORMAT_S8_UINT, 129, 2049, 1, 1, 0x90000 },
   { PIPE_FORMAT_S8_UINT, 129, 2049, 1, 12, 0xaac00 },
   { PIPE_FORMAT_S8_UINT, 129, 2049, 2, 1, 0x120000 },
   { PIPE_FORMAT_S8_UINT, 129, 2049, 2, 12, 0x155800 },
   { PIPE_FORMAT_S8_UINT, 129, 4095, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 129, 4095, 1, 12, 0x136c80 },
   { PIPE_FORMAT_S8_UINT, 129, 4095, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 129, 4095, 2, 12, 0x26d900 },
   { PIPE_FORMAT_S8_UINT, 129, 4096, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 129, 4096, 1, 13, 0x136c80 },
   { PIPE_FORMAT_S8_UINT, 129, 4096, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 129, 4096, 2, 13, 0x26d900 },
   { PIPE_FORMAT_S8_UINT, 129, 4097, 1, 1, 0x118000 },
   { PIPE_FORMAT_S8_UINT, 129, 4097, 1, 13, 0x149700 },
   { PIPE_FORMAT_S8_UINT, 129, 4097, 2, 1, 0x230000 },
   { PIPE_FORMAT_S8_UINT, 129, 4097, 2, 13, 0x292e00 },
   { PIPE_FORMAT_S8_UINT, 255, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 255, 16, 1, 8, 0x1a00 },
   { PIPE_FORMAT_S8_UINT, 255, 16, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 255, 16, 2, 8, 0x3400 },
   { PIPE_FORMAT_S8_UINT, 255, 17, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 255, 17, 1, 8, 0x2f80 },
   { PIPE_FORMAT_S8_UINT, 255, 17, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 255, 17, 2, 8, 0x5f00 },
   { PIPE_FORMAT_S8_UINT, 255, 31, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 255, 31, 1, 8, 0x2f80 },
   { PIPE_FORMAT_S8_UINT, 255, 31, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 255, 31, 2, 8, 0x5f00 },
   { PIPE_FORMAT_S8_UINT, 255, 32, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 255, 32, 1, 8, 0x2f80 },
   { PIPE_FORMAT_S8_UINT, 255, 32, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 255, 32, 2, 8, 0x5f00 },
   { PIPE_FORMAT_S8_UINT, 255, 33, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 255, 33, 1, 8, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 255, 33, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 255, 33, 2, 8, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 255, 63, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 255, 63, 1, 8, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 255, 63, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 255, 63, 2, 8, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 255, 64, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 255, 64, 1, 8, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 255, 64, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 255, 64, 2, 8, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 255, 65, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 255, 65, 1, 8, 0xc680 },
   { PIPE_FORMAT_S8_UINT, 255, 65, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 255, 65, 2, 8, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 255, 127, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 255, 127, 1, 8, 0xc680 },
   { PIPE_FORMAT_S8_UINT, 255, 127, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 255, 127, 2, 8, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 255, 128, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 255, 128, 1, 8, 0xc680 },
   { PIPE_FORMAT_S8_UINT, 255, 128, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 255, 128, 2, 8, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 255, 129, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 255, 129, 1, 8, 0x14b80 },
   { PIPE_FORMAT_S8_UINT, 255, 129, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 255, 129, 2, 8, 0x29700 },
   { PIPE_FORMAT_S8_UINT, 255, 255, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 255, 255, 1, 8, 0x18b80 },
   { PIPE_FORMAT_S8_UINT, 255, 255, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 255, 255, 2, 8, 0x31700 },
   { PIPE_FORMAT_S8_UINT, 255, 256, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 255, 256, 1, 9, 0x18b80 },
   { PIPE_FORMAT_S8_UINT, 255, 256, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 255, 256, 2, 9, 0x31700 },
   { PIPE_FORMAT_S8_UINT, 255, 257, 1, 1, 0x19000 },
   { PIPE_FORMAT_S8_UINT, 255, 257, 1, 9, 0x21600 },
   { PIPE_FORMAT_S8_UINT, 255, 257, 2, 1, 0x32000 },
   { PIPE_FORMAT_S8_UINT, 255, 257, 2, 9, 0x42c00 },
   { PIPE_FORMAT_S8_UINT, 255, 511, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 255, 511, 1, 9, 0x2d680 },
   { PIPE_FORMAT_S8_UINT, 255, 511, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 255, 511, 2, 9, 0x5ad00 },
   { PIPE_FORMAT_S8_UINT, 255, 512, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 255, 512, 1, 10, 0x2d680 },
   { PIPE_FORMAT_S8_UINT, 255, 512, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 255, 512, 2, 10, 0x5ad00 },
   { PIPE_FORMAT_S8_UINT, 255, 513, 1, 1, 0x2a000 },
   { PIPE_FORMAT_S8_UINT, 255, 513, 1, 10, 0x36b80 },
   { PIPE_FORMAT_S8_UINT, 255, 513, 2, 1, 0x54000 },
   { PIPE_FORMAT_S8_UINT, 255, 513, 2, 10, 0x6d700 },
   { PIPE_FORMAT_S8_UINT, 255, 1023, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 255, 1023, 1, 10, 0x5ac00 },
   { PIPE_FORMAT_S8_UINT, 255, 1023, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 255, 1023, 2, 10, 0xb5800 },
   { PIPE_FORMAT_S8_UINT, 255, 1024, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 255, 1024, 1, 11, 0x5ac00 },
   { PIPE_FORMAT_S8_UINT, 255, 1024, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 255, 1024, 2, 11, 0xb5800 },
   { PIPE_FORMAT_S8_UINT, 255, 1025, 1, 1, 0x4c000 },
   { PIPE_FORMAT_S8_UINT, 255, 1025, 1, 11, 0x65680 },
   { PIPE_FORMAT_S8_UINT, 255, 1025, 2, 1, 0x98000 },
   { PIPE_FORMAT_S8_UINT, 255, 1025, 2, 11, 0xcad00 },
   { PIPE_FORMAT_S8_UINT, 255, 2047, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 255, 2047, 1, 11, 0xb1700 },
   { PIPE_FORMAT_S8_UINT, 255, 2047, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 255, 2047, 2, 11, 0x162e00 },
   { PIPE_FORMAT_S8_UINT, 255, 2048, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 255, 2048, 1, 12, 0xb1700 },
   { PIPE_FORMAT_S8_UINT, 255, 2048, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 255, 2048, 2, 12, 0x162e00 },
   { PIPE_FORMAT_S8_UINT, 255, 2049, 1, 1, 0x90000 },
   { PIPE_FORMAT_S8_UINT, 255, 2049, 1, 12, 0xbec00 },
   { PIPE_FORMAT_S8_UINT, 255, 2049, 2, 1, 0x120000 },
   { PIPE_FORMAT_S8_UINT, 255, 2049, 2, 12, 0x17d800 },
   { PIPE_FORMAT_S8_UINT, 255, 4095, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 255, 4095, 1, 12, 0x162c80 },
   { PIPE_FORMAT_S8_UINT, 255, 4095, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 255, 4095, 2, 12, 0x2c5900 },
   { PIPE_FORMAT_S8_UINT, 255, 4096, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 255, 4096, 1, 13, 0x162c80 },
   { PIPE_FORMAT_S8_UINT, 255, 4096, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 255, 4096, 2, 13, 0x2c5900 },
   { PIPE_FORMAT_S8_UINT, 255, 4097, 1, 1, 0x118000 },
   { PIPE_FORMAT_S8_UINT, 255, 4097, 1, 13, 0x175700 },
   { PIPE_FORMAT_S8_UINT, 255, 4097, 2, 1, 0x230000 },
   { PIPE_FORMAT_S8_UINT, 255, 4097, 2, 13, 0x2eae00 },
   { PIPE_FORMAT_S8_UINT, 256, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_S8_UINT, 256, 16, 1, 9, 0x1a80 },
   { PIPE_FORMAT_S8_UINT, 256, 16, 2, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 256, 16, 2, 9, 0x3500 },
   { PIPE_FORMAT_S8_UINT, 256, 17, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 256, 17, 1, 9, 0x3000 },
   { PIPE_FORMAT_S8_UINT, 256, 17, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 256, 17, 2, 9, 0x6000 },
   { PIPE_FORMAT_S8_UINT, 256, 31, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 256, 31, 1, 9, 0x3000 },
   { PIPE_FORMAT_S8_UINT, 256, 31, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 256, 31, 2, 9, 0x6000 },
   { PIPE_FORMAT_S8_UINT, 256, 32, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 256, 32, 1, 9, 0x3000 },
   { PIPE_FORMAT_S8_UINT, 256, 32, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 256, 32, 2, 9, 0x6000 },
   { PIPE_FORMAT_S8_UINT, 256, 33, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 256, 33, 1, 9, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 256, 33, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 256, 33, 2, 9, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 256, 63, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 256, 63, 1, 9, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 256, 63, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 256, 63, 2, 9, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 256, 64, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 256, 64, 1, 9, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 256, 64, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 256, 64, 2, 9, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 256, 65, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 256, 65, 1, 9, 0xc680 },
   { PIPE_FORMAT_S8_UINT, 256, 65, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 256, 65, 2, 9, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 256, 127, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 256, 127, 1, 9, 0xc680 },
   { PIPE_FORMAT_S8_UINT, 256, 127, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 256, 127, 2, 9, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 256, 128, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 256, 128, 1, 9, 0xc680 },
   { PIPE_FORMAT_S8_UINT, 256, 128, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 256, 128, 2, 9, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 256, 129, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 256, 129, 1, 9, 0x14b80 },
   { PIPE_FORMAT_S8_UINT, 256, 129, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 256, 129, 2, 9, 0x29700 },
   { PIPE_FORMAT_S8_UINT, 256, 255, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 256, 255, 1, 9, 0x18b80 },
   { PIPE_FORMAT_S8_UINT, 256, 255, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 256, 255, 2, 9, 0x31700 },
   { PIPE_FORMAT_S8_UINT, 256, 256, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 256, 256, 1, 9, 0x18b80 },
   { PIPE_FORMAT_S8_UINT, 256, 256, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 256, 256, 2, 9, 0x31700 },
   { PIPE_FORMAT_S8_UINT, 256, 257, 1, 1, 0x19000 },
   { PIPE_FORMAT_S8_UINT, 256, 257, 1, 9, 0x25600 },
   { PIPE_FORMAT_S8_UINT, 256, 257, 2, 1, 0x32000 },
   { PIPE_FORMAT_S8_UINT, 256, 257, 2, 9, 0x4ac00 },
   { PIPE_FORMAT_S8_UINT, 256, 511, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 256, 511, 1, 9, 0x2d680 },
   { PIPE_FORMAT_S8_UINT, 256, 511, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 256, 511, 2, 9, 0x5ad00 },
   { PIPE_FORMAT_S8_UINT, 256, 512, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 256, 512, 1, 10, 0x2d680 },
   { PIPE_FORMAT_S8_UINT, 256, 512, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 256, 512, 2, 10, 0x5ad00 },
   { PIPE_FORMAT_S8_UINT, 256, 513, 1, 1, 0x2a000 },
   { PIPE_FORMAT_S8_UINT, 256, 513, 1, 10, 0x3ab80 },
   { PIPE_FORMAT_S8_UINT, 256, 513, 2, 1, 0x54000 },
   { PIPE_FORMAT_S8_UINT, 256, 513, 2, 10, 0x75700 },
   { PIPE_FORMAT_S8_UINT, 256, 1023, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 256, 1023, 1, 10, 0x5ac00 },
   { PIPE_FORMAT_S8_UINT, 256, 1023, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 256, 1023, 2, 10, 0xb5800 },
   { PIPE_FORMAT_S8_UINT, 256, 1024, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 256, 1024, 1, 11, 0x5ac00 },
   { PIPE_FORMAT_S8_UINT, 256, 1024, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 256, 1024, 2, 11, 0xb5800 },
   { PIPE_FORMAT_S8_UINT, 256, 1025, 1, 1, 0x4c000 },
   { PIPE_FORMAT_S8_UINT, 256, 1025, 1, 11, 0x69680 },
   { PIPE_FORMAT_S8_UINT, 256, 1025, 2, 1, 0x98000 },
   { PIPE_FORMAT_S8_UINT, 256, 1025, 2, 11, 0xd2d00 },
   { PIPE_FORMAT_S8_UINT, 256, 2047, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 256, 2047, 1, 11, 0xb1700 },
   { PIPE_FORMAT_S8_UINT, 256, 2047, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 256, 2047, 2, 11, 0x162e00 },
   { PIPE_FORMAT_S8_UINT, 256, 2048, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 256, 2048, 1, 12, 0xb1700 },
   { PIPE_FORMAT_S8_UINT, 256, 2048, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 256, 2048, 2, 12, 0x162e00 },
   { PIPE_FORMAT_S8_UINT, 256, 2049, 1, 1, 0x90000 },
   { PIPE_FORMAT_S8_UINT, 256, 2049, 1, 12, 0xc2c00 },
   { PIPE_FORMAT_S8_UINT, 256, 2049, 2, 1, 0x120000 },
   { PIPE_FORMAT_S8_UINT, 256, 2049, 2, 12, 0x185800 },
   { PIPE_FORMAT_S8_UINT, 256, 4095, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 256, 4095, 1, 12, 0x162c80 },
   { PIPE_FORMAT_S8_UINT, 256, 4095, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 256, 4095, 2, 12, 0x2c5900 },
   { PIPE_FORMAT_S8_UINT, 256, 4096, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 256, 4096, 1, 13, 0x162c80 },
   { PIPE_FORMAT_S8_UINT, 256, 4096, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 256, 4096, 2, 13, 0x2c5900 },
   { PIPE_FORMAT_S8_UINT, 256, 4097, 1, 1, 0x118000 },
   { PIPE_FORMAT_S8_UINT, 256, 4097, 1, 13, 0x179700 },
   { PIPE_FORMAT_S8_UINT, 256, 4097, 2, 1, 0x230000 },
   { PIPE_FORMAT_S8_UINT, 256, 4097, 2, 13, 0x2f2e00 },
   { PIPE_FORMAT_S8_UINT, 257, 16, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 257, 16, 1, 9, 0x3000 },
   { PIPE_FORMAT_S8_UINT, 257, 16, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 257, 16, 2, 9, 0x6000 },
   { PIPE_FORMAT_S8_UINT, 257, 17, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 257, 17, 1, 9, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 257, 17, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 257, 17, 2, 9, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 257, 31, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 257, 31, 1, 9, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 257, 31, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 257, 31, 2, 9, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 257, 32, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 257, 32, 1, 9, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 257, 32, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 257, 32, 2, 9, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 257, 33, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 257, 33, 1, 9, 0xc680 },
   { PIPE_FORMAT_S8_UINT, 257, 33, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 257, 33, 2, 9, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 257, 63, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 257, 63, 1, 9, 0xc680 },
   { PIPE_FORMAT_S8_UINT, 257, 63, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 257, 63, 2, 9, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 257, 64, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 257, 64, 1, 9, 0xc680 },
   { PIPE_FORMAT_S8_UINT, 257, 64, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 257, 64, 2, 9, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 257, 65, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 257, 65, 1, 9, 0x18b80 },
   { PIPE_FORMAT_S8_UINT, 257, 65, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 257, 65, 2, 9, 0x31700 },
   { PIPE_FORMAT_S8_UINT, 257, 127, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 257, 127, 1, 9, 0x18b80 },
   { PIPE_FORMAT_S8_UINT, 257, 127, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 257, 127, 2, 9, 0x31700 },
   { PIPE_FORMAT_S8_UINT, 257, 128, 1, 1, 0xc800 },
   { PIPE_FORMAT_S8_UINT, 257, 128, 1, 9, 0x10b80 },
   { PIPE_FORMAT_S8_UINT, 257, 128, 2, 1, 0x19000 },
   { PIPE_FORMAT_S8_UINT, 257, 128, 2, 9, 0x21700 },
   { PIPE_FORMAT_S8_UINT, 257, 129, 1, 1, 0x19000 },
   { PIPE_FORMAT_S8_UINT, 257, 129, 1, 9, 0x1d600 },
   { PIPE_FORMAT_S8_UINT, 257, 129, 2, 1, 0x32000 },
   { PIPE_FORMAT_S8_UINT, 257, 129, 2, 9, 0x3ac00 },
   { PIPE_FORMAT_S8_UINT, 257, 255, 1, 1, 0x19000 },
   { PIPE_FORMAT_S8_UINT, 257, 255, 1, 9, 0x21600 },
   { PIPE_FORMAT_S8_UINT, 257, 255, 2, 1, 0x32000 },
   { PIPE_FORMAT_S8_UINT, 257, 255, 2, 9, 0x42c00 },
   { PIPE_FORMAT_S8_UINT, 257, 256, 1, 1, 0x19000 },
   { PIPE_FORMAT_S8_UINT, 257, 256, 1, 9, 0x25600 },
   { PIPE_FORMAT_S8_UINT, 257, 256, 2, 1, 0x32000 },
   { PIPE_FORMAT_S8_UINT, 257, 256, 2, 9, 0x4ac00 },
   { PIPE_FORMAT_S8_UINT, 257, 257, 1, 1, 0x26000 },
   { PIPE_FORMAT_S8_UINT, 257, 257, 1, 9, 0x3eb00 },
   { PIPE_FORMAT_S8_UINT, 257, 257, 2, 1, 0x4c000 },
   { PIPE_FORMAT_S8_UINT, 257, 257, 2, 9, 0x7d600 },
   { PIPE_FORMAT_S8_UINT, 257, 511, 1, 1, 0x32000 },
   { PIPE_FORMAT_S8_UINT, 257, 511, 1, 9, 0x4ab80 },
   { PIPE_FORMAT_S8_UINT, 257, 511, 2, 1, 0x64000 },
   { PIPE_FORMAT_S8_UINT, 257, 511, 2, 9, 0x95700 },
   { PIPE_FORMAT_S8_UINT, 257, 512, 1, 1, 0x32000 },
   { PIPE_FORMAT_S8_UINT, 257, 512, 1, 10, 0x4ab80 },
   { PIPE_FORMAT_S8_UINT, 257, 512, 2, 1, 0x64000 },
   { PIPE_FORMAT_S8_UINT, 257, 512, 2, 10, 0x95700 },
   { PIPE_FORMAT_S8_UINT, 257, 513, 1, 1, 0x40000 },
   { PIPE_FORMAT_S8_UINT, 257, 513, 1, 10, 0x61600 },
   { PIPE_FORMAT_S8_UINT, 257, 513, 2, 1, 0x80000 },
   { PIPE_FORMAT_S8_UINT, 257, 513, 2, 10, 0xc2c00 },
   { PIPE_FORMAT_S8_UINT, 257, 1023, 1, 1, 0x64000 },
   { PIPE_FORMAT_S8_UINT, 257, 1023, 1, 10, 0x95680 },
   { PIPE_FORMAT_S8_UINT, 257, 1023, 2, 1, 0xc8000 },
   { PIPE_FORMAT_S8_UINT, 257, 1023, 2, 10, 0x12ad00 },
   { PIPE_FORMAT_S8_UINT, 257, 1024, 1, 1, 0x64000 },
   { PIPE_FORMAT_S8_UINT, 257, 1024, 1, 11, 0x95680 },
   { PIPE_FORMAT_S8_UINT, 257, 1024, 2, 1, 0xc8000 },
   { PIPE_FORMAT_S8_UINT, 257, 1024, 2, 11, 0x12ad00 },
   { PIPE_FORMAT_S8_UINT, 257, 1025, 1, 1, 0x74000 },
   { PIPE_FORMAT_S8_UINT, 257, 1025, 1, 11, 0xaeb80 },
   { PIPE_FORMAT_S8_UINT, 257, 1025, 2, 1, 0xe8000 },
   { PIPE_FORMAT_S8_UINT, 257, 1025, 2, 11, 0x15d700 },
   { PIPE_FORMAT_S8_UINT, 257, 2047, 1, 1, 0xc8000 },
   { PIPE_FORMAT_S8_UINT, 257, 2047, 1, 11, 0x126c00 },
   { PIPE_FORMAT_S8_UINT, 257, 2047, 2, 1, 0x190000 },
   { PIPE_FORMAT_S8_UINT, 257, 2047, 2, 11, 0x24d800 },
   { PIPE_FORMAT_S8_UINT, 257, 2048, 1, 1, 0xc8000 },
   { PIPE_FORMAT_S8_UINT, 257, 2048, 1, 12, 0x126c00 },
   { PIPE_FORMAT_S8_UINT, 257, 2048, 2, 1, 0x190000 },
   { PIPE_FORMAT_S8_UINT, 257, 2048, 2, 12, 0x24d800 },
   { PIPE_FORMAT_S8_UINT, 257, 2049, 1, 1, 0xdc000 },
   { PIPE_FORMAT_S8_UINT, 257, 2049, 1, 12, 0x145680 },
   { PIPE_FORMAT_S8_UINT, 257, 2049, 2, 1, 0x1b8000 },
   { PIPE_FORMAT_S8_UINT, 257, 2049, 2, 12, 0x28ad00 },
   { PIPE_FORMAT_S8_UINT, 257, 4095, 1, 1, 0x190000 },
   { PIPE_FORMAT_S8_UINT, 257, 4095, 1, 12, 0x24d700 },
   { PIPE_FORMAT_S8_UINT, 257, 4095, 2, 1, 0x320000 },
   { PIPE_FORMAT_S8_UINT, 257, 4095, 2, 12, 0x49ae00 },
   { PIPE_FORMAT_S8_UINT, 257, 4096, 1, 1, 0x190000 },
   { PIPE_FORMAT_S8_UINT, 257, 4096, 1, 13, 0x24d700 },
   { PIPE_FORMAT_S8_UINT, 257, 4096, 2, 1, 0x320000 },
   { PIPE_FORMAT_S8_UINT, 257, 4096, 2, 13, 0x49ae00 },
   { PIPE_FORMAT_S8_UINT, 257, 4097, 1, 1, 0x1ac000 },
   { PIPE_FORMAT_S8_UINT, 257, 4097, 1, 13, 0x276c00 },
   { PIPE_FORMAT_S8_UINT, 257, 4097, 2, 1, 0x358000 },
   { PIPE_FORMAT_S8_UINT, 257, 4097, 2, 13, 0x4ed800 },
   { PIPE_FORMAT_S8_UINT, 511, 16, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 511, 16, 1, 9, 0x3080 },
   { PIPE_FORMAT_S8_UINT, 511, 16, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 511, 16, 2, 9, 0x6100 },
   { PIPE_FORMAT_S8_UINT, 511, 17, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 511, 17, 1, 9, 0x8480 },
   { PIPE_FORMAT_S8_UINT, 511, 17, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 511, 17, 2, 9, 0x10900 },
   { PIPE_FORMAT_S8_UINT, 511, 31, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 511, 31, 1, 9, 0x8480 },
   { PIPE_FORMAT_S8_UINT, 511, 31, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 511, 31, 2, 9, 0x10900 },
   { PIPE_FORMAT_S8_UINT, 511, 32, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 511, 32, 1, 9, 0x8480 },
   { PIPE_FORMAT_S8_UINT, 511, 32, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 511, 32, 2, 9, 0x10900 },
   { PIPE_FORMAT_S8_UINT, 511, 33, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 511, 33, 1, 9, 0xc700 },
   { PIPE_FORMAT_S8_UINT, 511, 33, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 511, 33, 2, 9, 0x18e00 },
   { PIPE_FORMAT_S8_UINT, 511, 63, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 511, 63, 1, 9, 0xc700 },
   { PIPE_FORMAT_S8_UINT, 511, 63, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 511, 63, 2, 9, 0x18e00 },
   { PIPE_FORMAT_S8_UINT, 511, 64, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 511, 64, 1, 9, 0xc700 },
   { PIPE_FORMAT_S8_UINT, 511, 64, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 511, 64, 2, 9, 0x18e00 },
   { PIPE_FORMAT_S8_UINT, 511, 65, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 511, 65, 1, 9, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 511, 65, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 511, 65, 2, 9, 0x31800 },
   { PIPE_FORMAT_S8_UINT, 511, 127, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 511, 127, 1, 9, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 511, 127, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 511, 127, 2, 9, 0x31800 },
   { PIPE_FORMAT_S8_UINT, 511, 128, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 511, 128, 1, 9, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 511, 128, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 511, 128, 2, 9, 0x31800 },
   { PIPE_FORMAT_S8_UINT, 511, 129, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 511, 129, 1, 9, 0x29680 },
   { PIPE_FORMAT_S8_UINT, 511, 129, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 511, 129, 2, 9, 0x52d00 },
   { PIPE_FORMAT_S8_UINT, 511, 255, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 511, 255, 1, 9, 0x2d680 },
   { PIPE_FORMAT_S8_UINT, 511, 255, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 511, 255, 2, 9, 0x5ad00 },
   { PIPE_FORMAT_S8_UINT, 511, 256, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 511, 256, 1, 9, 0x2d680 },
   { PIPE_FORMAT_S8_UINT, 511, 256, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 511, 256, 2, 9, 0x5ad00 },
   { PIPE_FORMAT_S8_UINT, 511, 257, 1, 1, 0x32000 },
   { PIPE_FORMAT_S8_UINT, 511, 257, 1, 9, 0x4ab80 },
   { PIPE_FORMAT_S8_UINT, 511, 257, 2, 1, 0x64000 },
   { PIPE_FORMAT_S8_UINT, 511, 257, 2, 9, 0x95700 },
   { PIPE_FORMAT_S8_UINT, 511, 511, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 511, 511, 1, 9, 0x5ab80 },
   { PIPE_FORMAT_S8_UINT, 511, 511, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 511, 511, 2, 9, 0xb5700 },
   { PIPE_FORMAT_S8_UINT, 511, 512, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 511, 512, 1, 10, 0x5ab80 },
   { PIPE_FORMAT_S8_UINT, 511, 512, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 511, 512, 2, 10, 0xb5700 },
   { PIPE_FORMAT_S8_UINT, 511, 513, 1, 1, 0x54000 },
   { PIPE_FORMAT_S8_UINT, 511, 513, 1, 10, 0x79600 },
   { PIPE_FORMAT_S8_UINT, 511, 513, 2, 1, 0xa8000 },
   { PIPE_FORMAT_S8_UINT, 511, 513, 2, 10, 0xf2c00 },
   { PIPE_FORMAT_S8_UINT, 511, 1023, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 511, 1023, 1, 10, 0xb1680 },
   { PIPE_FORMAT_S8_UINT, 511, 1023, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 511, 1023, 2, 10, 0x162d00 },
   { PIPE_FORMAT_S8_UINT, 511, 1024, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 511, 1024, 1, 11, 0xb1680 },
   { PIPE_FORMAT_S8_UINT, 511, 1024, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 511, 1024, 2, 11, 0x162d00 },
   { PIPE_FORMAT_S8_UINT, 511, 1025, 1, 1, 0x98000 },
   { PIPE_FORMAT_S8_UINT, 511, 1025, 1, 11, 0xd2b80 },
   { PIPE_FORMAT_S8_UINT, 511, 1025, 2, 1, 0x130000 },
   { PIPE_FORMAT_S8_UINT, 511, 1025, 2, 11, 0x1a5700 },
   { PIPE_FORMAT_S8_UINT, 511, 2047, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 511, 2047, 1, 11, 0x162c00 },
   { PIPE_FORMAT_S8_UINT, 511, 2047, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 511, 2047, 2, 11, 0x2c5800 },
   { PIPE_FORMAT_S8_UINT, 511, 2048, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 511, 2048, 1, 12, 0x162c00 },
   { PIPE_FORMAT_S8_UINT, 511, 2048, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 511, 2048, 2, 12, 0x2c5800 },
   { PIPE_FORMAT_S8_UINT, 511, 2049, 1, 1, 0x120000 },
   { PIPE_FORMAT_S8_UINT, 511, 2049, 1, 12, 0x189680 },
   { PIPE_FORMAT_S8_UINT, 511, 2049, 2, 1, 0x240000 },
   { PIPE_FORMAT_S8_UINT, 511, 2049, 2, 12, 0x312d00 },
   { PIPE_FORMAT_S8_UINT, 511, 4095, 1, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 511, 4095, 1, 12, 0x2c1700 },
   { PIPE_FORMAT_S8_UINT, 511, 4095, 2, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 511, 4095, 2, 12, 0x582e00 },
   { PIPE_FORMAT_S8_UINT, 511, 4096, 1, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 511, 4096, 1, 13, 0x2c1700 },
   { PIPE_FORMAT_S8_UINT, 511, 4096, 2, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 511, 4096, 2, 13, 0x582e00 },
   { PIPE_FORMAT_S8_UINT, 511, 4097, 1, 1, 0x230000 },
   { PIPE_FORMAT_S8_UINT, 511, 4097, 1, 13, 0x2f2c00 },
   { PIPE_FORMAT_S8_UINT, 511, 4097, 2, 1, 0x460000 },
   { PIPE_FORMAT_S8_UINT, 511, 4097, 2, 13, 0x5e5800 },
   { PIPE_FORMAT_S8_UINT, 512, 16, 1, 1, 0x2100 },
   { PIPE_FORMAT_S8_UINT, 512, 16, 1, 10, 0x3100 },
   { PIPE_FORMAT_S8_UINT, 512, 16, 2, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 512, 16, 2, 10, 0x6200 },
   { PIPE_FORMAT_S8_UINT, 512, 17, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 512, 17, 1, 10, 0x8480 },
   { PIPE_FORMAT_S8_UINT, 512, 17, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 512, 17, 2, 10, 0x10900 },
   { PIPE_FORMAT_S8_UINT, 512, 31, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 512, 31, 1, 10, 0x8480 },
   { PIPE_FORMAT_S8_UINT, 512, 31, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 512, 31, 2, 10, 0x10900 },
   { PIPE_FORMAT_S8_UINT, 512, 32, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 512, 32, 1, 10, 0x8480 },
   { PIPE_FORMAT_S8_UINT, 512, 32, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 512, 32, 2, 10, 0x10900 },
   { PIPE_FORMAT_S8_UINT, 512, 33, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 512, 33, 1, 10, 0xc700 },
   { PIPE_FORMAT_S8_UINT, 512, 33, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 512, 33, 2, 10, 0x18e00 },
   { PIPE_FORMAT_S8_UINT, 512, 63, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 512, 63, 1, 10, 0xc700 },
   { PIPE_FORMAT_S8_UINT, 512, 63, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 512, 63, 2, 10, 0x18e00 },
   { PIPE_FORMAT_S8_UINT, 512, 64, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 512, 64, 1, 10, 0xc700 },
   { PIPE_FORMAT_S8_UINT, 512, 64, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 512, 64, 2, 10, 0x18e00 },
   { PIPE_FORMAT_S8_UINT, 512, 65, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 512, 65, 1, 10, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 512, 65, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 512, 65, 2, 10, 0x31800 },
   { PIPE_FORMAT_S8_UINT, 512, 127, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 512, 127, 1, 10, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 512, 127, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 512, 127, 2, 10, 0x31800 },
   { PIPE_FORMAT_S8_UINT, 512, 128, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 512, 128, 1, 10, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 512, 128, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 512, 128, 2, 10, 0x31800 },
   { PIPE_FORMAT_S8_UINT, 512, 129, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 512, 129, 1, 10, 0x29680 },
   { PIPE_FORMAT_S8_UINT, 512, 129, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 512, 129, 2, 10, 0x52d00 },
   { PIPE_FORMAT_S8_UINT, 512, 255, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 512, 255, 1, 10, 0x2d680 },
   { PIPE_FORMAT_S8_UINT, 512, 255, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 512, 255, 2, 10, 0x5ad00 },
   { PIPE_FORMAT_S8_UINT, 512, 256, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 512, 256, 1, 10, 0x2d680 },
   { PIPE_FORMAT_S8_UINT, 512, 256, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 512, 256, 2, 10, 0x5ad00 },
   { PIPE_FORMAT_S8_UINT, 512, 257, 1, 1, 0x32000 },
   { PIPE_FORMAT_S8_UINT, 512, 257, 1, 10, 0x4ab80 },
   { PIPE_FORMAT_S8_UINT, 512, 257, 2, 1, 0x64000 },
   { PIPE_FORMAT_S8_UINT, 512, 257, 2, 10, 0x95700 },
   { PIPE_FORMAT_S8_UINT, 512, 511, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 512, 511, 1, 10, 0x5ab80 },
   { PIPE_FORMAT_S8_UINT, 512, 511, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 512, 511, 2, 10, 0xb5700 },
   { PIPE_FORMAT_S8_UINT, 512, 512, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 512, 512, 1, 10, 0x5ab80 },
   { PIPE_FORMAT_S8_UINT, 512, 512, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 512, 512, 2, 10, 0xb5700 },
   { PIPE_FORMAT_S8_UINT, 512, 513, 1, 1, 0x54000 },
   { PIPE_FORMAT_S8_UINT, 512, 513, 1, 10, 0x7d600 },
   { PIPE_FORMAT_S8_UINT, 512, 513, 2, 1, 0xa8000 },
   { PIPE_FORMAT_S8_UINT, 512, 513, 2, 10, 0xfac00 },
   { PIPE_FORMAT_S8_UINT, 512, 1023, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 512, 1023, 1, 10, 0xb1680 },
   { PIPE_FORMAT_S8_UINT, 512, 1023, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 512, 1023, 2, 10, 0x162d00 },
   { PIPE_FORMAT_S8_UINT, 512, 1024, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 512, 1024, 1, 11, 0xb1680 },
   { PIPE_FORMAT_S8_UINT, 512, 1024, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 512, 1024, 2, 11, 0x162d00 },
   { PIPE_FORMAT_S8_UINT, 512, 1025, 1, 1, 0x98000 },
   { PIPE_FORMAT_S8_UINT, 512, 1025, 1, 11, 0xd6b80 },
   { PIPE_FORMAT_S8_UINT, 512, 1025, 2, 1, 0x130000 },
   { PIPE_FORMAT_S8_UINT, 512, 1025, 2, 11, 0x1ad700 },
   { PIPE_FORMAT_S8_UINT, 512, 2047, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 512, 2047, 1, 11, 0x162c00 },
   { PIPE_FORMAT_S8_UINT, 512, 2047, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 512, 2047, 2, 11, 0x2c5800 },
   { PIPE_FORMAT_S8_UINT, 512, 2048, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 512, 2048, 1, 12, 0x162c00 },
   { PIPE_FORMAT_S8_UINT, 512, 2048, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 512, 2048, 2, 12, 0x2c5800 },
   { PIPE_FORMAT_S8_UINT, 512, 2049, 1, 1, 0x120000 },
   { PIPE_FORMAT_S8_UINT, 512, 2049, 1, 12, 0x18d680 },
   { PIPE_FORMAT_S8_UINT, 512, 2049, 2, 1, 0x240000 },
   { PIPE_FORMAT_S8_UINT, 512, 2049, 2, 12, 0x31ad00 },
   { PIPE_FORMAT_S8_UINT, 512, 4095, 1, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 512, 4095, 1, 12, 0x2c1700 },
   { PIPE_FORMAT_S8_UINT, 512, 4095, 2, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 512, 4095, 2, 12, 0x582e00 },
   { PIPE_FORMAT_S8_UINT, 512, 4096, 1, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 512, 4096, 1, 13, 0x2c1700 },
   { PIPE_FORMAT_S8_UINT, 512, 4096, 2, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 512, 4096, 2, 13, 0x582e00 },
   { PIPE_FORMAT_S8_UINT, 512, 4097, 1, 1, 0x230000 },
   { PIPE_FORMAT_S8_UINT, 512, 4097, 1, 13, 0x2f6c00 },
   { PIPE_FORMAT_S8_UINT, 512, 4097, 2, 1, 0x460000 },
   { PIPE_FORMAT_S8_UINT, 512, 4097, 2, 13, 0x5ed800 },
   { PIPE_FORMAT_S8_UINT, 513, 16, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 513, 16, 1, 10, 0x8500 },
   { PIPE_FORMAT_S8_UINT, 513, 16, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 513, 16, 2, 10, 0x10a00 },
   { PIPE_FORMAT_S8_UINT, 513, 17, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 513, 17, 1, 10, 0xc700 },
   { PIPE_FORMAT_S8_UINT, 513, 17, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 513, 17, 2, 10, 0x18e00 },
   { PIPE_FORMAT_S8_UINT, 513, 31, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 513, 31, 1, 10, 0xc700 },
   { PIPE_FORMAT_S8_UINT, 513, 31, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 513, 31, 2, 10, 0x18e00 },
   { PIPE_FORMAT_S8_UINT, 513, 32, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 513, 32, 1, 10, 0xc700 },
   { PIPE_FORMAT_S8_UINT, 513, 32, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 513, 32, 2, 10, 0x18e00 },
   { PIPE_FORMAT_S8_UINT, 513, 33, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 513, 33, 1, 10, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 513, 33, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 513, 33, 2, 10, 0x31800 },
   { PIPE_FORMAT_S8_UINT, 513, 63, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 513, 63, 1, 10, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 513, 63, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 513, 63, 2, 10, 0x31800 },
   { PIPE_FORMAT_S8_UINT, 513, 64, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 513, 64, 1, 10, 0x18c00 },
   { PIPE_FORMAT_S8_UINT, 513, 64, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 513, 64, 2, 10, 0x31800 },
   { PIPE_FORMAT_S8_UINT, 513, 65, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 513, 65, 1, 10, 0x2d680 },
   { PIPE_FORMAT_S8_UINT, 513, 65, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 513, 65, 2, 10, 0x5ad00 },
   { PIPE_FORMAT_S8_UINT, 513, 127, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 513, 127, 1, 10, 0x2d680 },
   { PIPE_FORMAT_S8_UINT, 513, 127, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 513, 127, 2, 10, 0x5ad00 },
   { PIPE_FORMAT_S8_UINT, 513, 128, 1, 1, 0x15000 },
   { PIPE_FORMAT_S8_UINT, 513, 128, 1, 10, 0x1d680 },
   { PIPE_FORMAT_S8_UINT, 513, 128, 2, 1, 0x2a000 },
   { PIPE_FORMAT_S8_UINT, 513, 128, 2, 10, 0x3ad00 },
   { PIPE_FORMAT_S8_UINT, 513, 129, 1, 1, 0x2a000 },
   { PIPE_FORMAT_S8_UINT, 513, 129, 1, 10, 0x32b80 },
   { PIPE_FORMAT_S8_UINT, 513, 129, 2, 1, 0x54000 },
   { PIPE_FORMAT_S8_UINT, 513, 129, 2, 10, 0x65700 },
   { PIPE_FORMAT_S8_UINT, 513, 255, 1, 1, 0x2a000 },
   { PIPE_FORMAT_S8_UINT, 513, 255, 1, 10, 0x36b80 },
   { PIPE_FORMAT_S8_UINT, 513, 255, 2, 1, 0x54000 },
   { PIPE_FORMAT_S8_UINT, 513, 255, 2, 10, 0x6d700 },
   { PIPE_FORMAT_S8_UINT, 513, 256, 1, 1, 0x2a000 },
   { PIPE_FORMAT_S8_UINT, 513, 256, 1, 10, 0x3ab80 },
   { PIPE_FORMAT_S8_UINT, 513, 256, 2, 1, 0x54000 },
   { PIPE_FORMAT_S8_UINT, 513, 256, 2, 10, 0x75700 },
   { PIPE_FORMAT_S8_UINT, 513, 257, 1, 1, 0x40000 },
   { PIPE_FORMAT_S8_UINT, 513, 257, 1, 10, 0x61600 },
   { PIPE_FORMAT_S8_UINT, 513, 257, 2, 1, 0x80000 },
   { PIPE_FORMAT_S8_UINT, 513, 257, 2, 10, 0xc2c00 },
   { PIPE_FORMAT_S8_UINT, 513, 511, 1, 1, 0x54000 },
   { PIPE_FORMAT_S8_UINT, 513, 511, 1, 10, 0x79600 },
   { PIPE_FORMAT_S8_UINT, 513, 511, 2, 1, 0xa8000 },
   { PIPE_FORMAT_S8_UINT, 513, 511, 2, 10, 0xf2c00 },
   { PIPE_FORMAT_S8_UINT, 513, 512, 1, 1, 0x54000 },
   { PIPE_FORMAT_S8_UINT, 513, 512, 1, 10, 0x7d600 },
   { PIPE_FORMAT_S8_UINT, 513, 512, 2, 1, 0xa8000 },
   { PIPE_FORMAT_S8_UINT, 513, 512, 2, 10, 0xfac00 },
   { PIPE_FORMAT_S8_UINT, 513, 513, 1, 1, 0x6c000 },
   { PIPE_FORMAT_S8_UINT, 513, 513, 1, 10, 0xaeb00 },
   { PIPE_FORMAT_S8_UINT, 513, 513, 2, 1, 0xd8000 },
   { PIPE_FORMAT_S8_UINT, 513, 513, 2, 10, 0x15d600 },
   { PIPE_FORMAT_S8_UINT, 513, 1023, 1, 1, 0xa8000 },
   { PIPE_FORMAT_S8_UINT, 513, 1023, 1, 10, 0xf6b80 },
   { PIPE_FORMAT_S8_UINT, 513, 1023, 2, 1, 0x150000 },
   { PIPE_FORMAT_S8_UINT, 513, 1023, 2, 10, 0x1ed700 },
   { PIPE_FORMAT_S8_UINT, 513, 1024, 1, 1, 0xa8000 },
   { PIPE_FORMAT_S8_UINT, 513, 1024, 1, 11, 0xf6b80 },
   { PIPE_FORMAT_S8_UINT, 513, 1024, 2, 1, 0x150000 },
   { PIPE_FORMAT_S8_UINT, 513, 1024, 2, 11, 0x1ed700 },
   { PIPE_FORMAT_S8_UINT, 513, 1025, 1, 1, 0xc4000 },
   { PIPE_FORMAT_S8_UINT, 513, 1025, 1, 11, 0x12d600 },
   { PIPE_FORMAT_S8_UINT, 513, 1025, 2, 1, 0x188000 },
   { PIPE_FORMAT_S8_UINT, 513, 1025, 2, 11, 0x25ac00 },
   { PIPE_FORMAT_S8_UINT, 513, 2047, 1, 1, 0x150000 },
   { PIPE_FORMAT_S8_UINT, 513, 2047, 1, 11, 0x1f1680 },
   { PIPE_FORMAT_S8_UINT, 513, 2047, 2, 1, 0x2a0000 },
   { PIPE_FORMAT_S8_UINT, 513, 2047, 2, 11, 0x3e2d00 },
   { PIPE_FORMAT_S8_UINT, 513, 2048, 1, 1, 0x150000 },
   { PIPE_FORMAT_S8_UINT, 513, 2048, 1, 12, 0x1f1680 },
   { PIPE_FORMAT_S8_UINT, 513, 2048, 2, 1, 0x2a0000 },
   { PIPE_FORMAT_S8_UINT, 513, 2048, 2, 12, 0x3e2d00 },
   { PIPE_FORMAT_S8_UINT, 513, 2049, 1, 1, 0x174000 },
   { PIPE_FORMAT_S8_UINT, 513, 2049, 1, 12, 0x232b80 },
   { PIPE_FORMAT_S8_UINT, 513, 2049, 2, 1, 0x2e8000 },
   { PIPE_FORMAT_S8_UINT, 513, 2049, 2, 12, 0x465700 },
   { PIPE_FORMAT_S8_UINT, 513, 4095, 1, 1, 0x2a0000 },
   { PIPE_FORMAT_S8_UINT, 513, 4095, 1, 12, 0x3dec00 },
   { PIPE_FORMAT_S8_UINT, 513, 4095, 2, 1, 0x540000 },
   { PIPE_FORMAT_S8_UINT, 513, 4095, 2, 12, 0x7bd800 },
   { PIPE_FORMAT_S8_UINT, 513, 4096, 1, 1, 0x2a0000 },
   { PIPE_FORMAT_S8_UINT, 513, 4096, 1, 13, 0x3dec00 },
   { PIPE_FORMAT_S8_UINT, 513, 4096, 2, 1, 0x540000 },
   { PIPE_FORMAT_S8_UINT, 513, 4096, 2, 13, 0x7bd800 },
   { PIPE_FORMAT_S8_UINT, 513, 4097, 1, 1, 0x2d4000 },
   { PIPE_FORMAT_S8_UINT, 513, 4097, 1, 13, 0x435680 },
   { PIPE_FORMAT_S8_UINT, 513, 4097, 2, 1, 0x5a8000 },
   { PIPE_FORMAT_S8_UINT, 513, 4097, 2, 13, 0x86ad00 },
   { PIPE_FORMAT_S8_UINT, 1023, 16, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 1023, 16, 1, 10, 0x8580 },
   { PIPE_FORMAT_S8_UINT, 1023, 16, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 1023, 16, 2, 10, 0x10b00 },
   { PIPE_FORMAT_S8_UINT, 1023, 17, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 1023, 17, 1, 10, 0xc780 },
   { PIPE_FORMAT_S8_UINT, 1023, 17, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 1023, 17, 2, 10, 0x18f00 },
   { PIPE_FORMAT_S8_UINT, 1023, 31, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 1023, 31, 1, 10, 0xc780 },
   { PIPE_FORMAT_S8_UINT, 1023, 31, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 1023, 31, 2, 10, 0x18f00 },
   { PIPE_FORMAT_S8_UINT, 1023, 32, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 1023, 32, 1, 10, 0xc780 },
   { PIPE_FORMAT_S8_UINT, 1023, 32, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 1023, 32, 2, 10, 0x18f00 },
   { PIPE_FORMAT_S8_UINT, 1023, 33, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 1023, 33, 1, 10, 0x18c80 },
   { PIPE_FORMAT_S8_UINT, 1023, 33, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 1023, 33, 2, 10, 0x31900 },
   { PIPE_FORMAT_S8_UINT, 1023, 63, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 1023, 63, 1, 10, 0x18c80 },
   { PIPE_FORMAT_S8_UINT, 1023, 63, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 1023, 63, 2, 10, 0x31900 },
   { PIPE_FORMAT_S8_UINT, 1023, 64, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 1023, 64, 1, 10, 0x18c80 },
   { PIPE_FORMAT_S8_UINT, 1023, 64, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 1023, 64, 2, 10, 0x31900 },
   { PIPE_FORMAT_S8_UINT, 1023, 65, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 1023, 65, 1, 10, 0x2d700 },
   { PIPE_FORMAT_S8_UINT, 1023, 65, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 1023, 65, 2, 10, 0x5ae00 },
   { PIPE_FORMAT_S8_UINT, 1023, 127, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 1023, 127, 1, 10, 0x2d700 },
   { PIPE_FORMAT_S8_UINT, 1023, 127, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 1023, 127, 2, 10, 0x5ae00 },
   { PIPE_FORMAT_S8_UINT, 1023, 128, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 1023, 128, 1, 10, 0x2d700 },
   { PIPE_FORMAT_S8_UINT, 1023, 128, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 1023, 128, 2, 10, 0x5ae00 },
   { PIPE_FORMAT_S8_UINT, 1023, 129, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 1023, 129, 1, 10, 0x4ec00 },
   { PIPE_FORMAT_S8_UINT, 1023, 129, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 1023, 129, 2, 10, 0x9d800 },
   { PIPE_FORMAT_S8_UINT, 1023, 255, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 1023, 255, 1, 10, 0x5ac00 },
   { PIPE_FORMAT_S8_UINT, 1023, 255, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 1023, 255, 2, 10, 0xb5800 },
   { PIPE_FORMAT_S8_UINT, 1023, 256, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 1023, 256, 1, 10, 0x5ac00 },
   { PIPE_FORMAT_S8_UINT, 1023, 256, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 1023, 256, 2, 10, 0xb5800 },
   { PIPE_FORMAT_S8_UINT, 1023, 257, 1, 1, 0x64000 },
   { PIPE_FORMAT_S8_UINT, 1023, 257, 1, 10, 0x95680 },
   { PIPE_FORMAT_S8_UINT, 1023, 257, 2, 1, 0xc8000 },
   { PIPE_FORMAT_S8_UINT, 1023, 257, 2, 10, 0x12ad00 },
   { PIPE_FORMAT_S8_UINT, 1023, 511, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 1023, 511, 1, 10, 0xb1680 },
   { PIPE_FORMAT_S8_UINT, 1023, 511, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 1023, 511, 2, 10, 0x162d00 },
   { PIPE_FORMAT_S8_UINT, 1023, 512, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 1023, 512, 1, 10, 0xb1680 },
   { PIPE_FORMAT_S8_UINT, 1023, 512, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 1023, 512, 2, 10, 0x162d00 },
   { PIPE_FORMAT_S8_UINT, 1023, 513, 1, 1, 0xa8000 },
   { PIPE_FORMAT_S8_UINT, 1023, 513, 1, 10, 0xf6b80 },
   { PIPE_FORMAT_S8_UINT, 1023, 513, 2, 1, 0x150000 },
   { PIPE_FORMAT_S8_UINT, 1023, 513, 2, 10, 0x1ed700 },
   { PIPE_FORMAT_S8_UINT, 1023, 1023, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 1023, 1023, 1, 10, 0x162b80 },
   { PIPE_FORMAT_S8_UINT, 1023, 1023, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 1023, 1023, 2, 10, 0x2c5700 },
   { PIPE_FORMAT_S8_UINT, 1023, 1024, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 1023, 1024, 1, 11, 0x162b80 },
   { PIPE_FORMAT_S8_UINT, 1023, 1024, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 1023, 1024, 2, 11, 0x2c5700 },
   { PIPE_FORMAT_S8_UINT, 1023, 1025, 1, 1, 0x130000 },
   { PIPE_FORMAT_S8_UINT, 1023, 1025, 1, 11, 0x1ad600 },
   { PIPE_FORMAT_S8_UINT, 1023, 1025, 2, 1, 0x260000 },
   { PIPE_FORMAT_S8_UINT, 1023, 1025, 2, 11, 0x35ac00 },
   { PIPE_FORMAT_S8_UINT, 1023, 2047, 1, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 1023, 2047, 1, 11, 0x2c1680 },
   { PIPE_FORMAT_S8_UINT, 1023, 2047, 2, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 1023, 2047, 2, 11, 0x582d00 },
   { PIPE_FORMAT_S8_UINT, 1023, 2048, 1, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 1023, 2048, 1, 12, 0x2c1680 },
   { PIPE_FORMAT_S8_UINT, 1023, 2048, 2, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 1023, 2048, 2, 12, 0x582d00 },
   { PIPE_FORMAT_S8_UINT, 1023, 2049, 1, 1, 0x240000 },
   { PIPE_FORMAT_S8_UINT, 1023, 2049, 1, 12, 0x316b80 },
   { PIPE_FORMAT_S8_UINT, 1023, 2049, 2, 1, 0x480000 },
   { PIPE_FORMAT_S8_UINT, 1023, 2049, 2, 12, 0x62d700 },
   { PIPE_FORMAT_S8_UINT, 1023, 4095, 1, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 1023, 4095, 1, 12, 0x582c00 },
   { PIPE_FORMAT_S8_UINT, 1023, 4095, 2, 1, 0x840000 },
   { PIPE_FORMAT_S8_UINT, 1023, 4095, 2, 12, 0xb05800 },
   { PIPE_FORMAT_S8_UINT, 1023, 4096, 1, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 1023, 4096, 1, 13, 0x582c00 },
   { PIPE_FORMAT_S8_UINT, 1023, 4096, 2, 1, 0x840000 },
   { PIPE_FORMAT_S8_UINT, 1023, 4096, 2, 13, 0xb05800 },
   { PIPE_FORMAT_S8_UINT, 1023, 4097, 1, 1, 0x460000 },
   { PIPE_FORMAT_S8_UINT, 1023, 4097, 1, 13, 0x5ed680 },
   { PIPE_FORMAT_S8_UINT, 1023, 4097, 2, 1, 0x8c0000 },
   { PIPE_FORMAT_S8_UINT, 1023, 4097, 2, 13, 0xbdad00 },
   { PIPE_FORMAT_S8_UINT, 1024, 16, 1, 1, 0x4200 },
   { PIPE_FORMAT_S8_UINT, 1024, 16, 1, 11, 0x8580 },
   { PIPE_FORMAT_S8_UINT, 1024, 16, 2, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 1024, 16, 2, 11, 0x10b00 },
   { PIPE_FORMAT_S8_UINT, 1024, 17, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 1024, 17, 1, 11, 0xc780 },
   { PIPE_FORMAT_S8_UINT, 1024, 17, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 1024, 17, 2, 11, 0x18f00 },
   { PIPE_FORMAT_S8_UINT, 1024, 31, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 1024, 31, 1, 11, 0xc780 },
   { PIPE_FORMAT_S8_UINT, 1024, 31, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 1024, 31, 2, 11, 0x18f00 },
   { PIPE_FORMAT_S8_UINT, 1024, 32, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 1024, 32, 1, 11, 0xc780 },
   { PIPE_FORMAT_S8_UINT, 1024, 32, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 1024, 32, 2, 11, 0x18f00 },
   { PIPE_FORMAT_S8_UINT, 1024, 33, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 1024, 33, 1, 11, 0x18c80 },
   { PIPE_FORMAT_S8_UINT, 1024, 33, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 1024, 33, 2, 11, 0x31900 },
   { PIPE_FORMAT_S8_UINT, 1024, 63, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 1024, 63, 1, 11, 0x18c80 },
   { PIPE_FORMAT_S8_UINT, 1024, 63, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 1024, 63, 2, 11, 0x31900 },
   { PIPE_FORMAT_S8_UINT, 1024, 64, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 1024, 64, 1, 11, 0x18c80 },
   { PIPE_FORMAT_S8_UINT, 1024, 64, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 1024, 64, 2, 11, 0x31900 },
   { PIPE_FORMAT_S8_UINT, 1024, 65, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 1024, 65, 1, 11, 0x2d700 },
   { PIPE_FORMAT_S8_UINT, 1024, 65, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 1024, 65, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_S8_UINT, 1024, 127, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 1024, 127, 1, 11, 0x2d700 },
   { PIPE_FORMAT_S8_UINT, 1024, 127, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 1024, 127, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_S8_UINT, 1024, 128, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 1024, 128, 1, 11, 0x2d700 },
   { PIPE_FORMAT_S8_UINT, 1024, 128, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 1024, 128, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_S8_UINT, 1024, 129, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 1024, 129, 1, 11, 0x4ec00 },
   { PIPE_FORMAT_S8_UINT, 1024, 129, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 1024, 129, 2, 11, 0x9d800 },
   { PIPE_FORMAT_S8_UINT, 1024, 255, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 1024, 255, 1, 11, 0x5ac00 },
   { PIPE_FORMAT_S8_UINT, 1024, 255, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 1024, 255, 2, 11, 0xb5800 },
   { PIPE_FORMAT_S8_UINT, 1024, 256, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 1024, 256, 1, 11, 0x5ac00 },
   { PIPE_FORMAT_S8_UINT, 1024, 256, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 1024, 256, 2, 11, 0xb5800 },
   { PIPE_FORMAT_S8_UINT, 1024, 257, 1, 1, 0x64000 },
   { PIPE_FORMAT_S8_UINT, 1024, 257, 1, 11, 0x95680 },
   { PIPE_FORMAT_S8_UINT, 1024, 257, 2, 1, 0xc8000 },
   { PIPE_FORMAT_S8_UINT, 1024, 257, 2, 11, 0x12ad00 },
   { PIPE_FORMAT_S8_UINT, 1024, 511, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 1024, 511, 1, 11, 0xb1680 },
   { PIPE_FORMAT_S8_UINT, 1024, 511, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 1024, 511, 2, 11, 0x162d00 },
   { PIPE_FORMAT_S8_UINT, 1024, 512, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 1024, 512, 1, 11, 0xb1680 },
   { PIPE_FORMAT_S8_UINT, 1024, 512, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 1024, 512, 2, 11, 0x162d00 },
   { PIPE_FORMAT_S8_UINT, 1024, 513, 1, 1, 0xa8000 },
   { PIPE_FORMAT_S8_UINT, 1024, 513, 1, 11, 0xf6b80 },
   { PIPE_FORMAT_S8_UINT, 1024, 513, 2, 1, 0x150000 },
   { PIPE_FORMAT_S8_UINT, 1024, 513, 2, 11, 0x1ed700 },
   { PIPE_FORMAT_S8_UINT, 1024, 1023, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 1024, 1023, 1, 11, 0x162b80 },
   { PIPE_FORMAT_S8_UINT, 1024, 1023, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 1024, 1023, 2, 11, 0x2c5700 },
   { PIPE_FORMAT_S8_UINT, 1024, 1024, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 1024, 1024, 1, 11, 0x162b80 },
   { PIPE_FORMAT_S8_UINT, 1024, 1024, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 1024, 1024, 2, 11, 0x2c5700 },
   { PIPE_FORMAT_S8_UINT, 1024, 1025, 1, 1, 0x130000 },
   { PIPE_FORMAT_S8_UINT, 1024, 1025, 1, 11, 0x1b1600 },
   { PIPE_FORMAT_S8_UINT, 1024, 1025, 2, 1, 0x260000 },
   { PIPE_FORMAT_S8_UINT, 1024, 1025, 2, 11, 0x362c00 },
   { PIPE_FORMAT_S8_UINT, 1024, 2047, 1, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 1024, 2047, 1, 11, 0x2c1680 },
   { PIPE_FORMAT_S8_UINT, 1024, 2047, 2, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 1024, 2047, 2, 11, 0x582d00 },
   { PIPE_FORMAT_S8_UINT, 1024, 2048, 1, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 1024, 2048, 1, 12, 0x2c1680 },
   { PIPE_FORMAT_S8_UINT, 1024, 2048, 2, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 1024, 2048, 2, 12, 0x582d00 },
   { PIPE_FORMAT_S8_UINT, 1024, 2049, 1, 1, 0x240000 },
   { PIPE_FORMAT_S8_UINT, 1024, 2049, 1, 12, 0x31ab80 },
   { PIPE_FORMAT_S8_UINT, 1024, 2049, 2, 1, 0x480000 },
   { PIPE_FORMAT_S8_UINT, 1024, 2049, 2, 12, 0x635700 },
   { PIPE_FORMAT_S8_UINT, 1024, 4095, 1, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 1024, 4095, 1, 12, 0x582c00 },
   { PIPE_FORMAT_S8_UINT, 1024, 4095, 2, 1, 0x840000 },
   { PIPE_FORMAT_S8_UINT, 1024, 4095, 2, 12, 0xb05800 },
   { PIPE_FORMAT_S8_UINT, 1024, 4096, 1, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 1024, 4096, 1, 13, 0x582c00 },
   { PIPE_FORMAT_S8_UINT, 1024, 4096, 2, 1, 0x840000 },
   { PIPE_FORMAT_S8_UINT, 1024, 4096, 2, 13, 0xb05800 },
   { PIPE_FORMAT_S8_UINT, 1024, 4097, 1, 1, 0x460000 },
   { PIPE_FORMAT_S8_UINT, 1024, 4097, 1, 13, 0x5f1680 },
   { PIPE_FORMAT_S8_UINT, 1024, 4097, 2, 1, 0x8c0000 },
   { PIPE_FORMAT_S8_UINT, 1024, 4097, 2, 13, 0xbe2d00 },
   { PIPE_FORMAT_S8_UINT, 1025, 16, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 1025, 16, 1, 11, 0xc900 },
   { PIPE_FORMAT_S8_UINT, 1025, 16, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 1025, 16, 2, 11, 0x19200 },
   { PIPE_FORMAT_S8_UINT, 1025, 17, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 1025, 17, 1, 11, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 1025, 17, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 1025, 17, 2, 11, 0x31a00 },
   { PIPE_FORMAT_S8_UINT, 1025, 31, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 1025, 31, 1, 11, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 1025, 31, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 1025, 31, 2, 11, 0x31a00 },
   { PIPE_FORMAT_S8_UINT, 1025, 32, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 1025, 32, 1, 11, 0x18d00 },
   { PIPE_FORMAT_S8_UINT, 1025, 32, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 1025, 32, 2, 11, 0x31a00 },
   { PIPE_FORMAT_S8_UINT, 1025, 33, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 1025, 33, 1, 11, 0x2d700 },
   { PIPE_FORMAT_S8_UINT, 1025, 33, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 1025, 33, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_S8_UINT, 1025, 63, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 1025, 63, 1, 11, 0x2d700 },
   { PIPE_FORMAT_S8_UINT, 1025, 63, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 1025, 63, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_S8_UINT, 1025, 64, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 1025, 64, 1, 11, 0x2d700 },
   { PIPE_FORMAT_S8_UINT, 1025, 64, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 1025, 64, 2, 11, 0x5ae00 },
   { PIPE_FORMAT_S8_UINT, 1025, 65, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 1025, 65, 1, 11, 0x5ac00 },
   { PIPE_FORMAT_S8_UINT, 1025, 65, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 1025, 65, 2, 11, 0xb5800 },
   { PIPE_FORMAT_S8_UINT, 1025, 127, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 1025, 127, 1, 11, 0x5ac00 },
   { PIPE_FORMAT_S8_UINT, 1025, 127, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 1025, 127, 2, 11, 0xb5800 },
   { PIPE_FORMAT_S8_UINT, 1025, 128, 1, 1, 0x26000 },
   { PIPE_FORMAT_S8_UINT, 1025, 128, 1, 11, 0x32c00 },
   { PIPE_FORMAT_S8_UINT, 1025, 128, 2, 1, 0x4c000 },
   { PIPE_FORMAT_S8_UINT, 1025, 128, 2, 11, 0x65800 },
   { PIPE_FORMAT_S8_UINT, 1025, 129, 1, 1, 0x4c000 },
   { PIPE_FORMAT_S8_UINT, 1025, 129, 1, 11, 0x59680 },
   { PIPE_FORMAT_S8_UINT, 1025, 129, 2, 1, 0x98000 },
   { PIPE_FORMAT_S8_UINT, 1025, 129, 2, 11, 0xb2d00 },
   { PIPE_FORMAT_S8_UINT, 1025, 255, 1, 1, 0x4c000 },
   { PIPE_FORMAT_S8_UINT, 1025, 255, 1, 11, 0x65680 },
   { PIPE_FORMAT_S8_UINT, 1025, 255, 2, 1, 0x98000 },
   { PIPE_FORMAT_S8_UINT, 1025, 255, 2, 11, 0xcad00 },
   { PIPE_FORMAT_S8_UINT, 1025, 256, 1, 1, 0x4c000 },
   { PIPE_FORMAT_S8_UINT, 1025, 256, 1, 11, 0x69680 },
   { PIPE_FORMAT_S8_UINT, 1025, 256, 2, 1, 0x98000 },
   { PIPE_FORMAT_S8_UINT, 1025, 256, 2, 11, 0xd2d00 },
   { PIPE_FORMAT_S8_UINT, 1025, 257, 1, 1, 0x74000 },
   { PIPE_FORMAT_S8_UINT, 1025, 257, 1, 11, 0xaeb80 },
   { PIPE_FORMAT_S8_UINT, 1025, 257, 2, 1, 0xe8000 },
   { PIPE_FORMAT_S8_UINT, 1025, 257, 2, 11, 0x15d700 },
   { PIPE_FORMAT_S8_UINT, 1025, 511, 1, 1, 0x98000 },
   { PIPE_FORMAT_S8_UINT, 1025, 511, 1, 11, 0xd2b80 },
   { PIPE_FORMAT_S8_UINT, 1025, 511, 2, 1, 0x130000 },
   { PIPE_FORMAT_S8_UINT, 1025, 511, 2, 11, 0x1a5700 },
   { PIPE_FORMAT_S8_UINT, 1025, 512, 1, 1, 0x98000 },
   { PIPE_FORMAT_S8_UINT, 1025, 512, 1, 11, 0xd6b80 },
   { PIPE_FORMAT_S8_UINT, 1025, 512, 2, 1, 0x130000 },
   { PIPE_FORMAT_S8_UINT, 1025, 512, 2, 11, 0x1ad700 },
   { PIPE_FORMAT_S8_UINT, 1025, 513, 1, 1, 0xc4000 },
   { PIPE_FORMAT_S8_UINT, 1025, 513, 1, 11, 0x12d600 },
   { PIPE_FORMAT_S8_UINT, 1025, 513, 2, 1, 0x188000 },
   { PIPE_FORMAT_S8_UINT, 1025, 513, 2, 11, 0x25ac00 },
   { PIPE_FORMAT_S8_UINT, 1025, 1023, 1, 1, 0x130000 },
   { PIPE_FORMAT_S8_UINT, 1025, 1023, 1, 11, 0x1ad600 },
   { PIPE_FORMAT_S8_UINT, 1025, 1023, 2, 1, 0x260000 },
   { PIPE_FORMAT_S8_UINT, 1025, 1023, 2, 11, 0x35ac00 },
   { PIPE_FORMAT_S8_UINT, 1025, 1024, 1, 1, 0x130000 },
   { PIPE_FORMAT_S8_UINT, 1025, 1024, 1, 11, 0x1b1600 },
   { PIPE_FORMAT_S8_UINT, 1025, 1024, 2, 1, 0x260000 },
   { PIPE_FORMAT_S8_UINT, 1025, 1024, 2, 11, 0x362c00 },
   { PIPE_FORMAT_S8_UINT, 1025, 1025, 1, 1, 0x164000 },
   { PIPE_FORMAT_S8_UINT, 1025, 1025, 1, 11, 0x21eb00 },
   { PIPE_FORMAT_S8_UINT, 1025, 1025, 2, 1, 0x2c8000 },
   { PIPE_FORMAT_S8_UINT, 1025, 1025, 2, 11, 0x43d600 },
   { PIPE_FORMAT_S8_UINT, 1025, 2047, 1, 1, 0x260000 },
   { PIPE_FORMAT_S8_UINT, 1025, 2047, 1, 11, 0x362b80 },
   { PIPE_FORMAT_S8_UINT, 1025, 2047, 2, 1, 0x4c0000 },
   { PIPE_FORMAT_S8_UINT, 1025, 2047, 2, 11, 0x6c5700 },
   { PIPE_FORMAT_S8_UINT, 1025, 2048, 1, 1, 0x260000 },
   { PIPE_FORMAT_S8_UINT, 1025, 2048, 1, 12, 0x362b80 },
   { PIPE_FORMAT_S8_UINT, 1025, 2048, 2, 1, 0x4c0000 },
   { PIPE_FORMAT_S8_UINT, 1025, 2048, 2, 12, 0x6c5700 },
   { PIPE_FORMAT_S8_UINT, 1025, 2049, 1, 1, 0x2a4000 },
   { PIPE_FORMAT_S8_UINT, 1025, 2049, 1, 12, 0x3e1600 },
   { PIPE_FORMAT_S8_UINT, 1025, 2049, 2, 1, 0x548000 },
   { PIPE_FORMAT_S8_UINT, 1025, 2049, 2, 12, 0x7c2c00 },
   { PIPE_FORMAT_S8_UINT, 1025, 4095, 1, 1, 0x4c0000 },
   { PIPE_FORMAT_S8_UINT, 1025, 4095, 1, 12, 0x6c5680 },
   { PIPE_FORMAT_S8_UINT, 1025, 4095, 2, 1, 0x980000 },
   { PIPE_FORMAT_S8_UINT, 1025, 4095, 2, 12, 0xd8ad00 },
   { PIPE_FORMAT_S8_UINT, 1025, 4096, 1, 1, 0x4c0000 },
   { PIPE_FORMAT_S8_UINT, 1025, 4096, 1, 13, 0x6c5680 },
   { PIPE_FORMAT_S8_UINT, 1025, 4096, 2, 1, 0x980000 },
   { PIPE_FORMAT_S8_UINT, 1025, 4096, 2, 13, 0xd8ad00 },
   { PIPE_FORMAT_S8_UINT, 1025, 4097, 1, 1, 0x524000 },
   { PIPE_FORMAT_S8_UINT, 1025, 4097, 1, 13, 0x76eb80 },
   { PIPE_FORMAT_S8_UINT, 1025, 4097, 2, 1, 0xa48000 },
   { PIPE_FORMAT_S8_UINT, 1025, 4097, 2, 13, 0xedd700 },
   { PIPE_FORMAT_S8_UINT, 2047, 16, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 2047, 16, 1, 11, 0xc980 },
   { PIPE_FORMAT_S8_UINT, 2047, 16, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 2047, 16, 2, 11, 0x19300 },
   { PIPE_FORMAT_S8_UINT, 2047, 17, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 2047, 17, 1, 11, 0x18d80 },
   { PIPE_FORMAT_S8_UINT, 2047, 17, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 2047, 17, 2, 11, 0x31b00 },
   { PIPE_FORMAT_S8_UINT, 2047, 31, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 2047, 31, 1, 11, 0x18d80 },
   { PIPE_FORMAT_S8_UINT, 2047, 31, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 2047, 31, 2, 11, 0x31b00 },
   { PIPE_FORMAT_S8_UINT, 2047, 32, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 2047, 32, 1, 11, 0x18d80 },
   { PIPE_FORMAT_S8_UINT, 2047, 32, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 2047, 32, 2, 11, 0x31b00 },
   { PIPE_FORMAT_S8_UINT, 2047, 33, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 2047, 33, 1, 11, 0x2d780 },
   { PIPE_FORMAT_S8_UINT, 2047, 33, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 2047, 33, 2, 11, 0x5af00 },
   { PIPE_FORMAT_S8_UINT, 2047, 63, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 2047, 63, 1, 11, 0x2d780 },
   { PIPE_FORMAT_S8_UINT, 2047, 63, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 2047, 63, 2, 11, 0x5af00 },
   { PIPE_FORMAT_S8_UINT, 2047, 64, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 2047, 64, 1, 11, 0x2d780 },
   { PIPE_FORMAT_S8_UINT, 2047, 64, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 2047, 64, 2, 11, 0x5af00 },
   { PIPE_FORMAT_S8_UINT, 2047, 65, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 2047, 65, 1, 11, 0x5ac80 },
   { PIPE_FORMAT_S8_UINT, 2047, 65, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 2047, 65, 2, 11, 0xb5900 },
   { PIPE_FORMAT_S8_UINT, 2047, 127, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 2047, 127, 1, 11, 0x5ac80 },
   { PIPE_FORMAT_S8_UINT, 2047, 127, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 2047, 127, 2, 11, 0xb5900 },
   { PIPE_FORMAT_S8_UINT, 2047, 128, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 2047, 128, 1, 11, 0x5ac80 },
   { PIPE_FORMAT_S8_UINT, 2047, 128, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 2047, 128, 2, 11, 0xb5900 },
   { PIPE_FORMAT_S8_UINT, 2047, 129, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 2047, 129, 1, 11, 0x9d700 },
   { PIPE_FORMAT_S8_UINT, 2047, 129, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 2047, 129, 2, 11, 0x13ae00 },
   { PIPE_FORMAT_S8_UINT, 2047, 255, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 2047, 255, 1, 11, 0xb1700 },
   { PIPE_FORMAT_S8_UINT, 2047, 255, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 2047, 255, 2, 11, 0x162e00 },
   { PIPE_FORMAT_S8_UINT, 2047, 256, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 2047, 256, 1, 11, 0xb1700 },
   { PIPE_FORMAT_S8_UINT, 2047, 256, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 2047, 256, 2, 11, 0x162e00 },
   { PIPE_FORMAT_S8_UINT, 2047, 257, 1, 1, 0xc8000 },
   { PIPE_FORMAT_S8_UINT, 2047, 257, 1, 11, 0x126c00 },
   { PIPE_FORMAT_S8_UINT, 2047, 257, 2, 1, 0x190000 },
   { PIPE_FORMAT_S8_UINT, 2047, 257, 2, 11, 0x24d800 },
   { PIPE_FORMAT_S8_UINT, 2047, 511, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 2047, 511, 1, 11, 0x162c00 },
   { PIPE_FORMAT_S8_UINT, 2047, 511, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 2047, 511, 2, 11, 0x2c5800 },
   { PIPE_FORMAT_S8_UINT, 2047, 512, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 2047, 512, 1, 11, 0x162c00 },
   { PIPE_FORMAT_S8_UINT, 2047, 512, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 2047, 512, 2, 11, 0x2c5800 },
   { PIPE_FORMAT_S8_UINT, 2047, 513, 1, 1, 0x150000 },
   { PIPE_FORMAT_S8_UINT, 2047, 513, 1, 11, 0x1f1680 },
   { PIPE_FORMAT_S8_UINT, 2047, 513, 2, 1, 0x2a0000 },
   { PIPE_FORMAT_S8_UINT, 2047, 513, 2, 11, 0x3e2d00 },
   { PIPE_FORMAT_S8_UINT, 2047, 1023, 1, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 2047, 1023, 1, 11, 0x2c1680 },
   { PIPE_FORMAT_S8_UINT, 2047, 1023, 2, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 2047, 1023, 2, 11, 0x582d00 },
   { PIPE_FORMAT_S8_UINT, 2047, 1024, 1, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 2047, 1024, 1, 11, 0x2c1680 },
   { PIPE_FORMAT_S8_UINT, 2047, 1024, 2, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 2047, 1024, 2, 11, 0x582d00 },
   { PIPE_FORMAT_S8_UINT, 2047, 1025, 1, 1, 0x260000 },
   { PIPE_FORMAT_S8_UINT, 2047, 1025, 1, 11, 0x362b80 },
   { PIPE_FORMAT_S8_UINT, 2047, 1025, 2, 1, 0x4c0000 },
   { PIPE_FORMAT_S8_UINT, 2047, 1025, 2, 11, 0x6c5700 },
   { PIPE_FORMAT_S8_UINT, 2047, 2047, 1, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 2047, 2047, 1, 11, 0x582b80 },
   { PIPE_FORMAT_S8_UINT, 2047, 2047, 2, 1, 0x840000 },
   { PIPE_FORMAT_S8_UINT, 2047, 2047, 2, 11, 0xb05700 },
   { PIPE_FORMAT_S8_UINT, 2047, 2048, 1, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 2047, 2048, 1, 12, 0x582b80 },
   { PIPE_FORMAT_S8_UINT, 2047, 2048, 2, 1, 0x840000 },
   { PIPE_FORMAT_S8_UINT, 2047, 2048, 2, 12, 0xb05700 },
   { PIPE_FORMAT_S8_UINT, 2047, 2049, 1, 1, 0x480000 },
   { PIPE_FORMAT_S8_UINT, 2047, 2049, 1, 12, 0x639600 },
   { PIPE_FORMAT_S8_UINT, 2047, 2049, 2, 1, 0x900000 },
   { PIPE_FORMAT_S8_UINT, 2047, 2049, 2, 12, 0xc72c00 },
   { PIPE_FORMAT_S8_UINT, 2047, 4095, 1, 1, 0x840000 },
   { PIPE_FORMAT_S8_UINT, 2047, 4095, 1, 12, 0xb01680 },
   { PIPE_FORMAT_S8_UINT, 2047, 4095, 2, 1, 0x1080000 },
   { PIPE_FORMAT_S8_UINT, 2047, 4095, 2, 12, 0x1602d00 },
   { PIPE_FORMAT_S8_UINT, 2047, 4096, 1, 1, 0x840000 },
   { PIPE_FORMAT_S8_UINT, 2047, 4096, 1, 13, 0xb01680 },
   { PIPE_FORMAT_S8_UINT, 2047, 4096, 2, 1, 0x1080000 },
   { PIPE_FORMAT_S8_UINT, 2047, 4096, 2, 13, 0x1602d00 },
   { PIPE_FORMAT_S8_UINT, 2047, 4097, 1, 1, 0x8c0000 },
   { PIPE_FORMAT_S8_UINT, 2047, 4097, 1, 13, 0xbe2b80 },
   { PIPE_FORMAT_S8_UINT, 2047, 4097, 2, 1, 0x1180000 },
   { PIPE_FORMAT_S8_UINT, 2047, 4097, 2, 13, 0x17c5700 },
   { PIPE_FORMAT_S8_UINT, 2048, 16, 1, 1, 0x8400 },
   { PIPE_FORMAT_S8_UINT, 2048, 16, 1, 12, 0xc980 },
   { PIPE_FORMAT_S8_UINT, 2048, 16, 2, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 2048, 16, 2, 12, 0x19300 },
   { PIPE_FORMAT_S8_UINT, 2048, 17, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 2048, 17, 1, 12, 0x18d80 },
   { PIPE_FORMAT_S8_UINT, 2048, 17, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 2048, 17, 2, 12, 0x31b00 },
   { PIPE_FORMAT_S8_UINT, 2048, 31, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 2048, 31, 1, 12, 0x18d80 },
   { PIPE_FORMAT_S8_UINT, 2048, 31, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 2048, 31, 2, 12, 0x31b00 },
   { PIPE_FORMAT_S8_UINT, 2048, 32, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 2048, 32, 1, 12, 0x18d80 },
   { PIPE_FORMAT_S8_UINT, 2048, 32, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 2048, 32, 2, 12, 0x31b00 },
   { PIPE_FORMAT_S8_UINT, 2048, 33, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 2048, 33, 1, 12, 0x2d780 },
   { PIPE_FORMAT_S8_UINT, 2048, 33, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 2048, 33, 2, 12, 0x5af00 },
   { PIPE_FORMAT_S8_UINT, 2048, 63, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 2048, 63, 1, 12, 0x2d780 },
   { PIPE_FORMAT_S8_UINT, 2048, 63, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 2048, 63, 2, 12, 0x5af00 },
   { PIPE_FORMAT_S8_UINT, 2048, 64, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 2048, 64, 1, 12, 0x2d780 },
   { PIPE_FORMAT_S8_UINT, 2048, 64, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 2048, 64, 2, 12, 0x5af00 },
   { PIPE_FORMAT_S8_UINT, 2048, 65, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 2048, 65, 1, 12, 0x5ac80 },
   { PIPE_FORMAT_S8_UINT, 2048, 65, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 2048, 65, 2, 12, 0xb5900 },
   { PIPE_FORMAT_S8_UINT, 2048, 127, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 2048, 127, 1, 12, 0x5ac80 },
   { PIPE_FORMAT_S8_UINT, 2048, 127, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 2048, 127, 2, 12, 0xb5900 },
   { PIPE_FORMAT_S8_UINT, 2048, 128, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 2048, 128, 1, 12, 0x5ac80 },
   { PIPE_FORMAT_S8_UINT, 2048, 128, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 2048, 128, 2, 12, 0xb5900 },
   { PIPE_FORMAT_S8_UINT, 2048, 129, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 2048, 129, 1, 12, 0x9d700 },
   { PIPE_FORMAT_S8_UINT, 2048, 129, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 2048, 129, 2, 12, 0x13ae00 },
   { PIPE_FORMAT_S8_UINT, 2048, 255, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 2048, 255, 1, 12, 0xb1700 },
   { PIPE_FORMAT_S8_UINT, 2048, 255, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 2048, 255, 2, 12, 0x162e00 },
   { PIPE_FORMAT_S8_UINT, 2048, 256, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 2048, 256, 1, 12, 0xb1700 },
   { PIPE_FORMAT_S8_UINT, 2048, 256, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 2048, 256, 2, 12, 0x162e00 },
   { PIPE_FORMAT_S8_UINT, 2048, 257, 1, 1, 0xc8000 },
   { PIPE_FORMAT_S8_UINT, 2048, 257, 1, 12, 0x126c00 },
   { PIPE_FORMAT_S8_UINT, 2048, 257, 2, 1, 0x190000 },
   { PIPE_FORMAT_S8_UINT, 2048, 257, 2, 12, 0x24d800 },
   { PIPE_FORMAT_S8_UINT, 2048, 511, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 2048, 511, 1, 12, 0x162c00 },
   { PIPE_FORMAT_S8_UINT, 2048, 511, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 2048, 511, 2, 12, 0x2c5800 },
   { PIPE_FORMAT_S8_UINT, 2048, 512, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 2048, 512, 1, 12, 0x162c00 },
   { PIPE_FORMAT_S8_UINT, 2048, 512, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 2048, 512, 2, 12, 0x2c5800 },
   { PIPE_FORMAT_S8_UINT, 2048, 513, 1, 1, 0x150000 },
   { PIPE_FORMAT_S8_UINT, 2048, 513, 1, 12, 0x1f1680 },
   { PIPE_FORMAT_S8_UINT, 2048, 513, 2, 1, 0x2a0000 },
   { PIPE_FORMAT_S8_UINT, 2048, 513, 2, 12, 0x3e2d00 },
   { PIPE_FORMAT_S8_UINT, 2048, 1023, 1, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 2048, 1023, 1, 12, 0x2c1680 },
   { PIPE_FORMAT_S8_UINT, 2048, 1023, 2, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 2048, 1023, 2, 12, 0x582d00 },
   { PIPE_FORMAT_S8_UINT, 2048, 1024, 1, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 2048, 1024, 1, 12, 0x2c1680 },
   { PIPE_FORMAT_S8_UINT, 2048, 1024, 2, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 2048, 1024, 2, 12, 0x582d00 },
   { PIPE_FORMAT_S8_UINT, 2048, 1025, 1, 1, 0x260000 },
   { PIPE_FORMAT_S8_UINT, 2048, 1025, 1, 12, 0x362b80 },
   { PIPE_FORMAT_S8_UINT, 2048, 1025, 2, 1, 0x4c0000 },
   { PIPE_FORMAT_S8_UINT, 2048, 1025, 2, 12, 0x6c5700 },
   { PIPE_FORMAT_S8_UINT, 2048, 2047, 1, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 2048, 2047, 1, 12, 0x582b80 },
   { PIPE_FORMAT_S8_UINT, 2048, 2047, 2, 1, 0x840000 },
   { PIPE_FORMAT_S8_UINT, 2048, 2047, 2, 12, 0xb05700 },
   { PIPE_FORMAT_S8_UINT, 2048, 2048, 1, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 2048, 2048, 1, 12, 0x582b80 },
   { PIPE_FORMAT_S8_UINT, 2048, 2048, 2, 1, 0x840000 },
   { PIPE_FORMAT_S8_UINT, 2048, 2048, 2, 12, 0xb05700 },
   { PIPE_FORMAT_S8_UINT, 2048, 2049, 1, 1, 0x480000 },
   { PIPE_FORMAT_S8_UINT, 2048, 2049, 1, 12, 0x63d600 },
   { PIPE_FORMAT_S8_UINT, 2048, 2049, 2, 1, 0x900000 },
   { PIPE_FORMAT_S8_UINT, 2048, 2049, 2, 12, 0xc7ac00 },
   { PIPE_FORMAT_S8_UINT, 2048, 4095, 1, 1, 0x840000 },
   { PIPE_FORMAT_S8_UINT, 2048, 4095, 1, 12, 0xb01680 },
   { PIPE_FORMAT_S8_UINT, 2048, 4095, 2, 1, 0x1080000 },
   { PIPE_FORMAT_S8_UINT, 2048, 4095, 2, 12, 0x1602d00 },
   { PIPE_FORMAT_S8_UINT, 2048, 4096, 1, 1, 0x840000 },
   { PIPE_FORMAT_S8_UINT, 2048, 4096, 1, 13, 0xb01680 },
   { PIPE_FORMAT_S8_UINT, 2048, 4096, 2, 1, 0x1080000 },
   { PIPE_FORMAT_S8_UINT, 2048, 4096, 2, 13, 0x1602d00 },
   { PIPE_FORMAT_S8_UINT, 2048, 4097, 1, 1, 0x8c0000 },
   { PIPE_FORMAT_S8_UINT, 2048, 4097, 1, 13, 0xbe6b80 },
   { PIPE_FORMAT_S8_UINT, 2048, 4097, 2, 1, 0x1180000 },
   { PIPE_FORMAT_S8_UINT, 2048, 4097, 2, 13, 0x17cd700 },
   { PIPE_FORMAT_S8_UINT, 2049, 16, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 2049, 16, 1, 12, 0x19100 },
   { PIPE_FORMAT_S8_UINT, 2049, 16, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 2049, 16, 2, 12, 0x32200 },
   { PIPE_FORMAT_S8_UINT, 2049, 17, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 2049, 17, 1, 12, 0x2d900 },
   { PIPE_FORMAT_S8_UINT, 2049, 17, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 2049, 17, 2, 12, 0x5b200 },
   { PIPE_FORMAT_S8_UINT, 2049, 31, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 2049, 31, 1, 12, 0x2d900 },
   { PIPE_FORMAT_S8_UINT, 2049, 31, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 2049, 31, 2, 12, 0x5b200 },
   { PIPE_FORMAT_S8_UINT, 2049, 32, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 2049, 32, 1, 12, 0x2d900 },
   { PIPE_FORMAT_S8_UINT, 2049, 32, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 2049, 32, 2, 12, 0x5b200 },
   { PIPE_FORMAT_S8_UINT, 2049, 33, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 2049, 33, 1, 12, 0x5ad00 },
   { PIPE_FORMAT_S8_UINT, 2049, 33, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 2049, 33, 2, 12, 0xb5a00 },
   { PIPE_FORMAT_S8_UINT, 2049, 63, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 2049, 63, 1, 12, 0x5ad00 },
   { PIPE_FORMAT_S8_UINT, 2049, 63, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 2049, 63, 2, 12, 0xb5a00 },
   { PIPE_FORMAT_S8_UINT, 2049, 64, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 2049, 64, 1, 12, 0x5ad00 },
   { PIPE_FORMAT_S8_UINT, 2049, 64, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 2049, 64, 2, 12, 0xb5a00 },
   { PIPE_FORMAT_S8_UINT, 2049, 65, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 2049, 65, 1, 12, 0xb1700 },
   { PIPE_FORMAT_S8_UINT, 2049, 65, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 2049, 65, 2, 12, 0x162e00 },
   { PIPE_FORMAT_S8_UINT, 2049, 127, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 2049, 127, 1, 12, 0xb1700 },
   { PIPE_FORMAT_S8_UINT, 2049, 127, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 2049, 127, 2, 12, 0x162e00 },
   { PIPE_FORMAT_S8_UINT, 2049, 128, 1, 1, 0x48000 },
   { PIPE_FORMAT_S8_UINT, 2049, 128, 1, 12, 0x61700 },
   { PIPE_FORMAT_S8_UINT, 2049, 128, 2, 1, 0x90000 },
   { PIPE_FORMAT_S8_UINT, 2049, 128, 2, 12, 0xc2e00 },
   { PIPE_FORMAT_S8_UINT, 2049, 129, 1, 1, 0x90000 },
   { PIPE_FORMAT_S8_UINT, 2049, 129, 1, 12, 0xaac00 },
   { PIPE_FORMAT_S8_UINT, 2049, 129, 2, 1, 0x120000 },
   { PIPE_FORMAT_S8_UINT, 2049, 129, 2, 12, 0x155800 },
   { PIPE_FORMAT_S8_UINT, 2049, 255, 1, 1, 0x90000 },
   { PIPE_FORMAT_S8_UINT, 2049, 255, 1, 12, 0xbec00 },
   { PIPE_FORMAT_S8_UINT, 2049, 255, 2, 1, 0x120000 },
   { PIPE_FORMAT_S8_UINT, 2049, 255, 2, 12, 0x17d800 },
   { PIPE_FORMAT_S8_UINT, 2049, 256, 1, 1, 0x90000 },
   { PIPE_FORMAT_S8_UINT, 2049, 256, 1, 12, 0xc2c00 },
   { PIPE_FORMAT_S8_UINT, 2049, 256, 2, 1, 0x120000 },
   { PIPE_FORMAT_S8_UINT, 2049, 256, 2, 12, 0x185800 },
   { PIPE_FORMAT_S8_UINT, 2049, 257, 1, 1, 0xdc000 },
   { PIPE_FORMAT_S8_UINT, 2049, 257, 1, 12, 0x145680 },
   { PIPE_FORMAT_S8_UINT, 2049, 257, 2, 1, 0x1b8000 },
   { PIPE_FORMAT_S8_UINT, 2049, 257, 2, 12, 0x28ad00 },
   { PIPE_FORMAT_S8_UINT, 2049, 511, 1, 1, 0x120000 },
   { PIPE_FORMAT_S8_UINT, 2049, 511, 1, 12, 0x189680 },
   { PIPE_FORMAT_S8_UINT, 2049, 511, 2, 1, 0x240000 },
   { PIPE_FORMAT_S8_UINT, 2049, 511, 2, 12, 0x312d00 },
   { PIPE_FORMAT_S8_UINT, 2049, 512, 1, 1, 0x120000 },
   { PIPE_FORMAT_S8_UINT, 2049, 512, 1, 12, 0x18d680 },
   { PIPE_FORMAT_S8_UINT, 2049, 512, 2, 1, 0x240000 },
   { PIPE_FORMAT_S8_UINT, 2049, 512, 2, 12, 0x31ad00 },
   { PIPE_FORMAT_S8_UINT, 2049, 513, 1, 1, 0x174000 },
   { PIPE_FORMAT_S8_UINT, 2049, 513, 1, 12, 0x232b80 },
   { PIPE_FORMAT_S8_UINT, 2049, 513, 2, 1, 0x2e8000 },
   { PIPE_FORMAT_S8_UINT, 2049, 513, 2, 12, 0x465700 },
   { PIPE_FORMAT_S8_UINT, 2049, 1023, 1, 1, 0x240000 },
   { PIPE_FORMAT_S8_UINT, 2049, 1023, 1, 12, 0x316b80 },
   { PIPE_FORMAT_S8_UINT, 2049, 1023, 2, 1, 0x480000 },
   { PIPE_FORMAT_S8_UINT, 2049, 1023, 2, 12, 0x62d700 },
   { PIPE_FORMAT_S8_UINT, 2049, 1024, 1, 1, 0x240000 },
   { PIPE_FORMAT_S8_UINT, 2049, 1024, 1, 12, 0x31ab80 },
   { PIPE_FORMAT_S8_UINT, 2049, 1024, 2, 1, 0x480000 },
   { PIPE_FORMAT_S8_UINT, 2049, 1024, 2, 12, 0x635700 },
   { PIPE_FORMAT_S8_UINT, 2049, 1025, 1, 1, 0x2a4000 },
   { PIPE_FORMAT_S8_UINT, 2049, 1025, 1, 12, 0x3e1600 },
   { PIPE_FORMAT_S8_UINT, 2049, 1025, 2, 1, 0x548000 },
   { PIPE_FORMAT_S8_UINT, 2049, 1025, 2, 12, 0x7c2c00 },
   { PIPE_FORMAT_S8_UINT, 2049, 2047, 1, 1, 0x480000 },
   { PIPE_FORMAT_S8_UINT, 2049, 2047, 1, 12, 0x639600 },
   { PIPE_FORMAT_S8_UINT, 2049, 2047, 2, 1, 0x900000 },
   { PIPE_FORMAT_S8_UINT, 2049, 2047, 2, 12, 0xc72c00 },
   { PIPE_FORMAT_S8_UINT, 2049, 2048, 1, 1, 0x480000 },
   { PIPE_FORMAT_S8_UINT, 2049, 2048, 1, 12, 0x63d600 },
   { PIPE_FORMAT_S8_UINT, 2049, 2048, 2, 1, 0x900000 },
   { PIPE_FORMAT_S8_UINT, 2049, 2048, 2, 12, 0xc7ac00 },
   { PIPE_FORMAT_S8_UINT, 2049, 2049, 1, 1, 0x504000 },
   { PIPE_FORMAT_S8_UINT, 2049, 2049, 1, 12, 0x736b00 },
   { PIPE_FORMAT_S8_UINT, 2049, 2049, 2, 1, 0xa08000 },
   { PIPE_FORMAT_S8_UINT, 2049, 2049, 2, 12, 0xe6d600 },
   { PIPE_FORMAT_S8_UINT, 2049, 4095, 1, 1, 0x900000 },
   { PIPE_FORMAT_S8_UINT, 2049, 4095, 1, 12, 0xc76b80 },
   { PIPE_FORMAT_S8_UINT, 2049, 4095, 2, 1, 0x1200000 },
   { PIPE_FORMAT_S8_UINT, 2049, 4095, 2, 12, 0x18ed700 },
   { PIPE_FORMAT_S8_UINT, 2049, 4096, 1, 1, 0x900000 },
   { PIPE_FORMAT_S8_UINT, 2049, 4096, 1, 13, 0xc76b80 },
   { PIPE_FORMAT_S8_UINT, 2049, 4096, 2, 1, 0x1200000 },
   { PIPE_FORMAT_S8_UINT, 2049, 4096, 2, 13, 0x18ed700 },
   { PIPE_FORMAT_S8_UINT, 2049, 4097, 1, 1, 0x9c4000 },
   { PIPE_FORMAT_S8_UINT, 2049, 4097, 1, 13, 0xdc5600 },
   { PIPE_FORMAT_S8_UINT, 2049, 4097, 2, 1, 0x1388000 },
   { PIPE_FORMAT_S8_UINT, 2049, 4097, 2, 13, 0x1b8ac00 },
   { PIPE_FORMAT_S8_UINT, 4095, 16, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 4095, 16, 1, 12, 0x19180 },
   { PIPE_FORMAT_S8_UINT, 4095, 16, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 4095, 16, 2, 12, 0x32300 },
   { PIPE_FORMAT_S8_UINT, 4095, 17, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 4095, 17, 1, 12, 0x2d980 },
   { PIPE_FORMAT_S8_UINT, 4095, 17, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 4095, 17, 2, 12, 0x5b300 },
   { PIPE_FORMAT_S8_UINT, 4095, 31, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 4095, 31, 1, 12, 0x2d980 },
   { PIPE_FORMAT_S8_UINT, 4095, 31, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 4095, 31, 2, 12, 0x5b300 },
   { PIPE_FORMAT_S8_UINT, 4095, 32, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 4095, 32, 1, 12, 0x2d980 },
   { PIPE_FORMAT_S8_UINT, 4095, 32, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 4095, 32, 2, 12, 0x5b300 },
   { PIPE_FORMAT_S8_UINT, 4095, 33, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 4095, 33, 1, 12, 0x5ad80 },
   { PIPE_FORMAT_S8_UINT, 4095, 33, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 4095, 33, 2, 12, 0xb5b00 },
   { PIPE_FORMAT_S8_UINT, 4095, 63, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 4095, 63, 1, 12, 0x5ad80 },
   { PIPE_FORMAT_S8_UINT, 4095, 63, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 4095, 63, 2, 12, 0xb5b00 },
   { PIPE_FORMAT_S8_UINT, 4095, 64, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 4095, 64, 1, 12, 0x5ad80 },
   { PIPE_FORMAT_S8_UINT, 4095, 64, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 4095, 64, 2, 12, 0xb5b00 },
   { PIPE_FORMAT_S8_UINT, 4095, 65, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 4095, 65, 1, 12, 0xb1780 },
   { PIPE_FORMAT_S8_UINT, 4095, 65, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 4095, 65, 2, 12, 0x162f00 },
   { PIPE_FORMAT_S8_UINT, 4095, 127, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 4095, 127, 1, 12, 0xb1780 },
   { PIPE_FORMAT_S8_UINT, 4095, 127, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 4095, 127, 2, 12, 0x162f00 },
   { PIPE_FORMAT_S8_UINT, 4095, 128, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 4095, 128, 1, 12, 0xb1780 },
   { PIPE_FORMAT_S8_UINT, 4095, 128, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 4095, 128, 2, 12, 0x162f00 },
   { PIPE_FORMAT_S8_UINT, 4095, 129, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 4095, 129, 1, 12, 0x136c80 },
   { PIPE_FORMAT_S8_UINT, 4095, 129, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 4095, 129, 2, 12, 0x26d900 },
   { PIPE_FORMAT_S8_UINT, 4095, 255, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 4095, 255, 1, 12, 0x162c80 },
   { PIPE_FORMAT_S8_UINT, 4095, 255, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 4095, 255, 2, 12, 0x2c5900 },
   { PIPE_FORMAT_S8_UINT, 4095, 256, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 4095, 256, 1, 12, 0x162c80 },
   { PIPE_FORMAT_S8_UINT, 4095, 256, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 4095, 256, 2, 12, 0x2c5900 },
   { PIPE_FORMAT_S8_UINT, 4095, 257, 1, 1, 0x190000 },
   { PIPE_FORMAT_S8_UINT, 4095, 257, 1, 12, 0x24d700 },
   { PIPE_FORMAT_S8_UINT, 4095, 257, 2, 1, 0x320000 },
   { PIPE_FORMAT_S8_UINT, 4095, 257, 2, 12, 0x49ae00 },
   { PIPE_FORMAT_S8_UINT, 4095, 511, 1, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 4095, 511, 1, 12, 0x2c1700 },
   { PIPE_FORMAT_S8_UINT, 4095, 511, 2, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 4095, 511, 2, 12, 0x582e00 },
   { PIPE_FORMAT_S8_UINT, 4095, 512, 1, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 4095, 512, 1, 12, 0x2c1700 },
   { PIPE_FORMAT_S8_UINT, 4095, 512, 2, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 4095, 512, 2, 12, 0x582e00 },
   { PIPE_FORMAT_S8_UINT, 4095, 513, 1, 1, 0x2a0000 },
   { PIPE_FORMAT_S8_UINT, 4095, 513, 1, 12, 0x3dec00 },
   { PIPE_FORMAT_S8_UINT, 4095, 513, 2, 1, 0x540000 },
   { PIPE_FORMAT_S8_UINT, 4095, 513, 2, 12, 0x7bd800 },
   { PIPE_FORMAT_S8_UINT, 4095, 1023, 1, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 4095, 1023, 1, 12, 0x582c00 },
   { PIPE_FORMAT_S8_UINT, 4095, 1023, 2, 1, 0x840000 },
   { PIPE_FORMAT_S8_UINT, 4095, 1023, 2, 12, 0xb05800 },
   { PIPE_FORMAT_S8_UINT, 4095, 1024, 1, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 4095, 1024, 1, 12, 0x582c00 },
   { PIPE_FORMAT_S8_UINT, 4095, 1024, 2, 1, 0x840000 },
   { PIPE_FORMAT_S8_UINT, 4095, 1024, 2, 12, 0xb05800 },
   { PIPE_FORMAT_S8_UINT, 4095, 1025, 1, 1, 0x4c0000 },
   { PIPE_FORMAT_S8_UINT, 4095, 1025, 1, 12, 0x6c5680 },
   { PIPE_FORMAT_S8_UINT, 4095, 1025, 2, 1, 0x980000 },
   { PIPE_FORMAT_S8_UINT, 4095, 1025, 2, 12, 0xd8ad00 },
   { PIPE_FORMAT_S8_UINT, 4095, 2047, 1, 1, 0x840000 },
   { PIPE_FORMAT_S8_UINT, 4095, 2047, 1, 12, 0xb01680 },
   { PIPE_FORMAT_S8_UINT, 4095, 2047, 2, 1, 0x1080000 },
   { PIPE_FORMAT_S8_UINT, 4095, 2047, 2, 12, 0x1602d00 },
   { PIPE_FORMAT_S8_UINT, 4095, 2048, 1, 1, 0x840000 },
   { PIPE_FORMAT_S8_UINT, 4095, 2048, 1, 12, 0xb01680 },
   { PIPE_FORMAT_S8_UINT, 4095, 2048, 2, 1, 0x1080000 },
   { PIPE_FORMAT_S8_UINT, 4095, 2048, 2, 12, 0x1602d00 },
   { PIPE_FORMAT_S8_UINT, 4095, 2049, 1, 1, 0x900000 },
   { PIPE_FORMAT_S8_UINT, 4095, 2049, 1, 12, 0xc76b80 },
   { PIPE_FORMAT_S8_UINT, 4095, 2049, 2, 1, 0x1200000 },
   { PIPE_FORMAT_S8_UINT, 4095, 2049, 2, 12, 0x18ed700 },
   { PIPE_FORMAT_S8_UINT, 4095, 4095, 1, 1, 0x1080000 },
   { PIPE_FORMAT_S8_UINT, 4095, 4095, 1, 12, 0x1602b80 },
   { PIPE_FORMAT_S8_UINT, 4095, 4095, 2, 1, 0x2100000 },
   { PIPE_FORMAT_S8_UINT, 4095, 4095, 2, 12, 0x2c05700 },
   { PIPE_FORMAT_S8_UINT, 4095, 4096, 1, 1, 0x1080000 },
   { PIPE_FORMAT_S8_UINT, 4095, 4096, 1, 13, 0x1602b80 },
   { PIPE_FORMAT_S8_UINT, 4095, 4096, 2, 1, 0x2100000 },
   { PIPE_FORMAT_S8_UINT, 4095, 4096, 2, 13, 0x2c05700 },
   { PIPE_FORMAT_S8_UINT, 4095, 4097, 1, 1, 0x1180000 },
   { PIPE_FORMAT_S8_UINT, 4095, 4097, 1, 13, 0x17cd600 },
   { PIPE_FORMAT_S8_UINT, 4095, 4097, 2, 1, 0x2300000 },
   { PIPE_FORMAT_S8_UINT, 4095, 4097, 2, 13, 0x2f9ac00 },
   { PIPE_FORMAT_S8_UINT, 4096, 16, 1, 1, 0x10800 },
   { PIPE_FORMAT_S8_UINT, 4096, 16, 1, 13, 0x19180 },
   { PIPE_FORMAT_S8_UINT, 4096, 16, 2, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 4096, 16, 2, 13, 0x32300 },
   { PIPE_FORMAT_S8_UINT, 4096, 17, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 4096, 17, 1, 13, 0x2d980 },
   { PIPE_FORMAT_S8_UINT, 4096, 17, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 4096, 17, 2, 13, 0x5b300 },
   { PIPE_FORMAT_S8_UINT, 4096, 31, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 4096, 31, 1, 13, 0x2d980 },
   { PIPE_FORMAT_S8_UINT, 4096, 31, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 4096, 31, 2, 13, 0x5b300 },
   { PIPE_FORMAT_S8_UINT, 4096, 32, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 4096, 32, 1, 13, 0x2d980 },
   { PIPE_FORMAT_S8_UINT, 4096, 32, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 4096, 32, 2, 13, 0x5b300 },
   { PIPE_FORMAT_S8_UINT, 4096, 33, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 4096, 33, 1, 13, 0x5ad80 },
   { PIPE_FORMAT_S8_UINT, 4096, 33, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 4096, 33, 2, 13, 0xb5b00 },
   { PIPE_FORMAT_S8_UINT, 4096, 63, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 4096, 63, 1, 13, 0x5ad80 },
   { PIPE_FORMAT_S8_UINT, 4096, 63, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 4096, 63, 2, 13, 0xb5b00 },
   { PIPE_FORMAT_S8_UINT, 4096, 64, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 4096, 64, 1, 13, 0x5ad80 },
   { PIPE_FORMAT_S8_UINT, 4096, 64, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 4096, 64, 2, 13, 0xb5b00 },
   { PIPE_FORMAT_S8_UINT, 4096, 65, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 4096, 65, 1, 13, 0xb1780 },
   { PIPE_FORMAT_S8_UINT, 4096, 65, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 4096, 65, 2, 13, 0x162f00 },
   { PIPE_FORMAT_S8_UINT, 4096, 127, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 4096, 127, 1, 13, 0xb1780 },
   { PIPE_FORMAT_S8_UINT, 4096, 127, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 4096, 127, 2, 13, 0x162f00 },
   { PIPE_FORMAT_S8_UINT, 4096, 128, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 4096, 128, 1, 13, 0xb1780 },
   { PIPE_FORMAT_S8_UINT, 4096, 128, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 4096, 128, 2, 13, 0x162f00 },
   { PIPE_FORMAT_S8_UINT, 4096, 129, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 4096, 129, 1, 13, 0x136c80 },
   { PIPE_FORMAT_S8_UINT, 4096, 129, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 4096, 129, 2, 13, 0x26d900 },
   { PIPE_FORMAT_S8_UINT, 4096, 255, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 4096, 255, 1, 13, 0x162c80 },
   { PIPE_FORMAT_S8_UINT, 4096, 255, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 4096, 255, 2, 13, 0x2c5900 },
   { PIPE_FORMAT_S8_UINT, 4096, 256, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 4096, 256, 1, 13, 0x162c80 },
   { PIPE_FORMAT_S8_UINT, 4096, 256, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 4096, 256, 2, 13, 0x2c5900 },
   { PIPE_FORMAT_S8_UINT, 4096, 257, 1, 1, 0x190000 },
   { PIPE_FORMAT_S8_UINT, 4096, 257, 1, 13, 0x24d700 },
   { PIPE_FORMAT_S8_UINT, 4096, 257, 2, 1, 0x320000 },
   { PIPE_FORMAT_S8_UINT, 4096, 257, 2, 13, 0x49ae00 },
   { PIPE_FORMAT_S8_UINT, 4096, 511, 1, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 4096, 511, 1, 13, 0x2c1700 },
   { PIPE_FORMAT_S8_UINT, 4096, 511, 2, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 4096, 511, 2, 13, 0x582e00 },
   { PIPE_FORMAT_S8_UINT, 4096, 512, 1, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 4096, 512, 1, 13, 0x2c1700 },
   { PIPE_FORMAT_S8_UINT, 4096, 512, 2, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 4096, 512, 2, 13, 0x582e00 },
   { PIPE_FORMAT_S8_UINT, 4096, 513, 1, 1, 0x2a0000 },
   { PIPE_FORMAT_S8_UINT, 4096, 513, 1, 13, 0x3dec00 },
   { PIPE_FORMAT_S8_UINT, 4096, 513, 2, 1, 0x540000 },
   { PIPE_FORMAT_S8_UINT, 4096, 513, 2, 13, 0x7bd800 },
   { PIPE_FORMAT_S8_UINT, 4096, 1023, 1, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 4096, 1023, 1, 13, 0x582c00 },
   { PIPE_FORMAT_S8_UINT, 4096, 1023, 2, 1, 0x840000 },
   { PIPE_FORMAT_S8_UINT, 4096, 1023, 2, 13, 0xb05800 },
   { PIPE_FORMAT_S8_UINT, 4096, 1024, 1, 1, 0x420000 },
   { PIPE_FORMAT_S8_UINT, 4096, 1024, 1, 13, 0x582c00 },
   { PIPE_FORMAT_S8_UINT, 4096, 1024, 2, 1, 0x840000 },
   { PIPE_FORMAT_S8_UINT, 4096, 1024, 2, 13, 0xb05800 },
   { PIPE_FORMAT_S8_UINT, 4096, 1025, 1, 1, 0x4c0000 },
   { PIPE_FORMAT_S8_UINT, 4096, 1025, 1, 13, 0x6c5680 },
   { PIPE_FORMAT_S8_UINT, 4096, 1025, 2, 1, 0x980000 },
   { PIPE_FORMAT_S8_UINT, 4096, 1025, 2, 13, 0xd8ad00 },
   { PIPE_FORMAT_S8_UINT, 4096, 2047, 1, 1, 0x840000 },
   { PIPE_FORMAT_S8_UINT, 4096, 2047, 1, 13, 0xb01680 },
   { PIPE_FORMAT_S8_UINT, 4096, 2047, 2, 1, 0x1080000 },
   { PIPE_FORMAT_S8_UINT, 4096, 2047, 2, 13, 0x1602d00 },
   { PIPE_FORMAT_S8_UINT, 4096, 2048, 1, 1, 0x840000 },
   { PIPE_FORMAT_S8_UINT, 4096, 2048, 1, 13, 0xb01680 },
   { PIPE_FORMAT_S8_UINT, 4096, 2048, 2, 1, 0x1080000 },
   { PIPE_FORMAT_S8_UINT, 4096, 2048, 2, 13, 0x1602d00 },
   { PIPE_FORMAT_S8_UINT, 4096, 2049, 1, 1, 0x900000 },
   { PIPE_FORMAT_S8_UINT, 4096, 2049, 1, 13, 0xc76b80 },
   { PIPE_FORMAT_S8_UINT, 4096, 2049, 2, 1, 0x1200000 },
   { PIPE_FORMAT_S8_UINT, 4096, 2049, 2, 13, 0x18ed700 },
   { PIPE_FORMAT_S8_UINT, 4096, 4095, 1, 1, 0x1080000 },
   { PIPE_FORMAT_S8_UINT, 4096, 4095, 1, 13, 0x1602b80 },
   { PIPE_FORMAT_S8_UINT, 4096, 4095, 2, 1, 0x2100000 },
   { PIPE_FORMAT_S8_UINT, 4096, 4095, 2, 13, 0x2c05700 },
   { PIPE_FORMAT_S8_UINT, 4096, 4096, 1, 1, 0x1080000 },
   { PIPE_FORMAT_S8_UINT, 4096, 4096, 1, 13, 0x1602b80 },
   { PIPE_FORMAT_S8_UINT, 4096, 4096, 2, 1, 0x2100000 },
   { PIPE_FORMAT_S8_UINT, 4096, 4096, 2, 13, 0x2c05700 },
   { PIPE_FORMAT_S8_UINT, 4096, 4097, 1, 1, 0x1180000 },
   { PIPE_FORMAT_S8_UINT, 4096, 4097, 1, 13, 0x17d1600 },
   { PIPE_FORMAT_S8_UINT, 4096, 4097, 2, 1, 0x2300000 },
   { PIPE_FORMAT_S8_UINT, 4096, 4097, 2, 13, 0x2fa2c00 },
   { PIPE_FORMAT_S8_UINT, 4097, 16, 1, 1, 0x21000 },
   { PIPE_FORMAT_S8_UINT, 4097, 16, 1, 13, 0x2e100 },
   { PIPE_FORMAT_S8_UINT, 4097, 16, 2, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 4097, 16, 2, 13, 0x5c200 },
   { PIPE_FORMAT_S8_UINT, 4097, 17, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 4097, 17, 1, 13, 0x5b100 },
   { PIPE_FORMAT_S8_UINT, 4097, 17, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 4097, 17, 2, 13, 0xb6200 },
   { PIPE_FORMAT_S8_UINT, 4097, 31, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 4097, 31, 1, 13, 0x5b100 },
   { PIPE_FORMAT_S8_UINT, 4097, 31, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 4097, 31, 2, 13, 0xb6200 },
   { PIPE_FORMAT_S8_UINT, 4097, 32, 1, 1, 0x42000 },
   { PIPE_FORMAT_S8_UINT, 4097, 32, 1, 13, 0x5b100 },
   { PIPE_FORMAT_S8_UINT, 4097, 32, 2, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 4097, 32, 2, 13, 0xb6200 },
   { PIPE_FORMAT_S8_UINT, 4097, 33, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 4097, 33, 1, 13, 0xb1900 },
   { PIPE_FORMAT_S8_UINT, 4097, 33, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 4097, 33, 2, 13, 0x163200 },
   { PIPE_FORMAT_S8_UINT, 4097, 63, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 4097, 63, 1, 13, 0xb1900 },
   { PIPE_FORMAT_S8_UINT, 4097, 63, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 4097, 63, 2, 13, 0x163200 },
   { PIPE_FORMAT_S8_UINT, 4097, 64, 1, 1, 0x84000 },
   { PIPE_FORMAT_S8_UINT, 4097, 64, 1, 13, 0xb1900 },
   { PIPE_FORMAT_S8_UINT, 4097, 64, 2, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 4097, 64, 2, 13, 0x163200 },
   { PIPE_FORMAT_S8_UINT, 4097, 65, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 4097, 65, 1, 13, 0x162d00 },
   { PIPE_FORMAT_S8_UINT, 4097, 65, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 4097, 65, 2, 13, 0x2c5a00 },
   { PIPE_FORMAT_S8_UINT, 4097, 127, 1, 1, 0x108000 },
   { PIPE_FORMAT_S8_UINT, 4097, 127, 1, 13, 0x162d00 },
   { PIPE_FORMAT_S8_UINT, 4097, 127, 2, 1, 0x210000 },
   { PIPE_FORMAT_S8_UINT, 4097, 127, 2, 13, 0x2c5a00 },
   { PIPE_FORMAT_S8_UINT, 4097, 128, 1, 1, 0x8c000 },
   { PIPE_FORMAT_S8_UINT, 4097, 128, 1, 13, 0xbad00 },
   { PIPE_FORMAT_S8_UINT, 4097, 128, 2, 1, 0x118000 },
   { PIPE_FORMAT_S8_UINT, 4097, 128, 2, 13, 0x175a00 },
   { PIPE_FORMAT_S8_UINT, 4097, 129, 1, 1, 0x118000 },
   { PIPE_FORMAT_S8_UINT, 4097, 129, 1, 13, 0x149700 },
   { PIPE_FORMAT_S8_UINT, 4097, 129, 2, 1, 0x230000 },
   { PIPE_FORMAT_S8_UINT, 4097, 129, 2, 13, 0x292e00 },
   { PIPE_FORMAT_S8_UINT, 4097, 255, 1, 1, 0x118000 },
   { PIPE_FORMAT_S8_UINT, 4097, 255, 1, 13, 0x175700 },
   { PIPE_FORMAT_S8_UINT, 4097, 255, 2, 1, 0x230000 },
   { PIPE_FORMAT_S8_UINT, 4097, 255, 2, 13, 0x2eae00 },
   { PIPE_FORMAT_S8_UINT, 4097, 256, 1, 1, 0x118000 },
   { PIPE_FORMAT_S8_UINT, 4097, 256, 1, 13, 0x179700 },
   { PIPE_FORMAT_S8_UINT, 4097, 256, 2, 1, 0x230000 },
   { PIPE_FORMAT_S8_UINT, 4097, 256, 2, 13, 0x2f2e00 },
   { PIPE_FORMAT_S8_UINT, 4097, 257, 1, 1, 0x1ac000 },
   { PIPE_FORMAT_S8_UINT, 4097, 257, 1, 13, 0x276c00 },
   { PIPE_FORMAT_S8_UINT, 4097, 257, 2, 1, 0x358000 },
   { PIPE_FORMAT_S8_UINT, 4097, 257, 2, 13, 0x4ed800 },
   { PIPE_FORMAT_S8_UINT, 4097, 511, 1, 1, 0x230000 },
   { PIPE_FORMAT_S8_UINT, 4097, 511, 1, 13, 0x2f2c00 },
   { PIPE_FORMAT_S8_UINT, 4097, 511, 2, 1, 0x460000 },
   { PIPE_FORMAT_S8_UINT, 4097, 511, 2, 13, 0x5e5800 },
   { PIPE_FORMAT_S8_UINT, 4097, 512, 1, 1, 0x230000 },
   { PIPE_FORMAT_S8_UINT, 4097, 512, 1, 13, 0x2f6c00 },
   { PIPE_FORMAT_S8_UINT, 4097, 512, 2, 1, 0x460000 },
   { PIPE_FORMAT_S8_UINT, 4097, 512, 2, 13, 0x5ed800 },
   { PIPE_FORMAT_S8_UINT, 4097, 513, 1, 1, 0x2d4000 },
   { PIPE_FORMAT_S8_UINT, 4097, 513, 1, 13, 0x435680 },
   { PIPE_FORMAT_S8_UINT, 4097, 513, 2, 1, 0x5a8000 },
   { PIPE_FORMAT_S8_UINT, 4097, 513, 2, 13, 0x86ad00 },
   { PIPE_FORMAT_S8_UINT, 4097, 1023, 1, 1, 0x460000 },
   { PIPE_FORMAT_S8_UINT, 4097, 1023, 1, 13, 0x5ed680 },
   { PIPE_FORMAT_S8_UINT, 4097, 1023, 2, 1, 0x8c0000 },
   { PIPE_FORMAT_S8_UINT, 4097, 1023, 2, 13, 0xbdad00 },
   { PIPE_FORMAT_S8_UINT, 4097, 1024, 1, 1, 0x460000 },
   { PIPE_FORMAT_S8_UINT, 4097, 1024, 1, 13, 0x5f1680 },
   { PIPE_FORMAT_S8_UINT, 4097, 1024, 2, 1, 0x8c0000 },
   { PIPE_FORMAT_S8_UINT, 4097, 1024, 2, 13, 0xbe2d00 },
   { PIPE_FORMAT_S8_UINT, 4097, 1025, 1, 1, 0x524000 },
   { PIPE_FORMAT_S8_UINT, 4097, 1025, 1, 13, 0x76eb80 },
   { PIPE_FORMAT_S8_UINT, 4097, 1025, 2, 1, 0xa48000 },
   { PIPE_FORMAT_S8_UINT, 4097, 1025, 2, 13, 0xedd700 },
   { PIPE_FORMAT_S8_UINT, 4097, 2047, 1, 1, 0x8c0000 },
   { PIPE_FORMAT_S8_UINT, 4097, 2047, 1, 13, 0xbe2b80 },
   { PIPE_FORMAT_S8_UINT, 4097, 2047, 2, 1, 0x1180000 },
   { PIPE_FORMAT_S8_UINT, 4097, 2047, 2, 13, 0x17c5700 },
   { PIPE_FORMAT_S8_UINT, 4097, 2048, 1, 1, 0x8c0000 },
   { PIPE_FORMAT_S8_UINT, 4097, 2048, 1, 13, 0xbe6b80 },
   { PIPE_FORMAT_S8_UINT, 4097, 2048, 2, 1, 0x1180000 },
   { PIPE_FORMAT_S8_UINT, 4097, 2048, 2, 13, 0x17cd700 },
   { PIPE_FORMAT_S8_UINT, 4097, 2049, 1, 1, 0x9c4000 },
   { PIPE_FORMAT_S8_UINT, 4097, 2049, 1, 13, 0xdc5600 },
   { PIPE_FORMAT_S8_UINT, 4097, 2049, 2, 1, 0x1388000 },
   { PIPE_FORMAT_S8_UINT, 4097, 2049, 2, 13, 0x1b8ac00 },
   { PIPE_FORMAT_S8_UINT, 4097, 4095, 1, 1, 0x1180000 },
   { PIPE_FORMAT_S8_UINT, 4097, 4095, 1, 13, 0x17cd600 },
   { PIPE_FORMAT_S8_UINT, 4097, 4095, 2, 1, 0x2300000 },
   { PIPE_FORMAT_S8_UINT, 4097, 4095, 2, 13, 0x2f9ac00 },
   { PIPE_FORMAT_S8_UINT, 4097, 4096, 1, 1, 0x1180000 },
   { PIPE_FORMAT_S8_UINT, 4097, 4096, 1, 13, 0x17d1600 },
   { PIPE_FORMAT_S8_UINT, 4097, 4096, 2, 1, 0x2300000 },
   { PIPE_FORMAT_S8_UINT, 4097, 4096, 2, 13, 0x2fa2c00 },
   { PIPE_FORMAT_S8_UINT, 4097, 4097, 1, 1, 0x1304000 },
   { PIPE_FORMAT_S8_UINT, 4097, 4097, 1, 13, 0x1a66b00 },
   { PIPE_FORMAT_S8_UINT, 4097, 4097, 2, 1, 0x2608000 },
   { PIPE_FORMAT_S8_UINT, 4097, 4097, 2, 13, 0x34cd600 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 16, 1, 1, 0x480 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 16, 1, 5, 0x700 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 16, 2, 1, 0x900 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 16, 2, 5, 0xe00 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 17, 1, 1, 0x880 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 17, 1, 5, 0xc80 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 17, 2, 1, 0x1100 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 17, 2, 5, 0x1900 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 31, 1, 1, 0x880 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 31, 1, 5, 0xc80 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 31, 2, 1, 0x1100 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 31, 2, 5, 0x1900 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 32, 1, 1, 0x880 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 32, 1, 6, 0xd00 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 32, 2, 1, 0x1100 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 32, 2, 6, 0x1a00 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 33, 1, 1, 0x1080 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 33, 1, 6, 0x1780 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 33, 2, 1, 0x2100 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 33, 2, 6, 0x2f00 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 63, 1, 1, 0x1080 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 63, 1, 6, 0x1800 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 63, 2, 1, 0x2100 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 63, 2, 6, 0x3000 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 64, 1, 1, 0x1080 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 64, 1, 7, 0x1880 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 64, 2, 1, 0x2100 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 64, 2, 7, 0x3100 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 65, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 65, 1, 7, 0x2d80 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 65, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 65, 2, 7, 0x5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 127, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 127, 1, 7, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 127, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 127, 2, 7, 0x5c00 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 128, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 128, 1, 8, 0x2e80 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 128, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 128, 2, 8, 0x5d00 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 129, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 129, 1, 8, 0x8200 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 129, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 129, 2, 8, 0x10400 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 255, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 255, 1, 8, 0x8280 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 255, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 255, 2, 8, 0x10500 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 256, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 256, 1, 9, 0x8280 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 256, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 256, 2, 9, 0x10500 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 257, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 257, 1, 9, 0xc300 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 257, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 257, 2, 9, 0x18600 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 511, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 511, 1, 9, 0xc380 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 511, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 511, 2, 9, 0x18700 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 512, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 512, 1, 10, 0xc380 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 512, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 512, 2, 10, 0x18700 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 513, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 513, 1, 10, 0x18500 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 513, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 513, 2, 10, 0x30a00 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 1023, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 1023, 1, 10, 0x18580 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 1023, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 1023, 2, 10, 0x30b00 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 1024, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 1024, 1, 11, 0x18580 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 1024, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 1024, 2, 11, 0x30b00 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 1025, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 1025, 1, 11, 0x2c900 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 1025, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 1025, 2, 11, 0x59200 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 2047, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 2047, 1, 11, 0x2c980 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 2047, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 2047, 2, 11, 0x59300 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 2048, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 2048, 1, 12, 0x2c980 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 2048, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 2048, 2, 12, 0x59300 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 2049, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 2049, 1, 12, 0x59100 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 2049, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 2049, 2, 12, 0xb2200 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 4095, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 4095, 1, 12, 0x59180 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 4095, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 4095, 2, 12, 0xb2300 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 4096, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 4096, 1, 13, 0x59180 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 4096, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 4096, 2, 13, 0xb2300 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 4097, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 4097, 1, 13, 0xae100 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 4097, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 16, 4097, 2, 13, 0x15c200 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 16, 1, 1, 0x880 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 16, 1, 5, 0xc80 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 16, 2, 1, 0x1100 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 16, 2, 5, 0x1900 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 17, 1, 1, 0x1080 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 17, 1, 5, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 17, 2, 1, 0x2100 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 17, 2, 5, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 31, 1, 1, 0x1080 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 31, 1, 5, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 31, 2, 1, 0x2100 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 31, 2, 5, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 32, 1, 1, 0x1080 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 32, 1, 6, 0x1780 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 32, 2, 1, 0x2100 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 32, 2, 6, 0x2f00 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 33, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 33, 1, 6, 0x2c80 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 33, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 33, 2, 6, 0x5900 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 63, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 63, 1, 6, 0x2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 63, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 63, 2, 6, 0x5a00 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 64, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 64, 1, 7, 0x2d80 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 64, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 64, 2, 7, 0x5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 65, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 65, 1, 7, 0x8180 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 65, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 65, 2, 7, 0x10300 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 127, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 127, 1, 7, 0x8200 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 127, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 127, 2, 7, 0x10400 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 128, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 128, 1, 8, 0x8200 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 128, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 128, 2, 8, 0x10400 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 129, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 129, 1, 8, 0xc280 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 129, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 129, 2, 8, 0x18500 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 255, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 255, 1, 8, 0xc300 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 255, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 255, 2, 8, 0x18600 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 256, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 256, 1, 9, 0xc300 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 256, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 256, 2, 9, 0x18600 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 257, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 257, 1, 9, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 257, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 257, 2, 9, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 511, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 511, 1, 9, 0x18480 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 511, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 511, 2, 9, 0x30900 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 512, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 512, 1, 10, 0x18480 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 512, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 512, 2, 10, 0x30900 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 513, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 513, 1, 10, 0x2c700 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 513, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 513, 2, 10, 0x58e00 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 1023, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 1023, 1, 10, 0x2c780 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 1023, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 1023, 2, 10, 0x58f00 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 1024, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 1024, 1, 11, 0x2c780 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 1024, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 1024, 2, 11, 0x58f00 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 1025, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 1025, 1, 11, 0x58d00 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 1025, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 1025, 2, 11, 0xb1a00 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 2047, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 2047, 1, 11, 0x58d80 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 2047, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 2047, 2, 11, 0xb1b00 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 2048, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 2048, 1, 12, 0x58d80 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 2048, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 2048, 2, 12, 0xb1b00 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 2049, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 2049, 1, 12, 0xad900 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 2049, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 2049, 2, 12, 0x15b200 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 4095, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 4095, 1, 12, 0xad980 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 4095, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 4095, 2, 12, 0x15b300 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 4096, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 4096, 1, 13, 0xad980 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 4096, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 4096, 2, 13, 0x15b300 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 4097, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 4097, 1, 13, 0x15b100 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 4097, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 17, 4097, 2, 13, 0x2b6200 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 16, 1, 1, 0x880 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 16, 1, 5, 0xc80 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 16, 2, 1, 0x1100 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 16, 2, 5, 0x1900 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 17, 1, 1, 0x1080 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 17, 1, 5, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 17, 2, 1, 0x2100 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 17, 2, 5, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 31, 1, 1, 0x1080 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 31, 1, 5, 0x1700 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 31, 2, 1, 0x2100 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 31, 2, 5, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 32, 1, 1, 0x1080 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 32, 1, 6, 0x1780 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 32, 2, 1, 0x2100 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 32, 2, 6, 0x2f00 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 33, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 33, 1, 6, 0x2c80 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 33, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 33, 2, 6, 0x5900 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 63, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 63, 1, 6, 0x2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 63, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 63, 2, 6, 0x5a00 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 64, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 64, 1, 7, 0x2d80 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 64, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 64, 2, 7, 0x5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 65, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 65, 1, 7, 0x8180 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 65, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 65, 2, 7, 0x10300 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 127, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 127, 1, 7, 0x8200 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 127, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 127, 2, 7, 0x10400 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 128, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 128, 1, 8, 0x8200 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 128, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 128, 2, 8, 0x10400 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 129, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 129, 1, 8, 0xc280 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 129, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 129, 2, 8, 0x18500 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 255, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 255, 1, 8, 0xc300 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 255, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 255, 2, 8, 0x18600 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 256, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 256, 1, 9, 0xc300 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 256, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 256, 2, 9, 0x18600 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 257, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 257, 1, 9, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 257, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 257, 2, 9, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 511, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 511, 1, 9, 0x18480 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 511, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 511, 2, 9, 0x30900 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 512, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 512, 1, 10, 0x18480 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 512, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 512, 2, 10, 0x30900 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 513, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 513, 1, 10, 0x2c700 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 513, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 513, 2, 10, 0x58e00 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 1023, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 1023, 1, 10, 0x2c780 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 1023, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 1023, 2, 10, 0x58f00 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 1024, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 1024, 1, 11, 0x2c780 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 1024, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 1024, 2, 11, 0x58f00 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 1025, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 1025, 1, 11, 0x58d00 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 1025, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 1025, 2, 11, 0xb1a00 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 2047, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 2047, 1, 11, 0x58d80 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 2047, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 2047, 2, 11, 0xb1b00 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 2048, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 2048, 1, 12, 0x58d80 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 2048, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 2048, 2, 12, 0xb1b00 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 2049, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 2049, 1, 12, 0xad900 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 2049, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 2049, 2, 12, 0x15b200 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 4095, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 4095, 1, 12, 0xad980 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 4095, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 4095, 2, 12, 0x15b300 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 4096, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 4096, 1, 13, 0xad980 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 4096, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 4096, 2, 13, 0x15b300 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 4097, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 4097, 1, 13, 0x15b100 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 4097, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 31, 4097, 2, 13, 0x2b6200 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 16, 1, 1, 0x880 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 16, 1, 6, 0xd00 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 16, 2, 1, 0x1100 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 16, 2, 6, 0x1a00 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 17, 1, 1, 0x1080 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 17, 1, 6, 0x1780 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 17, 2, 1, 0x2100 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 17, 2, 6, 0x2f00 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 31, 1, 1, 0x1080 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 31, 1, 6, 0x1780 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 31, 2, 1, 0x2100 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 31, 2, 6, 0x2f00 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 32, 1, 1, 0x1080 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 32, 1, 6, 0x1780 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 32, 2, 1, 0x2100 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 32, 2, 6, 0x2f00 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 33, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 33, 1, 6, 0x2c80 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 33, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 33, 2, 6, 0x5900 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 63, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 63, 1, 6, 0x2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 63, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 63, 2, 6, 0x5a00 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 64, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 64, 1, 7, 0x2d80 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 64, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 64, 2, 7, 0x5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 65, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 65, 1, 7, 0x8180 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 65, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 65, 2, 7, 0x10300 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 127, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 127, 1, 7, 0x8200 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 127, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 127, 2, 7, 0x10400 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 128, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 128, 1, 8, 0x8200 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 128, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 128, 2, 8, 0x10400 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 129, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 129, 1, 8, 0xc280 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 129, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 129, 2, 8, 0x18500 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 255, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 255, 1, 8, 0xc300 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 255, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 255, 2, 8, 0x18600 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 256, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 256, 1, 9, 0xc300 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 256, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 256, 2, 9, 0x18600 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 257, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 257, 1, 9, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 257, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 257, 2, 9, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 511, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 511, 1, 9, 0x18480 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 511, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 511, 2, 9, 0x30900 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 512, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 512, 1, 10, 0x18480 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 512, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 512, 2, 10, 0x30900 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 513, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 513, 1, 10, 0x2c700 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 513, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 513, 2, 10, 0x58e00 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 1023, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 1023, 1, 10, 0x2c780 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 1023, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 1023, 2, 10, 0x58f00 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 1024, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 1024, 1, 11, 0x2c780 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 1024, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 1024, 2, 11, 0x58f00 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 1025, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 1025, 1, 11, 0x58d00 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 1025, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 1025, 2, 11, 0xb1a00 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 2047, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 2047, 1, 11, 0x58d80 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 2047, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 2047, 2, 11, 0xb1b00 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 2048, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 2048, 1, 12, 0x58d80 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 2048, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 2048, 2, 12, 0xb1b00 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 2049, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 2049, 1, 12, 0xad900 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 2049, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 2049, 2, 12, 0x15b200 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 4095, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 4095, 1, 12, 0xad980 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 4095, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 4095, 2, 12, 0x15b300 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 4096, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 4096, 1, 13, 0xad980 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 4096, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 4096, 2, 13, 0x15b300 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 4097, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 4097, 1, 13, 0x15b100 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 4097, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 32, 4097, 2, 13, 0x2b6200 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 16, 1, 6, 0x1780 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 16, 2, 1, 0x2100 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 16, 2, 6, 0x2f00 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 17, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 17, 1, 6, 0x2c80 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 17, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 17, 2, 6, 0x5900 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 31, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 31, 1, 6, 0x2c80 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 31, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 31, 2, 6, 0x5900 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 32, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 32, 1, 6, 0x2c80 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 32, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 32, 2, 6, 0x5900 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 33, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 33, 1, 6, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 33, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 33, 2, 6, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 63, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 63, 1, 6, 0x8180 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 63, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 63, 2, 6, 0x10300 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 64, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 64, 1, 7, 0x8180 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 64, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 64, 2, 7, 0x10300 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 65, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 65, 1, 7, 0xc200 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 65, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 65, 2, 7, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 127, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 127, 1, 7, 0xc280 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 127, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 127, 2, 7, 0x18500 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 128, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 128, 1, 8, 0xc280 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 128, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 128, 2, 8, 0x18500 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 129, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 129, 1, 8, 0x18380 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 129, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 129, 2, 8, 0x30700 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 255, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 255, 1, 8, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 255, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 255, 2, 8, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 256, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 256, 1, 9, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 256, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 256, 2, 9, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 257, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 257, 1, 9, 0x2c680 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 257, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 257, 2, 9, 0x58d00 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 511, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 511, 1, 9, 0x2c700 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 511, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 511, 2, 9, 0x58e00 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 512, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 512, 1, 10, 0x2c700 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 512, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 512, 2, 10, 0x58e00 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 513, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 513, 1, 10, 0x58c00 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 513, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 513, 2, 10, 0xb1800 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 1023, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 1023, 1, 10, 0x58c80 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 1023, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 1023, 2, 10, 0xb1900 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 1024, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 1024, 1, 11, 0x58c80 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 1024, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 1024, 2, 11, 0xb1900 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 1025, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 1025, 1, 11, 0xad700 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 1025, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 1025, 2, 11, 0x15ae00 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 2047, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 2047, 1, 11, 0xad780 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 2047, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 2047, 2, 11, 0x15af00 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 2048, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 2048, 1, 12, 0xad780 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 2048, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 2048, 2, 12, 0x15af00 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 2049, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 2049, 1, 12, 0x15ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 2049, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 2049, 2, 12, 0x2b5a00 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 4095, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 4095, 1, 12, 0x15ad80 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 4095, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 4095, 2, 12, 0x2b5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 4096, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 4096, 1, 13, 0x15ad80 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 4096, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 4096, 2, 13, 0x2b5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 4097, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 4097, 1, 13, 0x2b1900 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 4097, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 33, 4097, 2, 13, 0x563200 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 16, 1, 6, 0x1800 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 16, 2, 1, 0x2100 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 16, 2, 6, 0x3000 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 17, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 17, 1, 6, 0x2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 17, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 17, 2, 6, 0x5a00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 31, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 31, 1, 6, 0x2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 31, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 31, 2, 6, 0x5a00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 32, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 32, 1, 6, 0x2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 32, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 32, 2, 6, 0x5a00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 33, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 33, 1, 6, 0x8180 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 33, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 33, 2, 6, 0x10300 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 63, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 63, 1, 6, 0x8180 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 63, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 63, 2, 6, 0x10300 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 64, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 64, 1, 7, 0x8180 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 64, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 64, 2, 7, 0x10300 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 65, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 65, 1, 7, 0xc200 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 65, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 65, 2, 7, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 127, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 127, 1, 7, 0xc280 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 127, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 127, 2, 7, 0x18500 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 128, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 128, 1, 8, 0xc280 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 128, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 128, 2, 8, 0x18500 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 129, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 129, 1, 8, 0x18380 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 129, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 129, 2, 8, 0x30700 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 255, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 255, 1, 8, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 255, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 255, 2, 8, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 256, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 256, 1, 9, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 256, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 256, 2, 9, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 257, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 257, 1, 9, 0x2c680 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 257, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 257, 2, 9, 0x58d00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 511, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 511, 1, 9, 0x2c700 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 511, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 511, 2, 9, 0x58e00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 512, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 512, 1, 10, 0x2c700 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 512, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 512, 2, 10, 0x58e00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 513, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 513, 1, 10, 0x58c00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 513, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 513, 2, 10, 0xb1800 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 1023, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 1023, 1, 10, 0x58c80 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 1023, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 1023, 2, 10, 0xb1900 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 1024, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 1024, 1, 11, 0x58c80 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 1024, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 1024, 2, 11, 0xb1900 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 1025, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 1025, 1, 11, 0xad700 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 1025, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 1025, 2, 11, 0x15ae00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 2047, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 2047, 1, 11, 0xad780 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 2047, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 2047, 2, 11, 0x15af00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 2048, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 2048, 1, 12, 0xad780 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 2048, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 2048, 2, 12, 0x15af00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 2049, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 2049, 1, 12, 0x15ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 2049, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 2049, 2, 12, 0x2b5a00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 4095, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 4095, 1, 12, 0x15ad80 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 4095, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 4095, 2, 12, 0x2b5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 4096, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 4096, 1, 13, 0x15ad80 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 4096, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 4096, 2, 13, 0x2b5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 4097, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 4097, 1, 13, 0x2b1900 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 4097, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 63, 4097, 2, 13, 0x563200 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 16, 1, 1, 0x1080 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 16, 1, 7, 0x1880 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 16, 2, 1, 0x2100 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 16, 2, 7, 0x3100 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 17, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 17, 1, 7, 0x2d80 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 17, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 17, 2, 7, 0x5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 31, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 31, 1, 7, 0x2d80 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 31, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 31, 2, 7, 0x5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 32, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 32, 1, 7, 0x2d80 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 32, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 32, 2, 7, 0x5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 33, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 33, 1, 7, 0x8180 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 33, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 33, 2, 7, 0x10300 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 63, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 63, 1, 7, 0x8180 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 63, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 63, 2, 7, 0x10300 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 64, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 64, 1, 7, 0x8180 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 64, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 64, 2, 7, 0x10300 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 65, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 65, 1, 7, 0xc200 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 65, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 65, 2, 7, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 127, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 127, 1, 7, 0xc280 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 127, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 127, 2, 7, 0x18500 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 128, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 128, 1, 8, 0xc280 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 128, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 128, 2, 8, 0x18500 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 129, 1, 1, 0xc200 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 129, 1, 8, 0x10380 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 129, 2, 1, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 129, 2, 8, 0x20700 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 255, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 255, 1, 8, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 255, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 255, 2, 8, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 256, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 256, 1, 9, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 256, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 256, 2, 9, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 257, 1, 1, 0x14400 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 257, 1, 9, 0x1c680 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 257, 2, 1, 0x28800 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 257, 2, 9, 0x38d00 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 511, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 511, 1, 9, 0x2c700 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 511, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 511, 2, 9, 0x58e00 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 512, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 512, 1, 10, 0x2c700 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 512, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 512, 2, 10, 0x58e00 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 513, 1, 1, 0x24800 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 513, 1, 10, 0x30c00 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 513, 2, 1, 0x49000 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 513, 2, 10, 0x61800 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 1023, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 1023, 1, 10, 0x58c80 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 1023, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 1023, 2, 10, 0xb1900 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 1024, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 1024, 1, 11, 0x58c80 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 1024, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 1024, 2, 11, 0xb1900 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 1025, 1, 1, 0x45000 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 1025, 1, 11, 0x5d700 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 1025, 2, 1, 0x8a000 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 1025, 2, 11, 0xbae00 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 2047, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 2047, 1, 11, 0xad780 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 2047, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 2047, 2, 11, 0x15af00 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 2048, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 2048, 1, 12, 0xad780 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 2048, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 2048, 2, 12, 0x15af00 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 2049, 1, 1, 0x86000 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 2049, 1, 12, 0xb2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 2049, 2, 1, 0x10c000 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 2049, 2, 12, 0x165a00 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 4095, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 4095, 1, 12, 0x15ad80 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 4095, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 4095, 2, 12, 0x2b5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 4096, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 4096, 1, 13, 0x15ad80 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 4096, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 4096, 2, 13, 0x2b5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 4097, 1, 1, 0x108000 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 4097, 1, 13, 0x161900 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 4097, 2, 1, 0x210000 },
   { PIPE_FORMAT_Z32_FLOAT, 64, 4097, 2, 13, 0x2c3200 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 16, 1, 7, 0x2d80 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 16, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 16, 2, 7, 0x5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 17, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 17, 1, 7, 0x8180 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 17, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 17, 2, 7, 0x10300 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 31, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 31, 1, 7, 0x8180 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 31, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 31, 2, 7, 0x10300 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 32, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 32, 1, 7, 0x8180 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 32, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 32, 2, 7, 0x10300 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 33, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 33, 1, 7, 0xc200 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 33, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 33, 2, 7, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 63, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 63, 1, 7, 0xc200 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 63, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 63, 2, 7, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 64, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 64, 1, 7, 0xc200 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 64, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 64, 2, 7, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 65, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 65, 1, 7, 0x14300 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 65, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 65, 2, 7, 0x28600 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 127, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 127, 1, 7, 0x14380 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 127, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 127, 2, 7, 0x28700 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 128, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 128, 1, 8, 0x14380 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 128, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 128, 2, 8, 0x28700 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 129, 1, 1, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 129, 1, 8, 0x1c600 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 129, 2, 1, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 129, 2, 8, 0x38c00 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 255, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 255, 1, 8, 0x28680 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 255, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 255, 2, 8, 0x50d00 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 256, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 256, 1, 9, 0x28680 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 256, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 256, 2, 9, 0x50d00 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 257, 1, 1, 0x28800 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 257, 1, 9, 0x30b80 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 257, 2, 1, 0x51000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 257, 2, 9, 0x61700 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 511, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 511, 1, 9, 0x4cc00 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 511, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 511, 2, 9, 0x99800 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 512, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 512, 1, 10, 0x4cc00 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 512, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 512, 2, 10, 0x99800 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 513, 1, 1, 0x49000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 513, 1, 10, 0x55680 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 513, 2, 1, 0x92000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 513, 2, 10, 0xaad00 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 1023, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 1023, 1, 10, 0x99700 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 1023, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 1023, 2, 10, 0x132e00 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 1024, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 1024, 1, 11, 0x99700 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 1024, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 1024, 2, 11, 0x132e00 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 1025, 1, 1, 0x8a000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 1025, 1, 11, 0xa2c00 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 1025, 2, 1, 0x114000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 1025, 2, 11, 0x145800 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 2047, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 2047, 1, 11, 0x12ec80 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 2047, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 2047, 2, 11, 0x25d900 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 2048, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 2048, 1, 12, 0x12ec80 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 2048, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 2048, 2, 12, 0x25d900 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 2049, 1, 1, 0x10c000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 2049, 1, 12, 0x139700 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 2049, 2, 1, 0x218000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 2049, 2, 12, 0x272e00 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 4095, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 4095, 1, 12, 0x25d780 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 4095, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 4095, 2, 12, 0x4baf00 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 4096, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 4096, 1, 13, 0x25d780 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 4096, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 4096, 2, 13, 0x4baf00 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 4097, 1, 1, 0x210000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 4097, 1, 13, 0x26ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 4097, 2, 1, 0x420000 },
   { PIPE_FORMAT_Z32_FLOAT, 65, 4097, 2, 13, 0x4d5a00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 16, 1, 7, 0x2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 16, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 16, 2, 7, 0x5c00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 17, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 17, 1, 7, 0x8200 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 17, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 17, 2, 7, 0x10400 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 31, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 31, 1, 7, 0x8200 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 31, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 31, 2, 7, 0x10400 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 32, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 32, 1, 7, 0x8200 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 32, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 32, 2, 7, 0x10400 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 33, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 33, 1, 7, 0xc280 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 33, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 33, 2, 7, 0x18500 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 63, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 63, 1, 7, 0xc280 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 63, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 63, 2, 7, 0x18500 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 64, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 64, 1, 7, 0xc280 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 64, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 64, 2, 7, 0x18500 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 65, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 65, 1, 7, 0x14380 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 65, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 65, 2, 7, 0x28700 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 127, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 127, 1, 7, 0x18380 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 127, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 127, 2, 7, 0x30700 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 128, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 128, 1, 8, 0x18380 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 128, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 128, 2, 8, 0x30700 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 129, 1, 1, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 129, 1, 8, 0x20600 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 129, 2, 1, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 129, 2, 8, 0x40c00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 255, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 255, 1, 8, 0x2c680 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 255, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 255, 2, 8, 0x58d00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 256, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 256, 1, 9, 0x2c680 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 256, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 256, 2, 9, 0x58d00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 257, 1, 1, 0x28800 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 257, 1, 9, 0x34b80 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 257, 2, 1, 0x51000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 257, 2, 9, 0x69700 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 511, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 511, 1, 9, 0x58c00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 511, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 511, 2, 9, 0xb1800 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 512, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 512, 1, 10, 0x58c00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 512, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 512, 2, 10, 0xb1800 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 513, 1, 1, 0x49000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 513, 1, 10, 0x61680 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 513, 2, 1, 0x92000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 513, 2, 10, 0xc2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 1023, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 1023, 1, 10, 0xad700 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 1023, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 1023, 2, 10, 0x15ae00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 1024, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 1024, 1, 11, 0xad700 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 1024, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 1024, 2, 11, 0x15ae00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 1025, 1, 1, 0x8a000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 1025, 1, 11, 0xb6c00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 1025, 2, 1, 0x114000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 1025, 2, 11, 0x16d800 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 2047, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 2047, 1, 11, 0x15ac80 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 2047, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 2047, 2, 11, 0x2b5900 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 2048, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 2048, 1, 12, 0x15ac80 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 2048, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 2048, 2, 12, 0x2b5900 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 2049, 1, 1, 0x10c000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 2049, 1, 12, 0x165700 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 2049, 2, 1, 0x218000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 2049, 2, 12, 0x2cae00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 4095, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 4095, 1, 12, 0x2b1780 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 4095, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 4095, 2, 12, 0x562f00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 4096, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 4096, 1, 13, 0x2b1780 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 4096, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 4096, 2, 13, 0x562f00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 4097, 1, 1, 0x210000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 4097, 1, 13, 0x2bed00 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 4097, 2, 1, 0x420000 },
   { PIPE_FORMAT_Z32_FLOAT, 127, 4097, 2, 13, 0x57da00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 16, 1, 1, 0x2080 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 16, 1, 8, 0x2e80 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 16, 2, 1, 0x4100 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 16, 2, 8, 0x5d00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 17, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 17, 1, 8, 0x8200 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 17, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 17, 2, 8, 0x10400 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 31, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 31, 1, 8, 0x8200 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 31, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 31, 2, 8, 0x10400 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 32, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 32, 1, 8, 0x8200 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 32, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 32, 2, 8, 0x10400 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 33, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 33, 1, 8, 0xc280 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 33, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 33, 2, 8, 0x18500 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 63, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 63, 1, 8, 0xc280 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 63, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 63, 2, 8, 0x18500 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 64, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 64, 1, 8, 0xc280 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 64, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 64, 2, 8, 0x18500 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 65, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 65, 1, 8, 0x14380 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 65, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 65, 2, 8, 0x28700 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 127, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 127, 1, 8, 0x18380 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 127, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 127, 2, 8, 0x30700 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 128, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 128, 1, 8, 0x18380 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 128, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 128, 2, 8, 0x30700 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 129, 1, 1, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 129, 1, 8, 0x24600 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 129, 2, 1, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 129, 2, 8, 0x48c00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 255, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 255, 1, 8, 0x2c680 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 255, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 255, 2, 8, 0x58d00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 256, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 256, 1, 9, 0x2c680 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 256, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 256, 2, 9, 0x58d00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 257, 1, 1, 0x28800 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 257, 1, 9, 0x38b80 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 257, 2, 1, 0x51000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 257, 2, 9, 0x71700 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 511, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 511, 1, 9, 0x58c00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 511, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 511, 2, 9, 0xb1800 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 512, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 512, 1, 10, 0x58c00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 512, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 512, 2, 10, 0xb1800 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 513, 1, 1, 0x49000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 513, 1, 10, 0x65680 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 513, 2, 1, 0x92000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 513, 2, 10, 0xcad00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 1023, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 1023, 1, 10, 0xad700 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 1023, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 1023, 2, 10, 0x15ae00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 1024, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 1024, 1, 11, 0xad700 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 1024, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 1024, 2, 11, 0x15ae00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 1025, 1, 1, 0x8a000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 1025, 1, 11, 0xbac00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 1025, 2, 1, 0x114000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 1025, 2, 11, 0x175800 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 2047, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 2047, 1, 11, 0x15ac80 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 2047, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 2047, 2, 11, 0x2b5900 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 2048, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 2048, 1, 12, 0x15ac80 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 2048, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 2048, 2, 12, 0x2b5900 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 2049, 1, 1, 0x10c000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 2049, 1, 12, 0x169700 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 2049, 2, 1, 0x218000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 2049, 2, 12, 0x2d2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 4095, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 4095, 1, 12, 0x2b1780 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 4095, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 4095, 2, 12, 0x562f00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 4096, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 4096, 1, 13, 0x2b1780 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 4096, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 4096, 2, 13, 0x562f00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 4097, 1, 1, 0x210000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 4097, 1, 13, 0x2c2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 4097, 2, 1, 0x420000 },
   { PIPE_FORMAT_Z32_FLOAT, 128, 4097, 2, 13, 0x585a00 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 16, 1, 8, 0x8200 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 16, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 16, 2, 8, 0x10400 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 17, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 17, 1, 8, 0xc280 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 17, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 17, 2, 8, 0x18500 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 31, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 31, 1, 8, 0xc280 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 31, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 31, 2, 8, 0x18500 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 32, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 32, 1, 8, 0xc280 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 32, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 32, 2, 8, 0x18500 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 33, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 33, 1, 8, 0x18380 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 33, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 33, 2, 8, 0x30700 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 63, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 63, 1, 8, 0x18380 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 63, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 63, 2, 8, 0x30700 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 64, 1, 1, 0xc200 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 64, 1, 8, 0x10380 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 64, 2, 1, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 64, 2, 8, 0x20700 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 65, 1, 1, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 65, 1, 8, 0x1c600 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 65, 2, 1, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 65, 2, 8, 0x38c00 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 127, 1, 1, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 127, 1, 8, 0x20600 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 127, 2, 1, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 127, 2, 8, 0x40c00 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 128, 1, 1, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 128, 1, 8, 0x24600 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 128, 2, 1, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 128, 2, 8, 0x48c00 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 129, 1, 1, 0x24800 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 129, 1, 8, 0x3cb00 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 129, 2, 1, 0x49000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 129, 2, 8, 0x79600 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 255, 1, 1, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 255, 1, 8, 0x48b80 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 255, 2, 1, 0x61000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 255, 2, 8, 0x91700 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 256, 1, 1, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 256, 1, 9, 0x48b80 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 256, 2, 1, 0x61000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 256, 2, 9, 0x91700 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 257, 1, 1, 0x3d000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 257, 1, 9, 0x5d600 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 257, 2, 1, 0x7a000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 257, 2, 9, 0xbac00 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 511, 1, 1, 0x61000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 511, 1, 9, 0x91680 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 511, 2, 1, 0xc2000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 511, 2, 9, 0x122d00 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 512, 1, 1, 0x61000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 512, 1, 10, 0x91680 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 512, 2, 1, 0xc2000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 512, 2, 10, 0x122d00 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 513, 1, 1, 0x6e000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 513, 1, 10, 0xa6b80 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 513, 2, 1, 0xdc000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 513, 2, 10, 0x14d700 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 1023, 1, 1, 0xc2000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 1023, 1, 10, 0x11ec00 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 1023, 2, 1, 0x184000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 1023, 2, 10, 0x23d800 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 1024, 1, 1, 0xc2000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 1024, 1, 11, 0x11ec00 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 1024, 2, 1, 0x184000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 1024, 2, 11, 0x23d800 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 1025, 1, 1, 0xd0000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 1025, 1, 11, 0x135680 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 1025, 2, 1, 0x1a0000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 1025, 2, 11, 0x26ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 2047, 1, 1, 0x184000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 2047, 1, 11, 0x23d700 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 2047, 2, 1, 0x308000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 2047, 2, 11, 0x47ae00 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 2048, 1, 1, 0x184000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 2048, 1, 12, 0x23d700 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 2048, 2, 1, 0x308000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 2048, 2, 12, 0x47ae00 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 2049, 1, 1, 0x194000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 2049, 1, 12, 0x256c00 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 2049, 2, 1, 0x328000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 2049, 2, 12, 0x4ad800 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 4095, 1, 1, 0x308000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 4095, 1, 12, 0x476c80 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 4095, 2, 1, 0x610000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 4095, 2, 12, 0x8ed900 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 4096, 1, 1, 0x308000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 4096, 1, 13, 0x476c80 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 4096, 2, 1, 0x610000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 4096, 2, 13, 0x8ed900 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 4097, 1, 1, 0x31c000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 4097, 1, 13, 0x495700 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 4097, 2, 1, 0x638000 },
   { PIPE_FORMAT_Z32_FLOAT, 129, 4097, 2, 13, 0x92ae00 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 16, 1, 8, 0x8280 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 16, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 16, 2, 8, 0x10500 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 17, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 17, 1, 8, 0xc300 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 17, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 17, 2, 8, 0x18600 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 31, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 31, 1, 8, 0xc300 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 31, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 31, 2, 8, 0x18600 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 32, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 32, 1, 8, 0xc300 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 32, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 32, 2, 8, 0x18600 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 33, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 33, 1, 8, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 33, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 33, 2, 8, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 63, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 63, 1, 8, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 63, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 63, 2, 8, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 64, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 64, 1, 8, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 64, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 64, 2, 8, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 65, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 65, 1, 8, 0x28680 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 65, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 65, 2, 8, 0x50d00 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 127, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 127, 1, 8, 0x2c680 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 127, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 127, 2, 8, 0x58d00 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 128, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 128, 1, 8, 0x2c680 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 128, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 128, 2, 8, 0x58d00 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 129, 1, 1, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 129, 1, 8, 0x48b80 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 129, 2, 1, 0x61000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 129, 2, 8, 0x91700 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 255, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 255, 1, 8, 0x58b80 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 255, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 255, 2, 8, 0xb1700 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 256, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 256, 1, 9, 0x58b80 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 256, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 256, 2, 9, 0xb1700 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 257, 1, 1, 0x51000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 257, 1, 9, 0x75600 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 257, 2, 1, 0xa2000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 257, 2, 9, 0xeac00 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 511, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 511, 1, 9, 0xad680 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 511, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 511, 2, 9, 0x15ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 512, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 512, 1, 10, 0xad680 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 512, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 512, 2, 10, 0x15ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 513, 1, 1, 0x92000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 513, 1, 10, 0xcab80 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 513, 2, 1, 0x124000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 513, 2, 10, 0x195700 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 1023, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 1023, 1, 10, 0x15ac00 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 1023, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 1023, 2, 10, 0x2b5800 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 1024, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 1024, 1, 11, 0x15ac00 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 1024, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 1024, 2, 11, 0x2b5800 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 1025, 1, 1, 0x114000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 1025, 1, 11, 0x179680 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 1025, 2, 1, 0x228000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 1025, 2, 11, 0x2f2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 2047, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 2047, 1, 11, 0x2b1700 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 2047, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 2047, 2, 11, 0x562e00 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 2048, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 2048, 1, 12, 0x2b1700 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 2048, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 2048, 2, 12, 0x562e00 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 2049, 1, 1, 0x218000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 2049, 1, 12, 0x2d2c00 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 2049, 2, 1, 0x430000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 2049, 2, 12, 0x5a5800 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 4095, 1, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 4095, 1, 12, 0x562c80 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 4095, 2, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 4095, 2, 12, 0xac5900 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 4096, 1, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 4096, 1, 13, 0x562c80 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 4096, 2, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 4096, 2, 13, 0xac5900 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 4097, 1, 1, 0x420000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 4097, 1, 13, 0x589700 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 4097, 2, 1, 0x840000 },
   { PIPE_FORMAT_Z32_FLOAT, 255, 4097, 2, 13, 0xb12e00 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 16, 1, 1, 0x4080 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 16, 1, 9, 0x8280 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 16, 2, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 16, 2, 9, 0x10500 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 17, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 17, 1, 9, 0xc300 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 17, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 17, 2, 9, 0x18600 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 31, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 31, 1, 9, 0xc300 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 31, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 31, 2, 9, 0x18600 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 32, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 32, 1, 9, 0xc300 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 32, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 32, 2, 9, 0x18600 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 33, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 33, 1, 9, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 33, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 33, 2, 9, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 63, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 63, 1, 9, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 63, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 63, 2, 9, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 64, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 64, 1, 9, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 64, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 64, 2, 9, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 65, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 65, 1, 9, 0x28680 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 65, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 65, 2, 9, 0x50d00 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 127, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 127, 1, 9, 0x2c680 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 127, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 127, 2, 9, 0x58d00 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 128, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 128, 1, 9, 0x2c680 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 128, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 128, 2, 9, 0x58d00 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 129, 1, 1, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 129, 1, 9, 0x48b80 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 129, 2, 1, 0x61000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 129, 2, 9, 0x91700 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 255, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 255, 1, 9, 0x58b80 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 255, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 255, 2, 9, 0xb1700 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 256, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 256, 1, 9, 0x58b80 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 256, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 256, 2, 9, 0xb1700 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 257, 1, 1, 0x51000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 257, 1, 9, 0x79600 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 257, 2, 1, 0xa2000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 257, 2, 9, 0xf2c00 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 511, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 511, 1, 9, 0xad680 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 511, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 511, 2, 9, 0x15ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 512, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 512, 1, 10, 0xad680 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 512, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 512, 2, 10, 0x15ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 513, 1, 1, 0x92000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 513, 1, 10, 0xceb80 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 513, 2, 1, 0x124000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 513, 2, 10, 0x19d700 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 1023, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 1023, 1, 10, 0x15ac00 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 1023, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 1023, 2, 10, 0x2b5800 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 1024, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 1024, 1, 11, 0x15ac00 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 1024, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 1024, 2, 11, 0x2b5800 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 1025, 1, 1, 0x114000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 1025, 1, 11, 0x17d680 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 1025, 2, 1, 0x228000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 1025, 2, 11, 0x2fad00 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 2047, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 2047, 1, 11, 0x2b1700 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 2047, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 2047, 2, 11, 0x562e00 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 2048, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 2048, 1, 12, 0x2b1700 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 2048, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 2048, 2, 12, 0x562e00 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 2049, 1, 1, 0x218000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 2049, 1, 12, 0x2d6c00 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 2049, 2, 1, 0x430000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 2049, 2, 12, 0x5ad800 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 4095, 1, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 4095, 1, 12, 0x562c80 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 4095, 2, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 4095, 2, 12, 0xac5900 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 4096, 1, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 4096, 1, 13, 0x562c80 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 4096, 2, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 4096, 2, 13, 0xac5900 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 4097, 1, 1, 0x420000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 4097, 1, 13, 0x58d700 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 4097, 2, 1, 0x840000 },
   { PIPE_FORMAT_Z32_FLOAT, 256, 4097, 2, 13, 0xb1ae00 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 16, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 16, 1, 9, 0xc300 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 16, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 16, 2, 9, 0x18600 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 17, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 17, 1, 9, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 17, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 17, 2, 9, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 31, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 31, 1, 9, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 31, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 31, 2, 9, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 32, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 32, 1, 9, 0x18400 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 32, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 32, 2, 9, 0x30800 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 33, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 33, 1, 9, 0x2c680 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 33, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 33, 2, 9, 0x58d00 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 63, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 63, 1, 9, 0x2c680 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 63, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 63, 2, 9, 0x58d00 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 64, 1, 1, 0x14400 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 64, 1, 9, 0x1c680 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 64, 2, 1, 0x28800 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 64, 2, 9, 0x38d00 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 65, 1, 1, 0x28800 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 65, 1, 9, 0x30b80 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 65, 2, 1, 0x51000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 65, 2, 9, 0x61700 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 127, 1, 1, 0x28800 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 127, 1, 9, 0x34b80 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 127, 2, 1, 0x51000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 127, 2, 9, 0x69700 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 128, 1, 1, 0x28800 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 128, 1, 9, 0x38b80 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 128, 2, 1, 0x51000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 128, 2, 9, 0x71700 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 129, 1, 1, 0x3d000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 129, 1, 9, 0x5d600 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 129, 2, 1, 0x7a000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 129, 2, 9, 0xbac00 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 255, 1, 1, 0x51000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 255, 1, 9, 0x75600 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 255, 2, 1, 0xa2000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 255, 2, 9, 0xeac00 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 256, 1, 1, 0x51000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 256, 1, 9, 0x79600 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 256, 2, 1, 0xa2000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 256, 2, 9, 0xf2c00 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 257, 1, 1, 0x66000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 257, 1, 9, 0xa6b00 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 257, 2, 1, 0xcc000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 257, 2, 9, 0x14d600 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 511, 1, 1, 0xa2000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 511, 1, 9, 0xeeb80 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 511, 2, 1, 0x144000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 511, 2, 9, 0x1dd700 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 512, 1, 1, 0xa2000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 512, 1, 10, 0xeeb80 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 512, 2, 1, 0x144000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 512, 2, 10, 0x1dd700 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 513, 1, 1, 0xb8000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 513, 1, 10, 0x11d600 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 513, 2, 1, 0x170000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 513, 2, 10, 0x23ac00 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 1023, 1, 1, 0x144000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 1023, 1, 10, 0x1e1680 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 1023, 2, 1, 0x288000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 1023, 2, 10, 0x3c2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 1024, 1, 1, 0x144000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 1024, 1, 11, 0x1e1680 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 1024, 2, 1, 0x288000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 1024, 2, 11, 0x3c2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 1025, 1, 1, 0x15c000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 1025, 1, 11, 0x212b80 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 1025, 2, 1, 0x2b8000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 1025, 2, 11, 0x425700 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 2047, 1, 1, 0x288000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 2047, 1, 11, 0x3bec00 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 2047, 2, 1, 0x510000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 2047, 2, 11, 0x77d800 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 2048, 1, 1, 0x288000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 2048, 1, 12, 0x3bec00 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 2048, 2, 1, 0x510000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 2048, 2, 12, 0x77d800 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 2049, 1, 1, 0x2a4000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 2049, 1, 12, 0x3f5680 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 2049, 2, 1, 0x548000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 2049, 2, 12, 0x7ead00 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 4095, 1, 1, 0x510000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 4095, 1, 12, 0x77d700 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 4095, 2, 1, 0xa20000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 4095, 2, 12, 0xefae00 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 4096, 1, 1, 0x510000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 4096, 1, 13, 0x77d700 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 4096, 2, 1, 0xa20000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 4096, 2, 13, 0xefae00 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 4097, 1, 1, 0x534000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 4097, 1, 13, 0x7bec00 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 4097, 2, 1, 0xa68000 },
   { PIPE_FORMAT_Z32_FLOAT, 257, 4097, 2, 13, 0xf7d800 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 16, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 16, 1, 9, 0xc380 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 16, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 16, 2, 9, 0x18700 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 17, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 17, 1, 9, 0x18480 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 17, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 17, 2, 9, 0x30900 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 31, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 31, 1, 9, 0x18480 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 31, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 31, 2, 9, 0x30900 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 32, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 32, 1, 9, 0x18480 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 32, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 32, 2, 9, 0x30900 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 33, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 33, 1, 9, 0x2c700 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 33, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 33, 2, 9, 0x58e00 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 63, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 63, 1, 9, 0x2c700 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 63, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 63, 2, 9, 0x58e00 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 64, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 64, 1, 9, 0x2c700 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 64, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 64, 2, 9, 0x58e00 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 65, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 65, 1, 9, 0x4cc00 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 65, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 65, 2, 9, 0x99800 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 127, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 127, 1, 9, 0x58c00 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 127, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 127, 2, 9, 0xb1800 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 128, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 128, 1, 9, 0x58c00 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 128, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 128, 2, 9, 0xb1800 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 129, 1, 1, 0x61000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 129, 1, 9, 0x91680 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 129, 2, 1, 0xc2000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 129, 2, 9, 0x122d00 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 255, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 255, 1, 9, 0xad680 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 255, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 255, 2, 9, 0x15ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 256, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 256, 1, 9, 0xad680 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 256, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 256, 2, 9, 0x15ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 257, 1, 1, 0xa2000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 257, 1, 9, 0xeeb80 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 257, 2, 1, 0x144000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 257, 2, 9, 0x1dd700 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 511, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 511, 1, 9, 0x15ab80 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 511, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 511, 2, 9, 0x2b5700 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 512, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 512, 1, 10, 0x15ab80 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 512, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 512, 2, 10, 0x2b5700 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 513, 1, 1, 0x124000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 513, 1, 10, 0x19d600 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 513, 2, 1, 0x248000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 513, 2, 10, 0x33ac00 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 1023, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 1023, 1, 10, 0x2b1680 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 1023, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 1023, 2, 10, 0x562d00 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 1024, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 1024, 1, 11, 0x2b1680 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 1024, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 1024, 2, 11, 0x562d00 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 1025, 1, 1, 0x228000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 1025, 1, 11, 0x2f6b80 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 1025, 2, 1, 0x450000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 1025, 2, 11, 0x5ed700 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 2047, 1, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 2047, 1, 11, 0x562c00 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 2047, 2, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 2047, 2, 11, 0xac5800 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 2048, 1, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 2048, 1, 12, 0x562c00 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 2048, 2, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 2048, 2, 12, 0xac5800 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 2049, 1, 1, 0x430000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 2049, 1, 12, 0x5ad680 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 2049, 2, 1, 0x860000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 2049, 2, 12, 0xb5ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 4095, 1, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 4095, 1, 12, 0xac1700 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 4095, 2, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 4095, 2, 12, 0x1582e00 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 4096, 1, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 4096, 1, 13, 0xac1700 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 4096, 2, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 4096, 2, 13, 0x1582e00 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 4097, 1, 1, 0x840000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 4097, 1, 13, 0xb16c00 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 4097, 2, 1, 0x1080000 },
   { PIPE_FORMAT_Z32_FLOAT, 511, 4097, 2, 13, 0x162d800 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 16, 1, 1, 0x8100 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 16, 1, 10, 0xc380 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 16, 2, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 16, 2, 10, 0x18700 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 17, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 17, 1, 10, 0x18480 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 17, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 17, 2, 10, 0x30900 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 31, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 31, 1, 10, 0x18480 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 31, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 31, 2, 10, 0x30900 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 32, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 32, 1, 10, 0x18480 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 32, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 32, 2, 10, 0x30900 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 33, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 33, 1, 10, 0x2c700 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 33, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 33, 2, 10, 0x58e00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 63, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 63, 1, 10, 0x2c700 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 63, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 63, 2, 10, 0x58e00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 64, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 64, 1, 10, 0x2c700 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 64, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 64, 2, 10, 0x58e00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 65, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 65, 1, 10, 0x4cc00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 65, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 65, 2, 10, 0x99800 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 127, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 127, 1, 10, 0x58c00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 127, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 127, 2, 10, 0xb1800 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 128, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 128, 1, 10, 0x58c00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 128, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 128, 2, 10, 0xb1800 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 129, 1, 1, 0x61000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 129, 1, 10, 0x91680 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 129, 2, 1, 0xc2000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 129, 2, 10, 0x122d00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 255, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 255, 1, 10, 0xad680 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 255, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 255, 2, 10, 0x15ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 256, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 256, 1, 10, 0xad680 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 256, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 256, 2, 10, 0x15ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 257, 1, 1, 0xa2000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 257, 1, 10, 0xeeb80 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 257, 2, 1, 0x144000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 257, 2, 10, 0x1dd700 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 511, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 511, 1, 10, 0x15ab80 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 511, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 511, 2, 10, 0x2b5700 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 512, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 512, 1, 10, 0x15ab80 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 512, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 512, 2, 10, 0x2b5700 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 513, 1, 1, 0x124000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 513, 1, 10, 0x1a1600 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 513, 2, 1, 0x248000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 513, 2, 10, 0x342c00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 1023, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 1023, 1, 10, 0x2b1680 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 1023, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 1023, 2, 10, 0x562d00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 1024, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 1024, 1, 11, 0x2b1680 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 1024, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 1024, 2, 11, 0x562d00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 1025, 1, 1, 0x228000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 1025, 1, 11, 0x2fab80 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 1025, 2, 1, 0x450000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 1025, 2, 11, 0x5f5700 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 2047, 1, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 2047, 1, 11, 0x562c00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 2047, 2, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 2047, 2, 11, 0xac5800 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 2048, 1, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 2048, 1, 12, 0x562c00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 2048, 2, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 2048, 2, 12, 0xac5800 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 2049, 1, 1, 0x430000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 2049, 1, 12, 0x5b1680 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 2049, 2, 1, 0x860000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 2049, 2, 12, 0xb62d00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 4095, 1, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 4095, 1, 12, 0xac1700 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 4095, 2, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 4095, 2, 12, 0x1582e00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 4096, 1, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 4096, 1, 13, 0xac1700 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 4096, 2, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 4096, 2, 13, 0x1582e00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 4097, 1, 1, 0x840000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 4097, 1, 13, 0xb1ac00 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 4097, 2, 1, 0x1080000 },
   { PIPE_FORMAT_Z32_FLOAT, 512, 4097, 2, 13, 0x1635800 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 16, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 16, 1, 10, 0x18500 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 16, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 16, 2, 10, 0x30a00 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 17, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 17, 1, 10, 0x2c700 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 17, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 17, 2, 10, 0x58e00 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 31, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 31, 1, 10, 0x2c700 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 31, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 31, 2, 10, 0x58e00 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 32, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 32, 1, 10, 0x2c700 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 32, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 32, 2, 10, 0x58e00 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 33, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 33, 1, 10, 0x58c00 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 33, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 33, 2, 10, 0xb1800 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 63, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 63, 1, 10, 0x58c00 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 63, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 63, 2, 10, 0xb1800 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 64, 1, 1, 0x24800 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 64, 1, 10, 0x30c00 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 64, 2, 1, 0x49000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 64, 2, 10, 0x61800 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 65, 1, 1, 0x49000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 65, 1, 10, 0x55680 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 65, 2, 1, 0x92000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 65, 2, 10, 0xaad00 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 127, 1, 1, 0x49000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 127, 1, 10, 0x61680 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 127, 2, 1, 0x92000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 127, 2, 10, 0xc2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 128, 1, 1, 0x49000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 128, 1, 10, 0x65680 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 128, 2, 1, 0x92000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 128, 2, 10, 0xcad00 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 129, 1, 1, 0x6e000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 129, 1, 10, 0xa6b80 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 129, 2, 1, 0xdc000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 129, 2, 10, 0x14d700 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 255, 1, 1, 0x92000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 255, 1, 10, 0xcab80 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 255, 2, 1, 0x124000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 255, 2, 10, 0x195700 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 256, 1, 1, 0x92000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 256, 1, 10, 0xceb80 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 256, 2, 1, 0x124000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 256, 2, 10, 0x19d700 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 257, 1, 1, 0xb8000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 257, 1, 10, 0x11d600 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 257, 2, 1, 0x170000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 257, 2, 10, 0x23ac00 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 511, 1, 1, 0x124000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 511, 1, 10, 0x19d600 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 511, 2, 1, 0x248000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 511, 2, 10, 0x33ac00 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 512, 1, 1, 0x124000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 512, 1, 10, 0x1a1600 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 512, 2, 1, 0x248000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 512, 2, 10, 0x342c00 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 513, 1, 1, 0x14c000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 513, 1, 10, 0x1feb00 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 513, 2, 1, 0x298000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 513, 2, 10, 0x3fd600 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 1023, 1, 1, 0x248000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 1023, 1, 10, 0x342b80 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 1023, 2, 1, 0x490000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 1023, 2, 10, 0x685700 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 1024, 1, 1, 0x248000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 1024, 1, 11, 0x342b80 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 1024, 2, 1, 0x490000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 1024, 2, 11, 0x685700 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 1025, 1, 1, 0x274000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 1025, 1, 11, 0x3a1600 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 1025, 2, 1, 0x4e8000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 1025, 2, 11, 0x742c00 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 2047, 1, 1, 0x490000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 2047, 1, 11, 0x685680 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 2047, 2, 1, 0x920000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 2047, 2, 11, 0xd0ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 2048, 1, 1, 0x490000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 2048, 1, 12, 0x685680 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 2048, 2, 1, 0x920000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 2048, 2, 12, 0xd0ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 2049, 1, 1, 0x4c4000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 2049, 1, 12, 0x6eeb80 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 2049, 2, 1, 0x988000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 2049, 2, 12, 0xddd700 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 4095, 1, 1, 0x920000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 4095, 1, 12, 0xd0ac00 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 4095, 2, 1, 0x1240000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 4095, 2, 12, 0x1a15800 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 4096, 1, 1, 0x920000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 4096, 1, 13, 0xd0ac00 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 4096, 2, 1, 0x1240000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 4096, 2, 13, 0x1a15800 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 4097, 1, 1, 0x964000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 4097, 1, 13, 0xd89680 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 4097, 2, 1, 0x12c8000 },
   { PIPE_FORMAT_Z32_FLOAT, 513, 4097, 2, 13, 0x1b12d00 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 16, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 16, 1, 10, 0x18580 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 16, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 16, 2, 10, 0x30b00 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 17, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 17, 1, 10, 0x2c780 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 17, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 17, 2, 10, 0x58f00 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 31, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 31, 1, 10, 0x2c780 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 31, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 31, 2, 10, 0x58f00 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 32, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 32, 1, 10, 0x2c780 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 32, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 32, 2, 10, 0x58f00 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 33, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 33, 1, 10, 0x58c80 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 33, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 33, 2, 10, 0xb1900 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 63, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 63, 1, 10, 0x58c80 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 63, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 63, 2, 10, 0xb1900 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 64, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 64, 1, 10, 0x58c80 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 64, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 64, 2, 10, 0xb1900 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 65, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 65, 1, 10, 0x99700 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 65, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 65, 2, 10, 0x132e00 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 127, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 127, 1, 10, 0xad700 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 127, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 127, 2, 10, 0x15ae00 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 128, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 128, 1, 10, 0xad700 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 128, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 128, 2, 10, 0x15ae00 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 129, 1, 1, 0xc2000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 129, 1, 10, 0x11ec00 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 129, 2, 1, 0x184000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 129, 2, 10, 0x23d800 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 255, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 255, 1, 10, 0x15ac00 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 255, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 255, 2, 10, 0x2b5800 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 256, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 256, 1, 10, 0x15ac00 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 256, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 256, 2, 10, 0x2b5800 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 257, 1, 1, 0x144000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 257, 1, 10, 0x1e1680 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 257, 2, 1, 0x288000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 257, 2, 10, 0x3c2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 511, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 511, 1, 10, 0x2b1680 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 511, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 511, 2, 10, 0x562d00 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 512, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 512, 1, 10, 0x2b1680 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 512, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 512, 2, 10, 0x562d00 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 513, 1, 1, 0x248000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 513, 1, 10, 0x342b80 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 513, 2, 1, 0x490000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 513, 2, 10, 0x685700 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 1023, 1, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 1023, 1, 10, 0x562b80 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 1023, 2, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 1023, 2, 10, 0xac5700 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 1024, 1, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 1024, 1, 11, 0x562b80 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 1024, 2, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 1024, 2, 11, 0xac5700 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 1025, 1, 1, 0x450000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 1025, 1, 11, 0x5f9600 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 1025, 2, 1, 0x8a0000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 1025, 2, 11, 0xbf2c00 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 2047, 1, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 2047, 1, 11, 0xac1680 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 2047, 2, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 2047, 2, 11, 0x1582d00 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 2048, 1, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 2048, 1, 12, 0xac1680 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 2048, 2, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 2048, 2, 12, 0x1582d00 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 2049, 1, 1, 0x860000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 2049, 1, 12, 0xb62b80 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 2049, 2, 1, 0x10c0000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 2049, 2, 12, 0x16c5700 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 4095, 1, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 4095, 1, 12, 0x1582c00 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 4095, 2, 1, 0x2040000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 4095, 2, 12, 0x2b05800 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 4096, 1, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 4096, 1, 13, 0x1582c00 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 4096, 2, 1, 0x2040000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 4096, 2, 13, 0x2b05800 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 4097, 1, 1, 0x1080000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 4097, 1, 13, 0x1639680 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 4097, 2, 1, 0x2100000 },
   { PIPE_FORMAT_Z32_FLOAT, 1023, 4097, 2, 13, 0x2c72d00 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 16, 1, 1, 0x10200 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 16, 1, 11, 0x18580 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 16, 2, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 16, 2, 11, 0x30b00 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 17, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 17, 1, 11, 0x2c780 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 17, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 17, 2, 11, 0x58f00 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 31, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 31, 1, 11, 0x2c780 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 31, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 31, 2, 11, 0x58f00 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 32, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 32, 1, 11, 0x2c780 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 32, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 32, 2, 11, 0x58f00 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 33, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 33, 1, 11, 0x58c80 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 33, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 33, 2, 11, 0xb1900 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 63, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 63, 1, 11, 0x58c80 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 63, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 63, 2, 11, 0xb1900 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 64, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 64, 1, 11, 0x58c80 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 64, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 64, 2, 11, 0xb1900 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 65, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 65, 1, 11, 0x99700 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 65, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 65, 2, 11, 0x132e00 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 127, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 127, 1, 11, 0xad700 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 127, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 127, 2, 11, 0x15ae00 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 128, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 128, 1, 11, 0xad700 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 128, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 128, 2, 11, 0x15ae00 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 129, 1, 1, 0xc2000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 129, 1, 11, 0x11ec00 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 129, 2, 1, 0x184000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 129, 2, 11, 0x23d800 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 255, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 255, 1, 11, 0x15ac00 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 255, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 255, 2, 11, 0x2b5800 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 256, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 256, 1, 11, 0x15ac00 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 256, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 256, 2, 11, 0x2b5800 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 257, 1, 1, 0x144000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 257, 1, 11, 0x1e1680 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 257, 2, 1, 0x288000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 257, 2, 11, 0x3c2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 511, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 511, 1, 11, 0x2b1680 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 511, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 511, 2, 11, 0x562d00 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 512, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 512, 1, 11, 0x2b1680 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 512, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 512, 2, 11, 0x562d00 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 513, 1, 1, 0x248000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 513, 1, 11, 0x342b80 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 513, 2, 1, 0x490000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 513, 2, 11, 0x685700 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 1023, 1, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 1023, 1, 11, 0x562b80 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 1023, 2, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 1023, 2, 11, 0xac5700 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 1024, 1, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 1024, 1, 11, 0x562b80 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 1024, 2, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 1024, 2, 11, 0xac5700 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 1025, 1, 1, 0x450000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 1025, 1, 11, 0x5fd600 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 1025, 2, 1, 0x8a0000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 1025, 2, 11, 0xbfac00 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 2047, 1, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 2047, 1, 11, 0xac1680 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 2047, 2, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 2047, 2, 11, 0x1582d00 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 2048, 1, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 2048, 1, 12, 0xac1680 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 2048, 2, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 2048, 2, 12, 0x1582d00 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 2049, 1, 1, 0x860000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 2049, 1, 12, 0xb66b80 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 2049, 2, 1, 0x10c0000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 2049, 2, 12, 0x16cd700 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 4095, 1, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 4095, 1, 12, 0x1582c00 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 4095, 2, 1, 0x2040000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 4095, 2, 12, 0x2b05800 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 4096, 1, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 4096, 1, 13, 0x1582c00 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 4096, 2, 1, 0x2040000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 4096, 2, 13, 0x2b05800 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 4097, 1, 1, 0x1080000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 4097, 1, 13, 0x163d680 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 4097, 2, 1, 0x2100000 },
   { PIPE_FORMAT_Z32_FLOAT, 1024, 4097, 2, 13, 0x2c7ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 16, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 16, 1, 11, 0x2c900 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 16, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 16, 2, 11, 0x59200 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 17, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 17, 1, 11, 0x58d00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 17, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 17, 2, 11, 0xb1a00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 31, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 31, 1, 11, 0x58d00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 31, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 31, 2, 11, 0xb1a00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 32, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 32, 1, 11, 0x58d00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 32, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 32, 2, 11, 0xb1a00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 33, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 33, 1, 11, 0xad700 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 33, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 33, 2, 11, 0x15ae00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 63, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 63, 1, 11, 0xad700 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 63, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 63, 2, 11, 0x15ae00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 64, 1, 1, 0x45000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 64, 1, 11, 0x5d700 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 64, 2, 1, 0x8a000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 64, 2, 11, 0xbae00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 65, 1, 1, 0x8a000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 65, 1, 11, 0xa2c00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 65, 2, 1, 0x114000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 65, 2, 11, 0x145800 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 127, 1, 1, 0x8a000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 127, 1, 11, 0xb6c00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 127, 2, 1, 0x114000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 127, 2, 11, 0x16d800 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 128, 1, 1, 0x8a000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 128, 1, 11, 0xbac00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 128, 2, 1, 0x114000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 128, 2, 11, 0x175800 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 129, 1, 1, 0xd0000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 129, 1, 11, 0x135680 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 129, 2, 1, 0x1a0000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 129, 2, 11, 0x26ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 255, 1, 1, 0x114000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 255, 1, 11, 0x179680 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 255, 2, 1, 0x228000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 255, 2, 11, 0x2f2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 256, 1, 1, 0x114000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 256, 1, 11, 0x17d680 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 256, 2, 1, 0x228000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 256, 2, 11, 0x2fad00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 257, 1, 1, 0x15c000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 257, 1, 11, 0x212b80 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 257, 2, 1, 0x2b8000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 257, 2, 11, 0x425700 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 511, 1, 1, 0x228000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 511, 1, 11, 0x2f6b80 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 511, 2, 1, 0x450000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 511, 2, 11, 0x5ed700 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 512, 1, 1, 0x228000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 512, 1, 11, 0x2fab80 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 512, 2, 1, 0x450000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 512, 2, 11, 0x5f5700 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 513, 1, 1, 0x274000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 513, 1, 11, 0x3a1600 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 513, 2, 1, 0x4e8000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 513, 2, 11, 0x742c00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 1023, 1, 1, 0x450000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 1023, 1, 11, 0x5f9600 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 1023, 2, 1, 0x8a0000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 1023, 2, 11, 0xbf2c00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 1024, 1, 1, 0x450000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 1024, 1, 11, 0x5fd600 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 1024, 2, 1, 0x8a0000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 1024, 2, 11, 0xbfac00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 1025, 1, 1, 0x4a4000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 1025, 1, 11, 0x6b6b00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 1025, 2, 1, 0x948000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 1025, 2, 11, 0xd6d600 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 2047, 1, 1, 0x8a0000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 2047, 1, 11, 0xbf6b80 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 2047, 2, 1, 0x1140000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 2047, 2, 11, 0x17ed700 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 2048, 1, 1, 0x8a0000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 2048, 1, 12, 0xbf6b80 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 2048, 2, 1, 0x1140000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 2048, 2, 12, 0x17ed700 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 2049, 1, 1, 0x904000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 2049, 1, 12, 0xcc5600 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 2049, 2, 1, 0x1208000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 2049, 2, 12, 0x198ac00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 4095, 1, 1, 0x1140000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 4095, 1, 12, 0x17f1680 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 4095, 2, 1, 0x2280000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 4095, 2, 12, 0x2fe2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 4096, 1, 1, 0x1140000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 4096, 1, 13, 0x17f1680 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 4096, 2, 1, 0x2280000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 4096, 2, 13, 0x2fe2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 4097, 1, 1, 0x11c4000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 4097, 1, 13, 0x18eab80 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 4097, 2, 1, 0x2388000 },
   { PIPE_FORMAT_Z32_FLOAT, 1025, 4097, 2, 13, 0x31d5700 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 16, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 16, 1, 11, 0x2c980 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 16, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 16, 2, 11, 0x59300 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 17, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 17, 1, 11, 0x58d80 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 17, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 17, 2, 11, 0xb1b00 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 31, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 31, 1, 11, 0x58d80 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 31, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 31, 2, 11, 0xb1b00 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 32, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 32, 1, 11, 0x58d80 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 32, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 32, 2, 11, 0xb1b00 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 33, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 33, 1, 11, 0xad780 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 33, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 33, 2, 11, 0x15af00 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 63, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 63, 1, 11, 0xad780 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 63, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 63, 2, 11, 0x15af00 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 64, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 64, 1, 11, 0xad780 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 64, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 64, 2, 11, 0x15af00 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 65, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 65, 1, 11, 0x12ec80 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 65, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 65, 2, 11, 0x25d900 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 127, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 127, 1, 11, 0x15ac80 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 127, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 127, 2, 11, 0x2b5900 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 128, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 128, 1, 11, 0x15ac80 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 128, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 128, 2, 11, 0x2b5900 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 129, 1, 1, 0x184000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 129, 1, 11, 0x23d700 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 129, 2, 1, 0x308000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 129, 2, 11, 0x47ae00 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 255, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 255, 1, 11, 0x2b1700 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 255, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 255, 2, 11, 0x562e00 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 256, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 256, 1, 11, 0x2b1700 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 256, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 256, 2, 11, 0x562e00 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 257, 1, 1, 0x288000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 257, 1, 11, 0x3bec00 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 257, 2, 1, 0x510000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 257, 2, 11, 0x77d800 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 511, 1, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 511, 1, 11, 0x562c00 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 511, 2, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 511, 2, 11, 0xac5800 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 512, 1, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 512, 1, 11, 0x562c00 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 512, 2, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 512, 2, 11, 0xac5800 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 513, 1, 1, 0x490000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 513, 1, 11, 0x685680 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 513, 2, 1, 0x920000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 513, 2, 11, 0xd0ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 1023, 1, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 1023, 1, 11, 0xac1680 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 1023, 2, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 1023, 2, 11, 0x1582d00 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 1024, 1, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 1024, 1, 11, 0xac1680 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 1024, 2, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 1024, 2, 11, 0x1582d00 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 1025, 1, 1, 0x8a0000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 1025, 1, 11, 0xbf6b80 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 1025, 2, 1, 0x1140000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 1025, 2, 11, 0x17ed700 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 2047, 1, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 2047, 1, 11, 0x1582b80 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 2047, 2, 1, 0x2040000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 2047, 2, 11, 0x2b05700 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 2048, 1, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 2048, 1, 12, 0x1582b80 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 2048, 2, 1, 0x2040000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 2048, 2, 12, 0x2b05700 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 2049, 1, 1, 0x10c0000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 2049, 1, 12, 0x16cd600 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 2049, 2, 1, 0x2180000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 2049, 2, 12, 0x2d9ac00 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 4095, 1, 1, 0x2040000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 4095, 1, 12, 0x2b01680 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 4095, 2, 1, 0x4080000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 4095, 2, 12, 0x5602d00 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 4096, 1, 1, 0x2040000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 4096, 1, 13, 0x2b01680 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 4096, 2, 1, 0x4080000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 4096, 2, 13, 0x5602d00 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 4097, 1, 1, 0x2100000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 4097, 1, 13, 0x2c76b80 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 4097, 2, 1, 0x4200000 },
   { PIPE_FORMAT_Z32_FLOAT, 2047, 4097, 2, 13, 0x58ed700 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 16, 1, 1, 0x20400 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 16, 1, 12, 0x2c980 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 16, 2, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 16, 2, 12, 0x59300 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 17, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 17, 1, 12, 0x58d80 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 17, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 17, 2, 12, 0xb1b00 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 31, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 31, 1, 12, 0x58d80 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 31, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 31, 2, 12, 0xb1b00 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 32, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 32, 1, 12, 0x58d80 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 32, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 32, 2, 12, 0xb1b00 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 33, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 33, 1, 12, 0xad780 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 33, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 33, 2, 12, 0x15af00 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 63, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 63, 1, 12, 0xad780 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 63, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 63, 2, 12, 0x15af00 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 64, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 64, 1, 12, 0xad780 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 64, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 64, 2, 12, 0x15af00 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 65, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 65, 1, 12, 0x12ec80 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 65, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 65, 2, 12, 0x25d900 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 127, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 127, 1, 12, 0x15ac80 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 127, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 127, 2, 12, 0x2b5900 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 128, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 128, 1, 12, 0x15ac80 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 128, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 128, 2, 12, 0x2b5900 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 129, 1, 1, 0x184000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 129, 1, 12, 0x23d700 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 129, 2, 1, 0x308000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 129, 2, 12, 0x47ae00 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 255, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 255, 1, 12, 0x2b1700 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 255, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 255, 2, 12, 0x562e00 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 256, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 256, 1, 12, 0x2b1700 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 256, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 256, 2, 12, 0x562e00 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 257, 1, 1, 0x288000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 257, 1, 12, 0x3bec00 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 257, 2, 1, 0x510000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 257, 2, 12, 0x77d800 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 511, 1, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 511, 1, 12, 0x562c00 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 511, 2, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 511, 2, 12, 0xac5800 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 512, 1, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 512, 1, 12, 0x562c00 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 512, 2, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 512, 2, 12, 0xac5800 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 513, 1, 1, 0x490000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 513, 1, 12, 0x685680 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 513, 2, 1, 0x920000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 513, 2, 12, 0xd0ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 1023, 1, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 1023, 1, 12, 0xac1680 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 1023, 2, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 1023, 2, 12, 0x1582d00 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 1024, 1, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 1024, 1, 12, 0xac1680 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 1024, 2, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 1024, 2, 12, 0x1582d00 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 1025, 1, 1, 0x8a0000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 1025, 1, 12, 0xbf6b80 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 1025, 2, 1, 0x1140000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 1025, 2, 12, 0x17ed700 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 2047, 1, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 2047, 1, 12, 0x1582b80 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 2047, 2, 1, 0x2040000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 2047, 2, 12, 0x2b05700 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 2048, 1, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 2048, 1, 12, 0x1582b80 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 2048, 2, 1, 0x2040000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 2048, 2, 12, 0x2b05700 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 2049, 1, 1, 0x10c0000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 2049, 1, 12, 0x16d1600 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 2049, 2, 1, 0x2180000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 2049, 2, 12, 0x2da2c00 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 4095, 1, 1, 0x2040000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 4095, 1, 12, 0x2b01680 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 4095, 2, 1, 0x4080000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 4095, 2, 12, 0x5602d00 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 4096, 1, 1, 0x2040000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 4096, 1, 13, 0x2b01680 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 4096, 2, 1, 0x4080000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 4096, 2, 13, 0x5602d00 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 4097, 1, 1, 0x2100000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 4097, 1, 13, 0x2c7ab80 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 4097, 2, 1, 0x4200000 },
   { PIPE_FORMAT_Z32_FLOAT, 2048, 4097, 2, 13, 0x58f5700 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 16, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 16, 1, 12, 0x59100 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 16, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 16, 2, 12, 0xb2200 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 17, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 17, 1, 12, 0xad900 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 17, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 17, 2, 12, 0x15b200 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 31, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 31, 1, 12, 0xad900 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 31, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 31, 2, 12, 0x15b200 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 32, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 32, 1, 12, 0xad900 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 32, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 32, 2, 12, 0x15b200 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 33, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 33, 1, 12, 0x15ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 33, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 33, 2, 12, 0x2b5a00 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 63, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 63, 1, 12, 0x15ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 63, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 63, 2, 12, 0x2b5a00 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 64, 1, 1, 0x86000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 64, 1, 12, 0xb2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 64, 2, 1, 0x10c000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 64, 2, 12, 0x165a00 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 65, 1, 1, 0x10c000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 65, 1, 12, 0x139700 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 65, 2, 1, 0x218000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 65, 2, 12, 0x272e00 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 127, 1, 1, 0x10c000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 127, 1, 12, 0x165700 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 127, 2, 1, 0x218000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 127, 2, 12, 0x2cae00 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 128, 1, 1, 0x10c000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 128, 1, 12, 0x169700 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 128, 2, 1, 0x218000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 128, 2, 12, 0x2d2e00 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 129, 1, 1, 0x194000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 129, 1, 12, 0x256c00 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 129, 2, 1, 0x328000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 129, 2, 12, 0x4ad800 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 255, 1, 1, 0x218000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 255, 1, 12, 0x2d2c00 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 255, 2, 1, 0x430000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 255, 2, 12, 0x5a5800 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 256, 1, 1, 0x218000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 256, 1, 12, 0x2d6c00 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 256, 2, 1, 0x430000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 256, 2, 12, 0x5ad800 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 257, 1, 1, 0x2a4000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 257, 1, 12, 0x3f5680 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 257, 2, 1, 0x548000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 257, 2, 12, 0x7ead00 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 511, 1, 1, 0x430000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 511, 1, 12, 0x5ad680 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 511, 2, 1, 0x860000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 511, 2, 12, 0xb5ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 512, 1, 1, 0x430000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 512, 1, 12, 0x5b1680 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 512, 2, 1, 0x860000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 512, 2, 12, 0xb62d00 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 513, 1, 1, 0x4c4000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 513, 1, 12, 0x6eeb80 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 513, 2, 1, 0x988000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 513, 2, 12, 0xddd700 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 1023, 1, 1, 0x860000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 1023, 1, 12, 0xb62b80 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 1023, 2, 1, 0x10c0000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 1023, 2, 12, 0x16c5700 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 1024, 1, 1, 0x860000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 1024, 1, 12, 0xb66b80 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 1024, 2, 1, 0x10c0000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 1024, 2, 12, 0x16cd700 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 1025, 1, 1, 0x904000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 1025, 1, 12, 0xcc5600 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 1025, 2, 1, 0x1208000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 1025, 2, 12, 0x198ac00 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 2047, 1, 1, 0x10c0000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 2047, 1, 12, 0x16cd600 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 2047, 2, 1, 0x2180000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 2047, 2, 12, 0x2d9ac00 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 2048, 1, 1, 0x10c0000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 2048, 1, 12, 0x16d1600 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 2048, 2, 1, 0x2180000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 2048, 2, 12, 0x2da2c00 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 2049, 1, 1, 0x1184000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 2049, 1, 12, 0x1866b00 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 2049, 2, 1, 0x2308000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 2049, 2, 12, 0x30cd600 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 4095, 1, 1, 0x2180000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 4095, 1, 12, 0x2da2b80 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 4095, 2, 1, 0x4300000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 4095, 2, 12, 0x5b45700 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 4096, 1, 1, 0x2180000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 4096, 1, 13, 0x2da2b80 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 4096, 2, 1, 0x4300000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 4096, 2, 13, 0x5b45700 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 4097, 1, 1, 0x2284000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 4097, 1, 13, 0x2f89600 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 4097, 2, 1, 0x4508000 },
   { PIPE_FORMAT_Z32_FLOAT, 2049, 4097, 2, 13, 0x5f12c00 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 16, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 16, 1, 12, 0x59180 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 16, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 16, 2, 12, 0xb2300 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 17, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 17, 1, 12, 0xad980 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 17, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 17, 2, 12, 0x15b300 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 31, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 31, 1, 12, 0xad980 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 31, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 31, 2, 12, 0x15b300 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 32, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 32, 1, 12, 0xad980 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 32, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 32, 2, 12, 0x15b300 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 33, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 33, 1, 12, 0x15ad80 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 33, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 33, 2, 12, 0x2b5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 63, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 63, 1, 12, 0x15ad80 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 63, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 63, 2, 12, 0x2b5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 64, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 64, 1, 12, 0x15ad80 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 64, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 64, 2, 12, 0x2b5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 65, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 65, 1, 12, 0x25d780 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 65, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 65, 2, 12, 0x4baf00 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 127, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 127, 1, 12, 0x2b1780 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 127, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 127, 2, 12, 0x562f00 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 128, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 128, 1, 12, 0x2b1780 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 128, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 128, 2, 12, 0x562f00 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 129, 1, 1, 0x308000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 129, 1, 12, 0x476c80 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 129, 2, 1, 0x610000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 129, 2, 12, 0x8ed900 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 255, 1, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 255, 1, 12, 0x562c80 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 255, 2, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 255, 2, 12, 0xac5900 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 256, 1, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 256, 1, 12, 0x562c80 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 256, 2, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 256, 2, 12, 0xac5900 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 257, 1, 1, 0x510000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 257, 1, 12, 0x77d700 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 257, 2, 1, 0xa20000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 257, 2, 12, 0xefae00 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 511, 1, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 511, 1, 12, 0xac1700 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 511, 2, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 511, 2, 12, 0x1582e00 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 512, 1, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 512, 1, 12, 0xac1700 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 512, 2, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 512, 2, 12, 0x1582e00 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 513, 1, 1, 0x920000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 513, 1, 12, 0xd0ac00 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 513, 2, 1, 0x1240000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 513, 2, 12, 0x1a15800 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 1023, 1, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 1023, 1, 12, 0x1582c00 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 1023, 2, 1, 0x2040000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 1023, 2, 12, 0x2b05800 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 1024, 1, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 1024, 1, 12, 0x1582c00 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 1024, 2, 1, 0x2040000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 1024, 2, 12, 0x2b05800 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 1025, 1, 1, 0x1140000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 1025, 1, 12, 0x17f1680 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 1025, 2, 1, 0x2280000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 1025, 2, 12, 0x2fe2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 2047, 1, 1, 0x2040000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 2047, 1, 12, 0x2b01680 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 2047, 2, 1, 0x4080000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 2047, 2, 12, 0x5602d00 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 2048, 1, 1, 0x2040000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 2048, 1, 12, 0x2b01680 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 2048, 2, 1, 0x4080000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 2048, 2, 12, 0x5602d00 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 2049, 1, 1, 0x2180000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 2049, 1, 12, 0x2da2b80 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 2049, 2, 1, 0x4300000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 2049, 2, 12, 0x5b45700 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 4095, 1, 1, 0x4080000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 4095, 1, 12, 0x5602b80 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 4095, 2, 1, 0x8100000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 4095, 2, 12, 0xac05700 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 4096, 1, 1, 0x4080000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 4096, 1, 13, 0x5602b80 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 4096, 2, 1, 0x8100000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 4096, 2, 13, 0xac05700 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 4097, 1, 1, 0x4200000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 4097, 1, 13, 0x58f9600 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 4097, 2, 1, 0x8400000 },
   { PIPE_FORMAT_Z32_FLOAT, 4095, 4097, 2, 13, 0xb1f2c00 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 16, 1, 1, 0x40800 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 16, 1, 13, 0x59180 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 16, 2, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 16, 2, 13, 0xb2300 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 17, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 17, 1, 13, 0xad980 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 17, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 17, 2, 13, 0x15b300 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 31, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 31, 1, 13, 0xad980 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 31, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 31, 2, 13, 0x15b300 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 32, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 32, 1, 13, 0xad980 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 32, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 32, 2, 13, 0x15b300 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 33, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 33, 1, 13, 0x15ad80 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 33, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 33, 2, 13, 0x2b5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 63, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 63, 1, 13, 0x15ad80 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 63, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 63, 2, 13, 0x2b5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 64, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 64, 1, 13, 0x15ad80 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 64, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 64, 2, 13, 0x2b5b00 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 65, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 65, 1, 13, 0x25d780 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 65, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 65, 2, 13, 0x4baf00 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 127, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 127, 1, 13, 0x2b1780 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 127, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 127, 2, 13, 0x562f00 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 128, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 128, 1, 13, 0x2b1780 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 128, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 128, 2, 13, 0x562f00 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 129, 1, 1, 0x308000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 129, 1, 13, 0x476c80 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 129, 2, 1, 0x610000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 129, 2, 13, 0x8ed900 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 255, 1, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 255, 1, 13, 0x562c80 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 255, 2, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 255, 2, 13, 0xac5900 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 256, 1, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 256, 1, 13, 0x562c80 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 256, 2, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 256, 2, 13, 0xac5900 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 257, 1, 1, 0x510000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 257, 1, 13, 0x77d700 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 257, 2, 1, 0xa20000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 257, 2, 13, 0xefae00 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 511, 1, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 511, 1, 13, 0xac1700 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 511, 2, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 511, 2, 13, 0x1582e00 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 512, 1, 1, 0x810000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 512, 1, 13, 0xac1700 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 512, 2, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 512, 2, 13, 0x1582e00 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 513, 1, 1, 0x920000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 513, 1, 13, 0xd0ac00 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 513, 2, 1, 0x1240000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 513, 2, 13, 0x1a15800 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 1023, 1, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 1023, 1, 13, 0x1582c00 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 1023, 2, 1, 0x2040000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 1023, 2, 13, 0x2b05800 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 1024, 1, 1, 0x1020000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 1024, 1, 13, 0x1582c00 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 1024, 2, 1, 0x2040000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 1024, 2, 13, 0x2b05800 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 1025, 1, 1, 0x1140000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 1025, 1, 13, 0x17f1680 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 1025, 2, 1, 0x2280000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 1025, 2, 13, 0x2fe2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 2047, 1, 1, 0x2040000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 2047, 1, 13, 0x2b01680 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 2047, 2, 1, 0x4080000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 2047, 2, 13, 0x5602d00 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 2048, 1, 1, 0x2040000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 2048, 1, 13, 0x2b01680 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 2048, 2, 1, 0x4080000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 2048, 2, 13, 0x5602d00 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 2049, 1, 1, 0x2180000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 2049, 1, 13, 0x2da2b80 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 2049, 2, 1, 0x4300000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 2049, 2, 13, 0x5b45700 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 4095, 1, 1, 0x4080000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 4095, 1, 13, 0x5602b80 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 4095, 2, 1, 0x8100000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 4095, 2, 13, 0xac05700 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 4096, 1, 1, 0x4080000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 4096, 1, 13, 0x5602b80 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 4096, 2, 1, 0x8100000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 4096, 2, 13, 0xac05700 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 4097, 1, 1, 0x4200000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 4097, 1, 13, 0x58fd600 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 4097, 2, 1, 0x8400000 },
   { PIPE_FORMAT_Z32_FLOAT, 4096, 4097, 2, 13, 0xb1fac00 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 16, 1, 1, 0x81000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 16, 1, 13, 0xae100 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 16, 2, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 16, 2, 13, 0x15c200 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 17, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 17, 1, 13, 0x15b100 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 17, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 17, 2, 13, 0x2b6200 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 31, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 31, 1, 13, 0x15b100 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 31, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 31, 2, 13, 0x2b6200 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 32, 1, 1, 0x102000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 32, 1, 13, 0x15b100 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 32, 2, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 32, 2, 13, 0x2b6200 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 33, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 33, 1, 13, 0x2b1900 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 33, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 33, 2, 13, 0x563200 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 63, 1, 1, 0x204000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 63, 1, 13, 0x2b1900 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 63, 2, 1, 0x408000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 63, 2, 13, 0x563200 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 64, 1, 1, 0x108000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 64, 1, 13, 0x161900 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 64, 2, 1, 0x210000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 64, 2, 13, 0x2c3200 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 65, 1, 1, 0x210000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 65, 1, 13, 0x26ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 65, 2, 1, 0x420000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 65, 2, 13, 0x4d5a00 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 127, 1, 1, 0x210000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 127, 1, 13, 0x2bed00 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 127, 2, 1, 0x420000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 127, 2, 13, 0x57da00 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 128, 1, 1, 0x210000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 128, 1, 13, 0x2c2d00 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 128, 2, 1, 0x420000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 128, 2, 13, 0x585a00 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 129, 1, 1, 0x31c000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 129, 1, 13, 0x495700 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 129, 2, 1, 0x638000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 129, 2, 13, 0x92ae00 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 255, 1, 1, 0x420000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 255, 1, 13, 0x589700 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 255, 2, 1, 0x840000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 255, 2, 13, 0xb12e00 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 256, 1, 1, 0x420000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 256, 1, 13, 0x58d700 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 256, 2, 1, 0x840000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 256, 2, 13, 0xb1ae00 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 257, 1, 1, 0x534000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 257, 1, 13, 0x7bec00 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 257, 2, 1, 0xa68000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 257, 2, 13, 0xf7d800 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 511, 1, 1, 0x840000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 511, 1, 13, 0xb16c00 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 511, 2, 1, 0x1080000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 511, 2, 13, 0x162d800 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 512, 1, 1, 0x840000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 512, 1, 13, 0xb1ac00 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 512, 2, 1, 0x1080000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 512, 2, 13, 0x1635800 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 513, 1, 1, 0x964000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 513, 1, 13, 0xd89680 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 513, 2, 1, 0x12c8000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 513, 2, 13, 0x1b12d00 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 1023, 1, 1, 0x1080000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 1023, 1, 13, 0x1639680 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 1023, 2, 1, 0x2100000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 1023, 2, 13, 0x2c72d00 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 1024, 1, 1, 0x1080000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 1024, 1, 13, 0x163d680 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 1024, 2, 1, 0x2100000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 1024, 2, 13, 0x2c7ad00 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 1025, 1, 1, 0x11c4000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 1025, 1, 13, 0x18eab80 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 1025, 2, 1, 0x2388000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 1025, 2, 13, 0x31d5700 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 2047, 1, 1, 0x2100000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 2047, 1, 13, 0x2c76b80 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 2047, 2, 1, 0x4200000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 2047, 2, 13, 0x58ed700 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 2048, 1, 1, 0x2100000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 2048, 1, 13, 0x2c7ab80 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 2048, 2, 1, 0x4200000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 2048, 2, 13, 0x58f5700 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 2049, 1, 1, 0x2284000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 2049, 1, 13, 0x2f89600 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 2049, 2, 1, 0x4508000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 2049, 2, 13, 0x5f12c00 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 4095, 1, 1, 0x4200000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 4095, 1, 13, 0x58f9600 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 4095, 2, 1, 0x8400000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 4095, 2, 13, 0xb1f2c00 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 4096, 1, 1, 0x4200000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 4096, 1, 13, 0x58fd600 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 4096, 2, 1, 0x8400000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 4096, 2, 13, 0xb1fac00 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 4097, 1, 1, 0x4404000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 4097, 1, 13, 0x5cbeb00 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 4097, 2, 1, 0x8808000 },
   { PIPE_FORMAT_Z32_FLOAT, 4097, 4097, 2, 13, 0xb97d600 },
};

TEST(CompTwiddled, SizeTests)
{
   for (unsigned i = 0; i < ARRAY_SIZE(comptests); ++i) {
      struct sizetest test = comptests[i];

      struct ail_layout layout = {
         .width_px = test.width,
         .height_px = test.height,
         .depth_px = test.depth,
         .sample_count_sa = 1,
         .levels = test.levels,
         .tiling = AIL_TILING_TWIDDLED_COMPRESSED,
         .format = test.format,
      };

      ail_make_miptree(&layout);

      EXPECT_EQ(layout.size_B, test.size) <<
         test.width << "x" << test.height << "x" << test.depth << " " << (int)test.levels <<
         "L " << util_format_short_name(test.format) <<
         " compressed texture has wrong allocation size, off by " << ((int)layout.size_B - (int)test.size);
   }
}
