#!/bin/sh

usage() {
    echo >&2 "Usage run-test.sh [-v|--verbose] <test_js>..."
    exit 1
}

tests=
verbose=false
debug=
for arg in $@ ; do
    case $arg in
	-g|--debug)
	    debug="libtool --mode=execute gdb --args"
	    ;;
	-v|--verbose)
	    verbose=true
	    ;;
	-*)
	    usage
	    ;;
	*)
	    tests="$tests $arg"
	    ;;
    esac
done

builddir=`dirname $0`
builddir=`cd $builddir && pwd`
srcdir=/home/pechanove/gnome-shell/tests
srcdir=`cd $srcdir && pwd`

GI_TYPELIB_PATH="$GI_TYPELIB_PATH${GI_TYPELIB_PATH:+:}/usr/lib/x86_64-linux-gnu/mutter-14:$builddir/../src:$builddir/../src/st:$builddir/../subprojects/gvc"
GJS_PATH="$srcdir:$srcdir/../js:$builddir/../js"
GJS_DEBUG_OUTPUT=stderr
$verbose || GJS_DEBUG_TOPICS="JS ERROR;JS LOG"
GNOME_SHELL_TESTSDIR="$srcdir/"
GNOME_SHELL_JS="$srcdir/../js"
GNOME_SHELL_DATADIR="$builddir/../data"

export GI_TYPELIB_PATH GJS_PATH GJS_DEBUG_OUTPUT GJS_DEBUG_TOPICS GNOME_SHELL_TESTSDIR GNOME_SHELL_JS GNOME_SHELL_DATADIR LD_PRELOAD

for test in $tests ; do
    $debug $builddir/../src/run-js-test $test || exit $?
done
